/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.projsettings;

import com.sun.electric.database.text.Setting;
import com.sun.electric.technology.Foundry;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ProjectSettingsFrame;
import com.sun.electric.tool.user.dialogs.projsettings.ProjSettingsPanel;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TechnologyTab
extends ProjSettingsPanel {
    private ArrayList<Object> extraTechTabs = new ArrayList();
    public static final int MOCMOS_SCMOSRULES = 0;
    public static final int MOCMOS_SUBMRULES = 1;
    public static final int MOCMOS_DEEPRULES = 2;
    private Setting defaultTechnologySetting = User.getDefaultTechnologySetting();
    private Setting schematicTechnologySetting = User.getSchematicTechnologySetting();
    private Setting processLayoutTechnologySetting = User.getPWellProcessLayoutTechnologySetting();
    private Technology mocmos = Technology.getMocmosTechnology();
    private Setting mocmosRuleSetSetting = this.mocmos.getSetting("MOCMOS Rule Set");
    private Setting mocmosNumMetalSetting = this.mocmos.getSetting("NumMetalLayers");
    private Setting mocmosSecondPolysiliconSetting = this.mocmos.getSetting("UseSecondPolysilicon");
    private Setting mocmosDisallowStackedViasSetting = this.mocmos.getSetting("DisallowStackedVias");
    private Setting mocmosAlternateActivePolyRulesSetting = this.mocmos.getSetting("UseAlternativeActivePolyRules");
    private Setting mocmosAnalogSetting = this.mocmos.getSetting("Analog");
    private JPanel cmos90Panel;
    private JLabel defaultTechLabel;
    private JComboBox defaultTechPulldown;
    private JPanel defaultsPanel;
    private JLabel jLabel59;
    private JPanel mosisPanel;
    private JCheckBox techMOCMOSAlternateContactRules;
    private JCheckBox techMOCMOSAnalog;
    private JRadioButton techMOCMOSDeepRules;
    private JCheckBox techMOCMOSDisallowStackedVias;
    private ButtonGroup techMOCMOSRules;
    private JRadioButton techMOCMOSSCMOSRules;
    private JCheckBox techMOCMOSSecondPoly;
    private JRadioButton techMOCMOSSubmicronRules;
    private JLabel techMetalLabel;
    private JComboBox techMetalLayers;
    private JPanel technology;
    private JComboBox technologyPopup;
    private JCheckBox technologyProcess;
    private JPanel tsmc180Panel;

    public TechnologyTab(ProjectSettingsFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public JPanel getPanel() {
        return this.technology;
    }

    public String getName() {
        return "Technology";
    }

    public Foundry.Type setFoundrySelected(Technology tech, JComboBox pulldown) {
        String selectedFoundry = this.getString(tech.getPrefFoundrySetting());
        Foundry.Type foundry = Foundry.Type.NONE;
        Iterator<Foundry> itF = tech.getFoundries();
        while (itF.hasNext()) {
            Foundry factory = itF.next();
            Foundry.Type type = factory.getType();
            pulldown.addItem(type);
            if (!selectedFoundry.equalsIgnoreCase(factory.getType().getName())) continue;
            foundry = type;
        }
        pulldown.setEnabled(foundry != Foundry.Type.NONE);
        pulldown.setSelectedItem(foundry);
        return foundry;
    }

    public void init() {
        int initialTechRules = this.getInt(this.mocmosRuleSetSetting);
        if (initialTechRules == 0) {
            this.techMOCMOSSCMOSRules.setSelected(true);
        } else if (initialTechRules == 1) {
            this.techMOCMOSSubmicronRules.setSelected(true);
        } else {
            this.techMOCMOSDeepRules.setSelected(true);
        }
        this.techMetalLayers.addItem("2 Layers");
        this.techMetalLayers.addItem("3 Layers");
        this.techMetalLayers.addItem("4 Layers");
        this.techMetalLayers.addItem("5 Layers");
        this.techMetalLayers.addItem("6 Layers");
        this.techMetalLayers.setSelectedIndex(this.getInt(this.mocmosNumMetalSetting) - 2);
        this.techMOCMOSSecondPoly.setSelected(this.getBoolean(this.mocmosSecondPolysiliconSetting));
        this.techMOCMOSDisallowStackedVias.setSelected(this.getBoolean(this.mocmosDisallowStackedViasSetting));
        this.techMOCMOSAlternateContactRules.setSelected(this.getBoolean(this.mocmosAlternateActivePolyRulesSetting));
        this.techMOCMOSAnalog.setSelected(this.getBoolean(this.mocmosAnalogSetting));
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            Technology tech = it.next();
            this.defaultTechPulldown.addItem(tech.getTechName());
            if (!tech.isScaleRelevant()) continue;
            this.technologyPopup.addItem(tech.getTechName());
        }
        this.defaultTechPulldown.setSelectedItem(this.getString(this.defaultTechnologySetting));
        this.technologyPopup.setSelectedItem(User.getSchematicTechnology().getTechName());
        this.technologyProcess.setSelected(this.processLayoutTechnologySetting.getBoolean());
        this.initExtraTab("com.sun.electric.plugins.tsmc.CMOS90Tab", this.cmos90Panel);
        this.initExtraTab("com.sun.electric.plugins.tsmc.TSMC180Tab", this.tsmc180Panel);
    }

    private void initExtraTab(String className, JPanel panel) {
        try {
            Class<?> extraTechClass = Class.forName(className);
            Object extraTechTab = extraTechClass.getConstructor(TechnologyTab.class, JPanel.class).newInstance(this, panel);
            this.extraTechTabs.add(extraTechTab);
        }
        catch (Exception e) {
            this.technology.remove(panel);
        }
    }

    public void term() {
        int currentNumMetals = this.techMetalLayers.getSelectedIndex() + 2;
        int currentRules = 0;
        if (this.techMOCMOSSubmicronRules.isSelected()) {
            currentRules = 1;
        } else if (this.techMOCMOSDeepRules.isSelected()) {
            currentRules = 2;
        }
        boolean secondPoly = this.techMOCMOSSecondPoly.isSelected();
        boolean alternateContactRules = this.techMOCMOSAlternateContactRules.isSelected();
        if (this.techMOCMOSAnalog.isSelected() && (currentNumMetals != 2 || currentRules != 0 || !secondPoly || alternateContactRules)) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "The Analog setting requires 2 metals, 2 polys, SCMOS rules, and no alternate contact rules...making these changes");
            currentNumMetals = 2;
            currentRules = 0;
            secondPoly = true;
            alternateContactRules = false;
        }
        switch (currentNumMetals) {
            case 2: 
            case 3: 
            case 4: {
                if (currentRules != 2) break;
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot use Deep rules if there are less than 5 layers of metal...using SubMicron rules.");
                currentRules = 1;
                break;
            }
            case 5: 
            case 6: {
                if (currentRules != 0) break;
                JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot use SCMOS rules if there are more than 4 layers of metal...using SubMicron rules.");
                currentRules = 1;
            }
        }
        this.setInt(this.mocmosNumMetalSetting, currentNumMetals);
        this.setInt(this.mocmosRuleSetSetting, currentRules);
        this.setBoolean(this.mocmosSecondPolysiliconSetting, secondPoly);
        this.setBoolean(this.mocmosDisallowStackedViasSetting, this.techMOCMOSDisallowStackedVias.isSelected());
        this.setBoolean(this.mocmosAlternateActivePolyRulesSetting, alternateContactRules);
        this.setBoolean(this.mocmosAnalogSetting, this.techMOCMOSAnalog.isSelected());
        String currentTechName = (String)this.technologyPopup.getSelectedItem();
        if (Technology.findTechnology(currentTechName) != null) {
            this.setString(this.schematicTechnologySetting, currentTechName);
        }
        this.setString(this.defaultTechnologySetting, (String)this.defaultTechPulldown.getSelectedItem());
        boolean currentV = this.technologyProcess.isSelected();
        if (currentV != this.processLayoutTechnologySetting.getBoolean()) {
            this.setBoolean(this.processLayoutTechnologySetting, currentV);
            Technology.getCurrent().setCachedRules(null);
        }
        for (Object extraTechTab : this.extraTechTabs) {
            try {
                extraTechTab.getClass().getMethod("term", new Class[0]).invoke(extraTechTab, new Object[0]);
            }
            catch (Exception e) {
                System.out.println("Exceptions while importing extra technologies: " + e.getMessage());
            }
        }
    }

    public boolean checkFoundry(Foundry.Type foundry, Technology tech) {
        if (foundry == null) {
            return false;
        }
        boolean changed = false;
        if (!foundry.getName().equalsIgnoreCase(this.getString(tech.getPrefFoundrySetting()))) {
            changed = true;
            String[] messages = new String[]{tech.getTechShortName() + " primitives in database might be resized according to values provided by " + foundry + ".", "If you do not resize now, arc widths might not be optimal for " + foundry + ".", "If you cancel the operation, the foundry will not be changed.", "Do you want to resize the database?"};
            Object[] options = new Object[]{"Yes", "No", "Cancel"};
            int val = JOptionPane.showOptionDialog(TopLevel.getCurrentJFrame(), messages, "Resize primitive Nodes and Arcs", -1, 2, null, options, options[0]);
            if (val != 2) {
                this.setString(tech.getPrefFoundrySetting(), foundry.getName());
            }
        }
        return changed;
    }

    private void initComponents() {
        this.techMOCMOSRules = new ButtonGroup();
        this.technology = new JPanel();
        this.defaultsPanel = new JPanel();
        this.defaultTechLabel = new JLabel();
        this.defaultTechPulldown = new JComboBox();
        this.jLabel59 = new JLabel();
        this.technologyPopup = new JComboBox();
        this.technologyProcess = new JCheckBox();
        this.mosisPanel = new JPanel();
        this.techMetalLabel = new JLabel();
        this.techMetalLayers = new JComboBox();
        this.techMOCMOSSCMOSRules = new JRadioButton();
        this.techMOCMOSSubmicronRules = new JRadioButton();
        this.techMOCMOSDeepRules = new JRadioButton();
        this.techMOCMOSSecondPoly = new JCheckBox();
        this.techMOCMOSDisallowStackedVias = new JCheckBox();
        this.techMOCMOSAlternateContactRules = new JCheckBox();
        this.techMOCMOSAnalog = new JCheckBox();
        this.cmos90Panel = new JPanel();
        this.tsmc180Panel = new JPanel();
        this.setTitle("Edit Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                TechnologyTab.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.technology.setLayout(new GridBagLayout());
        this.defaultsPanel.setBorder(BorderFactory.createTitledBorder("Defaults"));
        this.defaultsPanel.setLayout(new GridBagLayout());
        this.defaultTechLabel.setText("Startup technology:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.defaultsPanel.add((Component)this.defaultTechLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.defaultsPanel.add((Component)this.defaultTechPulldown, gridBagConstraints);
        this.jLabel59.setText("Layout technology to use for Schematics:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.defaultsPanel.add((Component)this.jLabel59, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.defaultsPanel.add((Component)this.technologyPopup, gridBagConstraints);
        this.technologyProcess.setText("PWell process in Layout Technology");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.defaultsPanel.add((Component)this.technologyProcess, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.technology.add((Component)this.defaultsPanel, gridBagConstraints);
        this.mosisPanel.setBorder(BorderFactory.createTitledBorder("mocmos Technology"));
        this.mosisPanel.setLayout(new GridBagLayout());
        this.techMetalLabel.setText("Metal layers:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mosisPanel.add((Component)this.techMetalLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.mosisPanel.add((Component)this.techMetalLayers, gridBagConstraints);
        this.techMOCMOSRules.add(this.techMOCMOSSCMOSRules);
        this.techMOCMOSSCMOSRules.setText("SCMOS rules (4 metal or less)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.mosisPanel.add((Component)this.techMOCMOSSCMOSRules, gridBagConstraints);
        this.techMOCMOSRules.add(this.techMOCMOSSubmicronRules);
        this.techMOCMOSSubmicronRules.setText("Submicron rules");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.mosisPanel.add((Component)this.techMOCMOSSubmicronRules, gridBagConstraints);
        this.techMOCMOSRules.add(this.techMOCMOSDeepRules);
        this.techMOCMOSDeepRules.setText("Deep rules (5 metal or more)");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.mosisPanel.add((Component)this.techMOCMOSDeepRules, gridBagConstraints);
        this.techMOCMOSSecondPoly.setText("Second Polysilicon Layer");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 1, 4);
        this.mosisPanel.add((Component)this.techMOCMOSSecondPoly, gridBagConstraints);
        this.techMOCMOSDisallowStackedVias.setText("Disallow stacked vias");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.mosisPanel.add((Component)this.techMOCMOSDisallowStackedVias, gridBagConstraints);
        this.techMOCMOSAlternateContactRules.setText("Alternate Active and Poly contact rules");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 1, 4);
        this.mosisPanel.add((Component)this.techMOCMOSAlternateContactRules, gridBagConstraints);
        this.techMOCMOSAnalog.setText("Analog");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 4, 4, 4);
        this.mosisPanel.add((Component)this.techMOCMOSAnalog, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        this.technology.add((Component)this.mosisPanel, gridBagConstraints);
        this.cmos90Panel.setBorder(BorderFactory.createTitledBorder(""));
        this.cmos90Panel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.technology.add((Component)this.cmos90Panel, gridBagConstraints);
        this.tsmc180Panel.setBorder(BorderFactory.createTitledBorder(""));
        this.tsmc180Panel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.technology.add((Component)this.tsmc180Panel, gridBagConstraints);
        this.getContentPane().add((Component)this.technology, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

