/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.netlist;

import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.ncc.basic.Primes;
import com.sun.electric.tool.ncc.netlist.NccNameProxy;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.netlist.PinType;
import com.sun.electric.tool.ncc.netlist.Wire;
import java.util.HashMap;
import java.util.Map;

public class Resistor
extends Part {
    private static final ResistorPinTypeCache TYPE_TO_PINTYPE = new ResistorPinTypeCache();
    private static final int[] PIN_COEFFS = new int[]{Primes.get(1), Primes.get(1)};
    private final double width;
    private final double length;

    public Resistor(PrimitiveNode.Function type, NccNameProxy.PartNameProxy name, double width, double length, Wire w1, Wire w2) {
        super(name, type, new Wire[]{w1, w2});
        this.width = width;
        this.length = length;
    }

    public int[] getPinCoeffs() {
        return PIN_COEFFS;
    }

    public String valueDescription() {
        String sz = "W= " + this.width + " L=" + this.length;
        return sz;
    }

    public Integer hashCodeForParallelMerge() {
        int hc = this.pins[0].hashCode() + this.pins[1].hashCode() + this.getClass().hashCode();
        return new Integer(hc);
    }

    public double getWidth() {
        return this.width;
    }

    public double getLength() {
        return this.length;
    }

    public void connect(Wire ss, Wire ee) {
        this.pins[0] = ss;
        this.pins[1] = ee;
        ss.add(this);
        ee.add(this);
    }

    public boolean parallelMerge(Part p) {
        return false;
    }

    public int typeCode() {
        return this.type().ordinal();
    }

    public PinType getPinTypeOfNthPin(int n) {
        return TYPE_TO_PINTYPE.get(this.type());
    }

    public String typeString() {
        return this.type().getShortName();
    }

    public String connectionDescription(int n) {
        String s = this.pins[0].getName();
        String e = this.pins[1].getName();
        return "S= " + s + " E= " + e;
    }

    public String connectionDescription(Wire w) {
        String s = "";
        for (int i = 0; i < this.pins.length; ++i) {
            if (this.pins[i] != w) continue;
            if (s.length() != 0) {
                s = s + ",";
            }
            s = s + (i == 0 ? "S" : "E");
        }
        return s;
    }

    private static class ResistorPinTypeCache {
        private final Map<PrimitiveNode.Function, ResistorPinType> typeToPinType = new HashMap<PrimitiveNode.Function, ResistorPinType>();

        private ResistorPinTypeCache() {
        }

        synchronized ResistorPinType get(PrimitiveNode.Function f) {
            ResistorPinType t = this.typeToPinType.get((Object)f);
            if (t == null) {
                t = new ResistorPinType(f);
                this.typeToPinType.put(f, t);
            }
            return t;
        }
    }

    private static class ResistorPinType
    implements PinType {
        private PrimitiveNode.Function type;

        public ResistorPinType(PrimitiveNode.Function t) {
            this.type = t;
        }

        public String description() {
            return this.type.getShortName();
        }
    }
}

