/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.Xml;
import com.sun.electric.tool.user.dialogs.ComponentMenu;
import com.sun.electric.tool.user.dialogs.options.PreferencePanel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;

public class ComponentMenuTab
extends PreferencePanel {
    private ComponentMenu theMenu;
    private Technology tech;

    public ComponentMenuTab(Frame parent, boolean modal) {
        super(parent, modal);
        this.theMenu = new ComponentMenu(parent, false);
    }

    public JPanel getPanel() {
        return this.theMenu.getPanel();
    }

    public String getName() {
        return "Component Menu";
    }

    public void init() {
        this.tech = Technology.getCurrent();
        Xml.Technology xTech = new Xml.Technology();
        Iterator<Comparable<ArcProto>> it = this.tech.getArcs();
        while (it.hasNext()) {
            ArcProto ap = it.next();
            Xml.ArcProto curArc = new Xml.ArcProto();
            curArc.name = ap.getName();
            xTech.arcs.add(curArc);
        }
        it = this.tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = (PrimitiveNode)it.next();
            Xml.PrimitiveNode curNode = new Xml.PrimitiveNode();
            curNode.name = np.getName();
            curNode.function = np.getFunction();
            xTech.nodes.add(curNode);
        }
        Object[][] menuArray = this.makeMenuArray(xTech, this.tech.getNodesGrouped(null));
        Object[][] defMenuArray = this.makeMenuArray(xTech, this.tech.filterNodeGroups(this.tech.getDefaultNodesGrouped()));
        this.theMenu.showTechnology(this.tech.getTechName(), xTech, menuArray, defMenuArray);
    }

    private Object[][] makeMenuArray(Xml.Technology xTech, Object[][] curMenu) {
        int menuWid = curMenu[0].length;
        int menuHei = curMenu.length;
        Object[][] menuArray = new Object[menuHei][menuWid];
        for (int y = 0; y < menuHei; ++y) {
            for (int x = 0; x < menuWid; ++x) {
                Object menuEntry = curMenu[y][x];
                if (menuEntry instanceof List) {
                    ArrayList<Object> subList = new ArrayList<Object>();
                    for (Object it : (List)menuEntry) {
                        subList.add(this.convertToXML(it, xTech));
                    }
                    menuArray[y][x] = subList;
                    continue;
                }
                menuArray[y][x] = this.convertToXML(menuEntry, xTech);
            }
        }
        return menuArray;
    }

    public void term() {
        int menuWid;
        if (!this.theMenu.isChanged()) {
            return;
        }
        Xml.MenuPalette xmp = new Xml.MenuPalette();
        Object[][] menuArray = this.theMenu.getMenuInfo();
        int menuHei = menuArray.length;
        xmp.numColumns = menuWid = menuArray[0].length;
        xmp.menuBoxes = new ArrayList<List<Object>>();
        Object[][] convMenuArray = new Object[menuHei][menuWid];
        for (int y = 0; y < menuHei; ++y) {
            for (int x = 0; x < menuWid; ++x) {
                Object item = null;
                if (menuArray[y] != null) {
                    item = menuArray[y][x];
                }
                if (item instanceof List) {
                    xmp.menuBoxes.add((List)item);
                    ArrayList<Object> subConvList = new ArrayList<Object>();
                    for (Object it : (List)item) {
                        subConvList.add(this.convertFromXML(it));
                    }
                    convMenuArray[y][x] = subConvList;
                    continue;
                }
                ArrayList<Object> subList = new ArrayList<Object>();
                if (item != null) {
                    subList.add(item);
                }
                xmp.menuBoxes.add(subList);
                convMenuArray[y][x] = this.convertFromXML(item);
            }
        }
        this.tech.setNodesGrouped(convMenuArray, xmp.writeXml());
        Iterator<WindowFrame> it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WindowFrame wf = it.next();
            wf.getPaletteTab().loadForTechnology(this.tech, wf);
        }
    }

    private Object convertToXML(Object obj, Xml.Technology xTech) {
        if (obj instanceof NodeInst) {
            NodeInst ni = (NodeInst)obj;
            Xml.MenuNodeInst xni = new Xml.MenuNodeInst();
            xni.protoName = ni.getProto().getName();
            xni.function = ni.getFunction();
            Variable var = ni.getVar(Technology.TECH_TMPVAR);
            if (var != null) {
                xni.text = (String)var.getObject();
                xni.fontSize = var.getTextDescriptor().getSize().getSize();
            }
            xni.rotation = ni.getAngle();
            return xni;
        }
        if (obj instanceof NodeProto) {
            NodeProto np = (NodeProto)obj;
            if (np instanceof Cell) {
                Cell cell = (Cell)np;
                return "LOADCELL " + cell.libDescribe();
            }
            for (Xml.PrimitiveNode xnp : xTech.nodes) {
                if (!xnp.name.equals(np.getName())) continue;
                return xnp;
            }
            Xml.PrimitiveNode xnp = new Xml.PrimitiveNode();
            xnp.name = np.getName();
            return xnp;
        }
        if (obj instanceof ArcProto) {
            ArcProto ap = (ArcProto)obj;
            for (Xml.ArcProto xap : xTech.arcs) {
                if (!xap.name.equals(ap.getName())) continue;
                return xap;
            }
            Xml.ArcProto xap = new Xml.ArcProto();
            xap.name = ap.getName();
            return xap;
        }
        return obj;
    }

    private Object convertFromXML(Object obj) {
        if (obj instanceof Xml.MenuNodeInst) {
            Xml.MenuNodeInst xni = (Xml.MenuNodeInst)obj;
            PrimitiveNode np = this.tech.findNodeProto(xni.protoName);
            NodeInst ni = Technology.makeNodeInst(np, xni.function, xni.rotation, xni.text != null && xni.text.length() > 0, xni.text, xni.fontSize);
            return ni;
        }
        if (obj instanceof Xml.PrimitiveNode) {
            Xml.PrimitiveNode xnp = (Xml.PrimitiveNode)obj;
            PrimitiveNode np = this.tech.findNodeProto(xnp.name);
            return np;
        }
        if (obj instanceof Xml.ArcProto) {
            Xml.ArcProto xap = (Xml.ArcProto)obj;
            ArcProto ap = this.tech.findArcProto(xap.name);
            return ap;
        }
        return obj;
    }
}

