/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.ncc.NccOptions;
import com.sun.electric.tool.ncc.PIEOptions;
import com.sun.electric.tool.ncc.result.NccResults;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class Pie {
    private Class pieNccJobClass;
    private Constructor pieNccJobConstructor;
    private Class pieNccClass;
    private Method pieNccCompare;
    private static final Pie pie = new Pie();

    private Pie() {
        try {
            this.pieNccJobClass = Class.forName("com.sun.electric.plugins.pie.NccJob");
            this.pieNccJobConstructor = this.pieNccJobClass.getConstructor(Integer.TYPE);
            this.pieNccClass = Class.forName("com.sun.electric.plugins.pie.Ncc");
            this.pieNccClass.getMethod("compare", Cell.class, VarContext.class, Cell.class, VarContext.class, NccOptions.class, PIEOptions.class);
        }
        catch (Throwable e) {
            this.pieNccJobClass = null;
            this.pieNccJobConstructor = null;
        }
    }

    private static void prln(String msg) {
        System.out.println(msg);
    }

    public static boolean hasPie() {
        return Pie.pie.pieNccJobClass != null;
    }

    public static void invokePieNcc(int numWind) {
        LayoutLib.error(!Pie.hasPie(), "trying to invoke non-existant PIE");
        try {
            Pie.pie.pieNccJobConstructor.newInstance(new Integer(numWind));
        }
        catch (Throwable e) {
            Pie.prln("Invocation of pie NccJob threw Throwable: " + e);
            e.printStackTrace();
        }
    }

    public static NccResults invokePieNccCompare(Cell c1, VarContext v1, Cell c2, VarContext v2, NccOptions opt, PIEOptions pOpt) {
        LayoutLib.error(!Pie.hasPie(), "trying to invoke non-existant PIE");
        NccResults results = null;
        try {
            results = (NccResults)Pie.pie.pieNccCompare.invoke(null, c1, v1, c2, v2, opt, pOpt);
        }
        catch (Throwable e) {
            Pie.prln("Invocation of pie Ncc.compare threw Throwable: " + e);
            e.printStackTrace();
        }
        return results;
    }
}

