/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Part;
import com.sun.electric.tool.ncc.strategy.OutlierRecord;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.Iterator;

public class StratSizes
extends Strategy {
    private static final Integer CODE_OUTLIER = new Integer(1);
    private static final Integer CODE_REST = new Integer(2);
    private OutlierRecord outlierRecord;

    private StratSizes(NccGlobals globals) {
        super(globals);
    }

    private OutlierRecord findOutlierRecordWithLargestDeviation() {
        OutlierRecord furthestOut = null;
        Iterator<EquivRecord> frontier = this.globals.getPartLeafEquivRecs().getNotMatched();
        while (frontier.hasNext()) {
            OutlierRecord farOut;
            EquivRecord r = frontier.next();
            if (!r.isBalanced() || (farOut = new OutlierRecord(r)).deviation() == 0.0) continue;
            if (furthestOut == null) {
                furthestOut = farOut;
                continue;
            }
            if (!(farOut.deviation() > furthestOut.deviation())) continue;
            furthestOut = farOut;
        }
        return furthestOut;
    }

    private LeafList doYourJob() {
        OutlierRecord r = this.findOutlierRecordWithLargestDeviation();
        if (r == null) {
            return new LeafList();
        }
        this.outlierRecord = r;
        return this.doFor(r.getEquivRecord());
    }

    public Integer doFor(NetObject n) {
        Part p = (Part)n;
        return this.outlierRecord.isOutlier(p) ? CODE_OUTLIER : CODE_REST;
    }

    public static LeafList doYourJob(NccGlobals globals) {
        StratSizes ss = new StratSizes(globals);
        return ss.doYourJob();
    }
}

