/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs.projsettings;

import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.text.Setting;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.ProjectSettingsFrame;
import com.sun.electric.tool.user.dialogs.projsettings.ProjSettingsPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class NetlistsTab
extends ProjSettingsPanel {
    private Setting ignoreResistorsSetting = NetworkTool.getIgnoreResistorsSetting();
    private Setting includeDateAndVersionInOutputSetting = User.getIncludeDateAndVersionInOutputSetting();
    private Setting useCopyrightMessageSetting = IOTool.getUseCopyrightMessageSetting();
    private Setting copyrightMessageSetting = IOTool.getCopyrightMessageSetting();
    private JTextArea copyrightTextArea;
    private JPanel copyright;
    private ButtonGroup copyrightGroup;
    private JScrollPane copyrightMessage;
    private JRadioButton copyrightNone;
    private JRadioButton copyrightUse;
    private JCheckBox generalIncludeDateAndVersion;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JCheckBox netIgnoreResistors;
    private JPanel netlists;

    public NetlistsTab(ProjectSettingsFrame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    @Override
    public JPanel getPanel() {
        return this.netlists;
    }

    @Override
    public String getName() {
        return "Netlists";
    }

    @Override
    public void init() {
        this.netIgnoreResistors.setSelected(this.getBoolean(this.ignoreResistorsSetting));
        this.generalIncludeDateAndVersion.setSelected(this.getBoolean(this.includeDateAndVersionInOutputSetting));
        if (this.getBoolean(this.useCopyrightMessageSetting)) {
            this.copyrightUse.setSelected(true);
        } else {
            this.copyrightNone.setSelected(true);
        }
        this.copyrightTextArea = new JTextArea();
        this.copyrightMessage.setViewportView(this.copyrightTextArea);
        this.copyrightTextArea.setText(this.getString(this.copyrightMessageSetting));
        this.copyrightTextArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NetlistsTab.this.copyrightMessageKeyTyped(evt);
            }
        });
    }

    private void copyrightMessageKeyTyped(KeyEvent evt) {
        this.copyrightUse.setSelected(true);
    }

    @Override
    public void term() {
        this.setBoolean(this.ignoreResistorsSetting, this.netIgnoreResistors.isSelected());
        this.setBoolean(this.includeDateAndVersionInOutputSetting, this.generalIncludeDateAndVersion.isSelected());
        this.setBoolean(this.useCopyrightMessageSetting, this.copyrightUse.isSelected());
        this.setString(this.copyrightMessageSetting, this.copyrightTextArea.getText());
    }

    private void initComponents() {
        this.copyrightGroup = new ButtonGroup();
        this.netlists = new JPanel();
        this.generalIncludeDateAndVersion = new JCheckBox();
        this.copyright = new JPanel();
        this.jLabel4 = new JLabel();
        this.copyrightNone = new JRadioButton();
        this.copyrightUse = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.copyrightMessage = new JScrollPane();
        this.netIgnoreResistors = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("IO Options");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NetlistsTab.this.closeDialog(evt);
            }
        });
        this.getAccessibleContext().setAccessibleName("Netlist Settings");
        this.netlists.setLayout(new GridBagLayout());
        this.generalIncludeDateAndVersion.setText("Include date and version in output files");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.netlists.add((Component)this.generalIncludeDateAndVersion, gridBagConstraints);
        this.copyright.setLayout(new GridBagLayout());
        this.copyright.setBorder(BorderFactory.createTitledBorder("Copyright Information"));
        this.jLabel4.setText("A Copyright message can be added to every generated deck");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.copyright.add((Component)this.jLabel4, gridBagConstraints);
        this.copyrightGroup.add(this.copyrightNone);
        this.copyrightNone.setText("No copyright message");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 10, 4, 4);
        this.copyright.add((Component)this.copyrightNone, gridBagConstraints);
        this.copyrightGroup.add(this.copyrightUse);
        this.copyrightUse.setText("Use this copyright message:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 10, 4, 4);
        this.copyright.add((Component)this.copyrightUse, gridBagConstraints);
        this.jLabel5.setText("Do not put comment characters in this message");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.copyright.add((Component)this.jLabel5, gridBagConstraints);
        this.copyrightMessage.setMinimumSize(new Dimension(200, 200));
        this.copyrightMessage.setPreferredSize(new Dimension(200, 200));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.copyright.add((Component)this.copyrightMessage, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.netlists.add((Component)this.copyright, gridBagConstraints);
        this.netIgnoreResistors.setText("Ignore Resistors when building netlists");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.netlists.add((Component)this.netIgnoreResistors, gridBagConstraints);
        this.getContentPane().add((Component)this.netlists, new GridBagConstraints());
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

