/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.result.equivalence;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.generator.layout.LayoutLib;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class NccContext
implements Serializable {
    static final long serialVersionUID = 0L;
    private VarContext context;
    private Cell cell;
    private Map<String, NccContext> nodableNameToChild = new HashMap<String, NccContext>();
    private Set<Integer> objectIndices = new HashSet<Integer>();

    public NccContext(VarContext vc) {
        this.context = vc;
    }

    public void addChild(NccContext child) {
        String name = child.context.getNodable().getName();
        LayoutLib.error(this.nodableNameToChild.containsKey(name), "2 nodables with same name?");
        this.nodableNameToChild.put(name, child);
    }

    public void addNameProxyIndex(HierarchyEnumerator.NameProxy np, int i) {
        Integer bi = new Integer(i);
        LayoutLib.error(this.objectIndices.contains(bi), "duplicate index?");
        this.objectIndices.add(bi);
        LayoutLib.error(this.cell != null && this.cell != np.leafCell(), "NameProxy's in NccContext don't have same parent");
        this.cell = np.leafCell();
        LayoutLib.error(this.cell == null, "NameProxy with no parent Cell?");
    }

    public Iterator<Integer> getIndices() {
        return this.objectIndices.iterator();
    }

    public NccContext findChild(String instNm) {
        return this.nodableNameToChild.get(instNm);
    }

    public VarContext getContext() {
        return this.context;
    }

    public Cell getCell() {
        return this.cell;
    }
}

