/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.input.ArchSimOut;
import com.sun.electric.tool.io.input.EpicOut;
import com.sun.electric.tool.io.input.EpicOutProcess;
import com.sun.electric.tool.io.input.HSpiceOut;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.io.input.PSpiceOut;
import com.sun.electric.tool.io.input.RawSpiceOut;
import com.sun.electric.tool.io.input.SmartSpiceOut;
import com.sun.electric.tool.io.input.SpiceOut;
import com.sun.electric.tool.io.input.verilog.VerilogOut;
import com.sun.electric.tool.simulation.Simulation;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.dialogs.CellBrowser;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class Simulate
extends Input {
    public static void plotSpiceResults() {
        FileType type = Simulate.getCurrentSpiceOutputType();
        if (type == null) {
            return;
        }
        Simulate.plotSimulationResults(type, null, null, null);
    }

    public static void plotSpiceResultsThisCell() {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        FileType type = Simulate.getCurrentSpiceOutputType();
        if (type == null) {
            return;
        }
        Simulate.plotSimulationResults(type, cell, null, null);
    }

    public static void plotVerilogResults() {
        Simulate.plotSimulationResults(FileType.VERILOGOUT, null, null, null);
    }

    public static void plotVerilogResultsThisCell() {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return;
        }
        Simulate.plotSimulationResults(FileType.VERILOGOUT, cell, null, null);
    }

    public static void plotArchSimResults() {
        Simulate.plotSimulationResults(FileType.ARCHSIMOUT, null, null, null);
    }

    private static Simulate getSimulate(FileType type) {
        Simulate is = null;
        if (type == FileType.ARCHSIMOUT) {
            is = new ArchSimOut();
        } else if (type == FileType.HSPICEOUT) {
            is = new HSpiceOut();
        } else if (type == FileType.PSPICEOUT) {
            is = new PSpiceOut();
        } else if (type == FileType.RAWSPICEOUT) {
            is = new RawSpiceOut();
        } else if (type == FileType.RAWSSPICEOUT) {
            is = new SmartSpiceOut();
        } else if (type == FileType.SPICEOUT) {
            is = new SpiceOut();
        } else if (type == FileType.EPIC) {
            is = Simulation.isSpiceEpicReaderProcess() ? new EpicOutProcess() : new EpicOut();
        } else if (type == FileType.VERILOGOUT) {
            is = new VerilogOut();
        }
        return is;
    }

    public static void plotSimulationResults(FileType type, Cell cell, URL fileURL, WaveformWindow ww) {
        Simulate is = Simulate.getSimulate(type);
        if (is == null) {
            System.out.println("Cannot handle " + type.getName() + " files yet");
            return;
        }
        if (cell == null) {
            if (fileURL == null) {
                String fileName = OpenFile.chooseInputFile(type, null);
                if (fileName == null) {
                    return;
                }
                fileURL = TextUtils.makeURLToFile(fileName);
            }
            String cellName = TextUtils.getFileNameWithoutExtension(fileURL);
            Library curLib = Library.getCurrent();
            cell = curLib.findNodeProto(cellName);
            if (cell == null) {
                CellBrowser dialog = new CellBrowser((Frame)TopLevel.getCurrentJFrame(), true, CellBrowser.DoAction.selectCell);
                dialog.setVisible(true);
                cell = dialog.getSelectedCell();
                if (cell == null) {
                    return;
                }
            }
        } else if (fileURL == null) {
            String[] extensions = type.getExtensions();
            String fileName = cell.getName() + "." + extensions[0];
            String filePath = TextUtils.getFilePath(cell.getLibrary().getLibFile());
            File file = new File(filePath, fileName);
            if (!file.exists()) {
                String dir = type.getGroupPath();
                file = new File(dir, fileName);
            }
            fileURL = TextUtils.makeURLToFile(file.getPath());
        }
        new ReadSimulationOutput(type, is, fileURL, cell, ww).startJob();
    }

    public static Stimuli readSimulationResults(FileType type, Cell cell, URL fileURL) {
        Simulate is = Simulate.getSimulate(type);
        if (is == null) {
            System.out.println("Cannot handle " + type.getName() + " files yet");
            return null;
        }
        if (cell == null) {
            System.out.println("Error reading simulation results; specified Cell is null");
            return null;
        }
        if (fileURL == null) {
            System.out.println("Error reading simulation results; specified file is null");
            return null;
        }
        ReadSimulationOutput job = new ReadSimulationOutput(type, is, fileURL, cell, null);
        try {
            job.doIt();
        }
        catch (JobException e) {
            System.out.println(e.getMessage());
            return null;
        }
        return job.sd;
    }

    protected Stimuli readSimulationOutput(URL fileURL, Cell cell) throws IOException {
        return null;
    }

    public static FileType getCurrentSpiceOutputType() {
        String format = Simulation.getSpiceOutputFormat();
        Simulation.SpiceEngine engine = Simulation.getSpiceEngine();
        if (format.equalsIgnoreCase("Standard")) {
            if (engine == Simulation.SpiceEngine.SPICE_ENGINE_H) {
                return FileType.HSPICEOUT;
            }
            if (engine == Simulation.SpiceEngine.SPICE_ENGINE_3 || engine == Simulation.SpiceEngine.SPICE_ENGINE_P) {
                return FileType.PSPICEOUT;
            }
            return FileType.SPICEOUT;
        }
        if (format.equalsIgnoreCase("Raw")) {
            return FileType.RAWSPICEOUT;
        }
        if (format.equalsIgnoreCase("RawSmart")) {
            return FileType.RAWSSPICEOUT;
        }
        if (format.equalsIgnoreCase("Epic")) {
            return FileType.EPIC;
        }
        return null;
    }

    protected String getLineFromSimulator() throws IOException {
        StringBuffer sb = new StringBuffer();
        int bytesRead = 0;
        while (true) {
            int ch;
            if ((ch = this.lineReader.read()) == -1) {
                return null;
            }
            ++bytesRead;
            if (ch == 10 || ch == 13) break;
            sb.append((char)ch);
        }
        this.updateProgressDialog(bytesRead);
        return sb.toString();
    }

    static String removeLeadingX(String name) {
        int dotPos = -1;
        while (name.indexOf(46, dotPos + 1) >= 0) {
            int xPos = dotPos + 1;
            if (name.length() > xPos && name.charAt(xPos) == 'x') {
                name = name.substring(0, xPos) + name.substring(xPos + 1);
            }
            if ((dotPos = name.indexOf(46, xPos)) >= 0) continue;
            break;
        }
        return name;
    }

    private static class ReadSimulationOutput
    extends Job {
        private FileType type;
        private Simulate is;
        private URL fileURL;
        private Cell cell;
        private WaveformWindow ww;
        private Stimuli sd;

        private ReadSimulationOutput(FileType type, Simulate is, URL fileURL, Cell cell, WaveformWindow ww) {
            super("Read Simulation Output for " + cell, IOTool.getIOTool(), Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.type = type;
            this.is = is;
            this.fileURL = fileURL;
            this.cell = cell;
            this.ww = ww;
        }

        @Override
        public boolean doIt() throws JobException {
            try {
                this.sd = this.is.readSimulationOutput(this.fileURL, this.cell);
                if (this.sd != null) {
                    this.sd.setDataType(this.type);
                    this.sd.setFileURL(this.fileURL);
                }
            }
            catch (IOException e) {
                System.out.println("End of file reached while reading " + this.fileURL);
            }
            return true;
        }

        @Override
        public void terminateOK() {
            if (this.sd != null) {
                Simulation.showSimulationData(this.sd, this.ww);
            }
        }
    }
}

