/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Tool;
import java.awt.Component;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;

public class EObjectOutputStream
extends ObjectOutputStream {
    private final EDatabase database;

    public EObjectOutputStream(OutputStream out, EDatabase database) throws IOException {
        super(out);
        this.enableReplaceObject(true);
        this.database = database;
    }

    @Override
    protected Object replaceObject(Object obj) throws IOException {
        if (obj instanceof ElectricObject && ((ElectricObject)obj).getDatabase() != this.database) {
            throw new NotSerializableException("other database");
        }
        if (obj instanceof View) {
            return new EView((View)obj);
        }
        if (obj instanceof Technology) {
            return new ETechnology((Technology)obj);
        }
        if (obj instanceof PrimitiveNode) {
            return new EPrimitiveNode((PrimitiveNode)obj);
        }
        if (obj instanceof PrimitivePort) {
            return new EPrimitivePort((PrimitivePort)obj);
        }
        if (obj instanceof ArcProto) {
            return new EArcProto((ArcProto)obj);
        }
        if (obj instanceof Tool) {
            return new ETool((Tool)obj);
        }
        if (obj instanceof Variable.Key) {
            return new EVariableKey((Variable.Key)obj);
        }
        if (obj instanceof TextDescriptor) {
            return new ETextDescriptor((TextDescriptor)obj);
        }
        if (obj instanceof Network) {
            return new ENetwork((Network)obj);
        }
        if (obj instanceof Nodable) {
            return new ENodable((Nodable)obj);
        }
        if (obj instanceof Component) {
            throw new Error("Found AWT class " + obj.getClass() + " in serialized object");
        }
        return obj;
    }

    private static class ENodable
    implements Serializable {
        Cell cell;
        String nodableName;

        private ENodable(Nodable no) {
            this.cell = no.getParent();
            this.nodableName = no.getName();
        }

        private Object readResolve() throws ObjectStreamException {
            Netlist netlist = this.cell.getNetlist(false);
            Nodable nodable = null;
            Iterator<Nodable> it = netlist.getNodables();
            while (it.hasNext()) {
                Nodable no = it.next();
                if (!no.getName().equals(this.nodableName)) continue;
                nodable = no;
                break;
            }
            if (nodable == null) {
                throw new InvalidObjectException("Nodable");
            }
            return nodable;
        }
    }

    private static class ENetwork
    implements Serializable {
        Cell cell;
        int netIndex;
        boolean shortResistors;

        private ENetwork(Network net) {
            this.cell = net.getParent();
            this.netIndex = net.getNetIndex();
            this.shortResistors = net.getNetlist().getShortResistors();
        }

        private Object readResolve() throws ObjectStreamException {
            Netlist netlist = this.cell.getNetlist(this.shortResistors);
            Network net = netlist.getNetwork(this.netIndex);
            if (net == null) {
                throw new InvalidObjectException("Network");
            }
            return net;
        }
    }

    private static class ETextDescriptor
    implements Serializable {
        private boolean display;
        private long bits;
        private int colorIndex;
        private int cFlags;
        private String fontName;

        private ETextDescriptor(TextDescriptor td) {
            this.display = td.isDisplay();
            this.bits = td.lowLevelGet();
            this.colorIndex = td.getColorIndex();
            this.cFlags = td.getCode().getCFlags();
            int face = td.getFace();
            if (face != 0) {
                this.fontName = AbstractTextDescriptor.ActiveFont.findActiveFont(face).toString();
            }
        }

        private Object readResolve() throws ObjectStreamException {
            AbstractTextDescriptor.Code code = AbstractTextDescriptor.Code.getByCBits(this.cFlags);
            MutableTextDescriptor mtd = new MutableTextDescriptor(this.bits, this.colorIndex, this.display, code);
            int face = 0;
            if (this.fontName != null) {
                face = AbstractTextDescriptor.ActiveFont.findActiveFont(this.fontName).getIndex();
            }
            mtd.setFace(face);
            TextDescriptor td = TextDescriptor.newTextDescriptor(mtd);
            if (td == null) {
                throw new InvalidObjectException("TextDescriptor");
            }
            return td;
        }
    }

    private static class EVariableKey
    implements Serializable {
        String varName;

        private EVariableKey(Variable.Key varKey) {
            this.varName = varKey.toString();
        }

        private Object readResolve() throws ObjectStreamException {
            Variable.Key varKey = Variable.findKey(this.varName);
            if (varKey == null) {
                throw new InvalidObjectException("Variable.Key");
            }
            return varKey;
        }
    }

    private static class ETool
    implements Serializable {
        String toolName;

        private ETool(Tool tool) {
            this.toolName = tool.getName();
        }

        private Object readResolve() throws ObjectStreamException {
            Tool tool = Tool.findTool(this.toolName);
            if (tool == null) {
                throw new InvalidObjectException("Tool");
            }
            return tool;
        }
    }

    private static class EArcProto
    implements Serializable {
        String techName;
        String arcName;

        private EArcProto(ArcProto ap) {
            this.techName = ap.getTechnology().getTechName();
            this.arcName = ap.getName();
        }

        private Object readResolve() throws ObjectStreamException {
            Technology tech = Technology.findTechnology(this.techName);
            ArcProto ap = tech.findArcProto(this.arcName);
            if (ap == null) {
                throw new InvalidObjectException("ArcProto");
            }
            return ap;
        }
    }

    private static class EPrimitivePort
    implements Serializable {
        String techName;
        String primName;
        int portIndex;

        private EPrimitivePort(PrimitivePort pp) {
            PrimitiveNode pn = pp.getParent();
            this.techName = pn.getTechnology().getTechName();
            this.primName = pn.getName();
            this.portIndex = pp.getPortIndex();
        }

        private Object readResolve() throws ObjectStreamException {
            Technology tech = Technology.findTechnology(this.techName);
            PrimitiveNode pn = tech.findNodeProto(this.primName);
            PrimitivePort pp = pn.getPort(this.portIndex);
            if (pp == null) {
                throw new InvalidObjectException("PrimitivePort");
            }
            return pp;
        }
    }

    private static class EPrimitiveNode
    implements Serializable {
        String techName;
        String primName;

        private EPrimitiveNode(PrimitiveNode pn) {
            this.techName = pn.getTechnology().getTechName();
            this.primName = pn.getName();
        }

        private Object readResolve() throws ObjectStreamException {
            Technology tech = Technology.findTechnology(this.techName);
            PrimitiveNode pn = tech.findNodeProto(this.primName);
            if (pn == null) {
                throw new InvalidObjectException("PrimitiveNode");
            }
            return pn;
        }
    }

    private static class ETechnology
    implements Serializable {
        String techName;

        private ETechnology(Technology tech) {
            this.techName = tech.getTechName();
        }

        private Object readResolve() throws ObjectStreamException {
            Technology tech = Technology.findTechnology(this.techName);
            if (tech == null) {
                throw new InvalidObjectException("Technology");
            }
            return tech;
        }
    }

    private static class EView
    implements Serializable {
        String abbreviation;

        private EView(View view) {
            this.abbreviation = view.getAbbreviation();
        }

        private Object readResolve() throws ObjectStreamException {
            View view = View.findView(this.abbreviation);
            if (view == null) {
                throw new InvalidObjectException("View");
            }
            return view;
        }
    }
}

