/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.AbstractTextDescriptor;
import com.sun.electric.database.variable.EvalJavaBsh;
import com.sun.electric.database.variable.EvalSpice;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.generator.layout.LayoutLib;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarContext
implements Serializable {
    private static final Object FAST_EVAL_FAILED = new Object();
    private final VarContext prev;
    private final Nodable ni;
    private transient ValueCache cache;
    public static final VarContext globalContext = new VarContext();
    private static final Pattern pPat = Pattern.compile("P\\(\"(\\w+)\"\\)");

    private VarContext() {
        this.ni = null;
        this.prev = this;
        this.cache = null;
    }

    private VarContext(Nodable ni, VarContext prev, boolean caching) {
        this.ni = ni;
        this.prev = prev;
        this.cache = caching ? new ValueCache() : null;
    }

    private Object readResolve() throws ObjectStreamException {
        return this.prev != this ? this : globalContext;
    }

    private void throwNotFound(String name) throws EvalException {
        throw new EvalException(name.replaceFirst("ATTR_", "") + " not found");
    }

    private Object ifNotNumberTryToConvertToNumber(Object val) {
        if (val == null) {
            return val;
        }
        if (val instanceof Number) {
            return val;
        }
        try {
            Number d = TextUtils.parsePostFixNumber(val.toString());
            val = d;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    private String getSimpleVarRef(String expr) {
        String pOpen = "P(\"";
        int pOpenLen = "P(\"".length();
        String pClose = "\")";
        int pCloseLen = "\")".length();
        if (expr.startsWith("P(\"") && expr.endsWith("\")")) {
            String varNm = expr.substring(pOpenLen, expr.length() - pCloseLen);
            return this.isValidIdentifier(varNm) ? varNm : null;
        }
        if (expr.startsWith("@")) {
            String varNm = expr.substring(1);
            return this.isValidIdentifier(varNm) ? varNm : null;
        }
        return null;
    }

    private boolean isValidIdentifier(String identifier) {
        int len = identifier.length();
        for (int i = 0; i < len; ++i) {
            if (TextUtils.isLetterOrDigit(identifier.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object fastJavaVarEval(Variable var, Object info) throws EvalException {
        VarContext varContext = this;
        synchronized (varContext) {
            if (this.cache != null && this.cache.containsKey(var, info)) {
                return this.cache.get(var, info);
            }
        }
        String expr = var.getObject().toString();
        String varNm = this.getSimpleVarRef(expr);
        if (varNm == null) {
            return FAST_EVAL_FAILED;
        }
        return this.lookupVarEval("ATTR_" + varNm);
    }

    private void printValueCheckValue(Object value, Object checkValue) {
        System.out.println("fast eval mismatch");
        System.out.println("  fast value: " + value.toString());
        System.out.println("  slow value: " + checkValue.toString());
    }

    private void checkFastValue(Object value, Variable var, Object info) throws EvalException {
        if (value == FAST_EVAL_FAILED) {
            return;
        }
        Object checkValue = EvalJavaBsh.evalJavaBsh.evalVarObject(var.getObject(), this, info);
        if (value == null) {
            LayoutLib.error(value != checkValue, "fast eval null mismatch");
        } else if (!value.equals(checkValue)) {
            System.out.println("fast eval mismatch");
            this.printValueCheckValue(value, checkValue);
            LayoutLib.error(true, "fast eval mismatch");
        }
    }

    public VarContext push(Nodable ni) {
        return new VarContext(ni, this, false);
    }

    public VarContext pushCaching(Nodable ni) {
        return new VarContext(ni, this, true);
    }

    public VarContext pop() {
        return this.prev;
    }

    public Nodable getNodable() {
        return this.ni;
    }

    public PortInst getPortInst() {
        return null;
    }

    public boolean equals(VarContext c) {
        if (this == c) {
            return true;
        }
        if (this.ni == null || c.getNodable() == null) {
            return this.ni == c.getNodable();
        }
        Cell c1 = this.ni.getParent();
        Cell c2 = c.getNodable().getParent();
        String name1 = this.ni.getName();
        String name2 = c.getNodable().getName();
        if (c1 != c2 || !name1.equals(name2)) {
            return false;
        }
        return this.prev.equals(c.pop());
    }

    public Iterator<Nodable> getPathIterator() {
        Stack<Nodable> stack = new Stack<Nodable>();
        for (VarContext context = this; context != globalContext; context = context.pop()) {
            Nodable no = context.getNodable();
            stack.push(no);
        }
        ArrayList path = new ArrayList();
        while (!stack.isEmpty()) {
            path.add(stack.pop());
        }
        return path.iterator();
    }

    public VarContext removeParentContext(int levels) {
        VarContext acontext;
        Stack<Nodable> nodes = new Stack<Nodable>();
        for (acontext = this; acontext != globalContext; acontext = acontext.pop()) {
            nodes.push(acontext.getNodable());
        }
        for (int i = 0; i < levels; ++i) {
            nodes.pop();
        }
        acontext = globalContext;
        int size = nodes.size();
        for (int i = 0; i < size; ++i) {
            Nodable no = (Nodable)nodes.pop();
            acontext = acontext.push(no);
        }
        return acontext;
    }

    public int getNumLevels() {
        int i = 0;
        for (VarContext acontext = this; acontext != globalContext; acontext = acontext.pop()) {
            ++i;
        }
        return i;
    }

    public synchronized void deleteVariableCache() {
        this.cache = null;
    }

    public Object evalVar(Variable var) {
        return this.evalVar(var, null);
    }

    public Object evalVar(Variable var, Object info) {
        if (var == null) {
            return null;
        }
        try {
            return this.evalVarRecurse(var, info);
        }
        catch (EvalException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evalVarRecurse(Variable var, Object info) throws EvalException {
        AbstractTextDescriptor.Code code = var.getCode();
        Object value = var.getObject();
        if (code == AbstractTextDescriptor.Code.JAVA && (value = this.fastJavaVarEval(var, info)) == FAST_EVAL_FAILED) {
            value = EvalJavaBsh.evalJavaBsh.evalVarObject(var.getObject(), this, info);
            VarContext varContext = this;
            synchronized (varContext) {
                if (this.cache != null) {
                    this.cache.put(var, info, value);
                }
            }
        }
        if (code == AbstractTextDescriptor.Code.SPICE) {
            return this.evalSpice_(var, true);
        }
        value = this.ifNotNumberTryToConvertToNumber(value);
        return value;
    }

    public Object evalSpice(Variable var, boolean recurse) {
        try {
            return this.evalSpice_(var, recurse);
        }
        catch (EvalException e) {
            return null;
        }
    }

    private Object evalSpice_(Variable var, boolean recurse) throws EvalException {
        Object obj = var.getObject();
        if (obj instanceof String[]) {
            String[] strArray = (String[])obj;
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < strArray.length; ++i) {
                buf.append(strArray[i]);
                buf.append(" ");
            }
            obj = buf;
        }
        String expr = EvalJavaBsh.replace(obj.toString());
        Matcher pMat = pPat.matcher(expr);
        StringBuffer sb = new StringBuffer();
        while (pMat.find()) {
            Object value = pMat.group(1).substring(5);
            Variable parentVar = null;
            Nodable no = this.getNodable();
            if (no != null) {
                parentVar = no.getVar(Variable.findKey(pMat.group(1)));
            }
            if (parentVar != null) {
                boolean isSpiceCode;
                boolean bl = isSpiceCode = parentVar.getCode() == AbstractTextDescriptor.Code.SPICE;
                if (no.isCellInstance()) {
                    Variable protoVar;
                    Cell c = (Cell)no.getProto();
                    if (c.contentsView() != null) {
                        c = c.contentsView();
                    }
                    if ((protoVar = c.getVar(parentVar.getKey())) != null) {
                        boolean bl2 = isSpiceCode = protoVar.getCode() == AbstractTextDescriptor.Code.SPICE;
                    }
                }
                if (recurse || !isSpiceCode) {
                    value = this.pop().evalVarRecurse(parentVar, this.getNodable());
                }
            }
            pMat.appendReplacement(sb, value.toString());
        }
        pMat.appendTail(sb);
        EvalSpice sp = new EvalSpice(sb.toString());
        return sp.evaluate();
    }

    protected Object lookupVarEval(String name) throws EvalException {
        Object val;
        Variable var;
        Variable.Key key;
        if (this.ni == null) {
            this.throwNotFound(name);
        }
        if ((key = Variable.findKey(name)) == null) {
            this.throwNotFound(name);
        }
        if ((var = this.ni.getParameter(key)) == null) {
            this.throwNotFound(name);
        }
        if ((val = this.pop().evalVarRecurse(var, this.ni)) == null) {
            this.throwNotFound(name);
        }
        if ((val = this.ifNotNumberTryToConvertToNumber(val)) == null) {
            this.throwNotFound(name);
        }
        return val;
    }

    public String getInstPath(String sep) {
        Nodable no2;
        if (this == globalContext) {
            return "";
        }
        String prefix = this.pop() == globalContext ? "" : this.pop().getInstPath(sep);
        Nodable no = this.getNodable();
        if (no == null) {
            System.out.println("VarContext.getInstPath: context with null NodeInst?");
        }
        if (no instanceof NodeInst && (no2 = Netlist.getNodableFor((NodeInst)no, 0)) != null) {
            no = no2;
        }
        String me = no.getName();
        if (prefix.equals("")) {
            return me;
        }
        return prefix + sep + me;
    }

    public static float objectToFloat(Object obj, float def) {
        if (obj == null) {
            return def;
        }
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        try {
            Number n = TextUtils.parsePostFixNumber(obj.toString());
            return n.floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static int objectToInt(Object obj, int def) {
        if (obj == null) {
            return def;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        try {
            Number n = TextUtils.parsePostFixNumber(obj.toString());
            return n.intValue();
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static short objectToShort(Object obj, short def) {
        if (obj == null) {
            return def;
        }
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        try {
            Number n = TextUtils.parsePostFixNumber(obj.toString());
            return n.shortValue();
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static double objectToDouble(Object obj, double def) {
        if (obj == null) {
            return def;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        try {
            Number n = TextUtils.parsePostFixNumber(obj.toString());
            return n.doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public static class EvalException
    extends Exception {
        public EvalException() {
        }

        public EvalException(String message) {
            super(message);
        }

        public EvalException(String message, Throwable cause) {
            super(message, cause);
        }

        public EvalException(Throwable cause) {
            super(cause);
        }
    }

    private static class ValueCache {
        private final Map<EvalPair, Object> cache = new HashMap<EvalPair, Object>();

        private ValueCache() {
        }

        public synchronized boolean containsKey(Variable var, Object info) {
            return this.cache.containsKey(new EvalPair(var, info));
        }

        public synchronized Object get(Variable var, Object info) {
            return this.cache.get(new EvalPair(var, info));
        }

        public synchronized void put(Variable var, Object info, Object value) {
            EvalPair key = new EvalPair(var, info);
            LayoutLib.error(this.cache.containsKey(key), "duplicate keys in ValueCache?");
            this.cache.put(key, value);
        }

        private static class EvalPair {
            private final Variable var;
            private final Object info;

            public EvalPair(Variable v, Object i) {
                this.var = v;
                this.info = i;
            }

            public int hashCode() {
                return this.var.hashCode() * this.info.hashCode();
            }

            public boolean equals(Object o) {
                if (!(o instanceof EvalPair)) {
                    return false;
                }
                EvalPair ep = (EvalPair)o;
                return this.var == ep.var && this.info == ep.info;
            }
        }
    }
}

