/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.variable;

import com.sun.electric.database.variable.AbstractTextDescriptor;

public class MutableTextDescriptor
extends AbstractTextDescriptor {
    private boolean display;
    private long bits;
    private int colorIndex;
    private AbstractTextDescriptor.Code code;

    public MutableTextDescriptor(AbstractTextDescriptor descriptor) {
        this.display = descriptor.isDisplay();
        this.bits = descriptor.lowLevelGet();
        this.colorIndex = descriptor.getColorIndex();
        this.code = descriptor.getCode();
    }

    public MutableTextDescriptor() {
        this(0x10000000000L, 0, true, AbstractTextDescriptor.Code.NONE);
    }

    public MutableTextDescriptor(long descriptor, int colorIndex, boolean display, AbstractTextDescriptor.Code code) {
        this.display = display;
        this.bits = descriptor;
        this.colorIndex = colorIndex;
        this.code = code != null ? code : AbstractTextDescriptor.Code.NONE;
    }

    public void setCBits(int descriptor0, int descriptor1) {
        this.display = true;
        this.bits = (long)descriptor1 << 32 | (long)descriptor0 & 0xFFFFFFFFL;
        this.colorIndex = 0;
        this.code = AbstractTextDescriptor.Code.NONE;
    }

    public void setCBits(int descriptor0, int descriptor1, int cFlags) {
        this.display = (cFlags & 0x40) != 0;
        this.bits = (long)descriptor1 << 32 | (long)descriptor0 & 0xFFFFFFFFL;
        this.colorIndex = 0;
        this.code = AbstractTextDescriptor.Code.getByCBits(cFlags);
    }

    public boolean isDisplay() {
        return this.display;
    }

    public synchronized long lowLevelGet() {
        return this.bits;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public AbstractTextDescriptor.Code getCode() {
        return this.code;
    }

    private void setField(long mask, int shift, int value) {
        this.bits = this.bits & (mask ^ 0xFFFFFFFFFFFFFFFFL) | (long)value << shift & mask;
    }

    private void setFlag(long mask, boolean state) {
        this.bits = state ? this.bits | mask : this.bits & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static MutableTextDescriptor getNodeTextDescriptor() {
        return cacheNodeDescriptor.newMutableTextDescriptor();
    }

    public static MutableTextDescriptor getArcTextDescriptor() {
        return cacheArcDescriptor.newMutableTextDescriptor();
    }

    public static MutableTextDescriptor getExportTextDescriptor() {
        return cacheExportDescriptor.newMutableTextDescriptor();
    }

    public static MutableTextDescriptor getAnnotationTextDescriptor() {
        return cacheAnnotationDescriptor.newMutableTextDescriptor();
    }

    public static MutableTextDescriptor getInstanceTextDescriptor() {
        return cacheInstanceDescriptor.newMutableTextDescriptor();
    }

    public static MutableTextDescriptor getCellTextDescriptor() {
        return cacheCellDescriptor.newMutableTextDescriptor();
    }

    public void setDisplay(boolean state) {
        this.display = state;
    }

    public void setColorIndex(int colorIndex) {
        this.colorIndex = colorIndex;
    }

    public void setPos(AbstractTextDescriptor.Position p) {
        this.setField(15L, 0, p.getIndex());
    }

    public void setAbsSize(int s) {
        AbstractTextDescriptor.Size size = AbstractTextDescriptor.Size.newAbsSize(s);
        if (size == null) {
            System.out.println("Invalid absolute size of " + s);
            return;
        }
        this.setField(0x7FFF00000000L, 32, size.getBits());
    }

    public void setRelSize(double s) {
        AbstractTextDescriptor.Size size = AbstractTextDescriptor.Size.newRelSize(s);
        if (size == null) {
            System.out.println("Invalid relative size of " + s);
            return;
        }
        this.setField(0x7FFF00000000L, 32, size.getBits());
    }

    public void setFace(int f) {
        this.setField(17873661021126656L, 47, f);
    }

    public void setRotation(AbstractTextDescriptor.Rotation r) {
        this.setField(0xC0000000000000L, 54, r.getIndex());
    }

    public void setDispPart(AbstractTextDescriptor.DispPos d) {
        this.setField(48L, 4, d.getIndex());
    }

    public void setItalic(boolean state) {
        this.setFlag(64L, state);
    }

    public void setBold(boolean state) {
        this.setFlag(128L, state);
    }

    public void setUnderline(boolean state) {
        this.setFlag(256L, state);
    }

    public void setInterior(boolean state) {
        this.setFlag(1024L, state);
    }

    public void setInherit(boolean state) {
        this.setFlag(2048L, state);
    }

    public void setParam(boolean state) {
        this.setFlag(512L, state);
    }

    public void setOff(double xd, double yd) {
        boolean xneg = xd < 0.0;
        this.setFlag(0x200000L, xneg);
        if (xneg) {
            xd = -xd;
        }
        boolean yneg = yd < 0.0;
        this.setFlag(0x80000000L, yneg);
        if (yneg) {
            yd = -yd;
        }
        int scale = (int)(Math.max(xd, yd) * 4.0) >> 9;
        int x = Math.min((int)(xd * 4.0 / (double)(scale + 1) + 0.5), 511);
        int y = Math.min((int)(yd * 4.0 / (double)(scale + 1) + 0.5), 511);
        this.setField(0x1FF000L, 12, x);
        this.setField(2143289344L, 22, y);
        this.setField(0x1F00000000000000L, 56, scale);
    }

    public void setUnit(AbstractTextDescriptor.Unit u) {
        this.setField(-2305843009213693952L, 61, u.getIndex());
    }

    public void setCode(AbstractTextDescriptor.Code code) {
        this.code = code != null ? code : AbstractTextDescriptor.Code.NONE;
    }
}

