/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScanChainXML {
    private static final boolean DEBUG = false;
    private static final boolean FLAT = false;
    private static final boolean REDUCE = true;
    private String outputFile = null;
    private PrintWriter out;
    private File outFile = null;
    private JtagController jtagController = null;
    private HashMap<String, ScanChainElement> scanChainElements = new HashMap();
    private HashMap<String, PassThroughCell> passThroughCells = new HashMap();
    private HashMap<Cell, Cell> cellsToFlatten = new HashMap();
    private String chipName = "?";
    private Cell jtagCell = null;
    private Map<String, Entity> entities;
    private List<Chain> chains;
    private SubChain endChain;
    private List<String> chainStartExports = null;
    private List<String> chainNames = null;
    private List<ExPort> chainStartExPorts = null;

    public ScanChainXML() {
        this.out = new PrintWriter(System.out);
        this.entities = new HashMap<String, Entity>();
        this.chains = new ArrayList<Chain>();
    }

    public void addScanChainElement(String name, String access, String clears, String inport, String outport) {
        ScanChainElement e = new ScanChainElement(name, access, clears, inport, outport, "", "");
        this.scanChainElements.put(name + "_" + inport, e);
    }

    public void addScanChainElement(String name, String access, String clears, String inport, String outport, String dataport, String dataport2) {
        ScanChainElement e = new ScanChainElement(name, access, clears, inport, outport, dataport, dataport2);
        this.scanChainElements.put(name + "_" + inport, e);
    }

    public void addPassThroughCell(String cellName, String inport, String outport) {
        PassThroughCell p = new PassThroughCell(cellName, inport, outport);
        this.passThroughCells.put(cellName + "_" + inport, p);
    }

    public void addCellToFlatten(String libName, String cellName) {
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            System.out.println("Did not find library " + libName + " for flattening cell " + cellName);
            return;
        }
        Cell cell = lib.findNodeProto(cellName);
        if (cell == null) {
            System.out.println("Did not find cell " + cellName + " to flatten, in library " + libName);
            return;
        }
        this.cellsToFlatten.put(cell, cell);
    }

    public void setJtagController(String jtagLib, String jtagCellName, int lengthIR) {
        Library lib = Library.findLibrary(jtagLib);
        if (lib == null) {
            System.out.println("Did not find jtag library " + jtagLib);
            return;
        }
        Cell cell = lib.findNodeProto(jtagCellName);
        if (cell == null) {
            System.out.println("Did not find jtag cell " + jtagCellName + " in library " + jtagLib);
            return;
        }
        this.jtagCell = cell;
        this.jtagController = new JtagController(jtagCellName, lengthIR);
        this.endChain = new SubChain("end:jtagController", -1);
    }

    public void addJtagPort(int opcode, String soutPortName, String chainName) {
        if (this.jtagController == null) {
            System.out.println("Can't add port " + soutPortName + " because the jtag controller has not been defined yet");
            return;
        }
        this.jtagController.addPort(opcode, soutPortName, chainName);
    }

    public void startFromExport(String exportName, String chainName) {
        if (this.chainStartExports == null) {
            this.chainStartExports = new ArrayList<String>();
            this.chainNames = new ArrayList<String>();
            this.chainStartExPorts = new ArrayList<ExPort>();
        }
        this.chainStartExports.add(exportName);
        this.chainNames.add(chainName);
    }

    public void setChipName(String name) {
        this.chipName = name;
    }

    public void setOutput(String file) {
        this.outputFile = file;
        try {
            this.outFile = new File(this.outputFile);
            this.out = new PrintWriter(new BufferedWriter(new FileWriter(this.outFile)));
        }
        catch (IOException e) {
            System.out.println(e.getMessage() + "\nWriting XML to console");
        }
    }

    public void start(String libName, String cellName) {
        Library lib = Library.findLibrary(libName);
        if (lib == null) {
            System.out.println("Did not find library " + libName + " for starting chain analysis in cell " + cellName);
            return;
        }
        Cell cell = lib.findNodeProto(cellName);
        if (cell == null) {
            System.out.println("Did not find cell " + cellName + " for starting chain analysis, in library " + libName);
            return;
        }
        Stack<Nodable> startNode = null;
        if (this.chainStartExports != null) {
            for (int i = 0; i < this.chainStartExports.size(); ++i) {
                ExPort startExport = this.getExPort(cell, this.chainStartExports.get(i));
                if (startExport == null) {
                    System.out.println("Cannot find export " + this.chainStartExports.get(i) + " in cell " + cell.describe(false));
                    continue;
                }
                this.chainStartExPorts.add(startExport);
            }
            if (this.jtagController == null) {
                this.jtagController = new JtagController("", 8);
            }
        } else {
            if (this.jtagCell == null) {
                return;
            }
            startNode = this.findStartNode(cell, new Stack<Nodable>());
            if (startNode == null) {
                System.out.println("Did not find any usages of the jtag controller: " + this.jtagCell.getName());
                return;
            }
            Nodable no = (Nodable)startNode.lastElement();
            System.out.println("*** Generating chains starting from jtag controller " + no.getParent().describe(false) + " : " + no.getName());
        }
        this.start(startNode);
        if (this.outFile != null) {
            System.out.println("Wrote XML file to " + this.outFile.getAbsolutePath());
        } else {
            System.out.println("Wrote XML file to console");
        }
    }

    private Stack<Nodable> findStartNode(Cell cell, Stack<Nodable> context) {
        Netlist netlist = cell.getNetlist(true);
        Iterator<Nodable> it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable no = it.next();
            if (no.getProto().getName().equals(this.jtagCell.getName())) {
                context.push(no);
                return context;
            }
            if (!no.isCellInstance()) continue;
            Cell subCell = (Cell)no.getProto();
            if ((subCell = subCell.contentsView()) == null) {
                subCell = (Cell)no.getProto();
            }
            context.push(no);
            Stack<Nodable> next = this.findStartNode(subCell, context);
            if (next == null) {
                context.pop();
                continue;
            }
            return next;
        }
        return null;
    }

    private void start(Stack<Nodable> startNode) {
        Chain chain;
        if (startNode != null) {
            Iterator it = this.jtagController.getPorts();
            while (it.hasNext()) {
                JtagController.Port jtagPort = (JtagController.Port)it.next();
                if (jtagPort.soutPort == null) continue;
                String chainName = jtagPort.chainName;
                if (chainName == null) {
                    chainName = "chain_" + jtagPort.soutPort;
                }
                chain = new Chain(chainName, jtagPort.opcode, -1);
                Stack<Nodable> startNodeCopy = new Stack<Nodable>();
                startNodeCopy.addAll(startNode);
                this.startChain(chain, startNodeCopy, jtagPort.soutPort);
                int found = chain.numScanElements();
                System.out.println("Info: completed successfully: chain " + chainName + " had " + found + " scan chain elements");
                SubChain last = chain.getLastSubChain();
                if (last != this.endChain) {
                    System.out.println("Error! Chain " + chainName + " did not end at the jtag controller. Possible error in parsing or schematics.");
                    if (last != null) {
                        System.out.println("     Last sub chain is " + last.name + ", length=" + last.length);
                    }
                }
                this.chains.add(chain);
            }
        } else if (this.chainStartExPorts != null) {
            for (int i = 0; i < this.chainStartExPorts.size(); ++i) {
                ExPort startExport = this.chainStartExPorts.get(i);
                String name = this.chainNames.get(i);
                chain = new Chain(name, 0, -1);
                System.out.println("Tracing sub-chain " + name + " from export " + startExport);
                this.appendChain(chain, this.getOtherPorts(startExport));
                int found = chain.numScanElements();
                System.out.println("Info: completed successfully: chain " + name + " had " + found + " scan chain elements");
                this.chains.add(chain);
            }
        } else {
            System.out.println("No starting point, aborting.");
            return;
        }
        this.postProcessEntitiesRemovePassThroughs();
        this.postProcessEntitiesPhase1();
        this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.out.println("\n<!--");
        this.out.println("    Document      : " + this.outputFile);
        this.out.println("    Author        : automatically generated by Electric");
        this.out.println("    Description   : none");
        this.out.println("-->\n");
        this.out.println();
        this.out.println("<!DOCTYPE ChainG SYSTEM \"file:./ChainG.dtd\" [");
        for (Entity ent : this.entities.values()) {
            ent.writeDefinition(this.out, new StringBuffer(), this.cellsToFlatten);
        }
        this.out.println("]>");
        this.out.println();
        StringBuffer indent = new StringBuffer();
        this.out.println("<ChainG>");
        indent.append("\t");
        this.out.println(indent + "<system>");
        indent.append("\t");
        this.out.println(indent + "<chip name=\"" + this.chipName + "\" lengthIR=\"" + this.jtagController.lengthIR + "\">");
        indent.append("\t");
        for (Chain chain2 : this.chains) {
            if (chain2.numScanElements() == 0) continue;
            chain2.write(this.out, indent, null, this.cellsToFlatten);
        }
        indent.setLength(indent.length() - 1);
        this.out.println(indent + "</chip>");
        indent.setLength(indent.length() - 1);
        this.out.println(indent + "</system>");
        indent.setLength(indent.length() - 1);
        this.out.println("</ChainG>");
        this.out.flush();
    }

    private ScanChainElement getScanChainElement(String name, String sin) {
        ScanChainElement e = this.scanChainElements.get(name + "_" + sin);
        return e;
    }

    private PassThroughCell getPassThroughCell(String name, String sin) {
        PassThroughCell p = this.passThroughCells.get(name + "_" + sin);
        return p;
    }

    private SubChainInst startChain(Chain chain, Stack<Nodable> startNode, String startPortName) {
        ExPort outEx;
        if (startNode == null) {
            return null;
        }
        if (startNode.size() == 0) {
            return null;
        }
        Nodable no = (Nodable)startNode.remove(0);
        if (startNode.isEmpty()) {
            Port startPort = this.getPort(no, startPortName);
            if (startPort == null) {
                System.out.println("Can't find specified start port " + startPortName + " on jtag controller " + this.jtagController.name);
                return null;
            }
            SubChainInst subChainInst = this.appendChain(chain, this.getOtherPorts(startPort));
            if (subChainInst == null) {
                return new SubChainInst(null, startPort, null, null);
            }
            return subChainInst;
        }
        SubChain subChain = new SubChain(no.getName(), 0);
        SubChainInst curInst = new SubChainInst(null, null, no, subChain);
        chain.addSubChainInst(curInst);
        SubChainInst inst = this.startChain(subChain, startNode, startPortName);
        if (inst == null) {
            return null;
        }
        Port subOutPort = inst.getOutport();
        if (subOutPort != null && (outEx = this.getExportedPort(subOutPort)) != null) {
            Port outport = this.getPort(no, outEx.name.toString());
            curInst.setOutport(outport);
            inst = this.appendChain(chain, this.getOtherPorts(outport));
            if (inst != null) {
                curInst = inst;
            }
        }
        return curInst;
    }

    private SubChainInst getSubChain(Port inport) {
        Nodable no = inport.no;
        NodeProto np = no.getProto();
        PassThroughCell p = this.getPassThroughCell(np.getName(), inport.name.toString());
        if (p != null) {
            Port outport = this.getPort(no, p.outport);
            SubChain sub = new SubChain(p.cellName, -1);
            sub.setPassThrough(true);
            SubChainInst inst = new SubChainInst(inport, outport, no, sub);
            return inst;
        }
        if (no.isCellInstance()) {
            ScanChainElement e = this.getScanChainElement(np.getName(), inport.name.toString());
            if (e != null) {
                Port outport;
                SubChain sub;
                if (no.getNodeInst().getNameKey().isBus()) {
                    int size = no.getNodeInst().getNameKey().busWidth();
                    sub = new SubChain(no.getNodeInst().getName(), size, e.access, e.clears, e.dataport, e.dataport2);
                    Nodable lastNo = Netlist.getNodableFor(no.getNodeInst(), size - 1);
                    outport = this.getPort(lastNo, e.outport);
                    no = no.getNodeInst();
                } else {
                    sub = new SubChain(no.getName(), 1, e.access, e.clears, e.dataport, e.dataport2);
                    outport = this.getPort(no, e.outport);
                }
                SubChainInst inst = new SubChainInst(inport, outport, no, sub);
                return inst;
            }
            if (this.jtagCell != null && np.getName().equals(this.jtagCell.getName())) {
                SubChainInst inst = new SubChainInst(inport, null, no, this.endChain);
                return inst;
            }
            Cell sch = ((Cell)np).contentsView();
            if (sch == null) {
                sch = (Cell)np;
            }
            SubChainInst inst = this.getSubChain(sch, inport);
            return inst;
        }
        return null;
    }

    private DataNet getScanDataNet(Nodable no, DataNet definition) {
        if (definition == null) {
            return null;
        }
        String name = this.getNetName(no, definition.net);
        return new DataNet(name, definition.options);
    }

    private String getNetName(Nodable no, String portName) {
        String netName = null;
        PortInst pi = no.getNodeInst().findPortInst(portName);
        if (pi == null) {
            return null;
        }
        if (pi.hasConnections()) {
            ArcInst ai = pi.getConnections().next().getArc();
            Name busName = no.getParent().getNetlist(true).getBusName(ai);
            netName = busName == null ? no.getParent().getNetlist(true).getNetwork(ai, 0).getName() : busName.toString();
        }
        return netName;
    }

    private SubChainInst getSubChain(Cell cell, Port inport) {
        Nodable no = inport.no;
        Export inputEx = cell.findExport(inport.pp.getNameKey());
        ExPort schInPort = new ExPort(inport.name, inputEx, inport.index);
        String key = cell.describe(false) + schInPort.name.toString();
        Entity ent = this.entities.get(key);
        Port outport = null;
        if (ent == null) {
            Port lastOutport;
            if (inputEx == null) {
                System.out.println("Error! In " + cell + ", scan data input Export " + inport.name + " not found.");
                return null;
            }
            ent = new Entity(cell);
            ent.setInExPort(schInPort);
            this.entities.put(key, ent);
            ArrayList<Port> nextPorts = this.getOtherPorts(schInPort);
            SubChainInst lastInst = this.appendChain(ent, nextPorts);
            if (lastInst != null && (lastOutport = lastInst.getOutport()) != null) {
                ExPort outEx = this.getExportedPort(lastOutport);
                if (outEx == null) {
                    System.out.println("Error! In " + cell + ", last element \"" + lastOutport.no.getName() + "\", output port \"" + lastOutport + "\"" + " does not connect to another scan element, is not exported from cell, and does not terminate at the JTAG Controller");
                } else {
                    ent.setOutExPort(outEx);
                    outport = this.getPort(no, outEx.name.toString());
                }
            }
        } else {
            ExPort outEx = ent.getOutExPort();
            if (outEx != null) {
                outport = this.getPort(no, outEx.name.toString());
            }
        }
        return new SubChainInst(inport, outport, no, ent);
    }

    private SubChainInst appendChain(Chain chain, List<Port> ports) {
        SubChainInst inst;
        ArrayList<Chain> possibleChains = new ArrayList<Chain>();
        ArrayList<SubChainInst> chainLastInstances = new ArrayList<SubChainInst>();
        for (Port p : ports) {
            Port outport;
            inst = this.getSubChain(p);
            if (inst == null) continue;
            Chain tempChain = new Chain("temp", -1, -1);
            SubChain sub = inst.content;
            if (sub == this.endChain) {
                tempChain.addSubChainInst(inst);
                if (tempChain.getSubChainSize() <= 0) continue;
                possibleChains.add(tempChain);
                chainLastInstances.add(inst);
                continue;
            }
            if (sub != null && (sub.getLength() > 0 || sub.getSubChainSize() > 0 || sub.isPassThrough())) {
                tempChain.addSubChainInst(inst);
            }
            if ((outport = inst.getOutport()) == null) continue;
            SubChainInst last = inst;
            ArrayList<Port> nextPorts = this.getOtherPorts(outport);
            SubChainInst appendLast = this.appendChain(tempChain, nextPorts);
            if (appendLast != null) {
                last = appendLast;
            }
            if (tempChain.getSubChainSize() <= 0) continue;
            possibleChains.add(tempChain);
            chainLastInstances.add(last);
        }
        if (possibleChains.size() == 0) {
            return null;
        }
        if (possibleChains.size() > 1) {
            System.out.print("Error! Found more than one chain branching from port set: ");
            Port p2 = null;
            for (Port p2 : ports) {
                System.out.print(p2.no.getName() + ":" + p2.name + ", ");
            }
            System.out.println("in cell " + p2.no.getParent().describe(false));
        }
        Chain temp = (Chain)possibleChains.get(0);
        Iterator<Object> it = temp.getSubChainInsts();
        while (it.hasNext()) {
            inst = (SubChainInst)it.next();
            chain.addSubChainInst(inst);
        }
        return (SubChainInst)chainLastInstances.get(0);
    }

    private void postProcessEntitiesRemovePassThroughs() {
        for (Entity ent : this.entities.values()) {
            ent.removePassThroughs();
        }
    }

    private void postProcessEntitiesPhase1() {
        int reduced = 1;
        while (reduced > 0) {
            reduced = 0;
            for (Entity ent : this.entities.values()) {
                SubChain sub;
                if (ent.length <= 0 && ent.getSubChainSize() == 1) {
                    SubChainInst inst = ent.getSubChainInsts().next();
                    sub = inst.getSubChain();
                    if (sub.length > 0 && sub.getSubChainSize() == 0 && this.isFlattenable(inst)) {
                        ent.length = sub.length;
                        ent.access = sub.access;
                        ent.clears = sub.clears;
                        ent.dataNet = sub.dataNet != null ? new DataNet("x" + inst.getName() + "." + sub.dataNet.net, sub.dataNet.options) : null;
                        ent.dataNet2 = sub.dataNet2 != null ? new DataNet("x" + inst.getName() + "." + sub.dataNet2.net, sub.dataNet2.options) : null;
                        ent.remove(inst);
                        ++reduced;
                    }
                }
                if (ent.length > 0) continue;
                for (int i = 0; i < ent.getSubChainSize(); ++i) {
                    Entity subEnt;
                    sub = ent.getSubChain(i);
                    SubChainInst inst = ent.getSubChainInst(i);
                    if (!(sub instanceof Entity) || this.cellsToFlatten.get((subEnt = (Entity)sub).cell) == null || !this.isFlattenable(inst) || sub.length >= 0 || sub.getSubChainSize() <= 0) continue;
                    ent.remove(ent.getSubChainInst(i));
                    ent.addAllSubChainInsts(i, sub.getSubChainsInsts());
                    ++reduced;
                }
            }
        }
    }

    private boolean isMergable(SubChainInst inst) {
        return inst.getName().matches(".*?@.*");
    }

    private boolean isFlattenable(SubChainInst inst) {
        return inst.getName().matches(".*?@.*");
    }

    private ExPort getExportedPort(Port port) {
        if (port == null) {
            return null;
        }
        Cell cell = port.no.getParent();
        Netlist netlist = cell.getNetlist(true);
        Network net = netlist.getNetwork(port.no, port.pp, port.index);
        Iterator<PortProto> it = cell.getPorts();
        while (it.hasNext()) {
            Export ex = (Export)it.next();
            Name name = ex.getNameKey();
            for (int i = 0; i < name.busWidth(); ++i) {
                if (netlist.getNetwork(ex, i) != net) continue;
                return new ExPort(name.subname(i), ex, i);
            }
        }
        return null;
    }

    private ArrayList<Port> getOtherPorts(ExPort inport) {
        PortProto equiv;
        PortInst pi = inport.ex.getOriginalPort();
        NodeInst ni = pi.getNodeInst();
        Netlist netlist = ni.getParent().getNetlist(true);
        Network net = netlist.getNetwork(inport.ex, inport.index);
        Port port = null;
        PortProto pp = pi.getPortProto();
        if (pp instanceof Export && (equiv = ((Export)pp).getEquivalent()) != null) {
            pp = equiv;
        }
        Iterator<Nodable> it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable no = it.next();
            if (no.getNodeInst() != ni || net != netlist.getNetwork(no, pp, inport.index)) continue;
            port = new Port(inport.name, no, pp, inport.index);
            break;
        }
        if (port == null) {
            port = new Port(inport.name, ni, pp, inport.index);
            ArrayList<Port> list = new ArrayList<Port>();
            list.add(port);
            return list;
        }
        return this.getOtherPorts(port, false);
    }

    private ArrayList<Port> getOtherPorts(Port inport) {
        return this.getOtherPorts(inport, true);
    }

    private ArrayList<Port> getOtherPorts(Port inport, boolean ignoreInport) {
        if (inport == null) {
            return null;
        }
        ArrayList<Port> ports = new ArrayList<Port>();
        Cell cell = inport.no.getParent();
        Netlist netlist = cell.getNetlist(true);
        Network net = netlist.getNetwork(inport.no, inport.pp, inport.index);
        Iterator<Nodable> it = netlist.getNodables();
        while (it.hasNext()) {
            Nodable no = it.next();
            Iterator<PortProto> it2 = no.getProto().getPorts();
            while (it2.hasNext()) {
                PortProto pp = it2.next();
                Name name = pp.getNameKey();
                for (int i = 0; i < name.busWidth(); ++i) {
                    if (ignoreInport && no == inport.no && pp == inport.pp && i == inport.index || netlist.getNetwork(no, pp, i) != net) continue;
                    Name subname = name;
                    if (name.busWidth() > 1) {
                        subname = name.subname(i);
                    }
                    Port p = new Port(subname, no, pp, i);
                    ports.add(p);
                }
            }
        }
        if (ports.size() == 0) {
            if (!ignoreInport) {
                ports.add(inport);
                return ports;
            }
            System.out.println("Warning: no other ports connected to port " + inport.name + " on node " + inport.no.getName() + " in cell " + inport.no.getParent().describe(false));
        }
        return ports;
    }

    private Port getPort(Nodable no, String portName) {
        Iterator<PortProto> it = no.getProto().getPorts();
        while (it.hasNext()) {
            PortProto pp = it.next();
            Name name = pp.getNameKey();
            for (int i = 0; i < name.busWidth(); ++i) {
                Name subname = name.subname(i);
                if (!subname.toString().equals(portName)) continue;
                return new Port(subname, no, pp, i);
            }
        }
        System.out.println("Could not find " + portName + " on " + no.getName());
        return null;
    }

    private ExPort getExPort(Cell cell, String exportName) {
        Iterator<PortProto> it = cell.getPorts();
        while (it.hasNext()) {
            Export ex = (Export)it.next();
            Name name = ex.getNameKey();
            for (int i = 0; i < name.busWidth(); ++i) {
                Name subname = name.subname(i);
                if (!subname.toString().equals(exportName)) continue;
                return new ExPort(subname, ex, i);
            }
        }
        return null;
    }

    private static class ExPort {
        private Export ex;
        private int index;
        private Name name;

        private ExPort(Name name, Export ex, int index) {
            this.name = name;
            this.ex = ex;
            this.index = index;
        }

        public String toString() {
            if (this.name == null) {
                return null;
            }
            return this.name.toString();
        }

        public void print() {
            System.out.println("  Name: " + this.name);
            System.out.println("  Ex: " + this.ex);
            System.out.println("  int: " + this.index);
        }
    }

    private static class Port {
        private PortProto pp;
        private int index;
        private Name name;
        private Nodable no;

        private Port(Name name, Nodable no, PortProto pp, int index) {
            this.name = name;
            this.no = no;
            this.pp = pp;
            this.index = index;
        }

        public String toString() {
            if (this.name == null) {
                return null;
            }
            return this.no.getName() + ":" + this.name.toString();
        }

        public void print() {
            System.out.println("  Name: " + this.name);
            System.out.println("  No: " + this.no);
            System.out.println("  int: " + this.index);
            System.out.println("  pp: " + this.pp);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entity
    extends SubChain {
        private static final String deftag = "!ENTITY";
        private Cell cell;
        private ExPort inExport;
        private ExPort outExport;

        private Entity(Cell cell) {
            super(cell.getLibrary().getName() + "_" + cell.getName(), -1);
            this.cell = cell;
        }

        private void setInExPort(ExPort port) {
            this.inExport = port;
        }

        private ExPort getInExPort() {
            return this.inExport;
        }

        private void setOutExPort(ExPort port) {
            this.outExport = port;
        }

        private ExPort getOutExPort() {
            return this.outExport;
        }

        protected void writeDefinition(PrintWriter out, StringBuffer indent, Map<Cell, Cell> cellsToFlatten) {
            if (this.numScanElements() < 3 || this.getSubChainSize() == 0) {
                return;
            }
            out.println(indent + "<" + deftag + " " + this.getKey() + " '");
            indent.append("\t");
            Iterator<SubChainInst> it = this.getSubChainInsts();
            while (it.hasNext()) {
                SubChainInst inst = it.next();
                SubChain subChain = inst.getSubChain();
                subChain.write(out, indent, inst.getName(), cellsToFlatten);
            }
            indent.setLength(indent.length() - 1);
            out.println(indent + "'>");
        }

        @Override
        protected void write(PrintWriter out, StringBuffer indent, String instName, Map<Cell, Cell> cellsToFlatten) {
            if (this.numScanElements() < 3 || this.getSubChainSize() == 0) {
                super.write(out, indent, instName, cellsToFlatten);
            } else {
                out.println(indent + "<subchain name=\"" + instName + "\"> &" + this.getKey() + "; </subchain>");
            }
        }

        private Object getKey() {
            String key = this.name + "_" + this.inExport.name.toString();
            key = key.replaceAll("[\\[\\]]", "_");
            return key;
        }

        @Override
        public Object clone() {
            Entity ent = new Entity(this.cell);
            this.copyTo(ent);
            ent.inExport = this.inExport;
            ent.outExport = this.outExport;
            return ent;
        }
    }

    private static class SubChain
    extends Chain {
        private boolean passThrough;

        private SubChain(String name, int length, String access, String clears, DataNet dataNet, DataNet dataNet2) {
            super(name, -1, length, access, clears, dataNet, dataNet2);
            this.passThrough = false;
        }

        private SubChain(String name, int length) {
            super(name, -1, length);
        }

        protected String getTag() {
            return "subchain";
        }

        private void setPassThrough(boolean b) {
            this.passThrough = b;
        }

        private boolean isPassThrough() {
            return this.passThrough;
        }

        protected SubChain getLastSubChain() {
            if (this.getSubChainSize() == 0) {
                return this;
            }
            return super.getLastSubChain();
        }

        public Object clone() {
            SubChain sub = new SubChain(this.name, this.length, this.access, this.clears, this.dataNet, this.dataNet2);
            this.copyTo(sub);
            sub.passThrough = this.passThrough;
            return sub;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Chain {
        protected String name;
        private int opcode;
        protected int length;
        protected String access;
        protected String clears;
        protected DataNet dataNet;
        protected DataNet dataNet2;
        private List<SubChainInst> subchains;

        private Chain(String name, int opcode, int length, String access, String clears, DataNet dataNet, DataNet dataNet2) {
            this.name = name;
            this.opcode = opcode;
            this.length = length;
            this.access = access;
            this.clears = clears;
            this.dataNet = dataNet;
            this.dataNet2 = dataNet2;
            this.subchains = new ArrayList<SubChainInst>();
        }

        private Chain(String name, int opcode, int length) {
            this(name, opcode, length, null, null, null, null);
        }

        protected void addSubChainInst(SubChainInst subChain) {
            this.subchains.add(subChain);
        }

        protected int getSubChainSize() {
            return this.subchains.size();
        }

        protected SubChainInst getSubChainInst(int i) {
            return this.subchains.get(i);
        }

        protected SubChain getSubChain(int i) {
            SubChainInst inst = this.subchains.get(i);
            if (inst == null) {
                return null;
            }
            return inst.getSubChain();
        }

        protected Iterator<SubChainInst> getSubChainInsts() {
            return this.subchains.iterator();
        }

        protected Iterator<SubChain> getSubChains() {
            ArrayList<SubChain> subs = new ArrayList<SubChain>();
            for (SubChainInst inst : this.subchains) {
                subs.add(inst.getSubChain());
            }
            return subs.iterator();
        }

        protected int getLength() {
            return this.length;
        }

        protected String getAccess() {
            return this.access;
        }

        protected String getClears() {
            return this.clears;
        }

        protected void write(PrintWriter out, StringBuffer indent, String instName, Map<Cell, Cell> cellsToFlatten) {
            if (this.numScanElements() == 0) {
                return;
            }
            String n = instName == null ? this.name : instName;
            out.print(indent + "<" + this.getTag() + " name=\"" + n + "\"");
            if (this.opcode > -1) {
                out.print(" opcode=\"" + Integer.toBinaryString(this.opcode) + "\"");
            }
            if (this.length > 0) {
                out.print(" length=\"" + this.length + "\"");
            }
            if (this.access != null) {
                out.print(" access=\"" + this.access + "\"");
            }
            if (this.clears != null) {
                out.print(" clears=\"" + this.clears + "\"");
            }
            if (this.dataNet != null) {
                out.print(" dataNet=\"" + this.dataNet + "\"");
            }
            if (this.dataNet2 != null) {
                out.print(" dataNet2=\"" + this.dataNet2 + "\"");
            }
            if (this.subchains.size() == 0) {
                out.println(" />");
                return;
            }
            out.println(">");
            indent.append("\t");
            Iterator<SubChainInst> it = this.getSubChainInsts();
            while (it.hasNext()) {
                SubChainInst inst = it.next();
                SubChain subChain = inst.getSubChain();
                subChain.write(out, indent, inst.getName(), cellsToFlatten);
            }
            indent.setLength(indent.length() - 1);
            out.println(indent + "</" + this.getTag() + ">");
        }

        protected String getTag() {
            return "chain";
        }

        protected int numScanElements() {
            int num = 0;
            if (this.length > 0) {
                num += this.length;
            }
            for (SubChainInst inst : this.subchains) {
                SubChain sub = inst.getSubChain();
                num += sub.numScanElements();
            }
            return num;
        }

        protected SubChain getLastSubChain() {
            if (this.subchains.size() == 0) {
                return null;
            }
            SubChainInst last = this.subchains.get(this.subchains.size() - 1);
            return last.getSubChain().getLastSubChain();
        }

        protected void copyTo(Chain dest) {
            dest.name = this.name;
            dest.length = this.length;
            dest.access = this.access;
            dest.clears = this.clears;
            dest.subchains.clear();
            dest.subchains.addAll(this.subchains);
        }

        protected void removePassThroughs() {
            ArrayList<SubChainInst> toRemove = new ArrayList<SubChainInst>();
            Iterator<SubChainInst> it2 = this.getSubChainInsts();
            while (it2.hasNext()) {
                SubChainInst inst = it2.next();
                SubChain sub = inst.getSubChain();
                if (!sub.isPassThrough()) continue;
                toRemove.add(inst);
            }
            for (SubChainInst sci : toRemove) {
                this.subchains.remove(sci);
            }
        }

        protected void replaceSubChainInsts(List<SubChainInst> newSubChainInsts) {
            this.subchains.clear();
            this.subchains.addAll(newSubChainInsts);
        }

        protected void remove(SubChainInst inst) {
            this.subchains.remove(inst);
        }

        protected List<SubChainInst> getSubChainsInsts() {
            ArrayList<SubChainInst> copy = new ArrayList<SubChainInst>();
            Iterator<SubChainInst> it = this.getSubChainInsts();
            while (it.hasNext()) {
                copy.add(it.next());
            }
            return copy;
        }

        protected void addAllSubChainInsts(int i, List<SubChainInst> list) {
            this.subchains.addAll(i, list);
        }
    }

    private static class SubChainInst {
        private Port inport;
        private Port outport;
        private Nodable no;
        private SubChain content;

        private SubChainInst(Port inport, Port outport, Nodable no, SubChain content) {
            this.inport = inport;
            this.outport = outport;
            this.no = no;
            this.content = content;
        }

        protected void setInport(Port port) {
            this.inport = port;
        }

        protected Port getInport() {
            return this.inport;
        }

        protected void setOutport(Port port) {
            this.outport = port;
        }

        protected Port getOutport() {
            return this.outport;
        }

        public String toString() {
            return "SubChainInst " + this.no.getName() + "; in: " + this.inport + ", out: " + this.outport;
        }

        protected SubChain getSubChain() {
            return this.content;
        }

        protected String getName() {
            return this.no.getName();
        }
    }

    private static class PassThroughCell {
        public final String cellName;
        public final String inport;
        public final String outport;

        public PassThroughCell(String cellName, String inport, String outport) {
            this.cellName = cellName;
            this.inport = inport;
            this.outport = outport;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JtagController {
        public final String name;
        public final int lengthIR;
        private List<Port> ports;

        private JtagController(String name, int lengthIR) {
            this.name = name;
            this.lengthIR = lengthIR;
            this.ports = new ArrayList<Port>();
        }

        private void addPort(int opcode, String soutPort, String chainName) {
            Port p = new Port(opcode, soutPort, chainName);
            this.ports.add(p);
        }

        private Iterator<Port> getPorts() {
            return this.ports.iterator();
        }

        protected static class Port {
            public final int opcode;
            public final String soutPort;
            public final String chainName;

            public Port(int opcode, String soutPort, String chainName) {
                this.opcode = opcode;
                this.soutPort = soutPort;
                this.chainName = chainName;
            }
        }
    }

    private static class DataNet {
        public final String net;
        public final String options;

        public DataNet(String netName) {
            int i = netName.indexOf(40);
            if (i != -1) {
                this.net = netName.substring(0, i);
                this.options = netName.substring(i, netName.length());
            } else {
                this.net = netName;
                this.options = "";
            }
        }

        public DataNet(String net, String options) {
            this.net = net;
            this.options = options;
        }

        public String toString() {
            return this.net + this.options;
        }
    }

    private static class ScanChainElement {
        public final String name;
        public final String access;
        public final String clears;
        public final String inport;
        public final String outport;
        public final DataNet dataport;
        public final DataNet dataport2;

        private ScanChainElement(String name, String access, String clears, String inport, String outport, String dataport, String dataport2) {
            this.name = name;
            this.access = access;
            this.clears = clears;
            this.inport = inport;
            this.outport = outport;
            this.dataport = dataport == null || dataport.equals("") ? null : new DataNet(dataport);
            this.dataport2 = dataport2 == null || dataport2.equals("") ? null : new DataNet(dataport2);
        }
    }
}

