/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.lib.LibFile;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.simulation.DigitalSignal;
import com.sun.electric.tool.simulation.Engine;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.simulation.als.ALS;
import com.sun.electric.tool.user.CompileVHDL;
import com.sun.electric.tool.user.GenerateVHDL;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WaveformWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class Simulation
extends Listener {
    private static Simulation tool = new Simulation();
    public static final Variable.Key RISE_DELAY_KEY = Variable.newKey("SIM_rise_delay");
    public static final Variable.Key FALL_DELAY_KEY = Variable.newKey("SIM_fall_delay");
    public static final Variable.Key WEAK_NODE_KEY = Variable.newKey("SIM_weak_node");
    public static final Variable.Key M_FACTOR_KEY = Variable.newKey("ATTR_M");
    public static final int ALS_ENGINE = 0;
    public static final int IRSIM_ENGINE = 1;
    private static boolean irsimChecked = false;
    private static Class irsimClass = null;
    private static Method irsimSimulateMethod;
    private static final int CONVERT_TO_VHDL = 1;
    private static final int SIMULATENETLIST = 2;
    private static final int COMPILE_VHDL_FOR_SIM = 4;
    private static Pref cacheFastHenryUseSingleFrequency;
    private static Pref cacheFastHenryStartFrequency;
    private static Pref cacheFastHenryEndFrequency;
    private static Pref cacheFastHenryRunsPerDecade;
    private static Pref cacheFastHenryMultiPole;
    private static Pref cacheFastHenryNumPoles;
    private static Pref cacheFastHenryDefThickness;
    private static Pref cacheFastHenryWidthSubdivisions;
    private static Pref cacheFastHenryHeightSubdivisions;
    private static Pref cacheFastHenryMaxSegLength;
    private static Pref cacheVerilogUseAssign;
    private static Pref cacheVerilogUseTrireg;
    private static Pref cacheCDLLibName;
    private static Pref cacheCDLLibPath;
    private static Pref cacheCDLConvertBrackets;
    private static Pref cacheCDLIncludeFile;
    private static Pref cacheCDLIgnoreResistors;
    private static Pref cacheBuiltInResimulateEach;
    private static Pref cacheBuiltInAutoAdvance;
    private static Pref cacheWaveformDisplayMultiState;
    private static Pref cacheIRSIMShowsCommands;
    private static Pref cacheIRSIMDebugging;
    private static Pref cacheIRSIMParameterFile;
    private static Pref cacheIRSIMStepModel;
    private static Pref cacheIRSIMDelayedX;
    public static final int SPICE_ENGINE_2 = 0;
    public static final int SPICE_ENGINE_3 = 1;
    public static final int SPICE_ENGINE_H = 2;
    public static final int SPICE_ENGINE_P = 3;
    public static final int SPICE_ENGINE_G = 4;
    public static final int SPICE_ENGINE_S = 5;
    private static Pref cacheSpiceEngine;
    private static Pref cacheSpiceLevel;
    private static Pref cacheSpiceOutputFormat;
    public static final String spiceRunChoiceDontRun = "Don't Run";
    public static final String spiceRunChoiceRunIgnoreOutput = "Run, Ingore Output";
    public static final String spiceRunChoiceRunReportOutput = "Run, Report Output";
    private static final String[] spiceRunChoices;
    private static Pref cacheSpiceRunChoice;
    private static Pref cacheSpiceRunDir;
    private static Pref cacheSpiceUseRunDir;
    private static Pref cacheSpiceOutputOverwrite;
    private static Pref cacheSpiceRunProbe;
    private static Pref cacheSpiceRunProgram;
    private static Pref cacheSpiceRunProgramArgs;
    private static Pref cacheSpicePartsLibrary;
    private static Pref cacheSpiceHeaderCardInfo;
    private static Pref cacheSpiceTrailerCardInfo;
    private static Pref cacheSpiceUseParasitics;
    public static Pref cacheParasiticsUseVerboseNaming;
    public static Pref cacheParasiticsBackAnnotateLayout;
    public static Pref cacheParasiticsExtractPowerGround;
    public static Pref cacheSpiceExtractMeNetsOnly;
    private static Pref cacheSpiceUseNodeNames;
    private static Pref cacheSpiceForceGlobalPwrGnd;
    private static Pref cacheSpiceUseCellParameters;
    private static Pref cacheSpiceWriteTransSizeInLambda;
    private static Pref cacheSpiceWriteSubcktTopCell;
    private static Pref cacheSpiceMaxSeriesResistance;

    private Simulation() {
        super("simulation");
    }

    public void init() {
    }

    public static Simulation getSimulationTool() {
        return tool;
    }

    public static void startSimulation(int engine, boolean forceDeck, Cell prevCell, Engine prevEngine) {
        Cell cell = null;
        VarContext context = null;
        String fileName = null;
        if (prevCell != null) {
            cell = prevCell;
        } else if (forceDeck) {
            fileName = OpenFile.chooseInputFile(FileType.IRSIM, "IRSIM deck to simulate");
            if (fileName == null) {
                return;
            }
            cell = WindowFrame.getCurrentCell();
        } else {
            cell = WindowFrame.needCurCell();
            if (cell == null) {
                return;
            }
            EditWindow wnd = EditWindow.getCurrent();
            if (wnd != null) {
                context = wnd.getVarContext();
            }
        }
        switch (engine) {
            case 0: {
                int activities = 2;
                Cell originalCell = cell;
                if (cell.getView() != View.NETLISTALS) {
                    if (cell.getView() == View.SCHEMATIC || cell.getView() == View.LAYOUT) {
                        Cell vhdlCell = cell.otherView(View.VHDL);
                        if (vhdlCell != null && vhdlCell.getRevisionDate().after(cell.getRevisionDate())) {
                            cell = vhdlCell;
                        } else {
                            activities |= 5;
                        }
                    }
                    if (cell.getView() == View.VHDL) {
                        Cell netListCell = cell.otherView(View.NETLISTQUISC);
                        if (netListCell != null && netListCell.getRevisionDate().after(cell.getRevisionDate())) {
                            cell = netListCell;
                        } else {
                            activities |= 4;
                        }
                    }
                }
                DoNextActivity sJob = new DoNextActivity(cell, activities, originalCell, context, prevEngine);
                break;
            }
            case 1: {
                if (!Simulation.hasIRSIM()) {
                    return;
                }
                Simulation.runIRSIM(cell, context, fileName);
            }
        }
    }

    public static boolean hasIRSIM() {
        if (!irsimChecked) {
            irsimChecked = true;
            try {
                irsimClass = Class.forName("com.sun.electric.plugins.irsim.Analyzer");
            }
            catch (ClassNotFoundException e) {
                irsimClass = null;
                return false;
            }
            try {
                irsimSimulateMethod = irsimClass.getMethod("simulateCell", Cell.class, VarContext.class, String.class);
            }
            catch (NoSuchMethodException e) {
                irsimClass = null;
                return false;
            }
        }
        return irsimClass != null;
    }

    public static void runIRSIM(Cell cell, VarContext context, String fileName) {
        try {
            irsimSimulateMethod.invoke((Object)irsimClass, cell, context, fileName);
            return;
        }
        catch (Exception e) {
            System.out.println("Unable to run the IRSIM simulator");
            e.printStackTrace(System.out);
            return;
        }
    }

    public static void update() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        engine.update();
    }

    public static void setSignalHigh() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        engine.setSignalHigh();
    }

    public static void setSignalLow() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        engine.setSignalLow();
    }

    public static void setSignalX() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        engine.setSignalX();
    }

    public static void setClock() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        double period = ClockSpec.getClockSpec();
        if (period <= 0.0) {
            return;
        }
        engine.setClock(period);
    }

    public static void showSignalInfo() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        engine.showSignalInfo();
    }

    public static void removeStimuliFromSignal() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        engine.removeStimuliFromSignal();
    }

    public static void removeSelectedStimuli() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        engine.removeSelectedStimuli();
    }

    public static void removeAllStimuli() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        engine.removeAllStimuli();
    }

    public static void saveStimuli() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        engine.saveStimuli();
    }

    public static void restoreStimuli() {
        Engine engine = Simulation.findEngine();
        if (engine == null) {
            return;
        }
        engine.restoreStimuli();
    }

    private static Engine findEngine() {
        Engine engine = null;
        Iterator it = WindowFrame.getWindows();
        while (it.hasNext()) {
            WaveformWindow ww;
            Engine e;
            WindowFrame wf = (WindowFrame)it.next();
            if (!(wf.getContent() instanceof WaveformWindow) || (e = (ww = (WaveformWindow)wf.getContent()).getSimEngine()) == null) continue;
            if (wf == WindowFrame.getCurrentWindowFrame()) {
                return e;
            }
            engine = e;
        }
        if (engine == null) {
            System.out.println("No simulator is ready to handle the command");
        }
        return engine;
    }

    public static void setSpiceModel() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        NodeInst ni = (NodeInst)highlighter.getOneElectricObject(NodeInst.class);
        if (ni == null) {
            return;
        }
        SetSpiceModel job = new SetSpiceModel(ni);
    }

    public static void setVerilogWireCommand(int type) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        List list = highlighter.getHighlightedEObjs(false, true);
        if (list.size() == 0) {
            System.out.println("Must select arcs before setting their type");
            return;
        }
        SetWireType job = new SetWireType(list, type);
    }

    public static void setTransistorStrengthCommand(boolean weak) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return;
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return;
        }
        NodeInst ni = (NodeInst)highlighter.getOneElectricObject(NodeInst.class);
        if (ni == null) {
            return;
        }
        SetTransistorStrength job = new SetTransistorStrength(ni, weak);
    }

    public static void showSimulationData(Stimuli sd, WaveformWindow ww) {
        WaveformWindow.Panel wp;
        if (ww != null) {
            ww.setSimData(sd);
            return;
        }
        WindowFrame wf = WindowFrame.createWaveformWindow(sd);
        ww = (WaveformWindow)wf.getContent();
        Rectangle2D bounds = sd.getBounds();
        double lowTime = bounds.getMinX();
        double highTime = bounds.getMaxX();
        double lowValue = bounds.getMinY();
        double highValue = bounds.getMaxY();
        double timeRange = highTime - lowTime;
        ww.setMainTimeCursor(timeRange * 0.2 + lowTime);
        ww.setExtensionTimeCursor(timeRange * 0.8 + lowTime);
        ww.setDefaultTimeRange(lowTime, highTime);
        if (sd.getCell() != null) {
            String[] signalNames = WaveformWindow.getSignalOrder(sd.getCell());
            boolean isAnalog = sd.isAnalog();
            boolean showedSomething = false;
            for (int i = 0; i < signalNames.length; ++i) {
                int tabPos;
                String signalName = signalNames[i];
                WaveformWindow.Panel wp2 = null;
                boolean firstSignal = true;
                int start = 0;
                do {
                    tabPos = signalName.indexOf(9, start);
                    String sigName = null;
                    if (tabPos < 0) {
                        sigName = signalName.substring(start);
                    } else {
                        sigName = signalName.substring(start, tabPos);
                        start = tabPos + 1;
                    }
                    Signal sSig = sd.findSignalForNetwork(sigName);
                    if (sSig == null) continue;
                    if (firstSignal) {
                        firstSignal = false;
                        wp2 = new WaveformWindow.Panel(ww, isAnalog);
                        wp2.makeSelectedPanel();
                        showedSomething = true;
                    }
                    new WaveformWindow.WaveSignal(wp2, sSig);
                } while (tabPos >= 0);
            }
            if (showedSomething) {
                if (isAnalog) {
                    Iterator it = ww.getPanels();
                    while (it.hasNext()) {
                        wp = (WaveformWindow.Panel)it.next();
                        List signals = wp.getSignals();
                        boolean first = true;
                        double lowY = 0.0;
                        double highY = 0.0;
                        Iterator sIt = signals.iterator();
                        while (sIt.hasNext()) {
                            WaveformWindow.WaveSignal ws = (WaveformWindow.WaveSignal)sIt.next();
                            Signal sSig = ws.getSignal();
                            Rectangle2D sigBounds = sSig.getBounds();
                            if (first) {
                                lowY = sigBounds.getMinY();
                                highY = sigBounds.getMaxY();
                                first = false;
                                continue;
                            }
                            if (sigBounds.getMinY() < lowY) {
                                lowY = sigBounds.getMinY();
                            }
                            if (!(sigBounds.getMaxY() > highY)) continue;
                            highY = sigBounds.getMaxY();
                        }
                        if (first) continue;
                        wp.setValueRange(lowY, highY);
                    }
                }
                return;
            }
        }
        if (sd.isAnalog()) {
            WaveformWindow.Panel wp3 = new WaveformWindow.Panel(ww, true);
            wp3.setValueRange(lowValue, highValue);
            wp3.makeSelectedPanel();
        } else {
            int numSignals = 0;
            Simulation.makeBussedSignals(sd);
            List allSignals = sd.getSignals();
            for (int i = 0; i < allSignals.size(); ++i) {
                DigitalSignal sDSig = (DigitalSignal)allSignals.get(i);
                if (sDSig.getSignalContext() != null || sDSig.isInBus() || sDSig.getSignalName().indexOf(64) >= 0) continue;
                wp = new WaveformWindow.Panel(ww, false);
                wp.makeSelectedPanel();
                new WaveformWindow.WaveSignal(wp, sDSig);
                if (++numSignals > 15) break;
            }
        }
        ww.getPanel().validate();
    }

    private static void makeBussedSignals(Stimuli sd) {
        List signals = sd.getSignals();
        for (int i = 0; i < signals.size(); ++i) {
            Signal nextSig;
            int nextBracketPos;
            int j;
            Signal sSig = (Signal)signals.get(i);
            int thisBracketPos = sSig.getSignalName().indexOf(91);
            if (thisBracketPos < 0) continue;
            String prefix = sSig.getSignalName().substring(0, thisBracketPos);
            for (j = i + 1; j < signals.size() && (nextBracketPos = (nextSig = (Signal)signals.get(j)).getSignalName().indexOf(91)) >= 0 && thisBracketPos == nextBracketPos && prefix.equals(nextSig.getSignalName().substring(0, nextBracketPos)) && !(sSig.getSignalContext() == null ^ nextSig.getSignalContext() == null) && (sSig.getSignalContext() == null || sSig.getSignalContext().equals(nextSig.getSignalContext())); ++j) {
            }
            int numSignals = j - i;
            if (numSignals <= 1) continue;
            DigitalSignal busSig = new DigitalSignal(sd);
            busSig.setSignalName(prefix);
            busSig.setSignalContext(sSig.getSignalContext());
            busSig.buildBussedSignalList();
            for (int k = i; k < j; ++k) {
                Signal subSig = (Signal)signals.get(k);
                busSig.addToBussedSignalList(subSig);
            }
            i = j - 1;
        }
    }

    public static boolean isFastHenryUseSingleFrequency() {
        return cacheFastHenryUseSingleFrequency.getBoolean();
    }

    public static void setFastHenryUseSingleFrequency(boolean s) {
        cacheFastHenryUseSingleFrequency.setBoolean(s);
    }

    public static double getFastHenryStartFrequency() {
        return cacheFastHenryStartFrequency.getDouble();
    }

    public static void setFastHenryStartFrequency(double s) {
        cacheFastHenryStartFrequency.setDouble(s);
    }

    public static double getFastHenryEndFrequency() {
        return cacheFastHenryEndFrequency.getDouble();
    }

    public static void setFastHenryEndFrequency(double e) {
        cacheFastHenryEndFrequency.setDouble(e);
    }

    public static int getFastHenryRunsPerDecade() {
        return cacheFastHenryRunsPerDecade.getInt();
    }

    public static void setFastHenryRunsPerDecade(int r) {
        cacheFastHenryRunsPerDecade.setInt(r);
    }

    public static boolean isFastHenryMultiPole() {
        return cacheFastHenryMultiPole.getBoolean();
    }

    public static void setFastHenryMultiPole(boolean mp) {
        cacheFastHenryMultiPole.setBoolean(mp);
    }

    public static int getFastHenryNumPoles() {
        return cacheFastHenryNumPoles.getInt();
    }

    public static void setFastHenryNumPoles(int p) {
        cacheFastHenryNumPoles.setInt(p);
    }

    public static double getFastHenryDefThickness() {
        return cacheFastHenryDefThickness.getDouble();
    }

    public static void setFastHenryDefThickness(double t) {
        cacheFastHenryDefThickness.setDouble(t);
    }

    public static int getFastHenryWidthSubdivisions() {
        return cacheFastHenryWidthSubdivisions.getInt();
    }

    public static void setFastHenryWidthSubdivisions(int w) {
        cacheFastHenryWidthSubdivisions.setInt(w);
    }

    public static int getFastHenryHeightSubdivisions() {
        return cacheFastHenryHeightSubdivisions.getInt();
    }

    public static void setFastHenryHeightSubdivisions(int h) {
        cacheFastHenryHeightSubdivisions.setInt(h);
    }

    public static double getFastHenryMaxSegLength() {
        return cacheFastHenryMaxSegLength.getDouble();
    }

    public static void setFastHenryMaxSegLength(double s) {
        cacheFastHenryMaxSegLength.setDouble(s);
    }

    public static boolean getVerilogUseAssign() {
        return cacheVerilogUseAssign.getBoolean();
    }

    public static void setVerilogUseAssign(boolean use) {
        cacheVerilogUseAssign.setBoolean(use);
    }

    public static boolean getVerilogUseTrireg() {
        return cacheVerilogUseTrireg.getBoolean();
    }

    public static void setVerilogUseTrireg(boolean use) {
        cacheVerilogUseTrireg.setBoolean(use);
    }

    public static String getCDLLibName() {
        return cacheCDLLibName.getString();
    }

    public static void setCDLLibName(String libName) {
        cacheCDLLibName.setString(libName);
    }

    public static String getCDLLibPath() {
        return cacheCDLLibPath.getString();
    }

    public static void setCDLLibPath(String libName) {
        cacheCDLLibPath.setString(libName);
    }

    public static boolean isCDLConvertBrackets() {
        return cacheCDLConvertBrackets.getBoolean();
    }

    public static void setCDLConvertBrackets(boolean c) {
        cacheCDLConvertBrackets.setBoolean(c);
    }

    public static String getCDLIncludeFile() {
        return cacheCDLIncludeFile.getString();
    }

    public static void setCDLIncludeFile(String file) {
        cacheCDLIncludeFile.setString(file);
    }

    public static boolean getCDLIgnoreResistors() {
        return cacheCDLIgnoreResistors.getBoolean();
    }

    public static void setCDLIgnoreResistors(boolean b) {
        cacheCDLIgnoreResistors.setBoolean(b);
    }

    public static boolean isBuiltInResimulateEach() {
        return cacheBuiltInResimulateEach.getBoolean();
    }

    public static void setBuiltInResimulateEach(boolean r) {
        cacheBuiltInResimulateEach.setBoolean(r);
    }

    public static boolean isBuiltInAutoAdvance() {
        return cacheBuiltInAutoAdvance.getBoolean();
    }

    public static void setBuiltInAutoAdvance(boolean r) {
        cacheBuiltInAutoAdvance.setBoolean(r);
    }

    public static boolean isWaveformDisplayMultiState() {
        return cacheWaveformDisplayMultiState.getBoolean();
    }

    public static void setWaveformDisplayMultiState(boolean m) {
        cacheWaveformDisplayMultiState.setBoolean(m);
    }

    public static boolean isIRSIMShowsCommands() {
        return cacheIRSIMShowsCommands.getBoolean();
    }

    public static void setIRSIMShowsCommands(boolean r) {
        cacheIRSIMShowsCommands.setBoolean(r);
    }

    public static int getIRSIMDebugging() {
        return cacheIRSIMDebugging.getInt();
    }

    public static void setIRSIMDebugging(int p) {
        cacheIRSIMDebugging.setInt(p);
    }

    public static String getIRSIMParameterFile() {
        return cacheIRSIMParameterFile.getString();
    }

    public static void setIRSIMParameterFile(String p) {
        cacheIRSIMParameterFile.setString(p);
    }

    public static String getIRSIMStepModel() {
        return cacheIRSIMStepModel.getString();
    }

    public static void setIRSIMStepModel(String m) {
        cacheIRSIMStepModel.setString(m);
    }

    public static boolean isIRSIMDelayedX() {
        return cacheIRSIMDelayedX.getBoolean();
    }

    public static void setIRSIMDelayedX(boolean b) {
        cacheIRSIMDelayedX.setBoolean(b);
    }

    public static int getSpiceEngine() {
        return cacheSpiceEngine.getInt();
    }

    public static void setSpiceEngine(int engine) {
        cacheSpiceEngine.setInt(engine);
    }

    public static String getSpiceLevel() {
        return cacheSpiceLevel.getString();
    }

    public static void setSpiceLevel(String level) {
        cacheSpiceLevel.setString(level);
    }

    public static String getSpiceOutputFormat() {
        return cacheSpiceOutputFormat.getString();
    }

    public static void setSpiceOutputFormat(String format) {
        cacheSpiceOutputFormat.setString(format);
    }

    public static String[] getSpiceRunChoiceValues() {
        return spiceRunChoices;
    }

    public static String getSpiceRunChoice() {
        return spiceRunChoices[cacheSpiceRunChoice.getInt()];
    }

    public static void setSpiceRunChoice(String choice) {
        String[] values = Simulation.getSpiceRunChoiceValues();
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(choice)) continue;
            cacheSpiceRunChoice.setInt(i);
            return;
        }
    }

    public static String getSpiceRunDir() {
        return cacheSpiceRunDir.getString();
    }

    public static void setSpiceRunDir(String dir) {
        cacheSpiceRunDir.setString(dir);
    }

    public static boolean getSpiceUseRunDir() {
        return cacheSpiceUseRunDir.getBoolean();
    }

    public static void setSpiceUseRunDir(boolean b) {
        cacheSpiceUseRunDir.setBoolean(b);
    }

    public static boolean getSpiceOutputOverwrite() {
        return cacheSpiceOutputOverwrite.getBoolean();
    }

    public static void setSpiceOutputOverwrite(boolean b) {
        cacheSpiceOutputOverwrite.setBoolean(b);
    }

    public static boolean getSpiceRunProbe() {
        return cacheSpiceRunProbe.getBoolean();
    }

    public static void setSpiceRunProbe(boolean b) {
        cacheSpiceRunProbe.setBoolean(b);
    }

    public static String getSpiceRunProgram() {
        return cacheSpiceRunProgram.getString();
    }

    public static void setSpiceRunProgram(String c) {
        cacheSpiceRunProgram.setString(c);
    }

    public static String getSpiceRunProgramArgs() {
        return cacheSpiceRunProgramArgs.getString();
    }

    public static void setSpiceRunProgramArgs(String c) {
        cacheSpiceRunProgramArgs.setString(c);
    }

    public static String getSpicePartsLibrary() {
        if (cacheSpicePartsLibrary == null) {
            String[] libNames = LibFile.getSpicePartsLibraries();
            cacheSpicePartsLibrary = Pref.makeStringPref("SpicePartsLibrary", Simulation.tool.prefs, libNames[0]);
        }
        return cacheSpicePartsLibrary.getString();
    }

    public static void setSpicePartsLibrary(String parts) {
        if (cacheSpicePartsLibrary == null) {
            String[] libNames = LibFile.getSpicePartsLibraries();
            cacheSpicePartsLibrary = Pref.makeStringPref("SpicePartsLibrary", Simulation.tool.prefs, libNames[0]);
        }
        cacheSpicePartsLibrary.setString(parts);
    }

    public static String getSpiceHeaderCardInfo() {
        return cacheSpiceHeaderCardInfo.getString();
    }

    public static void setSpiceHeaderCardInfo(String spec) {
        cacheSpiceHeaderCardInfo.setString(spec);
    }

    public static String getSpiceTrailerCardInfo() {
        return cacheSpiceTrailerCardInfo.getString();
    }

    public static void setSpiceTrailerCardInfo(String spec) {
        cacheSpiceTrailerCardInfo.setString(spec);
    }

    public static boolean isSpiceUseParasitics() {
        return cacheSpiceUseParasitics.getBoolean();
    }

    public static void setSpiceUseParasitics(boolean p) {
        cacheSpiceUseParasitics.setBoolean(p);
    }

    public static boolean isParasiticsUseVerboseNaming() {
        return cacheParasiticsUseVerboseNaming.getBoolean();
    }

    public static void setParasiticsUseVerboseNaming(boolean b) {
        cacheParasiticsUseVerboseNaming.setBoolean(b);
    }

    public static boolean isParasiticsBackAnnotateLayout() {
        return cacheParasiticsBackAnnotateLayout.getBoolean();
    }

    public static void setParasiticsBackAnnotateLayout(boolean b) {
        cacheParasiticsBackAnnotateLayout.setBoolean(b);
    }

    public static boolean isParasiticsExtractPowerGround() {
        return cacheParasiticsExtractPowerGround.getBoolean();
    }

    public static void setParasiticsExtractPowerGround(boolean b) {
        cacheParasiticsExtractPowerGround.setBoolean(b);
    }

    public static boolean isSpiceExtractMeNetsOnly() {
        return cacheSpiceExtractMeNetsOnly.getBoolean();
    }

    public static void setSpiceExtractMeNetsOnly(boolean b) {
        cacheSpiceExtractMeNetsOnly.setBoolean(b);
    }

    public static boolean isSpiceUseNodeNames() {
        return cacheSpiceUseNodeNames.getBoolean();
    }

    public static void setSpiceUseNodeNames(boolean u) {
        cacheSpiceUseNodeNames.setBoolean(u);
    }

    public static boolean isSpiceForceGlobalPwrGnd() {
        return cacheSpiceForceGlobalPwrGnd.getBoolean();
    }

    public static void setSpiceForceGlobalPwrGnd(boolean g) {
        cacheSpiceForceGlobalPwrGnd.setBoolean(g);
    }

    public static boolean isSpiceUseCellParameters() {
        return cacheSpiceUseCellParameters.getBoolean();
    }

    public static void setSpiceUseCellParameters(boolean p) {
        cacheSpiceUseCellParameters.setBoolean(p);
    }

    public static boolean isSpiceWriteTransSizeInLambda() {
        return cacheSpiceWriteTransSizeInLambda.getBoolean();
    }

    public static void setSpiceWriteTransSizeInLambda(boolean l) {
        cacheSpiceWriteTransSizeInLambda.setBoolean(l);
    }

    public static boolean isSpiceWriteSubcktTopCell() {
        return cacheSpiceWriteSubcktTopCell.getBoolean();
    }

    public static void setSpiceWriteSubcktTopCell(boolean b) {
        cacheSpiceWriteSubcktTopCell.setBoolean(b);
    }

    public static double getSpiceMaxSeriesResistance() {
        return cacheSpiceMaxSeriesResistance.getDouble();
    }

    public static void setSpiceMaxSeriesResistance(double d) {
        cacheSpiceMaxSeriesResistance.setDouble(d);
    }

    static {
        cacheFastHenryUseSingleFrequency = Pref.makeBooleanPref("FastHenryUseSingleFrequency", Simulation.tool.prefs, false);
        cacheFastHenryStartFrequency = Pref.makeDoublePref("FastHenryStartFrequency", Simulation.tool.prefs, 0.0);
        cacheFastHenryEndFrequency = Pref.makeDoublePref("FastHenryEndFrequency", Simulation.tool.prefs, 0.0);
        cacheFastHenryRunsPerDecade = Pref.makeIntPref("FastHenryRunsPerDecade", Simulation.tool.prefs, 1);
        cacheFastHenryMultiPole = Pref.makeBooleanPref("FastHenryMultiPole", Simulation.tool.prefs, false);
        cacheFastHenryNumPoles = Pref.makeIntPref("FastHenryNumPoles", Simulation.tool.prefs, 20);
        cacheFastHenryDefThickness = Pref.makeDoublePref("FastHenryDefThickness", Simulation.tool.prefs, 2.0);
        cacheFastHenryWidthSubdivisions = Pref.makeIntPref("FastHenryWidthSubdivisions", Simulation.tool.prefs, 1);
        cacheFastHenryHeightSubdivisions = Pref.makeIntPref("FastHenryHeightSubdivisions", Simulation.tool.prefs, 1);
        cacheFastHenryMaxSegLength = Pref.makeDoublePref("FastHenryMaxSegLength", Simulation.tool.prefs, 0.0);
        cacheVerilogUseAssign = Pref.makeBooleanPref("VerilogUseAssign", Simulation.tool.prefs, false);
        cacheVerilogUseAssign.attachToObject(tool, "Tools/Verilog tab", "Verilog uses Assign construct");
        cacheVerilogUseTrireg = Pref.makeBooleanPref("VerilogUseTrireg", Simulation.tool.prefs, false);
        cacheVerilogUseTrireg.attachToObject(tool, "Tools/Verilog tab", "Verilog presumes wire is Trireg");
        cacheCDLLibName = Pref.makeStringPref("CDLLibName", Simulation.tool.prefs, "");
        cacheCDLLibPath = Pref.makeStringPref("CDLLibPath", Simulation.tool.prefs, "");
        cacheCDLConvertBrackets = Pref.makeBooleanPref("CDLConvertBrackets", Simulation.tool.prefs, false);
        cacheCDLIncludeFile = Pref.makeStringPref("CDLIncludeFile", Simulation.tool.prefs, "");
        cacheCDLIgnoreResistors = Pref.makeBooleanPref("CDLLIgnoreResistors", Simulation.tool.prefs, false);
        cacheBuiltInResimulateEach = Pref.makeBooleanPref("BuiltInResimulateEach", Simulation.tool.prefs, true);
        cacheBuiltInAutoAdvance = Pref.makeBooleanPref("BuiltInAutoAdvance", Simulation.tool.prefs, false);
        cacheWaveformDisplayMultiState = Pref.makeBooleanPref("WaveformDisplayMultiState", Simulation.tool.prefs, false);
        cacheIRSIMShowsCommands = Pref.makeBooleanPref("IRSIMShowsCommands", Simulation.tool.prefs, false);
        cacheIRSIMDebugging = Pref.makeIntPref("IRSIMDebugging", Simulation.tool.prefs, 0);
        cacheIRSIMParameterFile = Pref.makeStringPref("IRSIMParameterFile", Simulation.tool.prefs, "scmos0.3.prm");
        cacheIRSIMStepModel = Pref.makeStringPref("IRSIMStepModel", Simulation.tool.prefs, "RC");
        cacheIRSIMDelayedX = Pref.makeBooleanPref("IRSIMDelayedX", Simulation.tool.prefs, true);
        cacheSpiceEngine = Pref.makeIntPref("SpiceEngine", Simulation.tool.prefs, 1);
        cacheSpiceLevel = Pref.makeStringPref("SpiceLevel", Simulation.tool.prefs, "1");
        cacheSpiceOutputFormat = Pref.makeStringPref("SpiceOutputFormat", Simulation.tool.prefs, "Standard");
        spiceRunChoices = new String[]{spiceRunChoiceDontRun, spiceRunChoiceRunIgnoreOutput, spiceRunChoiceRunReportOutput};
        cacheSpiceRunChoice = Pref.makeIntPref("SpiceRunChoice", Simulation.tool.prefs, 0);
        cacheSpiceRunDir = Pref.makeStringPref("SpiceRunDir", Simulation.tool.prefs, "");
        cacheSpiceUseRunDir = Pref.makeBooleanPref("SpiceUseRunDir", Simulation.tool.prefs, false);
        cacheSpiceOutputOverwrite = Pref.makeBooleanPref("SpiceOverwriteOutputFile", Simulation.tool.prefs, false);
        cacheSpiceRunProbe = Pref.makeBooleanPref("SpiceRunProbe", Simulation.tool.prefs, false);
        cacheSpiceRunProgram = Pref.makeStringPref("SpiceRunProgram", Simulation.tool.prefs, "");
        cacheSpiceRunProgramArgs = Pref.makeStringPref("SpiceRunProgramArgs", Simulation.tool.prefs, "");
        cacheSpicePartsLibrary = null;
        cacheSpiceHeaderCardInfo = Pref.makeStringPref("SpiceHeaderCardInfo", Simulation.tool.prefs, "");
        cacheSpiceTrailerCardInfo = Pref.makeStringPref("SpiceTrailerCardInfo", Simulation.tool.prefs, "");
        cacheSpiceUseParasitics = Pref.makeBooleanPref("SpiceUseParasitics", Simulation.tool.prefs, true);
        cacheParasiticsUseVerboseNaming = Pref.makeBooleanPref("ParasiticsUseVerboseNaming", Simulation.tool.prefs, true);
        cacheParasiticsBackAnnotateLayout = Pref.makeBooleanPref("ParasiticsBackAnnotateLayout", Simulation.tool.prefs, true);
        cacheParasiticsExtractPowerGround = Pref.makeBooleanPref("ParasiticsExtractPowerGround", Simulation.tool.prefs, false);
        cacheSpiceExtractMeNetsOnly = Pref.makeBooleanPref("SpiceExtractMeNetsOnly", Simulation.tool.prefs, false);
        cacheSpiceUseNodeNames = Pref.makeBooleanPref("SpiceUseNodeNames", Simulation.tool.prefs, true);
        cacheSpiceForceGlobalPwrGnd = Pref.makeBooleanPref("SpiceForceGlobalPwrGnd", Simulation.tool.prefs, false);
        cacheSpiceUseCellParameters = Pref.makeBooleanPref("SpiceUseCellParameters", Simulation.tool.prefs, false);
        cacheSpiceWriteTransSizeInLambda = Pref.makeBooleanPref("SpiceWriteTransSizeInLambda", Simulation.tool.prefs, false);
        cacheSpiceWriteSubcktTopCell = Pref.makeBooleanPref("SpiceWriteSubcktTopCell", Simulation.tool.prefs, false);
        cacheSpiceMaxSeriesResistance = Pref.makeDoublePref("SpiceMaxSeriesResistance", Simulation.tool.prefs, 8.0);
    }

    private static class ClockSpec
    extends EDialog {
        private double period = -1.0;
        private JRadioButton freqBut;
        private JRadioButton periodBut;
        private JTextField freqField;
        private JTextField periodField;

        public static double getClockSpec() {
            ClockSpec dialog = new ClockSpec((Frame)TopLevel.getCurrentJFrame(), true);
            dialog.setVisible(true);
            return dialog.period;
        }

        public ClockSpec(Frame parent, boolean modal) {
            super(parent, modal);
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Clock Specification");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    ClockSpec.this.closeDialog(evt);
                }
            });
            ButtonGroup fp = new ButtonGroup();
            this.freqBut = new JRadioButton("Frequency:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            this.getContentPane().add((Component)this.freqBut, gbc);
            fp.add(this.freqBut);
            this.freqField = new JTextField();
            this.freqField.setColumns(12);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.freqField, gbc);
            this.periodBut = new JRadioButton("Period:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            this.getContentPane().add((Component)this.periodBut, gbc);
            fp.add(this.periodBut);
            this.periodBut.setSelected(true);
            this.periodField = new JTextField();
            this.periodField.setColumns(12);
            this.periodField.setText("0.00000001");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.periodField, gbc);
            JButton cancel = new JButton("Cancel");
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ClockSpec.this.cancel(evt);
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            JButton ok = new JButton("OK");
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ClockSpec.this.ok(evt);
                }
            });
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            this.pack();
            this.getRootPane().setDefaultButton(ok);
            this.finishInitialization();
        }

        protected void escapePressed() {
            this.cancel(null);
        }

        private void cancel(ActionEvent evt) {
            this.closeDialog(null);
        }

        private void ok(ActionEvent evt) {
            if (this.freqBut.isSelected()) {
                double freq = TextUtils.atof(this.freqField.getText());
                if (freq != 0.0) {
                    this.period = 1.0 / freq;
                }
            } else {
                this.period = TextUtils.atof(this.periodField.getText());
            }
            this.closeDialog(null);
        }

        private void closeDialog(WindowEvent evt) {
            this.setVisible(false);
            this.dispose();
        }
    }

    private static class SetTransistorStrength
    extends Job {
        NodeInst ni;
        boolean weak;

        protected SetTransistorStrength(NodeInst ni, boolean weak) {
            super("Change Transistor Strength", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.weak = weak;
            this.startJob();
        }

        public boolean doIt() {
            if (this.weak) {
                Variable variable = this.ni.newDisplayVar(WEAK_NODE_KEY, "Weak");
            } else if (this.ni.getVar(WEAK_NODE_KEY) != null) {
                this.ni.delVar(WEAK_NODE_KEY);
            }
            return true;
        }
    }

    private static class SetWireType
    extends Job {
        List list;
        int type;

        protected SetWireType(List list, int type) {
            super("Change Verilog Wire Types", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.list = list;
            this.type = type;
            this.startJob();
        }

        public boolean doIt() {
            Iterator it = this.list.iterator();
            while (it.hasNext()) {
                ArcInst ai = (ArcInst)it.next();
                switch (this.type) {
                    case 0: {
                        Variable var = ai.newDisplayVar(Verilog.WIRE_TYPE_KEY, "wire");
                        break;
                    }
                    case 1: {
                        Variable var = ai.newDisplayVar(Verilog.WIRE_TYPE_KEY, "trireg");
                        break;
                    }
                    case 2: {
                        if (ai.getVar(Verilog.WIRE_TYPE_KEY) == null) break;
                        ai.delVar(Verilog.WIRE_TYPE_KEY);
                    }
                }
            }
            return true;
        }
    }

    private static class SetSpiceModel
    extends Job {
        NodeInst ni;

        protected SetSpiceModel(NodeInst ni) {
            super("Set Spice Model", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.ni = ni;
            this.startJob();
        }

        public boolean doIt() {
            Variable var = this.ni.newDisplayVar(Spice.SPICE_MODEL_KEY, "SPICE-Model");
            return true;
        }
    }

    private static class DoNextActivity
    extends Job {
        private Cell cell;
        private Cell originalCell;
        private VarContext originalContext;
        private int activities;
        private Engine prevEngine;

        private DoNextActivity(Cell cell, int activities, Cell originalCell, VarContext originalContext, Engine prevEngine) {
            super("Simulation activity", tool, Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.activities = activities;
            this.originalCell = originalCell;
            this.originalContext = originalContext;
            this.prevEngine = prevEngine;
            this.startJob();
        }

        public boolean doIt() {
            if ((this.activities & 1) != 0) {
                System.out.print("Generating VHDL from '" + this.cell + "' ...");
                List vhdlStrings = GenerateVHDL.convertCell(this.cell);
                if (vhdlStrings == null) {
                    System.out.println("No VHDL produced");
                    return false;
                }
                String cellName = this.cell.getName() + "{vhdl}";
                Cell vhdlCell = this.cell.getLibrary().findNodeProto(cellName);
                if (vhdlCell == null && (vhdlCell = Cell.makeInstance(this.cell.getLibrary(), cellName)) == null) {
                    return false;
                }
                String[] array = new String[vhdlStrings.size()];
                for (int i = 0; i < vhdlStrings.size(); ++i) {
                    array[i] = (String)vhdlStrings.get(i);
                }
                vhdlCell.setTextViewContents(array);
                System.out.println(" Done, created " + vhdlCell);
                DoNextActivity sJob = new DoNextActivity(vhdlCell, this.activities & 0xFFFFFFFE, this.originalCell, this.originalContext, this.prevEngine);
                return true;
            }
            if ((this.activities & 4) != 0) {
                System.out.print("Compiling VHDL in " + this.cell + " ...");
                CompileVHDL c = new CompileVHDL(this.cell);
                if (c.hasErrors()) {
                    System.out.println("ERRORS during compilation, no netlist produced");
                    return false;
                }
                List netlistStrings = c.getALSNetlist();
                if (netlistStrings == null) {
                    System.out.println("No netlist produced");
                    return false;
                }
                String cellName = this.cell.getName() + "{net.als}";
                Cell netlistCell = this.cell.getLibrary().findNodeProto(cellName);
                if (netlistCell == null && (netlistCell = Cell.makeInstance(this.cell.getLibrary(), cellName)) == null) {
                    return false;
                }
                String[] array = new String[netlistStrings.size()];
                for (int i = 0; i < netlistStrings.size(); ++i) {
                    array[i] = (String)netlistStrings.get(i);
                }
                netlistCell.setTextViewContents(array);
                System.out.println(" Done, created " + netlistCell);
                DoNextActivity sJob = new DoNextActivity(netlistCell, this.activities & 0xFFFFFFFB, this.originalCell, this.originalContext, this.prevEngine);
                return true;
            }
            if ((this.activities & 2) != 0) {
                if (this.prevEngine != null) {
                    ALS.restartSimulation(this.cell, this.originalCell, this.originalContext, (ALS)this.prevEngine);
                } else {
                    ALS.simulateNetlist(this.cell, this.originalCell, this.originalContext);
                }
                DoNextActivity sJob = new DoNextActivity(this.cell, this.activities & 0xFFFFFFFD, this.originalCell, this.originalContext, this.prevEngine);
                return true;
            }
            return false;
        }
    }
}

