/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.cmosPLA;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.lib.LibFile;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.cmosPLA.Decode;
import com.sun.electric.tool.generator.cmosPLA.NGrid;
import com.sun.electric.tool.generator.cmosPLA.PGrid;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.input.LibraryFiles;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.OpenFile;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class PLA {
    static final int MAX_COL_SIZE = 500;
    static final int X_SEP = 10;
    static final int Y_MIR_SEP = 10;
    static final int Y_SEP = 10;
    Cell nmosOne;
    Cell pmosOne;
    Cell decoderInv;
    Cell ioInv4;
    Cell pullUps;
    private Cell pmosCell;
    private Cell nmosCell;
    private Cell orCell;
    private Cell decodeCell;
    private Cell orPlaneCell;
    PrimitiveNode m1Pin;
    PrimitiveNode m2Pin;
    PrimitiveNode m12Con;
    PrimitiveNode mpCon;
    PrimitiveNode maCon;
    PrimitiveNode mwBut;
    PrimitiveNode msBut;
    PrimitiveNode pwNode;
    ArcProto m1Arc;
    ArcProto m2Arc;
    ArcProto pArc;
    ArcProto aArc;
    UCRow[] columnList;
    UCRow[][] rowList;
    private NGrid ng;
    private PGrid pg;
    private Decode dec;
    private String cellName;
    private String andFileName;
    private String orFileName;
    private boolean inputsOnTop;
    private boolean outputsOnBottom;

    public static void generate() {
        SetupPLAGen dialog = new SetupPLAGen();
        if (dialog.failed()) {
            return;
        }
        String cellName = dialog.getCellName();
        String andFileName = dialog.getAndFileName();
        String orFileName = dialog.getOrFileName();
        boolean inputsOnTop = dialog.isInputsOnTop();
        boolean outputsOnBottom = dialog.isOutputsOnBottom();
        PLA me = new PLA(cellName, andFileName, orFileName, inputsOnTop, outputsOnBottom);
        new GeneratePLAJob(0, me, null);
    }

    public static void generate(String cellName, String andFileName, String orFileName, boolean inputsOnTop, boolean outputsOnBottom, Job completion) {
        PLA me = new PLA(cellName, andFileName, orFileName, inputsOnTop, outputsOnBottom);
        new GeneratePLAJob(0, me, completion);
    }

    private PLA(String cellName, String andFileName, String orFileName, boolean inputsOnTop, boolean outputsOnBottom) {
        this.cellName = cellName;
        this.andFileName = andFileName;
        this.orFileName = orFileName;
        this.inputsOnTop = inputsOnTop;
        this.outputsOnBottom = outputsOnBottom;
        this.pg = new PGrid(this);
        this.ng = new NGrid(this);
        this.dec = new Decode(this);
    }

    private boolean doStep(int step, Job completion) {
        boolean error = false;
        switch (step) {
            case 0: {
                System.out.println("STEP 1: initialize");
                if (this.initialize()) break;
                error = true;
                break;
            }
            case 1: {
                System.out.println("STEP 2: AND plane, part 1");
                String thisCellName = this.cellName + "_p_cell{lay}";
                this.pmosCell = this.pg.pmosGrid(Library.getCurrent(), this.andFileName, thisCellName);
                if (this.pmosCell != null) break;
                error = true;
                break;
            }
            case 2: {
                System.out.println("STEP 2: AND plane, part 2");
                String thisCellName = this.cellName + "_n_cell{lay}";
                this.nmosCell = this.ng.nmosGrid(Library.getCurrent(), this.andFileName, thisCellName);
                if (this.nmosCell != null) break;
                error = true;
                break;
            }
            case 3: {
                System.out.println("STEP 3: Decoder");
                String thisCellName = this.cellName + "_decode{lay}";
                this.decodeCell = this.dec.decodeGen(Library.getCurrent(), this.pmosCell, this.nmosCell, thisCellName, this.inputsOnTop);
                if (this.decodeCell != null) break;
                error = true;
                break;
            }
            case 4: {
                System.out.println("STEP 4: OR plane, part 1");
                String thisCellName = this.cellName + "_or_cell{lay}";
                this.orCell = this.ng.nmosGrid(Library.getCurrent(), this.orFileName, thisCellName);
                if (this.orCell != null) break;
                error = true;
                break;
            }
            case 5: {
                System.out.println("STEP 5: OR plane, part 2");
                String thisCellName = this.cellName + "_or_plane{lay}";
                this.orPlaneCell = this.makeOrPlane(Library.getCurrent(), thisCellName, this.outputsOnBottom);
                if (this.orPlaneCell != null) break;
                error = true;
                break;
            }
            case 6: {
                System.out.println("STEP 6: Final assembly");
                Cell plaCell = this.makePLA(Library.getCurrent(), this.cellName + "{lay}");
                if (plaCell == null) break;
                System.out.println("DONE");
                WindowFrame.createEditWindow(plaCell);
            }
        }
        if (step < 6 && !error) {
            new GeneratePLAJob(step + 1, this, completion);
            return true;
        }
        if (completion != null) {
            completion.startJob();
        }
        return true;
    }

    private boolean initialize() {
        Technology theTech = Technology.findTechnology("mocmos");
        if (theTech == null) {
            System.out.println("Cannot find technology 'mocmos'");
            return false;
        }
        this.m1Pin = theTech.findNodeProto("Metal-1-Pin");
        if (this.m1Pin == null) {
            System.out.println("Cannot find Metal-1-Pin primitive");
            return false;
        }
        this.m2Pin = theTech.findNodeProto("Metal-2-Pin");
        if (this.m2Pin == null) {
            System.out.println("Cannot find Metal-2-Pin primitive");
            return false;
        }
        this.m12Con = theTech.findNodeProto("Metal-1-Metal-2-Con");
        if (this.m12Con == null) {
            System.out.println("Cannot find Metal-1-Metal-2-Con primitive");
            return false;
        }
        this.mpCon = theTech.findNodeProto("Metal-1-Polysilicon-1-Con");
        if (this.mpCon == null) {
            System.out.println("Cannot find Metal-1-Polysilicon-1-Con primitive");
            return false;
        }
        this.maCon = theTech.findNodeProto("Metal-1-N-Active-Con");
        if (this.maCon == null) {
            System.out.println("Cannot find Metal-1-N-Active-Con primitive");
            return false;
        }
        this.mwBut = theTech.findNodeProto("Metal-1-P-Well-Con");
        if (this.mwBut == null) {
            System.out.println("Cannot find Metal-1-P-Well-Con primitive");
            return false;
        }
        this.msBut = theTech.findNodeProto("Metal-1-N-Well-Con");
        if (this.msBut == null) {
            System.out.println("Cannot find Metal-1-N-Well-Con primitive");
            return false;
        }
        this.pwNode = theTech.findNodeProto("P-Well-Node");
        if (this.pwNode == null) {
            System.out.println("Cannot find P-Well-Node primitive");
            return false;
        }
        this.m1Arc = theTech.findArcProto("Metal-1");
        if (this.msBut == null) {
            System.out.println("Cannot find Metal-1 arc");
            return false;
        }
        this.m2Arc = theTech.findArcProto("Metal-2");
        if (this.msBut == null) {
            System.out.println("Cannot find Metal-2 arc");
            return false;
        }
        this.pArc = theTech.findArcProto("Polysilicon-1");
        if (this.msBut == null) {
            System.out.println("Cannot find Polysilicon-1 arc");
            return false;
        }
        this.aArc = theTech.findArcProto("N-Active");
        if (this.msBut == null) {
            System.out.println("Cannot find N-Active arc");
            return false;
        }
        String libName = "pla_mocmos";
        Library cellLib = Library.findLibrary(libName);
        if (cellLib == null) {
            URL url = LibFile.getLibFile(libName + ".jelib");
            cellLib = LibraryFiles.readLibrary(url, null, FileType.JELIB, false);
            Undo.noUndoAllowed();
        }
        this.nmosOne = cellLib.findNodeProto("nmos_one");
        if (this.nmosOne == null) {
            System.out.println("Unable to find cell 'nmos_one'");
            return false;
        }
        this.pmosOne = cellLib.findNodeProto("pmos_one");
        if (this.pmosOne == null) {
            System.out.println("Unable to find cell 'pmos_one'");
            return false;
        }
        this.decoderInv = cellLib.findNodeProto("decoder_inv1");
        if (this.decoderInv == null) {
            System.out.println("Unable to find cell 'decoder_inv1'");
            return false;
        }
        this.ioInv4 = cellLib.findNodeProto("io-inv-4");
        if (this.ioInv4 == null) {
            System.out.println("Unable to find cell 'io-inv-4'");
            return false;
        }
        this.pullUps = cellLib.findNodeProto("pullups");
        if (this.pullUps == null) {
            System.out.println("Unable to find cell 'pullups'");
            return false;
        }
        this.columnList = new UCRow[500];
        this.rowList = new UCRow[500][3];
        for (int i = 0; i < 500; ++i) {
            this.columnList[i] = new UCRow();
            this.rowList[i][0] = new UCRow();
            this.rowList[i][1] = new UCRow();
            this.rowList[i][2] = new UCRow();
        }
        return true;
    }

    private Cell makeOrPlane(Library library, String cellName, boolean outputsOnBottom) {
        Rectangle2D pullUpsBounds;
        double pullUpsDiff;
        Cell cell = Cell.makeInstance(library, cellName);
        NodeInst orNode = this.makeInstance(cell, this.orCell, 0.0, 0.0, false);
        if (orNode == null) {
            return null;
        }
        NodeInst newNode = null;
        NodeInst lastNode = null;
        int columns = 2;
        Variable var = this.orCell.getVar("PLA_data_cols");
        if (var != null) {
            columns = (Integer)var.getObject();
        } else {
            System.out.println("DATA_cols defaulting to 2");
        }
        NodeInst gndNode2 = null;
        NodeInst pwrNode1 = null;
        char side = 'n';
        if (outputsOnBottom) {
            side = 's';
        }
        int limit = columns / 4;
        Rectangle2D nodeBounds = orNode.getBounds();
        double lowX = nodeBounds.getMinX();
        double highX = nodeBounds.getMaxX();
        double lowY = nodeBounds.getMinY();
        double highY = nodeBounds.getMaxY();
        Rectangle2D cellBounds = this.ioInv4.getBounds();
        double diff = cellBounds.getHeight();
        if (diff < 0.0) {
            diff = -diff;
        }
        if (limit == 0 || columns % 4 != 0) {
            ++limit;
        }
        int invCnt = 0;
        double invY = highY;
        if (outputsOnBottom) {
            invY = lowY - diff;
        }
        invY -= 5.0;
        double invXOffset = lowX + 17.0;
        Export invPwrW = this.ioInv4.findExport("PWR.m-2.w");
        Export invPwrE = this.ioInv4.findExport("PWR.m-2.e");
        Export invGnd1W = this.ioInv4.findExport("GND.m-2.sw");
        Export invGnd1E = this.ioInv4.findExport("GND.m-2.se");
        Export invGnd2W = this.ioInv4.findExport("GND.m-2.nw");
        Export invGnd2E = this.ioInv4.findExport("GND.m-2.ne");
        for (int i = 0; i < limit; ++i) {
            newNode = this.makeInstance(cell, this.ioInv4, (double)(i * 50) + invXOffset, invY, !outputsOnBottom);
            if (newNode == null) {
                return null;
            }
            if (lastNode == null) {
                Export.newInstance(cell, newNode.findPortInstFromProto(invPwrW), "PWR.m-2.w");
                Export.newInstance(cell, newNode.findPortInstFromProto(invGnd1W), "GND.m-2.w");
                Poly poly = newNode.findPortInstFromProto(invGnd1W).getPoly();
                double pwrY = poly.getCenterY();
                NodeInst gndNode1 = this.makePin(cell, lowX - 13.0, pwrY, 6.0, this.m12Con);
                if (gndNode1 == null) {
                    return null;
                }
                this.makeWire(this.m2Arc, 14.0, newNode, invGnd1W, gndNode1, gndNode1.getProto().getPort(0), cell);
                poly = newNode.findPortInstFromProto(invGnd2W).getPoly();
                pwrY = poly.getCenterY();
                gndNode2 = this.makePin(cell, lowX - 13.0, pwrY, 6.0, this.m12Con);
                if (gndNode2 == null) {
                    return null;
                }
                this.makeWire(this.m2Arc, 14.0, newNode, invGnd2W, gndNode2, gndNode2.getProto().getPort(0), cell);
                this.makeWire(this.m2Arc, 14.0, gndNode1, gndNode1.getProto().getPort(0), gndNode2, gndNode2.getProto().getPort(0), cell);
            } else {
                if (invPwrW != null && invPwrE != null) {
                    this.makeWire(this.m2Arc, 14.0, lastNode, invPwrE, newNode, invPwrW, cell);
                }
                if (invGnd1W != null && invGnd1E != null) {
                    this.makeWire(this.m2Arc, 14.0, lastNode, invGnd1E, newNode, invGnd1W, cell);
                }
                if (invGnd2W != null && invGnd2E != null) {
                    this.makeWire(this.m2Arc, 14.0, lastNode, invGnd2E, newNode, invGnd2W, cell);
                }
            }
            lastNode = newNode;
            for (int x = invCnt; x < invCnt + 4; ++x) {
                Export pPort = this.orCell.findExport("DATA" + x + ".m-1." + side);
                Export nPort = this.ioInv4.findExport("in" + x % 4 + ".m-1.n");
                Export outPort = this.ioInv4.findExport("out" + x % 4 + "-bar.m-1.s");
                if (outPort != null) {
                    Export.newInstance(cell, newNode.findPortInstFromProto(outPort), "out" + (invCnt + x % 4) + ".m-1." + side);
                }
                if (pPort == null || nPort == null) continue;
                this.makeWire(this.m1Arc, 4.0, orNode, pPort, newNode, nPort, cell);
            }
            invCnt += 4;
        }
        if (invPwrE != null) {
            Poly poly = lastNode.findPortInstFromProto(invPwrE).getPoly();
            double pwrY = poly.getCenterY();
            pwrNode1 = this.makePin(cell, highX + 13.0, pwrY, 14.0, this.m2Pin);
            if (pwrNode1 == null) {
                return null;
            }
            this.makeWire(this.m2Arc, 14.0, lastNode, invPwrE, pwrNode1, pwrNode1.getProto().getPort(0), cell);
            Export.newInstance(cell, lastNode.findPortInstFromProto(invPwrE), "PWR.m-2.e");
        }
        if (invGnd1W != null) {
            Export.newInstance(cell, lastNode.findPortInstFromProto(invGnd1E), "GND.m-2.e");
        }
        newNode = null;
        lastNode = null;
        side = 's';
        if (outputsOnBottom) {
            side = 'n';
        }
        if ((pullUpsDiff = (pullUpsBounds = this.pullUps.getBounds()).getHeight()) < 0.0) {
            pullUpsDiff = -pullUpsDiff;
        }
        int pullUpsCnt = 0;
        double pullUpsY = highY;
        if (!outputsOnBottom) {
            pullUpsY = lowY - pullUpsDiff;
        }
        pullUpsY += 16.0;
        double pullUpsXOffset = lowX + 27.0;
        Export pullUpsPwrW = this.pullUps.findExport("PWR.m-2w");
        if (pullUpsPwrW == null) {
            System.out.println("Cannot find port PWR.m-2w in " + this.pullUps);
            return null;
        }
        Export pullUpsPwrE = this.pullUps.findExport("PWR.m-2e");
        if (pullUpsPwrE == null) {
            System.out.println("Cannot find port PWR.m-2e in " + this.pullUps);
            return null;
        }
        Export pullUpsGnd1W = this.pullUps.findExport("GND.m-1.sw");
        if (pullUpsGnd1W == null) {
            System.out.println("Cannot find port GND.m-1.sw in " + this.pullUps);
            return null;
        }
        Export pullUpsGnd1E = this.pullUps.findExport("GND.m-1.se");
        if (pullUpsGnd1E == null) {
            System.out.println("Cannot find port GND.m-1.se in " + this.pullUps);
            return null;
        }
        for (int i = 0; i < limit; ++i) {
            newNode = this.makeInstance(cell, this.pullUps, (double)(i * 50) + pullUpsXOffset, pullUpsY, !outputsOnBottom);
            if (newNode == null) {
                return null;
            }
            if (lastNode == null) {
                Export.newInstance(cell, newNode.findPortInstFromProto(pullUpsPwrW), "PWR0.m-2.w");
                Export.newInstance(cell, newNode.findPortInstFromProto(pullUpsGnd1W), "GND0.m-1.w");
                PortInst pi = newNode.findPortInstFromProto(pullUpsGnd1W);
                Poly poly = pi.getPoly();
                double pwrY = poly.getCenterY();
                NodeInst gndNode1 = this.makePin(cell, lowX - 13.0, pwrY, 6.0, this.m12Con);
                if (gndNode1 == null) {
                    return null;
                }
                this.makeWire(this.m1Arc, 4.0, newNode, pullUpsGnd1W, gndNode1, gndNode1.getProto().getPort(0), cell);
                this.makeWire(this.m2Arc, 14.0, gndNode1, gndNode1.getProto().getPort(0), gndNode2, gndNode2.getProto().getPort(0), cell);
                Export pullUpsGnd2W = this.orCell.findExport("GND" + i + ".m-1." + side);
                Export pullUpsGnd2E = this.orCell.findExport("GND" + (i + 1) + ".m-1." + side);
                if (pullUpsGnd1W != null && pullUpsGnd2W != null) {
                    this.makeWire(this.m1Arc, 4.0, newNode, pullUpsGnd1W, orNode, pullUpsGnd2W, cell);
                }
                if (pullUpsGnd2W != null && pullUpsGnd2E != null) {
                    this.makeWire(this.m1Arc, 4.0, newNode, pullUpsGnd1E, orNode, pullUpsGnd2E, cell);
                }
            } else {
                if (pullUpsPwrW != null && pullUpsPwrE != null) {
                    this.makeWire(this.m2Arc, 14.0, lastNode, pullUpsPwrE, newNode, pullUpsPwrW, cell);
                }
                Export pullUpsGnd2W = this.orCell.findExport("GND" + i + ".m-1." + side);
                Export pullUpsGnd2E = this.orCell.findExport("GND" + (i + 1) + ".m-1." + side);
                if (pullUpsGnd1W != null && pullUpsGnd2W != null) {
                    this.makeWire(this.m1Arc, 4.0, newNode, pullUpsGnd1W, orNode, pullUpsGnd2W, cell);
                }
                if (pullUpsGnd1E != null && pullUpsGnd2E != null) {
                    this.makeWire(this.m1Arc, 4.0, newNode, pullUpsGnd1E, orNode, pullUpsGnd2E, cell);
                }
            }
            lastNode = newNode;
            for (int x = pullUpsCnt; x < pullUpsCnt + 4; ++x) {
                Export pPort = this.orCell.findExport("DATA" + x + ".m-1." + side);
                Export nPort = this.pullUps.findExport("PULLUP" + x % 4 + ".m-1.s");
                if (pPort == null || nPort == null) continue;
                this.makeWire(this.m1Arc, 4.0, orNode, pPort, newNode, nPort, cell);
            }
            pullUpsCnt += 4;
        }
        if (pullUpsPwrE != null) {
            PortInst pi = lastNode.findPortInstFromProto(pullUpsPwrE);
            Poly poly = pi.getPoly();
            double pwrY = poly.getCenterY();
            NodeInst pwrNode2 = this.makePin(cell, highX + 13.0, pwrY, 14.0, this.m2Pin);
            if (pwrNode2 == null) {
                return null;
            }
            this.makeWire(this.m2Arc, 14.0, lastNode, pullUpsPwrE, pwrNode2, pwrNode2.getProto().getPort(0), cell);
            this.makeWire(this.m2Arc, 14.0, pwrNode1, pwrNode1.getProto().getPort(0), pwrNode2, pwrNode2.getProto().getPort(0), cell);
            Export.newInstance(cell, lastNode.findPortInstFromProto(pullUpsPwrE), "PWR0.m-2.e");
        }
        if (pullUpsGnd1E != null) {
            Export.newInstance(cell, lastNode.findPortInstFromProto(pullUpsGnd1E), "GND0.m-1.e");
        }
        int x = 0;
        String aName = "ACCESS" + x + ".p.w";
        PortProto pPort = this.orCell.findPortProto(aName);
        while (pPort != null) {
            Export.newInstance(cell, orNode.findPortInstFromProto(pPort), aName);
            aName = "ACCESS" + ++x + ".p.w";
            pPort = this.orCell.findPortProto(aName);
        }
        return cell;
    }

    private Cell makePLA(Library library, String name) {
        Cell cell = Cell.makeInstance(library, name);
        NodeInst decodeNode = this.makeInstance(cell, this.decodeCell, 0.0, 0.0, false);
        if (decodeNode == null) {
            return null;
        }
        Rectangle2D decodeBounds = decodeNode.getBounds();
        NodeInst orNode = this.makeInstance(cell, this.orPlaneCell, decodeBounds.getMaxX() + 27.0, 0.0, false);
        if (orNode == null) {
            return null;
        }
        Export orPort = this.orPlaneCell.findExport("ACCESS0.p.w");
        Poly orPoly = orNode.findPortInstFromProto(orPort).getPoly();
        double orY = orPoly.getCenterY();
        Export decodePort = this.decodeCell.findExport("DATA0.m-1.n");
        Poly decodePoly = decodeNode.findPortInstFromProto(decodePort).getPoly();
        double decodeY = decodePoly.getCenterY();
        double dY = decodeY - orY;
        if (orY != decodeY) {
            orNode.move(0.0, dY);
        }
        int x = 0;
        while (orPort != null && decodePort != null) {
            this.makeWire(this.m1Arc, 4.0, orNode, orPort, decodeNode, decodePort, cell);
            orPort = this.orPlaneCell.findExport("ACCESS" + ++x + ".p.w");
            decodePort = this.decodeCell.findExport("DATA" + x + ".m-1.n");
        }
        return cell;
    }

    NodeInst makePin(Cell cell, double x, double y, double size, PrimitiveNode node) {
        NodeInst ni;
        double xS = node.getDefWidth();
        double yS = node.getDefHeight();
        if (size < xS) {
            size = xS;
        }
        if (size < yS) {
            size = yS;
        }
        if ((ni = NodeInst.makeInstance(node, new Point2D.Double(x, y), size, size, cell)) == null) {
            System.out.println("Unable to create " + node + " in " + cell);
        }
        return ni;
    }

    void makeWire(ArcProto typ, double width, NodeInst fromNodeInst, PortProto fromPortProto, NodeInst toNodeInst, PortProto toPortProto, Cell cell) {
        ArcInst ai;
        PortInst fromPi = fromNodeInst.findPortInstFromProto(fromPortProto);
        Poly fromPoly = fromPi.getPoly();
        PortInst toPi = toNodeInst.findPortInstFromProto(toPortProto);
        Poly toPoly = toPi.getPoly();
        if (typ == null) {
            System.out.println("Attempting to wire with unknown arc layer");
            return;
        }
        double wid = typ.getDefaultWidth();
        if (width > wid) {
            wid = width;
        }
        if ((ai = ArcInst.makeInstance(typ, wid, fromPi, toPi)) == null) {
            System.out.println("Unable to run " + typ + " from " + fromNodeInst + ", " + fromPortProto + " to " + toNodeInst + ", " + toPortProto + " in " + cell);
        }
    }

    NodeInst makeInstance(Cell cell, Cell Inst_proto, double x, double y, boolean mirror) {
        Rectangle2D protoBounds = Inst_proto.getBounds();
        double sX = protoBounds.getWidth();
        double sY = protoBounds.getHeight();
        Orientation orient = Orientation.IDENT;
        if (mirror) {
            orient = Orientation.Y;
            double Y1 = protoBounds.getMinY() + y;
            double Y2 = protoBounds.getMaxY() + y;
            y = Y2 + Y1 - y;
        }
        NodeInst ni = NodeInst.makeInstance(Inst_proto, new Point2D.Double(x, y), sX, sY, cell, orient, null, 0);
        return ni;
    }

    private static class SetupPLAGen
    extends EDialog {
        private JTextField andPlaneFile;
        private JTextField orPlaneFile;
        private JTextField cellName;
        private JCheckBox inputs;
        private JCheckBox outputs;
        private boolean good = false;

        private SetupPLAGen() {
            super((Frame)null, true);
            this.initComponents();
            this.setVisible(true);
        }

        private void ok() {
            this.exit(true);
        }

        protected void escapePressed() {
            this.exit(false);
        }

        public boolean failed() {
            return !this.good;
        }

        public String getAndFileName() {
            return this.andPlaneFile.getText();
        }

        public String getOrFileName() {
            return this.orPlaneFile.getText();
        }

        public boolean isInputsOnTop() {
            return this.inputs.isSelected();
        }

        public boolean isOutputsOnBottom() {
            return this.outputs.isSelected();
        }

        public String getCellName() {
            return this.cellName.getText();
        }

        private void exit(boolean goodButton) {
            this.good = goodButton;
            this.setVisible(false);
        }

        private void browse(boolean andPlane) {
            String fileName = OpenFile.chooseInputFile(FileType.ANY, andPlane ? "AND Plane File:" : "OR Plane File:");
            if (fileName == null) {
                return;
            }
            if (andPlane) {
                this.andPlaneFile.setText(fileName);
            } else {
                this.orPlaneFile.setText(fileName);
            }
        }

        private void initComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("MOSIS CMOS PLA Generation Control");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    SetupPLAGen.this.exit(false);
                }
            });
            JLabel lab1 = new JLabel("AND Plane File:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab1, gbc);
            this.andPlaneFile = new JTextField();
            this.andPlaneFile.setColumns(35);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.5;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.andPlaneFile, gbc);
            JButton andPlaneBrowse = new JButton("Browse");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 0;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)andPlaneBrowse, gbc);
            andPlaneBrowse.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SetupPLAGen.this.browse(true);
                }
            });
            JLabel lab2 = new JLabel("OR Plane File:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab2, gbc);
            this.orPlaneFile = new JTextField();
            this.orPlaneFile.setColumns(35);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 0.5;
            gbc.fill = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.orPlaneFile, gbc);
            JButton orPlaneBrowse = new JButton("Browse");
            gbc = new GridBagConstraints();
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)orPlaneBrowse, gbc);
            orPlaneBrowse.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SetupPLAGen.this.browse(false);
                }
            });
            this.inputs = new JCheckBox("Input to the Top of the AND plane");
            this.inputs.setSelected(true);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.gridwidth = 3;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.inputs, gbc);
            this.outputs = new JCheckBox("Outputs from the Bottom of the OR plane");
            this.outputs.setSelected(true);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.gridwidth = 3;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.outputs, gbc);
            JLabel lab3 = new JLabel("Cell name:");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 4;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)lab3, gbc);
            this.cellName = new JTextField();
            this.cellName.setText("pla");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 4;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.cellName, gbc);
            JButton cancel = new JButton("Cancel");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 5;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)cancel, gbc);
            cancel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SetupPLAGen.this.exit(false);
                }
            });
            JButton ok = new JButton("OK");
            this.getRootPane().setDefaultButton(ok);
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 5;
            gbc.gridwidth = 2;
            gbc.anchor = 10;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)ok, gbc);
            ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    SetupPLAGen.this.exit(true);
                }
            });
            this.pack();
        }
    }

    private static class GeneratePLAJob
    extends Job {
        private int step;
        private PLA pla;
        private Job completion;

        protected GeneratePLAJob(int step, PLA pla, Job completion) {
            super("Generate MOSIS CMOS PLA, Step " + (step + 1), User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.step = step;
            this.pla = pla;
            this.completion = completion;
            this.startJob();
        }

        public boolean doIt() {
            return this.pla.doStep(this.step, this.completion);
        }
    }

    static class UCRow {
        UCItem firstItem = new UCItem();
        UCItem lastitem = new UCItem();

        UCRow() {
        }
    }

    static class UCItem {
        int value;
        NodeInst nodeInst;
        UCItem rightItem;
        UCItem bottomItem;

        UCItem() {
        }
    }
}

