/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.text;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.tool.user.ActivityLogger;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class Version
implements Comparable {
    private static final String CURRENT = "8.03";
    private static final String ROOTARNAME = "electric";
    private final String version;
    private final int major;
    private final int minor;
    private final int details;
    private static final Version current = new Version("8.03");

    private Version(String version) {
        int major = 0;
        int minor = 0;
        int details = 0;
        int dot = version.indexOf(46);
        if (dot == -1) {
            major = Integer.parseInt(version);
        } else {
            int letters;
            String majorString = version.substring(0, dot);
            String restOfString = version.substring(dot + 1);
            major = Integer.parseInt(majorString);
            for (letters = 0; letters < restOfString.length() && TextUtils.isDigit(restOfString.charAt(letters)); ++letters) {
            }
            String minorString = restOfString.substring(0, letters);
            minor = Integer.parseInt(minorString);
            if ((restOfString = restOfString.substring(letters)).length() == 0) {
                details = 999;
            } else if (restOfString.charAt(0) == '.') {
                details = 1000 + Integer.parseInt(restOfString.substring(1));
            } else {
                while (restOfString.length() > 0 && Character.isLetter(restOfString.charAt(0))) {
                    details = details * 26 + Character.toLowerCase(restOfString.charAt(0)) - 97 + 1;
                    restOfString = restOfString.substring(1);
                }
                if (restOfString.length() > 0) {
                    System.out.println("Invalid version string " + version);
                }
            }
        }
        this.version = version;
        this.major = major;
        this.minor = minor;
        this.details = details;
    }

    public static String getAuthorInformation() {
        return "Written by Steven M. Rubin";
    }

    public static String getApplicationInformation() {
        return "The Electric VLSI Design System";
    }

    public static String getCopyrightInformation() {
        return "Copyright (c) 2004 Sun Microsystems and Static Free Software";
    }

    public static String getWarrantyInformation() {
        return "Electric comes with ABSOLUTELY NO WARRANTY";
    }

    public static String getVersionInformation() {
        String versionText = "Version " + Version.getVersion();
        String buildText = Version.getBuildDate();
        if (buildText != null) {
            versionText = versionText + " (built on " + buildText + ")";
        }
        return versionText;
    }

    public static Version getVersion() {
        return current;
    }

    public static String getBuildDate() {
        StringTokenizer parse = new StringTokenizer(System.getProperty("java.class.path"));
        String delim = System.getProperty("path.separator");
        try {
            while (parse.hasMoreElements()) {
                String filename;
                String val = parse.nextToken(delim);
                if (val.lastIndexOf(filename = "electric.jar") == -1) continue;
                File electricJar = new File(val);
                long date = electricJar.lastModified();
                Date d = new Date(date);
                return DateFormat.getDateInstance().format(d);
            }
        }
        catch (Exception e) {
            ActivityLogger.logException(e);
        }
        return null;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getDetail() {
        return this.details;
    }

    public int hashCode() {
        return this.major * 1000000 + this.minor * 10000 + this.details;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            Version v = (Version)obj;
            return this.major == v.major && this.minor == v.minor && this.details == v.details;
        }
        return false;
    }

    public int compareTo(Object o) {
        Version v = (Version)o;
        if (this.major < v.major) {
            return -1;
        }
        if (this.major > v.major) {
            return 1;
        }
        if (this.minor < v.minor) {
            return -1;
        }
        if (this.minor > v.minor) {
            return 1;
        }
        if (this.details < v.details) {
            return -1;
        }
        if (this.details > v.details) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.version;
    }

    public static Version parseVersion(String version) {
        Version v = new Version(version);
        return v;
    }
}

