/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.CellUsage;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Global;
import com.sun.electric.database.network.NetSchem;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.technologies.Artwork;
import com.sun.electric.technology.technologies.EFIDO;
import com.sun.electric.technology.technologies.GEM;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.user.ErrorLogger;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class NetCell {
    static final int VALID = 1;
    static final int LOCALVALID = 2;
    final Cell cell;
    int flags;
    int modCount = 0;
    private int[] equivPorts;
    int[] ni_pi;
    int arcsOffset;
    private int[] headConn;
    private int[] tailConn;
    int[] drawns;
    int numDrawns;
    int numExportedDrawns;
    int numConnectedDrawns;
    Map netNames = new HashMap();
    private int netNameCount;
    int exportedNetNameCount;
    private Netlist netlist;
    private static PortProto busPinPort;
    private static ArcProto busArc;
    static final /* synthetic */ boolean $assertionsDisabled;

    NetCell() {
        this.cell = null;
    }

    NetCell(Cell cell) {
        this.cell = cell;
        NetworkTool.setCell(cell, this);
    }

    final void setNetworksDirty() {
        this.setInvalid(true, false);
    }

    void exportsChanged() {
        this.setInvalid(true, true);
    }

    void setInvalid(boolean strongMe, boolean strongUsages) {
        if (strongMe) {
            this.flags &= 0xFFFFFFFD;
        }
        if ((this.flags & 1) == 0 && !strongUsages) {
            return;
        }
        this.flags &= 0xFFFFFFFE;
        this.invalidateUsagesOf(strongUsages);
    }

    void invalidateUsagesOf(boolean strong) {
        Iterator it = this.cell.getUsagesOf();
        while (it.hasNext()) {
            NetCell netCell;
            CellUsage u = (CellUsage)it.next();
            Cell parent = u.getParent();
            if (this.cell.isIconOf(parent) || (netCell = NetworkTool.getNetCell(parent)) == null) continue;
            netCell.setInvalid(strong, false);
        }
    }

    Netlist getNetlist(boolean shortResistors) {
        if ((this.flags & 1) == 0) {
            this.redoNetworks();
        }
        return this.netlist;
    }

    Iterator getNodables() {
        return this.cell.getNodes();
    }

    Global.Set getGlobals() {
        return Global.Set.empty;
    }

    int getNetMapOffset(Global global) {
        return -1;
    }

    int getNetMapOffset(Nodable no, Global global) {
        return -1;
    }

    int getNetMapOffset(Nodable no, PortProto portProto, int busIndex) {
        NodeInst ni = (NodeInst)no;
        return this.drawns[this.ni_pi[ni.getNodeIndex()] + portProto.getPortIndex()];
    }

    int getBusWidth(Nodable no, PortProto portProto) {
        return 1;
    }

    int getNetMapOffset(Export export, int busIndex) {
        return this.drawns[export.getPortIndex()];
    }

    int getNetMapOffset(ArcInst ai, int busIndex) {
        return this.drawns[this.arcsOffset + ai.getArcIndex()];
    }

    Name getBusName(ArcInst ai) {
        return null;
    }

    public int getBusWidth(ArcInst ai) {
        int drawn = this.drawns[this.arcsOffset + ai.getArcIndex()];
        if (drawn < 0) {
            return 0;
        }
        return 1;
    }

    private void checkLayoutCell() {
        ErrorLogger.MessageLog log;
        String msg;
        HashMap<NodeProto, ArrayList<NodeInst>> strangeNodes = null;
        int numNodes = this.cell.getNumNodes();
        for (int i = 0; i < numNodes; ++i) {
            ArrayList<NodeInst> nodesOfType;
            NodeInst ni = this.cell.getNode(i);
            if (ni.getNameKey().isBus()) {
                msg = "Network: Layout " + this.cell + " has arrayed " + ni;
                System.out.println(msg);
                log = NetworkTool.errorLogger.logError(msg, this.cell, 1);
                log.addGeom(ni, true, this.cell, null);
            }
            Object log2 = null;
            NodeProto np = ni.getProto();
            if ((!(np instanceof Cell) || !(NetworkTool.getNetCell((Cell)np) instanceof NetSchem)) && np != Generic.tech.universalPinNode && (!(np instanceof PrimitiveNode) || np.getTechnology() != Schematics.tech)) continue;
            if (strangeNodes == null) {
                strangeNodes = new HashMap<NodeProto, ArrayList<NodeInst>>();
            }
            if ((nodesOfType = (ArrayList<NodeInst>)strangeNodes.get(np)) == null) {
                nodesOfType = new ArrayList<NodeInst>();
                strangeNodes.put(np, nodesOfType);
            }
            nodesOfType.add(ni);
        }
        if (strangeNodes == null) {
            return;
        }
        Iterator it = strangeNodes.keySet().iterator();
        while (it.hasNext()) {
            NodeProto np = (NodeProto)it.next();
            ArrayList nodesOfType = (ArrayList)strangeNodes.get(np);
            msg = "Network: Layout " + this.cell + " has " + nodesOfType.size() + " " + np.describe(true) + " nodes";
            System.out.println(msg);
            log = NetworkTool.errorLogger.logError(msg, this.cell, 1);
            int numNodes2 = nodesOfType.size();
            for (int i = 0; i < numNodes2; ++i) {
                NodeInst ni = (NodeInst)nodesOfType.get(i);
                log.addGeom(ni, true, this.cell, null);
            }
        }
    }

    private void initConnections() {
        int i;
        int numPorts = this.cell.getNumPorts();
        int numNodes = this.cell.getNumNodes();
        int numArcs = this.cell.getNumArcs();
        if (this.ni_pi == null || this.ni_pi.length != numNodes) {
            this.ni_pi = new int[numNodes];
        }
        int offset = numPorts;
        for (i = 0; i < numNodes; ++i) {
            NodeInst ni = this.cell.getNode(i);
            this.ni_pi[i] = offset;
            offset += ni.getProto().getNumPorts();
        }
        this.arcsOffset = offset;
        if (this.headConn == null || this.headConn.length != (offset += numArcs)) {
            this.headConn = new int[offset];
            this.tailConn = new int[offset];
            this.drawns = new int[offset];
        }
        for (i = numPorts; i < this.arcsOffset; ++i) {
            this.headConn[i] = i;
            this.tailConn[i] = i;
        }
        for (i = 0; i < numPorts; ++i) {
            int portOffset = i;
            Export export = (Export)this.cell.getPort(i);
            int orig = this.getPortInstOffset(export.getOriginalPort());
            this.headConn[portOffset] = this.headConn[orig];
            this.headConn[orig] = portOffset;
            this.tailConn[portOffset] = -1;
        }
        for (i = 0; i < this.cell.getNumArcs(); ++i) {
            ArcInst ai = this.cell.getArc(i);
            int arcOffset = this.arcsOffset + i;
            int head = this.getPortInstOffset(ai.getHeadPortInst());
            this.headConn[arcOffset] = this.headConn[head];
            this.headConn[head] = arcOffset;
            int tail = this.getPortInstOffset(ai.getTailPortInst());
            this.tailConn[arcOffset] = this.tailConn[tail];
            this.tailConn[tail] = arcOffset;
        }
    }

    private void showConnections() {
        int numNodes = this.cell.getNumNodes();
        for (int i = 0; i < numNodes; ++i) {
            NodeInst ni = this.cell.getNode(i);
            int numPortInsts = ni.getProto().getNumPorts();
            for (int j = 0; j < numPortInsts; ++j) {
                int piOffset;
                PortInst pi = ni.getPortInst(j);
                System.out.println("Connections of " + pi);
                int k = piOffset = this.getPortInstOffset(pi);
                while (this.headConn[k] != piOffset) {
                    if ((k = this.headConn[k]) >= this.arcsOffset) {
                        System.out.println("\thead_arc\t" + this.cell.getArc(k - this.arcsOffset).describe(true));
                        continue;
                    }
                    System.out.println("\tport\t" + this.cell.getPort(k));
                }
                k = piOffset;
                while (this.tailConn[k] != piOffset) {
                    k = this.tailConn[k];
                    System.out.println("\ttail_arc\t" + this.cell.getArc(k - this.arcsOffset).describe(true));
                }
            }
        }
    }

    private void addToDrawn1(PortInst pi) {
        ArcProto ap;
        ArcInst ai;
        int piOffset = this.getPortInstOffset(pi);
        if (this.drawns[piOffset] >= 0) {
            return;
        }
        PortProto pp = pi.getPortProto();
        if (pp instanceof PrimitivePort && ((PrimitivePort)pp).isIsolated()) {
            return;
        }
        this.drawns[piOffset] = this.numDrawns;
        if (NetworkTool.debug) {
            System.out.println(this.numDrawns + ": " + pi);
        }
        int k = piOffset;
        while (this.headConn[k] != piOffset) {
            PortInst tpi;
            if (this.drawns[k = this.headConn[k]] >= 0) continue;
            if (k < this.arcsOffset) {
                this.drawns[k] = this.numDrawns;
                if (!NetworkTool.debug) continue;
                System.out.println(this.numDrawns + ": " + this.cell.getPort(k));
                continue;
            }
            ai = this.cell.getArc(k - this.arcsOffset);
            ap = ai.getProto();
            if (ap.getFunction() == ArcProto.Function.NONELEC || pp == busPinPort && ap != busArc) continue;
            this.drawns[k] = this.numDrawns;
            if (NetworkTool.debug) {
                System.out.println(this.numDrawns + ": " + ai);
            }
            if ((tpi = ai.getTailPortInst()).getPortProto() == busPinPort && ap != busArc) continue;
            this.addToDrawn(tpi);
        }
        k = piOffset;
        while (this.tailConn[k] != piOffset) {
            PortInst hpi;
            if (this.drawns[k = this.tailConn[k]] >= 0 || (ap = (ai = this.cell.getArc(k - this.arcsOffset)).getProto()).getFunction() == ArcProto.Function.NONELEC || pp == busPinPort && ap != busArc) continue;
            this.drawns[k] = this.numDrawns;
            if (NetworkTool.debug) {
                System.out.println(this.numDrawns + ": " + ai);
            }
            if ((hpi = ai.getHeadPortInst()).getPortProto() == busPinPort && ap != busArc) continue;
            this.addToDrawn(hpi);
        }
    }

    private void addToDrawn(PortInst pi) {
        PortProto pp = pi.getPortProto();
        NodeProto np = pp.getParent();
        int numPorts = np.getNumPorts();
        if (numPorts == 1 || np instanceof Cell) {
            this.addToDrawn1(pi);
            return;
        }
        NodeInst ni = pi.getNodeInst();
        int topology = ((PrimitivePort)pp).getTopology();
        for (int i = 0; i < numPorts; ++i) {
            if (((PrimitivePort)np.getPort(i)).getTopology() != topology) continue;
            this.addToDrawn1(ni.getPortInst(i));
        }
    }

    void makeDrawns() {
        int i;
        this.initConnections();
        Arrays.fill(this.drawns, -1);
        this.numDrawns = 0;
        int numPorts = this.cell.getNumPorts();
        for (i = 0; i < numPorts; ++i) {
            if (this.drawns[i] >= 0) continue;
            this.drawns[i] = this.numDrawns++;
            Export export = (Export)this.cell.getPort(i);
            this.addToDrawn(export.getOriginalPort());
        }
        this.numExportedDrawns = this.numDrawns;
        int numArcs = this.cell.getNumArcs();
        for (i = 0; i < numArcs; ++i) {
            PortInst tpi;
            PortInst hpi;
            ArcInst ai;
            ArcProto ap;
            if (this.drawns[this.arcsOffset + i] >= 0 || (ap = (ai = this.cell.getArc(i)).getProto()).getFunction() == ArcProto.Function.NONELEC) continue;
            this.drawns[this.arcsOffset + i] = this.numDrawns;
            if (NetworkTool.debug) {
                System.out.println(this.numDrawns + ": " + ai);
            }
            if ((hpi = ai.getHeadPortInst()).getPortProto() != busPinPort || ap == busArc) {
                this.addToDrawn(hpi);
            }
            if ((tpi = ai.getTailPortInst()).getPortProto() != busPinPort || ap == busArc) {
                this.addToDrawn(tpi);
            }
            ++this.numDrawns;
        }
        this.numConnectedDrawns = this.numDrawns;
        HashMap<NodeProto, ArrayList<NodeInst>> unconnectedPins = null;
        int numNodes = this.cell.getNumNodes();
        for (int i2 = 0; i2 < numNodes; ++i2) {
            NodeInst ni = this.cell.getNode(i2);
            NodeProto np = ni.getProto();
            int numPortInsts = np.getNumPorts();
            for (int j = 0; j < numPortInsts; ++j) {
                PortInst pi = ni.getPortInst(j);
                int piOffset = this.getPortInstOffset(pi);
                if (ni.isIconOfParent() || np.getFunction() == PrimitiveNode.Function.ART && np != Generic.tech.simProbeNode || np == Artwork.tech.pinNode || np == Generic.tech.invisiblePinNode) {
                    if (this.drawns[piOffset] < 0 || this.cell.isIcon()) continue;
                    String msg = "Network: " + this.cell + " has connections on " + pi;
                    System.out.println(msg);
                    ErrorLogger.MessageLog log = NetworkTool.errorLogger.logError(msg, this.cell, 1);
                    log.addPoly(pi.getPoly(), true, this.cell);
                    continue;
                }
                if (this.drawns[piOffset] >= 0 || pi.getPortProto() instanceof PrimitivePort && ((PrimitivePort)pi.getPortProto()).isIsolated()) continue;
                if (np.getFunction() == PrimitiveNode.Function.PIN && !this.cell.isIcon() && this.cell.getTechnology() != GEM.tech && this.cell.getTechnology() != EFIDO.tech) {
                    ArrayList<NodeInst> pinsOfType;
                    if (unconnectedPins == null) {
                        unconnectedPins = new HashMap<NodeProto, ArrayList<NodeInst>>();
                    }
                    if ((pinsOfType = (ArrayList<NodeInst>)unconnectedPins.get(np)) == null) {
                        pinsOfType = new ArrayList<NodeInst>();
                        unconnectedPins.put(np, pinsOfType);
                    }
                    pinsOfType.add(ni);
                }
                this.addToDrawn(pi);
                ++this.numDrawns;
            }
        }
        if (unconnectedPins != null) {
            Iterator it = unconnectedPins.keySet().iterator();
            while (it.hasNext()) {
                NodeProto np = (NodeProto)it.next();
                ArrayList pinsOfType = (ArrayList)unconnectedPins.get(np);
                String msg = "Network: " + this.cell + " has " + pinsOfType.size() + " unconnected pins " + np;
                System.out.println(msg);
                ErrorLogger.MessageLog log = NetworkTool.errorLogger.logWarning(msg, this.cell, 1);
                int numPins = pinsOfType.size();
                for (int i3 = 0; i3 < numPins; ++i3) {
                    NodeInst ni = (NodeInst)pinsOfType.get(i3);
                    log.addGeom(ni, true, this.cell, null);
                }
            }
        }
    }

    void showDrawns() {
        PrintWriter out;
        String filePath = "tttt";
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(filePath, true)));
        }
        catch (IOException e) {
            System.out.println("Error opening " + filePath);
            return;
        }
        out.println("Drawns " + this.cell);
        int numPorts = this.cell.getNumPorts();
        for (int drawn = 0; drawn < this.numDrawns; ++drawn) {
            for (int i = 0; i < this.drawns.length; ++i) {
                int k;
                if (this.drawns[i] != drawn) continue;
                if (i < numPorts) {
                    out.println(drawn + ": " + this.cell.getPort(i));
                    continue;
                }
                if (i >= this.arcsOffset) {
                    out.println(drawn + ": " + this.cell.getArc(i - this.arcsOffset));
                    continue;
                }
                for (k = 1; k < this.cell.getNumNodes() && this.ni_pi[k] <= i; ++k) {
                }
                NodeInst ni = this.cell.getNode(--k);
                PortInst pi = ni.getPortInst(i - this.ni_pi[k]);
                out.println(drawn + ": " + pi);
            }
        }
        out.close();
    }

    void initNetnames() {
        NetName nn;
        Iterator it = this.netNames.values().iterator();
        while (it.hasNext()) {
            nn = (NetName)it.next();
            nn.name = null;
            nn.index = -1;
        }
        this.netNameCount = 0;
        it = this.cell.getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            this.addNetNames(e.getNameKey());
        }
        this.exportedNetNameCount = this.netNameCount;
        it = this.cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = (ArcInst)it.next();
            if (ai.getProto().getFunction() == ArcProto.Function.NONELEC) continue;
            if (ai.getNameKey().isBus() && ai.getProto() != busArc) {
                String msg = "Network: " + this.cell + " has bus name <" + ai.getNameKey() + "> on arc that is not a bus";
                System.out.println(msg);
                ErrorLogger.MessageLog log = NetworkTool.errorLogger.logError(msg, this.cell, 0);
                log.addGeom(ai, true, this.cell, null);
            }
            if (!ai.isUsernamed()) continue;
            this.addNetNames(ai.getNameKey());
        }
        it = this.netNames.values().iterator();
        while (it.hasNext()) {
            nn = (NetName)it.next();
            if (nn.name == null) {
                it.remove();
                continue;
            }
            if (!NetworkTool.debug) continue;
            System.out.println("NetName " + nn.name + " " + nn.index);
        }
        if (this.netNameCount != this.netNames.size()) {
            System.out.println("Error netNameCount in NetCell.initNetnames");
        }
    }

    void addNetNames(Name name) {
        if (name.isBus()) {
            System.out.println("Network: Layout " + this.cell + " has bus port/arc " + name);
        }
        this.addNetName(name);
    }

    void addNetName(Name name) {
        NetName nn = (NetName)this.netNames.get(name);
        if (nn == null) {
            nn = new NetName();
            this.netNames.put(name.canonic(), nn);
        }
        if (nn.index < 0) {
            nn.name = name;
            nn.index = this.netNameCount++;
        }
    }

    private void internalConnections() {
        Iterator it = this.cell.getNodes();
        while (it.hasNext()) {
            NetCell netCell;
            NodeInst ni = (NodeInst)it.next();
            NodeProto np = ni.getProto();
            if (!(np instanceof Cell) || (netCell = NetworkTool.getNetCell((Cell)np)) instanceof NetSchem) continue;
            int[] eq = netCell.equivPorts;
            int nodeOffset = this.ni_pi[ni.getNodeIndex()];
            for (int i = 0; i < eq.length; ++i) {
                if (eq[i] == i) continue;
                this.netlist.connectMap(this.drawns[nodeOffset + i], this.drawns[nodeOffset + eq[i]]);
            }
        }
    }

    final int getPortInstOffset(PortInst pi) {
        return this.ni_pi[pi.getNodeInst().getNodeIndex()] + pi.getPortProto().getPortIndex();
    }

    int getPortOffset(int portIndex, int busIndex) {
        return busIndex == 0 ? portIndex : -1;
    }

    NetSchem getSchem() {
        return null;
    }

    private void buildNetworkList() {
        int drawn;
        ArcInst ai;
        int i;
        this.netlist.initNetworks(this.numExportedDrawns);
        Network[] netNameToNet = new Network[this.netNames.size()];
        int numPorts = this.cell.getNumPorts();
        for (int i2 = 0; i2 < numPorts; ++i2) {
            Export e = (Export)this.cell.getPort(i2);
            this.setNetName(netNameToNet, this.drawns[i2], e.getNameKey(), true);
        }
        int numArcs = this.cell.getNumArcs();
        for (i = 0; i < numArcs; ++i) {
            ai = this.cell.getArc(i);
            if (!ai.isUsernamed() || (drawn = this.drawns[this.arcsOffset + i]) < 0) continue;
            this.setNetName(netNameToNet, drawn, ai.getNameKey(), false);
        }
        for (i = 0; i < numArcs; ++i) {
            Network network;
            ai = this.cell.getArc(i);
            drawn = this.drawns[this.arcsOffset + i];
            if (drawn < 0 || (network = this.netlist.getNetworkByMap(drawn)).hasNames()) continue;
            network.addTempName(ai.getName());
        }
        for (i = 0; i < this.cell.getNumNodes(); ++i) {
            NodeInst ni = this.cell.getNode(i);
            for (int j = 0; j < ni.getProto().getNumPorts(); ++j) {
                Network network;
                int drawn2 = this.drawns[this.ni_pi[i] + j];
                if (drawn2 < 0 || (network = this.netlist.getNetworkByMap(drawn2)).hasNames()) continue;
                network.addTempName(ni.getName() + "@" + ni.getProto().getPort(j).getName());
            }
        }
        int numNetworks = this.netlist.getNumNetworks();
        for (i = 0; i < numNetworks; ++i) {
            if (!$assertionsDisabled && !this.netlist.getNetwork(i).hasNames()) {
                throw new AssertionError();
            }
        }
    }

    private void setNetName(Network[] netNamesToNet, int drawn, Name name, boolean exported) {
        Network network = this.netlist.getNetworkByMap(drawn);
        NetName nn = (NetName)this.netNames.get(name);
        if (netNamesToNet[nn.index] != null) {
            if (netNamesToNet[nn.index] == network) {
                return;
            }
            String msg = "Network: Layout " + this.cell + " has nets with same name " + name;
            System.out.println(msg);
            ErrorLogger.MessageLog log = NetworkTool.errorLogger.logError(msg, this.cell, 0);
            int numPorts = this.cell.getNumPorts();
            for (int i = 0; i < numPorts; ++i) {
                Export e = (Export)this.cell.getPort(i);
                if (!e.getName().equals(name.toString())) continue;
                log.addExport(e, true, this.cell, null);
            }
            int numArcs = this.cell.getNumArcs();
            for (int i = 0; i < numArcs; ++i) {
                ArcInst ai = this.cell.getArc(i);
                if (!ai.isUsernamed() || !ai.getName().equals(name.toString())) continue;
                log.addGeom(ai, true, this.cell, null);
            }
        } else {
            netNamesToNet[nn.index] = network;
        }
        network.addUserName(name, exported);
    }

    private boolean updateInterface() {
        boolean changed = false;
        int numPorts = this.cell.getNumPorts();
        if (this.equivPorts == null || this.equivPorts.length != numPorts) {
            changed = true;
            this.equivPorts = new int[numPorts];
        }
        int[] netToPort = new int[numPorts];
        Arrays.fill(netToPort, -1);
        for (int i = 0; i < numPorts; ++i) {
            int net = this.netlist.netMap[this.drawns[i]];
            if (netToPort[net] < 0) {
                netToPort[net] = i;
            }
            if (this.equivPorts[i] == netToPort[net]) continue;
            changed = true;
            this.equivPorts[i] = netToPort[net];
        }
        return changed;
    }

    int getNumEquivPorts() {
        return this.equivPorts.length;
    }

    int getEquivPorts(int portIndex) {
        return this.equivPorts[portIndex];
    }

    private void showEquivPorts() {
        System.out.println("Equivalent ports of " + this.cell);
        String s = "\t";
        Export[] ports = new Export[this.cell.getNumPorts()];
        int i = 0;
        Iterator it = this.cell.getPorts();
        while (it.hasNext()) {
            ports[i] = (Export)it.next();
            ++i;
        }
        for (i = 0; i < this.equivPorts.length; ++i) {
            Export pi = ports[i];
            if (this.equivPorts[i] != i) continue;
            boolean found = false;
            for (int j = i + 1; j < this.equivPorts.length; ++j) {
                if (this.equivPorts[i] != this.equivPorts[j]) continue;
                Export pj = ports[j];
                if (!found) {
                    s = s + " ( " + pi.getName();
                }
                found = true;
                s = s + " " + pj.getName();
            }
            s = found ? s + ")" : s + " " + pi.getName();
        }
        System.out.println(s);
    }

    void redoNetworks() {
        if ((this.flags & 1) != 0) {
            return;
        }
        NetworkTool.errorLogger.clearLogs(this.cell);
        Iterator it = this.cell.getUsagesIn();
        while (it.hasNext()) {
            CellUsage u = (CellUsage)it.next();
            Cell subCell = u.getProto();
            if (subCell.isIconOf(this.cell)) continue;
            NetCell netCell = NetworkTool.getNetCell(subCell);
            if ((netCell.flags & 1) != 0) continue;
            netCell.redoNetworks();
        }
        NetSchem schem = this.getSchem();
        if (schem != null && schem != this) {
            schem.redoNetworks();
        }
        if ((this.flags & 2) != 0) {
            this.flags |= 1;
            return;
        }
        ++this.modCount;
        this.makeDrawns();
        this.initNetnames();
        if (this.redoNetworks1()) {
            this.setInvalid(false, true);
        }
        this.flags |= 3;
    }

    boolean redoNetworks1() {
        this.checkLayoutCell();
        this.netlist = new Netlist(this, false, this.numDrawns);
        this.internalConnections();
        this.buildNetworkList();
        return this.updateInterface();
    }

    static {
        $assertionsDisabled = !NetCell.class.desiredAssertionStatus();
        busPinPort = Schematics.tech.busPinNode.getPort(0);
        busArc = Schematics.tech.bus_arc;
    }

    static class NetName {
        Name name;
        int index = -1;

        NetName() {
        }
    }
}

