/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.Geometry;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class GDS
extends Geometry {
    private static final int GDSVERSION = 3;
    private static final int BYTEMASK = 255;
    private static final int DSIZE = 512;
    private static final int MAXPOINTS = 510;
    private static final int EXPORTPRESENTATION = 0;
    private static final int STRANS_REFLX = 32768;
    private static final int STRANS_ABSA = 2;
    private static final int DTYP_NONE = 0;
    private static final short HDR_HEADER = 2;
    private static final short HDR_BGNLIB = 258;
    private static final short HDR_LIBNAME = 518;
    private static final short HDR_UNITS = 773;
    private static final short HDR_ENDLIB = 1024;
    private static final short HDR_BGNSTR = 1282;
    private static final short HDR_STRNAME = 1542;
    private static final short HDR_ENDSTR = 1792;
    private static final short HDR_BOUNDARY = 2048;
    private static final short HDR_PATH = 2304;
    private static final short HDR_SREF = 2560;
    private static final short HDR_AREF = 2816;
    private static final short HDR_TEXT = 3072;
    private static final short HDR_LAYER = 3330;
    private static final short HDR_DATATYPE = 3586;
    private static final short HDR_XY = 4099;
    private static final short HDR_ENDEL = 4352;
    private static final short HDR_SNAME = 4614;
    private static final short HDR_TEXTTYPE = 5634;
    private static final short HDR_PRESENTATION = 5889;
    private static final short HDR_STRING = 6406;
    private static final short HDR_STRANS = 6657;
    private static final short HDR_MAG = 6917;
    private static final short HDR_ANGLE = 7173;
    private static final short HDR_N_BGNLIB = 28;
    private static final short HDR_N_UNITS = 20;
    private static final short HDR_N_ANGLE = 12;
    private static final short HDR_N_MAG = 12;
    private static final int HDR_M_SNAME = 32;
    private static final int HDR_M_STRNAME = 32;
    private static final int HDR_M_ASCII = 256;
    private static final double BESTTHRESH = 0.001;
    private static final double WORSTTHRESH = 0.1;
    private static byte[] dataBufferGDS = new byte[512];
    private static byte[] emptyBuffer = new byte[512];
    private static GDSLayers currentLayerNumbers;
    private static int bufferPosition;
    private static int blockCount;
    private static double scaleFactor;
    private HashMap cellNames;
    private HashMap layerNumbers;

    public static void writeGDSFile(Cell cell, VarContext context, String filePath) {
        GDS out = new GDS();
        if (out.openBinaryOutputStream(filePath)) {
            return;
        }
        BloatVisitor visitor = out.makeBloatVisitor(GDS.getMaxHierDepth(cell));
        if (out.writeCell(cell, context, visitor)) {
            return;
        }
        if (out.closeBinaryOutputStream()) {
            return;
        }
        System.out.println(filePath + " written");
    }

    GDS() {
    }

    protected void start() {
        this.initOutput();
        this.outputBeginLibrary(this.topCell);
    }

    protected void done() {
        this.outputHeader((short)1024, 0);
        this.doneWritingOutput();
    }

    protected void writeCellGeom(Geometry.CellGeom cellGeom) {
        Cell cell = cellGeom.cell;
        this.outputBeginStruct(cell);
        Set layers = cellGeom.polyMap.keySet();
        Iterator it = layers.iterator();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            this.selectLayer(layer);
            List polyList = (List)cellGeom.polyMap.get(layer);
            Iterator polyIt = polyList.iterator();
            while (polyIt.hasNext()) {
                Poly poly = (Poly)polyIt.next();
                this.writePoly(poly, GDS.currentLayerNumbers.normal);
            }
        }
        Iterator noIt = cellGeom.nodables.iterator();
        while (noIt.hasNext()) {
            Nodable no = (Nodable)noIt.next();
            this.writeNodable(no);
        }
        if (IOTool.getGDSOutDefaultTextLayer() >= 0) {
            it = cell.getPorts();
            while (it.hasNext()) {
                int pinLayer;
                Export pp = (Export)it.next();
                NodeInst bottomNi = pp.getOriginalPort().getNodeInst();
                PortProto bottomPp = pp.getOriginalPort().getPortProto();
                AffineTransform trans = bottomNi.rotateOut();
                while (bottomNi.getProto() instanceof Cell) {
                    AffineTransform tempTrans = bottomNi.translateOut();
                    tempTrans.preConcatenate(trans);
                    PortInst pi = ((Export)bottomPp).getOriginalPort();
                    bottomNi = pi.getNodeInst();
                    bottomPp = pi.getPortProto();
                    trans = bottomNi.rotateOut();
                    trans.preConcatenate(tempTrans);
                }
                boolean wasWiped = bottomNi.isWiped();
                bottomNi.clearWiped();
                Technology tech = bottomNi.getProto().getTechnology();
                Poly[] polys = tech.getShapeOfNode(bottomNi);
                Poly poly = polys[0];
                if (wasWiped) {
                    bottomNi.setWiped();
                }
                Layer layer = poly.getLayer().getNonPseudoLayer();
                this.selectLayer(layer);
                int textLayer = pinLayer = IOTool.getGDSOutDefaultTextLayer();
                if (GDS.currentLayerNumbers.text >= 0) {
                    textLayer = GDS.currentLayerNumbers.text;
                }
                if (GDS.currentLayerNumbers.pin >= 0) {
                    pinLayer = GDS.currentLayerNumbers.pin;
                }
                if (IOTool.isGDSOutWritesExportPins()) {
                    poly.transform(trans);
                    this.writePoly(poly, pinLayer);
                }
                this.outputHeader((short)3072, 0);
                this.outputHeader((short)3330, textLayer);
                this.outputHeader((short)5634, 0);
                this.outputHeader((short)5889, 0);
                NodeInst ni = pp.getOriginalPort().getNodeInst();
                int transValue = 0;
                int angle = ni.getAngle();
                if (ni.isXMirrored() != ni.isYMirrored()) {
                    transValue |= 0x8000;
                }
                if (ni.isYMirrored()) {
                    angle = (3600 - angle) % 3600;
                }
                if (ni.isXMirrored()) {
                    angle = (1800 - angle) % 3600;
                }
                this.outputHeader((short)6657, transValue);
                this.outputMag(0.5);
                this.outputAngle(angle);
                this.outputShort((short)12);
                this.outputShort((short)4099);
                Poly portPoly = pp.getOriginalPort().getPoly();
                this.outputInt((int)(scaleFactor * portPoly.getCenterX()));
                this.outputInt((int)(scaleFactor * portPoly.getCenterY()));
                String str = pp.getName();
                int j = str.length();
                if (j > 512) {
                    j = 512;
                }
                this.outputShort((short)(4 + j));
                this.outputShort((short)6406);
                this.outputString(str, j);
                this.outputHeader((short)4352, 0);
            }
        }
        this.outputHeader((short)1792, 0);
    }

    protected boolean mergeGeom(int hierLevelsFromBottom) {
        return IOTool.isGDSOutMergesBoxes();
    }

    protected boolean selectLayer(Layer layer) {
        boolean validLayer = true;
        GDSLayers numbers = (GDSLayers)this.layerNumbers.get(layer);
        if (numbers == null) {
            String layerName = layer.getGDSLayer();
            if (layerName == null) {
                numbers = new GDSLayers();
                numbers.text = -1;
                numbers.pin = -1;
                numbers.normal = -1;
                validLayer = false;
            } else {
                numbers = GDS.parseLayerString(layerName);
            }
            this.layerNumbers.put(layer, numbers);
        }
        currentLayerNumbers = numbers;
        return validLayer;
    }

    protected void writePoly(Poly poly, int layerNumber) {
        if (layerNumber < 0) {
            return;
        }
        Point2D[] points = poly.getPoints();
        if (poly.getStyle() == Poly.Type.DISC) {
            double r = points[0].distance(points[1]);
            if (r <= 0.0) {
                return;
            }
            Poly newPoly = new Poly(points[0].getX(), points[0].getY(), r * 2.0, r * 2.0);
            this.outputBoundary(newPoly, layerNumber);
            return;
        }
        Rectangle2D polyBounds = poly.getBox();
        if (polyBounds != null) {
            if (polyBounds.getWidth() == 0.0 || polyBounds.getHeight() == 0.0) {
                return;
            }
            this.outputBoundary(poly, layerNumber);
            return;
        }
        if (points.length == 1) {
            System.out.println("WARNING: Single point cannot be written in GDS-II");
            return;
        }
        if (points.length > 200) {
            System.out.println("WARNING: GDS-II Polygons may not have more than 200 points (this has " + points.length + ")");
            return;
        }
        if (points.length == 2) {
            this.outputPath(poly, layerNumber);
        } else {
            this.outputBoundary(poly, layerNumber);
        }
    }

    protected void writeNodable(Nodable no) {
        NodeInst ni = (NodeInst)no;
        Cell subCell = (Cell)ni.getProto();
        int transValue = 0;
        int angle = ni.getAngle();
        if (ni.isXMirrored() != ni.isYMirrored()) {
            transValue |= 0x8000;
        }
        if (ni.isYMirrored()) {
            angle = (3600 - angle) % 3600;
        }
        if (ni.isXMirrored()) {
            angle = (1800 - angle) % 3600;
        }
        this.outputHeader((short)2560, 0);
        String name = (String)this.cellNames.get(subCell);
        this.outputName(4614, name, 32);
        this.outputHeader((short)6657, transValue);
        this.outputAngle(angle);
        this.outputShort((short)12);
        this.outputShort((short)4099);
        this.outputInt((int)(scaleFactor * ni.getAnchorCenterX()));
        this.outputInt((int)(scaleFactor * ni.getAnchorCenterY()));
        this.outputHeader((short)4352, 0);
    }

    private BloatVisitor makeBloatVisitor(int maxDepth) {
        BloatVisitor visitor = new BloatVisitor((Geometry)this, maxDepth);
        return visitor;
    }

    private void initOutput() {
        blockCount = 0;
        bufferPosition = 0;
        for (int i = 0; i < 512; ++i) {
            GDS.emptyBuffer[i] = 0;
        }
        Technology tech = Technology.getCurrent();
        scaleFactor = tech.getScale();
        this.layerNumbers = new HashMap();
        boolean foundValid = false;
        Iterator it = tech.getLayers();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            if (!this.selectLayer(layer)) continue;
            foundValid = true;
        }
        if (!foundValid) {
            System.out.println("Warning: there are no GDS II layers defined for the " + tech.getTechName() + " technology");
        }
        this.cellNames = new HashMap();
        it = Library.getCurrent().getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            this.cellNames.put(cell, this.makeUniqueName(cell));
        }
        it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = (Library)it.next();
            if (lib == Library.getCurrent() || lib.isHidden()) continue;
            Iterator cIt = lib.getCells();
            while (cIt.hasNext()) {
                Cell cell = (Cell)cIt.next();
                this.cellNames.put(cell, this.makeUniqueName(cell));
            }
        }
    }

    String makeUniqueName(Cell cell) {
        String name = this.makeGDSName(cell.getName());
        if (cell.getNewestVersion() != cell) {
            name = name + "_" + cell.getVersion();
        }
        String baseName = name;
        int index = 1;
        while (true) {
            boolean found = false;
            Iterator it = this.cellNames.values().iterator();
            while (it.hasNext()) {
                String str = (String)it.next();
                if (!str.equals(name)) continue;
                found = true;
                break;
            }
            if (!found) break;
            name = baseName + "_" + index;
            ++index;
        }
        this.cellNames.put(cell, name);
        return name;
    }

    private String makeGDSName(String str) {
        String ret = "";
        for (int k = 0; k < str.length(); ++k) {
            int ch = str.charAt(k);
            if (IOTool.isGDSOutUpperCase()) {
                ch = Character.toUpperCase((char)ch);
            }
            if (ch != 36 && !Character.isDigit((char)ch) && ch != 63 && !Character.isLetter((char)ch)) {
                ch = 95;
            }
            ret = ret + (char)ch;
        }
        return ret;
    }

    private void doneWritingOutput() {
        try {
            if (bufferPosition > 0) {
                for (int i = bufferPosition; i < 512; ++i) {
                    GDS.dataBufferGDS[i] = 0;
                }
                this.dataOutputStream.write(dataBufferGDS, 0, 512);
                ++blockCount;
            }
            while (blockCount % 4 != 0) {
                this.dataOutputStream.write(emptyBuffer, 0, 512);
                ++blockCount;
            }
        }
        catch (IOException e) {
            System.out.println("End of file reached while finishing GDS");
        }
    }

    private void outputBeginLibrary(Cell cell) {
        int[] units01 = this.convertFloatToArray(0.001);
        int[] units23 = this.convertFloatToArray(1.0E-9);
        this.outputHeader((short)2, 3);
        this.outputHeader((short)258, 0);
        this.outputDate(cell.getCreationDate());
        this.outputDate(cell.getRevisionDate());
        this.outputName(518, this.makeGDSName(cell.getName()), 256);
        this.outputShort((short)20);
        this.outputShort((short)773);
        this.outputIntArray(units01, 2);
        this.outputIntArray(units23, 2);
    }

    void outputBeginStruct(Cell cell) {
        this.outputHeader((short)1282, 0);
        this.outputDate(cell.getCreationDate());
        this.outputDate(cell.getRevisionDate());
        String name = (String)this.cellNames.get(cell);
        this.outputName(1542, name, 32);
    }

    private void outputDate(Date val) {
        short[] date = new short[6];
        Calendar cal = Calendar.getInstance();
        cal.setTime(val);
        date[0] = (short)cal.get(1);
        date[1] = (short)cal.get(2);
        date[2] = (short)cal.get(5);
        date[3] = (short)cal.get(10);
        date[4] = (short)cal.get(12);
        date[5] = (short)cal.get(13);
        this.outputShortArray(date, 6);
    }

    private void outputHeader(short header, int p1) {
        int type = header & 0xFF;
        int count = 4;
        if (type != 0) {
            switch (header) {
                case 2: 
                case 3330: 
                case 3586: 
                case 5634: 
                case 5889: 
                case 6657: {
                    count = 6;
                    break;
                }
                case 258: 
                case 1282: {
                    count = 28;
                    break;
                }
                case 773: {
                    count = 20;
                    break;
                }
                default: {
                    System.out.println("No entry for header " + header);
                    return;
                }
            }
        }
        this.outputShort((short)count);
        this.outputShort(header);
        if (type == 0) {
            return;
        }
        if (count == 6) {
            this.outputShort((short)p1);
        }
        if (count == 8) {
            this.outputInt(p1);
        }
    }

    private void outputName(int header, String p1, int max) {
        int count = Math.min(p1.length(), max);
        if ((count & 1) != 0) {
            ++count;
        }
        this.outputShort((short)(count + 4));
        this.outputShort((short)header);
        this.outputString(p1, count);
    }

    private void outputAngle(int ang) {
        double gdfloat = (double)ang / 10.0;
        this.outputShort((short)12);
        this.outputShort((short)7173);
        int[] units = this.convertFloatToArray(gdfloat);
        this.outputIntArray(units, 2);
    }

    private void outputMag(double scale) {
        this.outputShort((short)12);
        this.outputShort((short)6917);
        int[] units = this.convertFloatToArray(scale);
        this.outputIntArray(units, 2);
    }

    private void outputBoundary(Poly poly, int layerNumber) {
        Point2D[] points = poly.getPoints();
        int count = points.length;
        if (count > 510) {
            return;
        }
        int start = 0;
        while (true) {
            int sofar;
            for (sofar = start + 1; sofar < count && (points[sofar].getX() != points[start].getX() || points[sofar].getY() != points[start].getY()); ++sofar) {
            }
            if (sofar < count) {
                ++sofar;
            }
            this.outputHeader((short)2048, 0);
            this.outputHeader((short)3330, layerNumber);
            this.outputHeader((short)3586, 0);
            this.outputShort((short)(8 * (sofar + 1) + 4));
            this.outputShort((short)4099);
            for (int i = start; i <= sofar; ++i) {
                int j = i;
                if (i == sofar) {
                    j = 0;
                }
                this.outputInt((int)(scaleFactor * points[j].getX()));
                this.outputInt((int)(scaleFactor * points[j].getY()));
            }
            this.outputHeader((short)4352, 0);
            if (sofar >= count) break;
            count -= sofar;
            start = sofar;
        }
    }

    private void outputPath(Poly poly, int layerNumber) {
        this.outputHeader((short)2304, 0);
        this.outputHeader((short)3330, layerNumber);
        this.outputHeader((short)3586, 0);
        Point2D[] points = poly.getPoints();
        int count = 8 * points.length + 4;
        this.outputShort((short)count);
        this.outputShort((short)4099);
        for (int i = 0; i < points.length; ++i) {
            this.outputInt((int)(scaleFactor * points[i].getX()));
            this.outputInt((int)(scaleFactor * points[i].getY()));
        }
        this.outputHeader((short)4352, 0);
    }

    private void outputByte(byte val) {
        GDS.dataBufferGDS[GDS.bufferPosition++] = val;
        if (bufferPosition >= 512) {
            try {
                this.dataOutputStream.write(dataBufferGDS, 0, 512);
            }
            catch (IOException e) {
                System.out.println("End of file reached while writing GDS");
            }
            ++blockCount;
            bufferPosition = 0;
        }
    }

    private void outputShort(short val) {
        this.outputByte((byte)(val >> 8 & 0xFF));
        this.outputByte((byte)(val & 0xFF));
    }

    private void outputInt(int val) {
        this.outputShort((short)(val >> 16));
        this.outputShort((short)val);
    }

    private void outputShortArray(short[] ptr, int n) {
        for (int i = 0; i < n; ++i) {
            this.outputShort(ptr[i]);
        }
    }

    private void outputIntArray(int[] ptr, int n) {
        for (int i = 0; i < n; ++i) {
            this.outputInt(ptr[i]);
        }
    }

    private void outputString(String ptr, int n) {
        int i;
        if (IOTool.isGDSOutUpperCase()) {
            for (i = 0; i < ptr.length(); ++i) {
                this.outputByte((byte)Character.toUpperCase(ptr.charAt(i)));
            }
        } else {
            while (i < ptr.length()) {
                this.outputByte((byte)ptr.charAt(i));
                ++i;
            }
        }
        while (i < n) {
            this.outputByte((byte)0);
            ++i;
        }
    }

    private int[] convertFloatToArray(double a) {
        int exponent;
        int[] ret = new int[2];
        if (a == 0.0) {
            ret[0] = 0x40000000;
            ret[1] = 0;
            return ret;
        }
        double temp = a;
        boolean negsign = false;
        if (temp < 0.0) {
            negsign = true;
            temp = -temp;
        }
        for (exponent = 64; temp < 0.0625 && exponent > 0; temp *= 16.0, --exponent) {
        }
        if (exponent == 0) {
            System.out.println("Exponent underflow");
        }
        while (temp >= 1.0 && exponent < 128) {
            temp /= 16.0;
            ++exponent;
        }
        if (exponent > 127) {
            System.out.println("Exponent overflow");
        }
        if (negsign) {
            exponent |= 0x80;
        }
        double top = temp;
        for (int i = 0; i < 24; ++i) {
            top *= 2.0;
        }
        int highmantissa = (int)top;
        double frac = top - (double)highmantissa;
        for (int i = 0; i < 32; ++i) {
            frac *= 2.0;
        }
        ret[0] = highmantissa | exponent << 24;
        ret[1] = (int)frac;
        return ret;
    }

    public static GDSLayers parseLayerString(String string) {
        String trimmed;
        GDSLayers answers = new GDSLayers();
        answers.text = -1;
        answers.pin = -1;
        answers.normal = -1;
        while ((trimmed = string.trim()).length() != 0) {
            char lastch;
            int number = TextUtils.atoi(trimmed);
            int endPos = trimmed.indexOf(44);
            if (endPos < 0) {
                endPos = trimmed.length();
            }
            if ((lastch = trimmed.charAt(endPos - 1)) == 't') {
                answers.text = number;
            } else if (lastch == 'p') {
                answers.pin = number;
            } else {
                answers.normal = number;
            }
            if (endPos == trimmed.length()) break;
            string = trimmed.substring(endPos + 1);
        }
        return answers;
    }

    private class BloatVisitor
    extends Geometry.Visitor {
        BloatVisitor(Geometry outGeom, int maxHierDepth) {
            super(GDS.this, outGeom, maxHierDepth);
        }

        public void addNodeInst(NodeInst ni, AffineTransform trans) {
            PrimitiveNode prim = (PrimitiveNode)ni.getProto();
            Technology tech = prim.getTechnology();
            Poly[] polys = tech.getShapeOfNode(ni, null);
            Layer firstLayer = null;
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                Layer thisLayer = poly.getLayer();
                if (thisLayer != null && firstLayer == null) {
                    firstLayer = thisLayer;
                }
                if (poly.getStyle().isText()) {
                    GDS.this.outputHeader((short)3072, 0);
                    if (firstLayer != null) {
                        GDS.this.selectLayer(firstLayer);
                    }
                    GDS.this.outputHeader((short)3330, currentLayerNumbers.normal);
                    GDS.this.outputHeader((short)5634, 0);
                    GDS.this.outputHeader((short)5889, 0);
                    int transValue = 0;
                    int angle = ni.getAngle();
                    if (ni.isXMirrored() != ni.isYMirrored()) {
                        transValue |= 0x8000;
                    }
                    if (ni.isYMirrored()) {
                        angle = (3600 - angle) % 3600;
                    }
                    if (ni.isXMirrored()) {
                        angle = (1800 - angle) % 3600;
                    }
                    GDS.this.outputHeader((short)6657, transValue);
                    GDS.this.outputAngle(angle);
                    GDS.this.outputShort((short)12);
                    GDS.this.outputShort((short)4099);
                    Point2D[] points = poly.getPoints();
                    GDS.this.outputInt((int)(scaleFactor * points[0].getX()));
                    GDS.this.outputInt((int)(scaleFactor * points[0].getY()));
                    String str = poly.getString();
                    int j = str.length();
                    if (j > 512) {
                        j = 512;
                    }
                    GDS.this.outputShort((short)(4 + j));
                    GDS.this.outputShort((short)6406);
                    GDS.this.outputString(str, j);
                    GDS.this.outputHeader((short)4352, 0);
                }
                poly.transform(trans);
            }
            this.cellGeom.addPolys(polys);
        }

        public void addArcInst(ArcInst ai) {
            ArcProto ap = ai.getProto();
            Technology tech = ap.getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            this.cellGeom.addPolys(polys);
        }
    }

    public static class GDSLayers {
        public int normal;
        public int pin;
        public int text;
    }
}

