/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.Tech;
import com.sun.electric.tool.user.User;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Properties;

public class LayFlat
extends Job {
    private static void error(boolean pred, String msg) {
        if (pred) {
            System.out.println(msg);
            throw new RuntimeException();
        }
    }

    private boolean osIsWindows() {
        Properties props = System.getProperties();
        String osName = ((String)props.get("os.name")).toLowerCase();
        return osName.indexOf("windows") != -1;
    }

    private static String userName() {
        Properties props = System.getProperties();
        String name = (String)props.get("user.name");
        return name;
    }

    private Cell openCell(String libDir, String libNm, String cellNm) {
        Library lib = LayoutLib.openLibForRead(libNm, libDir + libNm + ".elib");
        Cell cell = lib.findNodeProto(cellNm);
        LayFlat.error(cell == null, "can't find cell: " + cellNm);
        return cell;
    }

    private String getHomeDir() {
        String homeDir = null;
        if (LayFlat.userName().equals("rkao")) {
            boolean nfsWedged = false;
            homeDir = this.osIsWindows() ? (nfsWedged ? "c:/a1/kao/Sun/" : "x:/") : "/home/rkao/";
        } else {
            LayFlat.error(true, "unrecognized user");
        }
        return homeDir;
    }

    private Cell getTestCell() {
        String homeDir = this.getHomeDir();
        Cell cell = null;
        String libDir = homeDir + "work/async/qFour.0/";
        libDir = homeDir + "work/async/kaoLayout/";
        cell = this.openCell(libDir, "flatTest", "bot{lay}");
        libDir = homeDir + "work/async/ivanTest/qFourP1/electric-final/";
        return cell;
    }

    public boolean doIt() {
        System.out.println("Begin flat");
        Cell cell = this.getTestCell();
        Library scratch = LayoutLib.openLibForWrite("scratch", this.getHomeDir() + "work/async/scratch.elib");
        Cell lowCell = Cell.newInstance(scratch, "lowCell{lay}");
        NodeInst.newInstance(Tech.m1m2, new Point2D.Double(1.0, 2.0), 5.0, 9.0, 0, lowCell, null);
        Cell hiCell = Cell.newInstance(scratch, "hiCell{lay}");
        Rectangle2D b = lowCell.getBounds();
        NodeInst lowInst = NodeInst.newInstance(lowCell, new Point2D.Double(0.0, 0.0), b.getWidth(), b.getHeight(), 0, hiCell, null);
        System.out.println(lowInst.getAnchorCenter());
        System.out.println("Done");
        return true;
    }

    public LayFlat() {
        super("Run Layout Flattener", User.tool, Job.Type.CHANGE, null, null, Job.Priority.ANALYSIS);
        this.startJob();
    }
}

