/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.erc;

import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.geometry.PolyQTree;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.JNetwork;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.erc.ERC;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ERCWellCheck {
    private static List wellCons;
    private static int wellConIndex;
    private static List wellAreas;
    private static HashMap cellMerges;

    public static void analyzeCurCell(boolean newAlgorithm) {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        Job job = null;
        job = newAlgorithm ? new WellCheckNew(curCell) : new WellCheck(curCell);
    }

    private static int getWellLayerType(Layer layer) {
        Layer.Function fun = layer.getFunction();
        int extra = layer.getFunctionExtras();
        if ((extra & 0x1000) != 0) {
            return 0;
        }
        if (fun == Layer.Function.WELLP) {
            return 1;
        }
        if (fun == Layer.Function.WELL || fun == Layer.Function.WELLN) {
            return 2;
        }
        if (fun == Layer.Function.IMPLANTP) {
            return 3;
        }
        if (fun == Layer.Function.IMPLANT || fun == Layer.Function.IMPLANTN) {
            return 4;
        }
        if (fun == Layer.Function.SUBSTRATE) {
            if ((extra & 0x40) != 0) {
                return 3;
            }
            return 4;
        }
        return 0;
    }

    public static class Visitor
    extends HierarchyEnumerator.Visitor {
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
            AffineTransform trans;
            NodeInst ni;
            Iterator it;
            Cell cell = info.getCell();
            PolyMerge merge = (PolyMerge)cellMerges.get(cell);
            if (merge == null) {
                merge = new PolyMerge();
                cellMerges.put(cell, merge);
                it = cell.getNodes();
                while (it.hasNext()) {
                    ni = (NodeInst)it.next();
                    trans = ni.rotateOut();
                    NodeProto subNp = ni.getProto();
                    if (subNp instanceof PrimitiveNode) {
                        PrimitiveNode pNp = (PrimitiveNode)subNp;
                        Technology tech = pNp.getTechnology();
                        Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, null, true, true);
                        int tot = nodeInstPolyList.length;
                        for (int i = 0; i < tot; ++i) {
                            Poly poly = nodeInstPolyList[i];
                            Layer layer = poly.getLayer();
                            if (ERCWellCheck.getWellLayerType(layer) == 0) continue;
                            poly.transform(trans);
                            merge.addPolygon(layer, poly);
                        }
                        continue;
                    }
                    PolyMerge subMerge = (PolyMerge)cellMerges.get(subNp);
                    if (subMerge == null) continue;
                    AffineTransform tTrans = ni.translateOut();
                    tTrans.concatenate(trans);
                    merge.addMerge(subMerge, tTrans);
                }
                it = cell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai = (ArcInst)it.next();
                    Technology tech = ai.getProto().getTechnology();
                    Poly[] arcInstPolyList = tech.getShapeOfArc(ai);
                    int tot = arcInstPolyList.length;
                    for (int i = 0; i < tot; ++i) {
                        Poly poly = arcInstPolyList[i];
                        Layer layer = poly.getLayer();
                        if (ERCWellCheck.getWellLayerType(layer) == 0) continue;
                        merge.addPolygon(layer, poly);
                    }
                }
            }
            it = cell.getNodes();
            while (it.hasNext()) {
                ni = (NodeInst)it.next();
                trans = ni.rotateOut();
                NodeProto.Function fun = ni.getFunction();
                if (fun != NodeProto.Function.WELL && fun != NodeProto.Function.SUBSTRATE) continue;
                WellCon wc = new WellCon();
                wc.ctr = ni.getTrueCenter();
                trans.transform(wc.ctr, wc.ctr);
                info.getTransformToRoot().transform(wc.ctr, wc.ctr);
                wc.np = ni.getProto();
                wc.fun = fun;
                wc.index = wellConIndex++;
                PortInst pi = ni.getOnlyPortInst();
                Netlist netList = info.getNetlist();
                JNetwork net = netList.getNetwork(pi);
                wc.netNum = info.getNetID(net);
                wc.onProperRail = false;
                if (net != null) {
                    wc.onProperRail = fun == NodeProto.Function.WELL ? true : true;
                }
                wellCons.add(wc);
            }
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            return true;
        }
    }

    public static class VisitorNew
    extends HierarchyEnumerator.Visitor {
        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            return true;
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
            AffineTransform trans;
            NodeInst ni;
            Iterator it;
            Cell cell = info.getCell();
            PolyQTree merge = (PolyQTree)cellMerges.get(cell);
            if (merge == null) {
                merge = new PolyQTree(cell.getBounds());
                cellMerges.put(cell, merge);
                it = cell.getNodes();
                while (it.hasNext()) {
                    ni = (NodeInst)it.next();
                    trans = ni.rotateOut();
                    NodeProto subNp = ni.getProto();
                    if (subNp instanceof PrimitiveNode) {
                        PrimitiveNode pNp = (PrimitiveNode)subNp;
                        Technology tech = pNp.getTechnology();
                        Poly[] nodeInstPolyList = tech.getShapeOfNode(ni, null, true, true);
                        int tot = nodeInstPolyList.length;
                        for (int i = 0; i < tot; ++i) {
                            Poly poly = nodeInstPolyList[i];
                            Layer layer = poly.getLayer();
                            if (ERCWellCheck.getWellLayerType(layer) == 0) continue;
                            poly.transform(trans);
                            merge.insert(layer, new PolyQTree.PolyNode(poly.getBounds2D()));
                        }
                        continue;
                    }
                    PolyQTree subMerge = (PolyQTree)cellMerges.get(subNp);
                    if (subMerge == null) continue;
                    AffineTransform tTrans = ni.translateOut();
                    tTrans.concatenate(trans);
                    merge.insert(subMerge, tTrans);
                }
                it = cell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai = (ArcInst)it.next();
                    Technology tech = ai.getProto().getTechnology();
                    Poly[] arcInstPolyList = tech.getShapeOfArc(ai);
                    int tot = arcInstPolyList.length;
                    for (int i = 0; i < tot; ++i) {
                        Poly poly = arcInstPolyList[i];
                        Layer layer = poly.getLayer();
                        if (ERCWellCheck.getWellLayerType(layer) == 0) continue;
                        merge.insert(layer, new PolyQTree.PolyNode(poly.getBounds2D()));
                    }
                }
            }
            it = cell.getNodes();
            while (it.hasNext()) {
                ni = (NodeInst)it.next();
                trans = ni.rotateOut();
                NodeProto.Function fun = ni.getFunction();
                if (fun != NodeProto.Function.WELL && fun != NodeProto.Function.SUBSTRATE) continue;
                WellCon wc = new WellCon();
                wc.ctr = ni.getTrueCenter();
                trans.transform(wc.ctr, wc.ctr);
                info.getTransformToRoot().transform(wc.ctr, wc.ctr);
                wc.np = ni.getProto();
                wc.fun = fun;
                wc.index = wellConIndex++;
                PortInst pi = ni.getOnlyPortInst();
                Netlist netList = info.getNetlist();
                JNetwork net = netList.getNetwork(pi);
                wc.netNum = info.getNetID(net);
                wc.onProperRail = false;
                if (net != null) {
                    wc.onProperRail = fun == NodeProto.Function.WELL ? true : true;
                }
                wellCons.add(wc);
            }
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            return true;
        }
    }

    private static class WellCheck
    extends Job {
        Cell cell;
        ErrorLogger errorLogger;

        protected WellCheck(Cell cell) {
            super("ERC Well Check", ERC.tool, Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() {
            ErrorLogger.ErrorLog err;
            Iterator it;
            WellArea wa;
            WellCon wc;
            long startTime = System.currentTimeMillis();
            this.errorLogger = ErrorLogger.newInstance("ERC Well Check");
            System.out.println("Checking Wells and Substrates...");
            wellCons = new ArrayList();
            wellConIndex = 0;
            cellMerges = new HashMap();
            Visitor wcVisitor = new Visitor();
            HierarchyEnumerator.enumerateCell(this.cell, VarContext.globalContext, null, wcVisitor);
            PolyMerge topMerge = (PolyMerge)cellMerges.get(this.cell);
            wellAreas = new ArrayList();
            int wellIndex = 0;
            Iterator it2 = topMerge.getLayersUsed();
            while (it2.hasNext()) {
                Layer layer = (Layer)it2.next();
                List polyList = topMerge.getMergedPoints(layer);
                if (polyList == null) continue;
                Iterator pIt = polyList.iterator();
                while (pIt.hasNext()) {
                    WellArea wa2 = new WellArea();
                    wa2.poly = (Poly)pIt.next();
                    wa2.bounds = wa2.poly.getBounds2D();
                    wa2.layer = layer;
                    wa2.index = wellIndex++;
                    wellAreas.add(wa2);
                }
            }
            int largestNetNum = 0;
            Iterator it3 = wellCons.iterator();
            while (it3.hasNext()) {
                wc = (WellCon)it3.next();
                if (wc.netNum <= largestNetNum) continue;
                largestNetNum = wc.netNum;
            }
            it3 = wellAreas.iterator();
            while (it3.hasNext()) {
                wa = (WellArea)it3.next();
                int wellType = ERCWellCheck.getWellLayerType(wa.layer);
                if (wellType != 1 && wellType != 2) continue;
                NodeProto.Function desiredContact = NodeProto.Function.SUBSTRATE;
                String noContactError = "No N-Well contact found in this area";
                int contactAction = ERC.getNWellCheck();
                if (wellType == 1) {
                    desiredContact = NodeProto.Function.WELL;
                    contactAction = ERC.getPWellCheck();
                    noContactError = "No P-Well contact found in this area";
                }
                boolean found = false;
                Iterator cIt = wellCons.iterator();
                while (cIt.hasNext()) {
                    WellCon wc2 = (WellCon)cIt.next();
                    if (wc2.fun != desiredContact || !wa.bounds.contains(wc2.ctr) || !wa.poly.contains(wc2.ctr)) continue;
                    wa.netNum = wc2.netNum;
                    found = true;
                    break;
                }
                if (found || contactAction != 0) continue;
                ErrorLogger.ErrorLog err2 = this.errorLogger.logError(noContactError, this.cell, 0);
                err2.addPoly(wa.poly, true, this.cell);
            }
            it3 = wellCons.iterator();
            block11: while (it3.hasNext()) {
                wc = (WellCon)it3.next();
                if (wc.netNum == 0) {
                    String errorMsg = "N-Well contact is floating";
                    if (wc.fun == NodeProto.Function.WELL) {
                        errorMsg = "P-Well contact is floating";
                    }
                    ErrorLogger.ErrorLog err3 = this.errorLogger.logError(errorMsg, this.cell, 0);
                    err3.addPoint(wc.ctr.getX(), wc.ctr.getY(), this.cell);
                    continue;
                }
                if (!wc.onProperRail) {
                    ErrorLogger.ErrorLog err4;
                    if (wc.fun == NodeProto.Function.WELL) {
                        if (ERC.isMustConnectPWellToGround()) {
                            err4 = this.errorLogger.logError("P-Well contact not connected to ground", this.cell, 0);
                            err4.addPoint(wc.ctr.getX(), wc.ctr.getY(), this.cell);
                        }
                    } else if (ERC.isMustConnectNWellToPower()) {
                        err4 = this.errorLogger.logError("N-Well contact not connected to power", this.cell, 0);
                        err4.addPoint(wc.ctr.getX(), wc.ctr.getY(), this.cell);
                    }
                }
                Iterator oIt = wellCons.iterator();
                while (oIt.hasNext()) {
                    WellCon oWc = (WellCon)oIt.next();
                    if (oWc.index <= wc.index || oWc.netNum == 0 || oWc.fun != wc.fun || oWc.netNum == wc.netNum) continue;
                    String errorMsg = "N-Well contacts are not connected";
                    if (wc.fun == NodeProto.Function.WELL) {
                        errorMsg = "P-Well contacts are not connected";
                    }
                    ErrorLogger.ErrorLog err5 = this.errorLogger.logError(errorMsg, this.cell, 0);
                    err5.addPoint(wc.ctr.getX(), wc.ctr.getY(), this.cell);
                    err5.addPoint(oWc.ctr.getX(), oWc.ctr.getY(), this.cell);
                    continue block11;
                }
            }
            if (ERC.getNWellCheck() == 1) {
                boolean found = false;
                it = wellCons.iterator();
                while (it.hasNext()) {
                    WellCon wc3 = (WellCon)it.next();
                    if (wc3.fun != NodeProto.Function.SUBSTRATE) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    err = this.errorLogger.logError("No N-Well contact found in this cell", this.cell, 0);
                }
            }
            if (ERC.getPWellCheck() == 1) {
                boolean found = false;
                it = wellCons.iterator();
                while (it.hasNext()) {
                    WellCon wc4 = (WellCon)it.next();
                    if (wc4.fun != NodeProto.Function.WELL) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    err = this.errorLogger.logError("No P-Well contact found in this cell", this.cell, 0);
                }
            }
            it = wellAreas.iterator();
            while (it.hasNext()) {
                wa = (WellArea)it.next();
                Iterator oIt = wellAreas.iterator();
                while (oIt.hasNext()) {
                    int layertype;
                    double dist;
                    WellArea oWa = (WellArea)oIt.next();
                    if (wa.index <= oWa.index || wa.layer != oWa.layer) continue;
                    boolean con = false;
                    if (wa.netNum == oWa.netNum && wa.netNum >= 0) {
                        con = true;
                    }
                    DRC.Rule rule = DRC.getSpacingRule(wa.layer, wa.layer, con, false, false);
                    if (rule.distance < 0.0 || wa.bounds.getMinX() > oWa.bounds.getMaxX() + rule.distance || oWa.bounds.getMinX() > wa.bounds.getMaxX() + rule.distance || wa.bounds.getMinY() > oWa.bounds.getMaxY() + rule.distance || oWa.bounds.getMinY() > wa.bounds.getMaxY() + rule.distance || !((dist = wa.poly.separation(oWa.poly)) < rule.distance) || (layertype = ERCWellCheck.getWellLayerType(wa.layer)) == 0) continue;
                    String areaType = null;
                    switch (layertype) {
                        case 1: {
                            areaType = "P-Well";
                            break;
                        }
                        case 2: {
                            areaType = "N-Well";
                            break;
                        }
                        case 3: {
                            areaType = "P-Select";
                            break;
                        }
                        case 4: {
                            areaType = "N-Select";
                        }
                    }
                    ErrorLogger.ErrorLog err6 = this.errorLogger.logError(areaType + " areas too close (are " + dist + ", should be " + rule.distance + ")", this.cell, 0);
                    err6.addPoly(wa.poly, true, this.cell);
                    err6.addPoly(oWa.poly, true, this.cell);
                }
            }
            if (ERC.isFindWorstCaseWell()) {
                double worstPWellDist = 0.0;
                Point2D worstPWellCon = null;
                Point2D worstPWellEdge = null;
                double worstNWellDist = 0.0;
                Point2D worstNWellCon = null;
                Point2D worstNWellEdge = null;
                Iterator it4 = wellAreas.iterator();
                while (it4.hasNext()) {
                    WellArea wa3 = (WellArea)it4.next();
                    int wellType = ERCWellCheck.getWellLayerType(wa3.layer);
                    if (wellType != 1 && wellType != 2) continue;
                    NodeProto.Function desiredContact = NodeProto.Function.SUBSTRATE;
                    if (wellType == 1) {
                        desiredContact = NodeProto.Function.WELL;
                    }
                    Point2D[] points = wa3.poly.getPoints();
                    int count = points.length;
                    for (int i = 0; i < count * 2; ++i) {
                        Point2D testPoint = null;
                        if (i < count) {
                            int prev = i - 1;
                            if (i == 0) {
                                prev = count - 1;
                            }
                            testPoint = new Point2D.Double((points[prev].getX() + points[i].getX()) / 2.0, (points[prev].getY() + points[i].getY()) / 2.0);
                        } else {
                            testPoint = points[i - count];
                        }
                        boolean first = true;
                        double bestDist = 0.0;
                        WellCon bestWc = null;
                        Iterator cIt = wellCons.iterator();
                        while (cIt.hasNext()) {
                            WellCon wc5 = (WellCon)cIt.next();
                            if (wc5.fun != desiredContact || !wa3.bounds.contains(wc5.ctr) || !wa3.poly.contains(wc5.ctr)) continue;
                            double dist = testPoint.distance(wc5.ctr);
                            if (first || dist < bestDist) {
                                bestDist = dist;
                                bestWc = wc5;
                            }
                            first = false;
                        }
                        if (first) continue;
                        if (wellType == 1) {
                            if (!(bestDist > worstPWellDist)) continue;
                            worstPWellDist = bestDist;
                            worstPWellCon = bestWc.ctr;
                            worstPWellEdge = testPoint;
                            continue;
                        }
                        if (!(bestDist > worstNWellDist)) continue;
                        worstNWellDist = bestDist;
                        worstNWellCon = bestWc.ctr;
                        worstNWellEdge = testPoint;
                    }
                }
                if (worstPWellDist > 0.0 || worstNWellDist > 0.0) {
                    Highlight.clear();
                    if (worstPWellDist > 0.0) {
                        Highlight.addLine(worstPWellCon, worstPWellEdge, this.cell);
                        System.out.println("Farthest distance from a P-Well contact is " + worstPWellDist);
                    }
                    if (worstNWellDist > 0.0) {
                        Highlight.addLine(worstNWellCon, worstNWellEdge, this.cell);
                        System.out.println("Farthest distance from an N-Well contact is " + worstNWellDist);
                    }
                    Highlight.finished();
                }
            }
            long endTime = System.currentTimeMillis();
            int errorCount = this.errorLogger.numErrors();
            if (errorCount == 0) {
                System.out.println("No Well errors found (took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
            } else {
                System.out.println("FOUND " + errorCount + " WELL ERRORS (took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
            }
            this.errorLogger.termLogging(true);
            return true;
        }
    }

    private static class WellCheckNew
    extends Job {
        Cell cell;
        ErrorLogger errorLogger;

        protected WellCheckNew(Cell cell) {
            super("ERC Well Check New", ERC.tool, Job.Type.EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.startJob();
        }

        public boolean doIt() {
            ErrorLogger.ErrorLog err;
            Iterator it;
            WellArea wa;
            WellCon wc;
            long startTime = System.currentTimeMillis();
            this.errorLogger = ErrorLogger.newInstance("ERC Well Check New");
            System.out.println("Checking Wells and Substrates...");
            wellCons = new ArrayList();
            wellConIndex = 0;
            cellMerges = new HashMap();
            VisitorNew wcVisitor = new VisitorNew();
            HierarchyEnumerator.enumerateCell(this.cell, VarContext.globalContext, null, wcVisitor);
            PolyQTree topMerge = (PolyQTree)cellMerges.get(this.cell);
            wellAreas = new ArrayList();
            int wellIndex = 0;
            Iterator it2 = topMerge.getKeyIterator();
            while (it2.hasNext()) {
                Layer layer = (Layer)it2.next();
                Set set = topMerge.getObjects(layer, false);
                Iterator pIt = set.iterator();
                while (pIt.hasNext()) {
                    WellArea wa2 = new WellArea();
                    PolyQTree.PolyNode pn = (PolyQTree.PolyNode)pIt.next();
                    wa2.poly = new Poly(pn.getPoints());
                    wa2.poly.setLayer(layer);
                    wa2.poly.setStyle(Poly.Type.FILLED);
                    wa2.bounds = wa2.poly.getBounds2D();
                    wa2.layer = layer;
                    wa2.index = wellIndex++;
                    wellAreas.add(wa2);
                }
            }
            int largestNetNum = 0;
            Iterator it3 = wellCons.iterator();
            while (it3.hasNext()) {
                wc = (WellCon)it3.next();
                if (wc.netNum <= largestNetNum) continue;
                largestNetNum = wc.netNum;
            }
            it3 = wellAreas.iterator();
            while (it3.hasNext()) {
                wa = (WellArea)it3.next();
                int wellType = ERCWellCheck.getWellLayerType(wa.layer);
                if (wellType != 1 && wellType != 2) continue;
                NodeProto.Function desiredContact = NodeProto.Function.SUBSTRATE;
                String noContactError = "No N-Well contact found in this area";
                int contactAction = ERC.getNWellCheck();
                if (wellType == 1) {
                    desiredContact = NodeProto.Function.WELL;
                    contactAction = ERC.getPWellCheck();
                    noContactError = "No P-Well contact found in this area";
                }
                boolean found = false;
                Iterator cIt = wellCons.iterator();
                while (cIt.hasNext()) {
                    WellCon wc2 = (WellCon)cIt.next();
                    if (wc2.fun != desiredContact || !wa.bounds.contains(wc2.ctr) || !wa.poly.contains(wc2.ctr)) continue;
                    wa.netNum = wc2.netNum;
                    found = true;
                    break;
                }
                if (found || contactAction != 0) continue;
                ErrorLogger.ErrorLog err2 = this.errorLogger.logError(noContactError, this.cell, 0);
                err2.addPoly(wa.poly, true, this.cell);
            }
            it3 = wellCons.iterator();
            block11: while (it3.hasNext()) {
                wc = (WellCon)it3.next();
                if (wc.netNum == 0) {
                    String errorMsg = "N-Well contact is floating";
                    if (wc.fun == NodeProto.Function.WELL) {
                        errorMsg = "P-Well contact is floating";
                    }
                    ErrorLogger.ErrorLog err3 = this.errorLogger.logError(errorMsg, this.cell, 0);
                    err3.addPoint(wc.ctr.getX(), wc.ctr.getY(), this.cell);
                    continue;
                }
                if (!wc.onProperRail) {
                    ErrorLogger.ErrorLog err4;
                    if (wc.fun == NodeProto.Function.WELL) {
                        if (ERC.isMustConnectPWellToGround()) {
                            err4 = this.errorLogger.logError("P-Well contact not connected to ground", this.cell, 0);
                            err4.addPoint(wc.ctr.getX(), wc.ctr.getY(), this.cell);
                        }
                    } else if (ERC.isMustConnectNWellToPower()) {
                        err4 = this.errorLogger.logError("N-Well contact not connected to power", this.cell, 0);
                        err4.addPoint(wc.ctr.getX(), wc.ctr.getY(), this.cell);
                    }
                }
                Iterator oIt = wellCons.iterator();
                while (oIt.hasNext()) {
                    WellCon oWc = (WellCon)oIt.next();
                    if (oWc.index <= wc.index || oWc.netNum == 0 || oWc.fun != wc.fun || oWc.netNum == wc.netNum) continue;
                    String errorMsg = "N-Well contacts are not connected";
                    if (wc.fun == NodeProto.Function.WELL) {
                        errorMsg = "P-Well contacts are not connected";
                    }
                    ErrorLogger.ErrorLog err5 = this.errorLogger.logError(errorMsg, this.cell, 0);
                    err5.addPoint(wc.ctr.getX(), wc.ctr.getY(), this.cell);
                    err5.addPoint(oWc.ctr.getX(), oWc.ctr.getY(), this.cell);
                    continue block11;
                }
            }
            if (ERC.getNWellCheck() == 1) {
                boolean found = false;
                it = wellCons.iterator();
                while (it.hasNext()) {
                    WellCon wc3 = (WellCon)it.next();
                    if (wc3.fun != NodeProto.Function.SUBSTRATE) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    err = this.errorLogger.logError("No N-Well contact found in this cell", this.cell, 0);
                }
            }
            if (ERC.getPWellCheck() == 1) {
                boolean found = false;
                it = wellCons.iterator();
                while (it.hasNext()) {
                    WellCon wc4 = (WellCon)it.next();
                    if (wc4.fun != NodeProto.Function.WELL) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    err = this.errorLogger.logError("No P-Well contact found in this cell", this.cell, 0);
                }
            }
            it = wellAreas.iterator();
            while (it.hasNext()) {
                wa = (WellArea)it.next();
                Iterator oIt = wellAreas.iterator();
                while (oIt.hasNext()) {
                    int layertype;
                    double dist;
                    WellArea oWa = (WellArea)oIt.next();
                    if (wa.index <= oWa.index || wa.layer != oWa.layer) continue;
                    boolean con = false;
                    if (wa.netNum == oWa.netNum && wa.netNum >= 0) {
                        con = true;
                    }
                    DRC.Rule rule = DRC.getSpacingRule(wa.layer, wa.layer, con, false, false);
                    if (rule.distance < 0.0 || wa.bounds.getMinX() > oWa.bounds.getMaxX() + rule.distance || oWa.bounds.getMinX() > wa.bounds.getMaxX() + rule.distance || wa.bounds.getMinY() > oWa.bounds.getMaxY() + rule.distance || oWa.bounds.getMinY() > wa.bounds.getMaxY() + rule.distance || !((dist = wa.poly.separation(oWa.poly)) < rule.distance) || (layertype = ERCWellCheck.getWellLayerType(wa.layer)) == 0) continue;
                    String areaType = null;
                    switch (layertype) {
                        case 1: {
                            areaType = "P-Well";
                            break;
                        }
                        case 2: {
                            areaType = "N-Well";
                            break;
                        }
                        case 3: {
                            areaType = "P-Select";
                            break;
                        }
                        case 4: {
                            areaType = "N-Select";
                        }
                    }
                    ErrorLogger.ErrorLog err6 = this.errorLogger.logError(areaType + " areas too close (are " + dist + ", should be " + rule.distance + ")", this.cell, 0);
                    err6.addPoly(wa.poly, true, this.cell);
                    err6.addPoly(oWa.poly, true, this.cell);
                }
            }
            if (ERC.isFindWorstCaseWell()) {
                double worstPWellDist = 0.0;
                Point2D worstPWellCon = null;
                Point2D worstPWellEdge = null;
                double worstNWellDist = 0.0;
                Point2D worstNWellCon = null;
                Point2D worstNWellEdge = null;
                Iterator it4 = wellAreas.iterator();
                while (it4.hasNext()) {
                    WellArea wa3 = (WellArea)it4.next();
                    int wellType = ERCWellCheck.getWellLayerType(wa3.layer);
                    if (wellType != 1 && wellType != 2) continue;
                    NodeProto.Function desiredContact = NodeProto.Function.SUBSTRATE;
                    if (wellType == 1) {
                        desiredContact = NodeProto.Function.WELL;
                    }
                    Point2D[] points = wa3.poly.getPoints();
                    int count = points.length;
                    for (int i = 0; i < count * 2; ++i) {
                        Point2D testPoint = null;
                        if (i < count) {
                            int prev = i - 1;
                            if (i == 0) {
                                prev = count - 1;
                            }
                            testPoint = new Point2D.Double((points[prev].getX() + points[i].getX()) / 2.0, (points[prev].getY() + points[i].getY()) / 2.0);
                        } else {
                            testPoint = points[i - count];
                        }
                        boolean first = true;
                        double bestDist = 0.0;
                        WellCon bestWc = null;
                        Iterator cIt = wellCons.iterator();
                        while (cIt.hasNext()) {
                            WellCon wc5 = (WellCon)cIt.next();
                            if (wc5.fun != desiredContact || !wa3.bounds.contains(wc5.ctr) || !wa3.poly.contains(wc5.ctr)) continue;
                            double dist = testPoint.distance(wc5.ctr);
                            if (first || dist < bestDist) {
                                bestDist = dist;
                                bestWc = wc5;
                            }
                            first = false;
                        }
                        if (first) continue;
                        if (wellType == 1) {
                            if (!(bestDist > worstPWellDist)) continue;
                            worstPWellDist = bestDist;
                            worstPWellCon = bestWc.ctr;
                            worstPWellEdge = testPoint;
                            continue;
                        }
                        if (!(bestDist > worstNWellDist)) continue;
                        worstNWellDist = bestDist;
                        worstNWellCon = bestWc.ctr;
                        worstNWellEdge = testPoint;
                    }
                }
                if (worstPWellDist > 0.0 || worstNWellDist > 0.0) {
                    Highlight.clear();
                    if (worstPWellDist > 0.0) {
                        Highlight.addLine(worstPWellCon, worstPWellEdge, this.cell);
                        System.out.println("Farthest distance from a P-Well contact is " + worstPWellDist);
                    }
                    if (worstNWellDist > 0.0) {
                        Highlight.addLine(worstNWellCon, worstNWellEdge, this.cell);
                        System.out.println("Farthest distance from an N-Well contact is " + worstNWellDist);
                    }
                    Highlight.finished();
                }
            }
            long endTime = System.currentTimeMillis();
            int errorCount = this.errorLogger.numErrors();
            if (errorCount == 0) {
                System.out.println("No Well errors found (took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
            } else {
                System.out.println("FOUND " + errorCount + " WELL ERRORS (took " + TextUtils.getElapsedTime(endTime - startTime) + ")");
            }
            this.errorLogger.termLogging(true);
            return true;
        }
    }

    static class WellArea {
        Rectangle2D bounds;
        Poly poly;
        Layer layer;
        int netNum;
        int index;

        WellArea() {
        }
    }

    static class WellCon {
        Point2D ctr;
        int netNum;
        boolean onProperRail;
        NodeProto.Function fun;
        NodeProto np;
        int index;

        WellCon() {
        }
    }
}

