/*
 * Electric(tm) VLSI Design System
 *
 * File: tecfpga.h
 * FPGA technology header file
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

/* all of the primitives */
extern TECHNOLOGY *fpga_tech;				/* the technology */

extern NODEPROTO  *fpga_wirepinprim;		/* wire pin */
extern NODEPROTO  *fpga_pipprim;			/* pip */
extern NODEPROTO  *fpga_repeaterprim;		/* repeater */

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
extern "C"
{
#endif

/* prototypes for technology routines */
void fpga_shapearcpoly(ARCINST*, INTSML, POLYGON*);
INTSML fpga_arcpolys(ARCINST*);
void fpga_shapeportpoly(NODEINST*, PORTPROTO*, POLYGON*, XARRAY, INTSML);
INTSML fpga_nodeEpolys(NODEINST*);
void fpga_shapeEnodepoly(NODEINST*, INTSML, POLYGON*);
void fpga_shapenodepoly(NODEINST*, INTSML, POLYGON*);
INTSML fpga_nodepolys(NODEINST*);
void fpga_setmode(INTSML, char*[]);
INTSML fpga_initprocess(TECHNOLOGY*, INTSML);
void fpga_termprocess(void);

#if defined(__cplusplus) && !defined(ALLCPLUSPLUS)
};
#endif
