#line 2 "java_scanner.c"

#line 4 "java_scanner.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 33
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#if __STDC__

#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE java_restart(java_in  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

extern int java_leng;

extern FILE *java_in, *java_out;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up java_text. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up java_text again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

/* The following is because we cannot portably get our hands on size_t
 * (without autoconf's help, which isn't available because we want
 * flex-generated scanners to compile on their own).
 */

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef unsigned int yy_size_t;
#endif

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via java_restart()), so that the user can continue scanning by
	 * just pointing java_in at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when java_text is formed. */
static char yy_hold_char;
static int yy_n_chars;		/* number of characters read into yy_ch_buf */
int java_leng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow java_wrap()'s to do buffer switches
 * instead of setting up a fresh java_in.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void java_restart (FILE *input_file  );
void java__switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE java__create_buffer (FILE *file,int size  );
void java__delete_buffer (YY_BUFFER_STATE b  );
void java__flush_buffer (YY_BUFFER_STATE b  );
void java_push_buffer_state (YY_BUFFER_STATE new_buffer  );
void java_pop_buffer_state (void );

static void java_ensure_buffer_stack (void );
static void java__load_buffer_state (void );
static void java__init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER java__flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE java__scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE java__scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE java__scan_bytes (yyconst char *bytes,int len  );

void *java_alloc (yy_size_t  );
void *java_realloc (void *,yy_size_t  );
void java_free (void *  );

#define yy_new_buffer java__create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        java_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            java__create_buffer(java_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        java_ensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            java__create_buffer(java_in,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define java_wrap(n) 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *java_in = (FILE *) 0, *java_out = (FILE *) 0;

typedef int yy_state_type;

extern int java_lineno;
extern char *java_text;
#define yytext_ptr java_text

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up java_text.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	java_leng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 92
#define YY_END_OF_BUFFER 93
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[342] =
    {   0,
        0,    0,    0,    0,   93,   91,   84,   90,   91,   91,
       91,   91,   91,   91,   91,   91,   91,   91,   81,   81,
        6,   91,    7,   76,   91,   91,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   91,   88,   89,   88,   84,   11,    0,   83,
        0,   16,   12,   22,    0,    0,   14,    1,   17,    2,
       18,   78,   85,   87,   15,    0,   81,   79,    0,   81,
        0,    3,    8,   10,    9,    4,   76,    0,    0,    0,
       24,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       39,   76,   76,   76,   76,   76,   76,   76,   37,   76,

       76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   23,   13,
       86,   82,   78,    0,   87,    0,   77,   80,   19,   20,
        5,    0,    0,    0,    0,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       76,   41,   76,   76,   76,   57,   76,   76,   70,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   76,   42,   76,   76,   76,    0,
       78,   77,   80,   21,    0,    0,    0,    0,   76,   76,
       76,   53,   47,   76,   60,   76,   76,   76,   76,   76,

       38,   76,   76,   76,   76,   52,   76,   76,   76,   76,
       61,   76,   75,   76,   76,   76,   76,   76,   76,   76,
       76,   76,   76,   76,   72,   76,   76,   73,   59,   76,
       76,    0,    0,    0,    0,   76,   76,   49,   43,   55,
       69,   76,   76,   76,   76,   74,   30,   62,   76,   76,
       76,   76,   76,   76,   76,   76,   76,   76,   58,   76,
       76,   68,   76,   76,   44,   76,   76,   40,    0,    0,
        0,   76,   76,   76,   76,   76,   56,   76,   76,   76,
       63,   76,   76,   67,   76,   76,   76,   27,   51,   32,
       76,   46,   76,   34,   76,   76,    0,    0,   76,   54,

       76,   48,   36,   45,   76,   76,   76,   71,   26,   76,
       76,   76,   76,   76,    0,    0,   25,   50,   76,   76,
       76,   76,   65,   76,   76,   66,    0,    0,   76,   76,
       31,   29,   76,   28,    0,   35,   64,   76,   76,   33,
        0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        2,    2,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    2,    1,    1,    1,    1,
        1,    2,    4,    5,    1,    1,    6,    7,    8,    1,
        1,    9,   10,    1,   11,   12,   13,   14,   15,   15,
       15,   15,   15,   15,   15,   15,   15,    1,    1,   16,
       17,   18,    1,    1,   19,   19,   19,   20,   21,   22,
       23,   23,   23,   23,   23,   24,   23,   23,   23,   23,
       23,   23,   23,   23,   25,   23,   23,   26,   23,   23,
        1,   27,    1,   28,   23,    1,   29,   30,   31,   32,

       33,   34,   35,   36,   37,   23,   38,   39,   40,   41,
       42,   43,   23,   44,   45,   46,   47,   48,   49,   50,
       51,   52,    1,   53,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static yyconst flex_int32_t yy_meta[54] =
    {   0,
        1,    1,    2,    1,    1,    1,    1,    3,    1,    1,
        1,    1,    1,    4,    4,    1,    1,    1,    4,    4,
        4,    4,    5,    5,    5,    5,    5,    1,    4,    4,
        4,    4,    4,    4,    5,    5,    5,    5,    5,    5,
        5,    5,    5,    5,    5,    5,    5,    5,    5,    5,
        5,    5,    1
    } ;

static yyconst flex_int16_t yy_base[370] =
    {   0,
        0,    0,   51,   52,  652,  653,  649,  653,  633,   51,
      632,   50,  621,  630,   48,   51,   49,   57,   67,   33,
       55,  629,   58,  618,   48,  627,   50,   63,   82,   70,
       65,   93,   42,   99,   71,   96,  107,   69,  101,   83,
       89,   58,   91,  653,  653,  630,  640,  653,  133,  653,
      638,  653,  653,  653,  134,  138,  653,  653,  653,  653,
      653,  148,  653,    0,  653,  141,  123,  653,  161,  653,
        0,  623,  653,  653,  653,  140,  612,  120,    0,    0,
      653,  132,  137,  151,  139,  147,  159,  160,  156,  164,
      163,  167,  168,  126,  172,  169,  173,  174,  611,  175,

      176,  178,  177,  179,  188,  198,  189,  203,  197,  205,
      207,  210,  208,  211,  212,  213,  228,  217,  653,  653,
      653,  653,  653,  247,    0,  193,  254,  224,  653,  653,
      620,    0,    0,    0,    0,  232,  243,  244,  239,  248,
      219,  250,  252,  253,  256,  257,  262,  263,  264,  273,
      274,  609,  265,  266,  277,  279,  283,  284,  608,  286,
      288,  287,  290,  289,  292,  293,  295,  297,  300,  302,
      311,  304,  303,  305,  317,  607,  320,  324,  316,  342,
      344,  653,  653,  653,    0,    0,    0,    0,  327,  334,
      335,  606,  605,  333,  604,  336,  338,  343,  341,  347,

      603,  348,  350,  352,  355,  602,  360,  358,  363,  367,
      601,  368,  600,  369,  370,  373,  376,  377,  378,  380,
      381,  382,  383,  391,  599,  388,  393,  598,  597,  395,
      392,    0,    0,    0,    0,  401,  402,  596,  595,  594,
      593,  405,  396,  406,  413,  592,  409,  591,  407,  415,
      416,  417,  422,  423,  425,  429,  432,  426,  590,  435,
      427,  589,  438,  437,  441,  442,  443,  588,    0,    0,
        0,  587,  445,  448,  450,  455,  586,  451,  456,  457,
      585,  460,  465,  584,  466,  471,  468,  583,  582,  581,
      475,  580,  458,  579,  478,  476,    0,    0,  479,  578,

      483,  577,  576,  575,  481,  485,  486,  574,  573,  493,
      492,  496,  497,  494,    0,    0,  572,  571,  501,  502,
      503,  507,  570,  504,  505,  569,    0,    0,  513,  515,
      568,  567,  516,  566,    0,  565,  564,  519,  518,  560,
      653,  568,  573,  578,  580,  585,  577,  563,  562,  561,
      560,  559,  558,  557,  556,  555,  553,  552,  551,  550,
      549,  544,  529,  484,  368,  336,  237,  205,   82
    } ;

static yyconst flex_int16_t yy_def[370] =
    {   0,
      341,    1,  342,  342,  341,  341,  341,  341,  341,  343,
      341,  341,  344,  341,  341,  341,  341,  341,  341,   19,
      341,  341,  341,  345,  341,  341,  345,  345,  345,  345,
      345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
      345,  345,  341,  341,  341,  341,  341,  341,  343,  341,
      343,  341,  341,  341,  344,  344,  341,  341,  341,  341,
      341,  341,  341,  346,  341,  341,   19,  341,  341,  341,
      347,  341,  341,  341,  341,  341,  345,  341,  348,  349,
      341,  345,  345,  345,  345,  345,  345,  345,  345,  345,
      345,  345,  345,  345,  345,  345,  345,  345,  345,  345,

      345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
      345,  345,  345,  345,  345,  345,  345,  345,  341,  341,
      341,  341,  341,  341,  346,  341,  341,  347,  341,  341,
      341,  350,  351,  352,  353,  345,  345,  345,  345,  345,
      345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
      345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
      345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
      345,  345,  345,  345,  345,  345,  345,  345,  345,  341,
      341,  341,  341,  341,  354,  355,  356,  357,  345,  345,
      345,  345,  345,  345,  345,  345,  345,  345,  345,  345,

      345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
      345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
      345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
      345,  358,  359,  360,  361,  345,  345,  345,  345,  345,
      345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
      345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
      345,  345,  345,  345,  345,  345,  345,  345,  362,  363,
      364,  345,  345,  345,  345,  345,  345,  345,  345,  345,
      345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
      345,  345,  345,  345,  345,  345,  365,  366,  345,  345,

      345,  345,  345,  345,  345,  345,  345,  345,  345,  345,
      345,  345,  345,  345,  367,  368,  345,  345,  345,  345,
      345,  345,  345,  345,  345,  345,  369,  361,  345,  345,
      345,  345,  345,  345,  363,  345,  345,  345,  345,  345,
        0,  341,  341,  341,  341,  341,  341,  341,  341,  341,
      341,  341,  341,  341,  341,  341,  341,  341,  341,  341,
      341,  341,  341,  341,  341,  341,  341,  341,  341
    } ;

static yyconst flex_int16_t yy_nxt[707] =
    {   0,
        6,    7,    8,    9,   10,   11,   12,   13,   14,   15,
       16,   17,   18,   19,   20,   21,   22,   23,   24,   24,
       24,   24,   24,   24,   24,   24,   25,   26,   27,   28,
       29,   30,   31,   32,   33,   24,   34,   24,   35,   24,
       36,   24,   37,   38,   39,   40,   24,   41,   42,   24,
       24,   24,   43,   45,   45,   50,   53,   58,  341,   46,
       46,   60,   62,   62,   59,   63,   54,   61,   78,   64,
       72,   73,   79,   65,   75,   76,   78,   51,   66,   82,
       67,   67,  341,   98,   78,  335,   68,   69,   68,   78,
       70,   78,   71,  118,   80,   78,   78,   78,   68,   69,

       68,  109,   90,   92,   83,   70,   84,  119,   78,   78,
       86,   91,  102,   85,   93,   78,   71,   87,  115,   78,
       88,   94,   78,   89,  103,   78,  116,   78,  104,   95,
      117,   96,   99,   78,   97,  106,  110,   50,  100,  101,
      341,  122,  105,  120,  132,   55,  111,  112,  341,  113,
      107,  114,   78,  108,   62,   62,  130,  131,   78,   51,
       56,   62,   62,   78,  149,   78,  133,  123,  124,  123,
      126,  126,  341,   78,  127,  127,  136,   78,  137,  123,
      124,  123,   78,  138,  139,   78,   78,  142,  143,   78,
       78,  140,  141,   78,   78,   78,  144,  145,   78,   78,

       78,   78,   78,   78,   78,   78,  127,  127,  328,  146,
      151,  147,  150,  148,   78,   78,  152,  154,  157,  153,
      155,  156,  158,   78,   78,  162,  160,  159,  161,   78,
      163,   78,  164,   78,   78,  167,   78,   78,   78,   78,
      327,  174,  165,   78,  170,   78,  166,  183,  172,  194,
      168,  171,  169,  179,   78,  173,  180,  180,   78,  175,
      181,  181,  183,  176,  177,   78,  178,  127,  127,   78,
       78,  192,  191,  182,   78,  182,   78,  189,   78,   78,
      193,  190,   78,   78,  199,  182,  200,  182,   78,   78,
       78,   78,   78,  195,  201,  202,  196,  197,  198,   78,

       78,  204,  205,   78,  207,   78,  206,  208,  203,   78,
       78,  210,   78,   78,   78,   78,   78,  211,   78,   78,
      212,   78,  209,   78,  213,  214,   78,  217,   78,   78,
       78,   78,  222,  221,  215,  216,  219,   78,  218,  316,
      220,  224,   78,   78,  226,  227,   78,  223,  225,  228,
       78,  229,  230,   78,  231,  181,  181,  181,  181,   78,
       78,   78,   78,  123,   78,  123,  237,   78,  239,   78,
      236,  315,  238,   78,   78,  123,   78,  123,   78,  242,
      240,   78,  246,  241,   78,  244,   78,  243,  245,   78,
      247,  251,  249,   78,   78,   78,   78,  254,  255,   78,

      248,  250,   78,   78,   78,  256,   78,   78,   78,   78,
      252,  261,  257,  263,   78,  253,  260,   78,   78,   78,
      258,   78,   78,  259,  268,  262,  264,   78,   78,  273,
      274,   78,   78,   78,  276,   78,  265,  266,  277,   78,
      267,   78,   78,   78,  278,  275,  280,  279,   78,   78,
      283,   78,   78,   78,  284,   78,  282,  285,   78,  287,
      281,   78,  288,   78,   78,  290,  289,   78,   78,   78,
      286,   78,  291,  292,   78,  299,   78,   78,  295,  296,
      293,   78,   78,   78,   78,  294,   78,  298,  300,  305,
      306,   78,   78,  307,   78,  303,  301,   78,  308,  312,

      302,   78,   78,  309,   78,   78,  304,   78,  311,   78,
      313,   78,   78,  310,  314,  318,  321,  320,   78,   78,
       78,  319,   78,   78,  317,  322,  326,   78,   78,   78,
       78,   78,   77,   78,  323,  331,  324,  325,  332,   78,
      333,   78,   78,  330,   78,   78,  329,  297,  337,  340,
      334,  339,  272,  271,  270,  269,  235,  336,  234,  233,
      232,  188,  187,  186,  185,  135,  134,  338,   44,   44,
       44,   44,   44,   49,   49,   49,   49,   49,   55,   55,
      128,   55,   55,   77,   77,  125,   78,  125,  125,  125,
       78,   78,   78,   78,   78,   78,   78,   78,   78,   78,

       78,   78,   78,   78,   78,   78,   78,   78,   78,   78,
       78,   78,   78,   78,   78,   78,   78,   78,   78,   78,
       78,   78,   78,   78,   78,   78,   78,   78,   78,   78,
       78,   78,   78,   78,   78,   78,  184,   78,   78,  129,
      341,   47,  121,   81,   78,   74,   57,   56,   52,   48,
       47,  341,    5,  341,  341,  341,  341,  341,  341,  341,
      341,  341,  341,  341,  341,  341,  341,  341,  341,  341,
      341,  341,  341,  341,  341,  341,  341,  341,  341,  341,
      341,  341,  341,  341,  341,  341,  341,  341,  341,  341,
      341,  341,  341,  341,  341,  341,  341,  341,  341,  341,

      341,  341,  341,  341,  341,  341
    } ;

static yyconst flex_int16_t yy_chk[707] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    3,    4,   10,   12,   15,   20,    3,
        4,   16,   17,   17,   15,   18,   12,   16,   33,   18,
       21,   21,   25,   18,   23,   23,   27,   10,   19,   27,
       19,   19,   20,   33,   42,  369,   19,   19,   19,   28,
       19,   31,   19,   42,   25,   38,   30,   35,   19,   19,

       19,   38,   30,   31,   28,   19,   28,   43,   29,   40,
       29,   30,   35,   28,   31,   41,   19,   29,   40,   32,
       29,   32,   36,   29,   36,   34,   40,   39,   36,   32,
       41,   32,   34,   37,   32,   37,   39,   49,   34,   34,
       56,   55,   36,   43,   78,   56,   39,   39,   67,   39,
       37,   39,   94,   37,   66,   66,   76,   76,   82,   49,
       55,   62,   62,   83,   94,   85,   78,   62,   62,   62,
       69,   69,   67,   86,   69,   69,   82,   84,   83,   62,
       62,   62,   89,   84,   85,   87,   88,   87,   88,   91,
       90,   86,   86,   92,   93,   96,   89,   90,   95,   97,

       98,  100,  101,  103,  102,  104,  126,  126,  368,   91,
       96,   92,   95,   93,  105,  107,   97,  100,  102,   98,
      101,  101,  103,  109,  106,  107,  105,  104,  106,  108,
      107,  110,  108,  111,  113,  111,  112,  114,  115,  116,
      367,  116,  109,  118,  113,  141,  110,  128,  115,  141,
      111,  114,  112,  118,  117,  115,  124,  124,  136,  116,
      124,  124,  128,  116,  117,  139,  117,  127,  127,  137,
      138,  139,  138,  127,  140,  127,  142,  136,  143,  144,
      140,  137,  145,  146,  145,  127,  146,  127,  147,  148,
      149,  153,  154,  142,  147,  148,  143,  144,  144,  150,

      151,  150,  151,  155,  154,  156,  153,  154,  149,  157,
      158,  156,  160,  162,  161,  164,  163,  157,  165,  166,
      158,  167,  155,  168,  160,  161,  169,  164,  170,  173,
      172,  174,  169,  168,  162,  163,  166,  171,  165,  366,
      167,  171,  179,  175,  173,  174,  177,  170,  172,  175,
      178,  177,  178,  189,  179,  180,  180,  181,  181,  194,
      190,  191,  196,  181,  197,  181,  190,  199,  194,  198,
      189,  365,  191,  200,  202,  181,  203,  181,  204,  198,
      196,  205,  203,  197,  208,  200,  207,  199,  202,  209,
      204,  209,  207,  210,  212,  214,  215,  214,  215,  216,

      205,  208,  217,  218,  219,  216,  220,  221,  222,  223,
      210,  221,  217,  223,  226,  212,  220,  224,  231,  227,
      218,  230,  243,  219,  231,  222,  224,  236,  237,  236,
      237,  242,  244,  249,  243,  247,  226,  227,  244,  245,
      230,  250,  251,  252,  245,  242,  249,  247,  253,  254,
      252,  255,  258,  261,  253,  256,  251,  254,  257,  256,
      250,  260,  257,  264,  263,  260,  258,  265,  266,  267,
      255,  273,  261,  263,  274,  273,  275,  278,  266,  267,
      264,  276,  279,  280,  293,  265,  282,  364,  274,  280,
      282,  283,  285,  283,  287,  278,  275,  286,  285,  293,

      276,  291,  296,  286,  295,  299,  279,  305,  291,  301,
      295,  306,  307,  287,  296,  301,  307,  306,  311,  310,
      314,  305,  312,  313,  299,  310,  314,  319,  320,  321,
      324,  325,  363,  322,  311,  321,  312,  313,  322,  329,
      324,  330,  333,  320,  339,  338,  319,  362,  330,  339,
      325,  338,  361,  360,  359,  358,  357,  329,  356,  355,
      354,  353,  352,  351,  350,  349,  348,  333,  342,  342,
      342,  342,  342,  343,  343,  343,  343,  343,  344,  344,
      347,  344,  344,  345,  345,  346,  340,  346,  346,  346,
      337,  336,  334,  332,  331,  326,  323,  318,  317,  309,

      308,  304,  303,  302,  300,  294,  292,  290,  289,  288,
      284,  281,  277,  272,  268,  262,  259,  248,  246,  241,
      240,  239,  238,  229,  228,  225,  213,  211,  206,  201,
      195,  193,  192,  176,  159,  152,  131,   99,   77,   72,
       51,   47,   46,   26,   24,   22,   14,   13,   11,    9,
        7,    5,  341,  341,  341,  341,  341,  341,  341,  341,
      341,  341,  341,  341,  341,  341,  341,  341,  341,  341,
      341,  341,  341,  341,  341,  341,  341,  341,  341,  341,
      341,  341,  341,  341,  341,  341,  341,  341,  341,  341,
      341,  341,  341,  341,  341,  341,  341,  341,  341,  341,

      341,  341,  341,  341,  341,  341
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int java__flex_debug;
int java__flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *java_text;
#line 1 "java_scanner.l"
#line 2 "java_scanner.l"
/*
 * java_scanner.l - Input file for lex that defines the Java token syntax.
 *
 * Copyright (C) 2001  Southern Storm Software, Pty Ltd.
 * Copyright (C) 2003  Gopal.V
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/* Rename the lex/yacc symbols to support multiple parsers */
#include "java_rename.h"

#include <stdio.h>
#include "java_internal.h"
#include "java_grammar.h"

extern YYSTYPE yylval;
#ifdef YYLTYPE
extern YYLTYPE yylloc;
#endif

/*
 * Get the next line of input from the C# pre-processor.
 */
#define	YY_INPUT(buf,result,maxSize)	\
	{ \
		result = CCPluginInput((buf), (maxSize)); \
	}

/*
 * Update the line number information and return a token code.
 */
#ifdef YYLTYPE
#define	RETURNTOK(x)		\
			do { \
				yylloc.first_line = yycurrlinenum(); \
				return (x); \
			} while (0)
#else
#define	RETURNTOK(x)		return (x)
#endif

/*
 * Parse a floating point quantity into yylval.
 */
static int ParseFloat(char *text)
{
	char *endptr;

#ifdef HAVE_STRTOD
	/* Use "strtod" to parse the value */
	yylval.real.value = (ILDouble)(strtod(text, &endptr));
#else
	/* Use "sscanf" to parse the value */
	double result;
	int num;
	if(sscanf(text, "%lf%n", &result, &num) <= 0)
	{
		/* Shouldn't happen, but do something reasonable */
		yylval.real.value = (ILDouble)0.0;
		yylval.real.type = JAVA_NUMTYPE_FLOAT64;
		return FLOAT_LITERAL;
	}
	yylval.real.value = (ILDouble)result;
	endptr = text + num;
#endif

	/* Process the floating point suffix, if present */
	if(*endptr == 'f' || *endptr == 'F')
	{
		yylval.real.type = JAVA_NUMTYPE_FLOAT32;
		return FLOAT_LITERAL;
	}
	else
	{
		yylval.real.type = JAVA_NUMTYPE_FLOAT64;
		return FLOAT_LITERAL;
	}
}

/*
 * Parse an integer quantity into yylval.
 */
static void ParseInt(char *text)
{
	ILUInt64 value = 0;
	ILUInt64 digit;
	int errorType = 0;

	/* Parse the main parse of the value */
	if(*text == '0' && (text[1] == 'x' || text[1] == 'X'))
	{
		/* Hexadecimal integer constant */
		text += 2;
		while(*text != '\0')
		{
			if(*text >= 'A' && *text <= 'F')
			{
				digit = (ILUInt64)(*text - 'A' + 10);
			}
			else if(*text >= 'a' && *text <= 'f')
			{
				digit = (ILUInt64)(*text - 'a' + 10);
			}
			else if(*text >= '0' && *text <= '9')
			{
				digit = (ILUInt64)(*text - '0');
			}
			else
			{
				break;
			}
			if((value & 0xF000000000000000ULL) != 0)
			{
				errorType |= 1;
			}
			value = (value << 4) + digit;
			++text;
		}
	}
	else if(*text == '0' && text[1] != '\0' && text[1] != 'u' &&
	        text[1] != 'U' && text[1] != 'l' && text[1] != 'L')
	{
		/* The C# standard does not support octal integer constants,
		   but we have provided an option to turn them back on */
		if(CCStringListContains(extension_flags, num_extension_flags,
								"octal-constants"))
		{
			/* Octal integer constant: only active with "-foctal-constants" */
			while(*text != '\0')
			{
				if(*text >= '0' && *text <= '7')
				{
					digit = (ILUInt64)(*text - '0');
				}
				else if(*text == '8' || *text == '9')
				{
					/* Cannot use '8' and '9' in octal constants! */
					errorType |= 2;
					digit = 0;
				}
				else
				{
					break;
				}
				if((value & 0xE000000000000000ULL) != 0)
				{
					errorType |= 1;
				}
				value = (value << 3) + digit;
				++text;
			}
		}
		else
		{
			/* Parse as a decimal constant */
			goto decimal;
		}
	}
	else
	{
		/* Decimal integer constant */
	decimal:
		while(*text != '\0')
		{
			if(*text >= '0' && *text <= '9')
			{
				if((value & 0x8000000000000000ULL) != 0)
				{
					errorType |= 1;
				}
				value <<= 1;
				if((value & 0xC000000000000000ULL) != 0)
				{
					errorType |= 1;
				}
				digit = value << 2;
				if((value += digit) < digit)
				{
					errorType |= 1;
				}
				digit = (ILUInt64)(*text - '0');
				if((value += digit) < digit)
				{
					errorType |= 1;
				}
			}
			else
			{
				break;
			}
			++text;
		}
	}

	/* Report errors */
	if(errorType)
	{
		if((errorType & 1) != 0)
		{
			CCError("integer constant is too large");
		}
		if((errorType & 2) != 0)
		{
			CCError("invalid octal constant");
		}
		value = 0;
	}

	/* Set the return value */
	yylval.integer.value = value;

	/* Parse the type information and determine if the value can be negated */
	if((*text == 'l' || *text == 'L') && text[1] == '\0')
	{
		/* Long constant */
		yylval.integer.type = JAVA_NUMTYPE_INT64;
		yylval.integer.canneg = 1;
	}
	else if(*text != '\0')
	{
		/* Unsigned long constant */
		yylval.integer.type = JAVA_NUMTYPE_INT64;
		yylval.integer.canneg = 0;
	}
	else
	{
		/* Untyped constant */
		if(value == 0x8000000000000000ULL)
		{
			yylval.integer.type = JAVA_NUMTYPE_INT64;
			yylval.integer.canneg = 1;
		}
		else if((value & 0xFFFFFFFF00000000ULL) != 0)
		{
			yylval.integer.type = JAVA_NUMTYPE_INT64;
			yylval.integer.canneg = 1;
		}
		else if(value == 0x0000000080000000ULL)
		{
			yylval.integer.type = JAVA_NUMTYPE_INT32;
			yylval.integer.canneg = 1;
		}
		else if((value & 0x0000000080000000ULL) != 0)
		{
			yylval.integer.type = JAVA_NUMTYPE_INT32;
			yylval.integer.canneg = 1;
		}
		else
		{
			yylval.integer.type = JAVA_NUMTYPE_INT32;
			yylval.integer.canneg = 1;
		}
	}
}

/*
 * Parse a single hex digit.
 */
#define	PARSE_HEX_DIGIT(need)		\
			do { \
				if(*temp >= '0' && *temp <= '9') \
				{ \
					*value = *value * 16 + (ILUInt32)(*temp - '0'); \
					++temp; \
				} \
				else if(*temp >= 'A' && *temp <= 'F') \
				{ \
					*value = *value * 16 + (ILUInt32)(*temp - 'A' + 10); \
					++temp; \
				} \
				else if(*temp >= 'a' && *temp <= 'f') \
				{ \
					*value = *value * 16 + (ILUInt32)(*temp - 'a' + 10); \
					++temp; \
				} \
				else if((need)) \
				{ \
					goto invalidHex; \
				} \
			} while (0)

/*
 * Parse an escape sequence within a character or string.
 */
static int ParseEscape(const char *temp, ILUInt32 *value)
{
	const char *begin = temp;
	static char escapechars[] =
		"\007\010cde\014ghijklm\012opq\015s\011u\013wxyz";

	if(*temp == 'x')
	{
		/* Hex character: the C# specification allows 1-4 hex chars */
		++temp;
		*value = 0;
		PARSE_HEX_DIGIT(1);
		PARSE_HEX_DIGIT(0);
		PARSE_HEX_DIGIT(0);
		PARSE_HEX_DIGIT(0);
	}
	else if(*temp == 'u')
	{
		/* 16-bit Unicode character */
		++temp;
		*value = 0;
		PARSE_HEX_DIGIT(1);
		PARSE_HEX_DIGIT(1);
		PARSE_HEX_DIGIT(1);
		PARSE_HEX_DIGIT(1);
	}
	else if(*temp == 'U')
	{
		/* 32-bit Unicode character */
		++temp;
		*value = 0;
		PARSE_HEX_DIGIT(1);
		PARSE_HEX_DIGIT(1);
		PARSE_HEX_DIGIT(1);
		PARSE_HEX_DIGIT(1);
		PARSE_HEX_DIGIT(1);
		PARSE_HEX_DIGIT(1);
		PARSE_HEX_DIGIT(1);
		PARSE_HEX_DIGIT(1);
	}
	else if(*temp >= 'a' && *temp <= 'z')
	{
		*value = (ILUInt32)(escapechars[*temp - 'a']);
		if(*value == (ILUInt32)(*temp))
		{
			CCTypedWarning("-unknown-escapes",
						   "unknown escape sequence `\\%c'", *temp);
		}
		++temp;
	}
	else if(*temp >= '0' && *temp <= '7')
	{
		/* Octal character constant.  The C# standard only supports
		   '\0', but we allow others to be used also, with a warning */
		if(*temp == '0' && (temp[1] < '0' || temp[1] > '7'))
		{
			/* Unambiguous "\0" escape sequence */
			*value = 0;
			++temp;
		}
		else
		{
			/* The programmer can supply "-fno-octal-chars" to disable
			   the use of octal character constants */
			if(CCStringListContainsInv(extension_flags, num_extension_flags,
									   "octal-chars"))
			{
				if(*temp == '0')
				{
					*value = 0;
					++temp;
				}
				else
				{
					goto unknown;
				}
			}
			else
			{
				if(*temp != '0' || (temp[1] >= '0' && temp[1] <= '7'))
				{
					CCTypedWarning("-octal-chars",
					               "non-standard octal character escape used");
					CCTypedWarning("-octal-chars",
							   	   "(use -fno-octal-chars to disable the use");
					CCTypedWarning("-octal-chars",
							   	   "(of non-standard octal character escapes)");
				}
				*value = 0;
				do
				{
					*value = *value * 8 + (ILUInt32)(*temp - '0');
					++temp;
				}
				while(*temp >= '0' && *temp <= '7');
			}
		}
	}
	else
	{
	unknown:
		if(*temp != '\'' && *temp != '"' && *temp != '\\')
		{
			CCTypedWarning("-unknown-escapes",
						   "unknown escape sequence `\\%c'", *temp);
		}
		*value = (((ILUInt32)(*temp)) & (ILUInt32)0xFF);
		++temp;
	}
	return (int)(temp - begin);
invalidHex:
	{
		char save = *temp;
		*((char *)temp) = '\0';
		CCError("invalid hexadecimal escape sequence `%s'", begin - 1);
		*((char *)temp) = save;
		return (int)(temp - begin);
	}
}

/*
 * Parse a character according to the prevailing charset encoding.
 * Returns the length of the sequence.
 */
static int ParseEncodedChar(const char *text, ILUInt32 *value)
{
	const char *begin = text;

	if(CCStringListContains(extension_flags, num_extension_flags,
							"latin1-charset"))
	{
		/* Latin-1 character */
		*value = (((ILUInt32)(*text)) & (ILUInt32)0xFF);
		++text;
	}
	else if((*text & (char)0xE0) == (char)0xC0 &&
	        (text[1] & (char)0xC0) == (char)0x80)
	{
		/* Two-byte UTF-8 character */
		*value = ((((ILUInt32)(*text)) & 0x1F) << 6) |
		          (((ILUInt32)(text[1])) & 0x3F);
		text += 2;
	}
	else if((*text & (char)0xF0) == (char)0xE0 &&
	        (text[1] & (char)0xC0) == (char)0x80 &&
	        (text[2] & (char)0xC0) == (char)0x80)
	{
		/* Three-byte UTF-8 character */
		*value = ((((ILUInt32)(*text)) & 0x0F) << 12) |
		         ((((ILUInt32)(text[1])) & 0x3F) << 6) |
		          (((ILUInt32)(text[2])) & 0x3F);
		text += 3;
	}
	else if((*text & (char)0xF8) == (char)0xF0 &&
	        (text[1] & (char)0xC0) == (char)0x80 &&
	        (text[2] & (char)0xC0) == (char)0x80 &&
	        (text[3] & (char)0xC0) == (char)0x80)
	{
		/* Four-byte UTF-8 character */
		*value = ((((ILUInt32)(*text)) & 0x07) << 18) |
		         ((((ILUInt32)(text[1])) & 0x3F) << 12) |
		         ((((ILUInt32)(text[2])) & 0x3F) << 6) |
		          (((ILUInt32)(text[3])) & 0x3F);
		text += 4;
	}
	else if((*text & (char)0xFC) == (char)0xF8 &&
	        (text[1] & (char)0xC0) == (char)0x80 &&
	        (text[2] & (char)0xC0) == (char)0x80 &&
	        (text[3] & (char)0xC0) == (char)0x80 &&
	        (text[4] & (char)0xC0) == (char)0x80)
	{
		/* Five-byte UTF-8 character */
		*value = ((((ILUInt32)(*text)) & 0x03) << 24) |
		         ((((ILUInt32)(text[1])) & 0x3F) << 18) |
		         ((((ILUInt32)(text[2])) & 0x3F) << 12) |
		         ((((ILUInt32)(text[3])) & 0x3F) << 6) |
		          (((ILUInt32)(text[4])) & 0x3F);
		text += 5;
	}
	else if((*text & (char)0xFC) == (char)0xFC &&
	        (text[1] & (char)0xC0) == (char)0x80 &&
	        (text[2] & (char)0xC0) == (char)0x80 &&
	        (text[3] & (char)0xC0) == (char)0x80 &&
	        (text[4] & (char)0xC0) == (char)0x80)
	{
		/* Six-byte UTF-8 character */
		*value = ((((ILUInt32)(*text)) & 0x03) << 30) |
		         ((((ILUInt32)(text[1])) & 0x3F) << 24) |
		         ((((ILUInt32)(text[2])) & 0x3F) << 18) |
		         ((((ILUInt32)(text[3])) & 0x3F) << 12) |
		         ((((ILUInt32)(text[4])) & 0x3F) << 6) |
		          (((ILUInt32)(text[5])) & 0x3F);
		text += 6;
	}
	else
	{
		/* Invalid sequence: treat it as an 8-bit character and skip it */
		CCTypedWarning("-invalid-utf8", "invalid UTF-8 sequence");
		*value = (((ILUInt32)(*text)) & (ILUInt32)0xFF);
		++text;
	}

	return (int)(text - begin);
}

/*
 * Parse a wide character value.  Returns the length of the parsed data.
 */
static int ParseWChar(const char *text, ILUInt32 *result)
{
	const char *begin = text;

	/* Parse the character */
	if(*text == '\\')
	{
		/* Escaped character */
		++text;
		text += ParseEscape(text, result);
	}
	else if((*text & (char)0x80) == 0)
	{
		/* Normal 7-bit character */
		*result = (((ILUInt32)(*text)) & (ILUInt32)0xFF);
		++text;
	}
	else
	{
		/* Character in the prevailing charset encoding */
		text += ParseEncodedChar(text, result);
	}

	/* Return the length of the character to the caller */
	return (int)(text - begin);
}

/*
 * Parse a character constant value.
 */
static ILUInt32 ParseCharConstant(const char *text)
{
	ILUInt32 value;

	/* Skip the leading "'" */
	++text;

	/* Parse the character */
	text += ParseWChar(text, &value);

	/* Warn if the character is greater than 16-bits */
	if(value >= (ILUInt32)0x00010000)
	{
		CCTypedWarning("-large-unicode-chars",
					   "32-bit Unicode character `\\U%08lX' used: truncating "
				  	   "to 16 bits", (unsigned long)value);
	}

	/* Make sure that the constant is terminated correctly */
	if(*text != '\'')
	{
		CCTypedWarning("-multi-char-constant", "multi-character constant");
	}

	/* Return the value to the caller */
	return value;
}

/*
 * Parse a string value, converting it into UTF-8.
 */
static ILIntString ParseString(char *text)
{
	char buffer[128];
	ILUInt32 ch;
	int posn;
	ILIntString intern;
	ILIntString append;

	/* Initialize the value to be returned */
	intern.string = 0;
	intern.len = 0;
	posn = 0;

	/* Read characters from the string and encode them in UTF-8 */
	while(*text != '"' && *text != '\0')
	{
		/* Get the next character */
		text += ParseWChar(text, &ch);

		/* Encode it in UTF-8 */
		if(!ch)
		{
			/* Encode embedded NUL's using 2 bytes to protect
			   them from higher-level code that may try to use
			   the string as a normal C string */
			buffer[posn++] = (char)0xC0;
			buffer[posn++] = (char)0x80;
		}
		else if(ch < 0x80)
		{
			buffer[posn++] = (char)ch;
		}
		else if(ch < (1 << 11))
		{
			buffer[posn++] = (char)((ch >> 6) | 0xC0);
			buffer[posn++] = (char)((ch & 0x3F) | 0x80);
		}
		else if(ch < (1 << 16))
		{
			buffer[posn++] = (char)((ch >> 12) | 0xE0);
			buffer[posn++] = (char)(((ch >> 6) & 0x3F) | 0x80);
			buffer[posn++] = (char)((ch & 0x3F) | 0x80);
		}
		else if(ch < (1 << 21))
		{
			buffer[posn++] = (char)((ch >> 18) | 0xF0);
			buffer[posn++] = (char)(((ch >> 12) & 0x3F) | 0x80);
			buffer[posn++] = (char)(((ch >> 6) & 0x3F) | 0x80);
			buffer[posn++] = (char)((ch & 0x3F) | 0x80);
		}
		else if(ch < (1 << 26))
		{
			buffer[posn++] = (char)((ch >> 24) | 0xF8);
			buffer[posn++] = (char)(((ch >> 18) & 0x3F) | 0x80);
			buffer[posn++] = (char)(((ch >> 12) & 0x3F) | 0x80);
			buffer[posn++] = (char)(((ch >> 6) & 0x3F) | 0x80);
			buffer[posn++] = (char)((ch & 0x3F) | 0x80);
		}
		else
		{
			buffer[posn++] = (char)((ch >> 30) | 0xFC);
			buffer[posn++] = (char)(((ch >> 24) & 0x3F) | 0x80);
			buffer[posn++] = (char)(((ch >> 18) & 0x3F) | 0x80);
			buffer[posn++] = (char)(((ch >> 12) & 0x3F) | 0x80);
			buffer[posn++] = (char)(((ch >> 6) & 0x3F) | 0x80);
			buffer[posn++] = (char)((ch & 0x3F) | 0x80);
		}

		/* Flush the buffer into "intern" if it is nearly full */
		if(posn >= 120)
		{
			if(intern.len)
			{
				append.string = buffer;
				append.len = posn;
				intern = ILInternAppendedString(intern, append);
			}
			else
			{
				intern = ILInternString(buffer, posn);
			}
			posn = 0;
		}
	}

	/* Flush the remainder of the buffer into "intern" */
	if(intern.len)
	{
		append.string = buffer;
		append.len = posn;
		intern = ILInternAppendedString(intern, append);
	}
	else
	{
		intern = ILInternString(buffer, posn);
	}

	/* Return the final string to the caller */
	return intern;
}

/*
 * Parse an identifier value, converting it into UTF-8.
 */
static ILIntString ParseIdentifier(char *text)
{
	char buffer[128];
	ILUInt32 ch;
	int posn;
	ILIntString intern;
	ILIntString append;
	int first;
	ILUnicodeCategory category;
	int invalid;

	/* Initialize the value to be returned */
	intern.string = 0;
	intern.len = 0;
	posn = 0;
	first = 1;
	invalid = 0;

	/* Read characters from the string and encode them in UTF-8 */
	while(*text != '\0')
	{
		/* Get the next character */
		text += ParseWChar(text, &ch);

		/* Validate it */
		if(first)
		{
			if(!((ch >= 'A' && ch <= 'Z') ||
			     (ch >= 'a' && ch <= 'z') || ch == '_'))
			{
				category = ILGetUnicodeCategory((unsigned)ch);
				if(ch != '_' &&
				   category != ILUnicode_UppercaseLetter &&
				   category != ILUnicode_LowercaseLetter &&
				   category != ILUnicode_TitlecaseLetter &&
				   category != ILUnicode_ModifierLetter &&
				   category != ILUnicode_OtherLetter &&
				   category != ILUnicode_LetterNumber)
				{
					invalid = 1;
				}
			}
			first = 0;
		}
		else
		{
			if(!((ch >= 'A' && ch <= 'Z') ||
			     (ch >= 'a' && ch <= 'z') ||
			     (ch >= '0' && ch <= '9') || ch == '_'))
			{
				category = ILGetUnicodeCategory((unsigned)ch);
				if(category != ILUnicode_UppercaseLetter &&
				   category != ILUnicode_LowercaseLetter &&
				   category != ILUnicode_TitlecaseLetter &&
				   category != ILUnicode_ModifierLetter &&
				   category != ILUnicode_OtherLetter &&
				   category != ILUnicode_LetterNumber &&
				   category != ILUnicode_DecimalDigitNumber &&
				   category != ILUnicode_NonSpacingMark &&
				   category != ILUnicode_SpaceCombiningMark &&
				   category != ILUnicode_ConnectorPunctuation &&
				   category != ILUnicode_Format)
				{
					invalid = 1;
				}
			}
		}

		/* Encode it in UTF-8 */
		if(!ch)
		{
			/* Encode embedded NUL's using 2 bytes to protect
			   them from higher-level code that may try to use
			   the string as a normal C string */
			buffer[posn++] = (char)0xC0;
			buffer[posn++] = (char)0x80;
		}
		else if(ch < 0x80)
		{
			buffer[posn++] = (char)ch;
		}
		else if(ch < (1 << 11))
		{
			buffer[posn++] = (char)((ch >> 6) | 0xC0);
			buffer[posn++] = (char)((ch & 0x3F) | 0x80);
		}
		else if(ch < (1 << 16))
		{
			buffer[posn++] = (char)((ch >> 12) | 0xE0);
			buffer[posn++] = (char)(((ch >> 6) & 0x3F) | 0x80);
			buffer[posn++] = (char)((ch & 0x3F) | 0x80);
		}
		else if(ch < (1 << 21))
		{
			buffer[posn++] = (char)((ch >> 18) | 0xF0);
			buffer[posn++] = (char)(((ch >> 12) & 0x3F) | 0x80);
			buffer[posn++] = (char)(((ch >> 6) & 0x3F) | 0x80);
			buffer[posn++] = (char)((ch & 0x3F) | 0x80);
		}
		else if(ch < (1 << 26))
		{
			buffer[posn++] = (char)((ch >> 24) | 0xF8);
			buffer[posn++] = (char)(((ch >> 18) & 0x3F) | 0x80);
			buffer[posn++] = (char)(((ch >> 12) & 0x3F) | 0x80);
			buffer[posn++] = (char)(((ch >> 6) & 0x3F) | 0x80);
			buffer[posn++] = (char)((ch & 0x3F) | 0x80);
		}
		else
		{
			buffer[posn++] = (char)((ch >> 30) | 0xFC);
			buffer[posn++] = (char)(((ch >> 24) & 0x3F) | 0x80);
			buffer[posn++] = (char)(((ch >> 18) & 0x3F) | 0x80);
			buffer[posn++] = (char)(((ch >> 12) & 0x3F) | 0x80);
			buffer[posn++] = (char)(((ch >> 6) & 0x3F) | 0x80);
			buffer[posn++] = (char)((ch & 0x3F) | 0x80);
		}

		/* Flush the buffer into "intern" if it is nearly full */
		if(posn >= 120)
		{
			if(intern.len)
			{
				append.string = buffer;
				append.len = posn;
				intern = ILInternAppendedString(intern, append);
			}
			else
			{
				intern = ILInternString(buffer, posn);
			}
			posn = 0;
		}
	}

	/* Flush the remainder of the buffer into "intern" */
	if(intern.len)
	{
		append.string = buffer;
		append.len = posn;
		intern = ILInternAppendedString(intern, append);
	}
	else
	{
		intern = ILInternString(buffer, posn);
	}

	/* Report an error if there was an invalid character in the identifier */
	if(invalid)
	{
		CCError("invalid character in identifier");
	}

	/* Return the final string to the caller */
	return intern;
}


#line 1556 "java_scanner.c"

#define INITIAL 0
#define COMMENT 1

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int java_wrap (void );
#else
extern int java_wrap (void );
#endif
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif

#ifndef YY_NO_INPUT

#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO (void) fwrite( java_text, java_leng, 1, java_out )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( java_in )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( java_in ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, java_in))==0 && ferror(java_in)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(java_in); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int java_lex (void);

#define YY_DECL int java_lex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after java_text and java_leng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
#line 845 "java_scanner.l"


#line 1711 "java_scanner.c"

	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! java_in )
			java_in = stdin;

		if ( ! java_out )
			java_out = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			java_ensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				java__create_buffer(java_in,YY_BUF_SIZE );
		}

		java__load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of java_text. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 342 )
					yy_c = yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 653 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
#line 847 "java_scanner.l"
{ RETURNTOK(INC_OP); }
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 848 "java_scanner.l"
{ RETURNTOK(DEC_OP); }
	YY_BREAK
case 3:
YY_RULE_SETUP
#line 849 "java_scanner.l"
{ RETURNTOK(SHL_OP); }
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 850 "java_scanner.l"
{ RETURNTOK(SHR_OP); }
	YY_BREAK
case 5:
YY_RULE_SETUP
#line 851 "java_scanner.l"
{ RETURNTOK(USHR_OP); }
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 852 "java_scanner.l"
{ RETURNTOK(L_OP); }
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 853 "java_scanner.l"
{ RETURNTOK(G_OP); }
	YY_BREAK
case 8:
YY_RULE_SETUP
#line 854 "java_scanner.l"
{ RETURNTOK(LE_OP); }
	YY_BREAK
case 9:
YY_RULE_SETUP
#line 855 "java_scanner.l"
{ RETURNTOK(GE_OP); }
	YY_BREAK
case 10:
YY_RULE_SETUP
#line 856 "java_scanner.l"
{ RETURNTOK(EQ_OP); }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 857 "java_scanner.l"
{ RETURNTOK(NEQ_OP); }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 858 "java_scanner.l"
{ RETURNTOK(AND_OP); }
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 859 "java_scanner.l"
{ RETURNTOK(OR_OP); }
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 860 "java_scanner.l"
{ RETURNTOK(MUL_ASSIGN_OP); }
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 861 "java_scanner.l"
{ RETURNTOK(DIV_ASSIGN_OP); }
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 862 "java_scanner.l"
{ RETURNTOK(MOD_ASSIGN_OP); }
	YY_BREAK
case 17:
YY_RULE_SETUP
#line 863 "java_scanner.l"
{ RETURNTOK(ADD_ASSIGN_OP); }
	YY_BREAK
case 18:
YY_RULE_SETUP
#line 864 "java_scanner.l"
{ RETURNTOK(SUB_ASSIGN_OP); }
	YY_BREAK
case 19:
YY_RULE_SETUP
#line 865 "java_scanner.l"
{ RETURNTOK(SHL_ASSIGN_OP); }
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 866 "java_scanner.l"
{ RETURNTOK(SHR_ASSIGN_OP); }
	YY_BREAK
case 21:
YY_RULE_SETUP
#line 867 "java_scanner.l"
{ RETURNTOK(USHR_ASSIGN_OP); }
	YY_BREAK
case 22:
YY_RULE_SETUP
#line 868 "java_scanner.l"
{ RETURNTOK(AND_ASSIGN_OP); }
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 869 "java_scanner.l"
{ RETURNTOK(OR_ASSIGN_OP); }
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 870 "java_scanner.l"
{ RETURNTOK(XOR_ASSIGN_OP); }
	YY_BREAK
case 25:
YY_RULE_SETUP
#line 872 "java_scanner.l"
{ RETURNTOK(ABSTRACT); }
	YY_BREAK
case 26:
YY_RULE_SETUP
#line 873 "java_scanner.l"
{ RETURNTOK(PRIVATE); }
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 874 "java_scanner.l"
{ RETURNTOK(PUBLIC); }
	YY_BREAK
case 28:
YY_RULE_SETUP
#line 875 "java_scanner.l"
{ RETURNTOK(TRANSIENT); }
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 876 "java_scanner.l"
{ RETURNTOK(PROTECTED); }
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 877 "java_scanner.l"
{ RETURNTOK(FINAL); }
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 878 "java_scanner.l"
{ RETURNTOK(INTERFACE); }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 879 "java_scanner.l"
{ RETURNTOK(STATIC); }
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 880 "java_scanner.l"
{ RETURNTOK(SYNCHRONIZED); }
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 881 "java_scanner.l"
{ RETURNTOK(THROWS); }
	YY_BREAK
case 35:
YY_RULE_SETUP
#line 883 "java_scanner.l"
{ RETURNTOK(IMPLEMENTS); }
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 884 "java_scanner.l"
{ RETURNTOK(EXTENDS); }
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 886 "java_scanner.l"
{ RETURNTOK(IF); }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 887 "java_scanner.l"
{ RETURNTOK(ELSE); }
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 888 "java_scanner.l"
{ RETURNTOK(DO); }
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 889 "java_scanner.l"
{ RETURNTOK(WHILE); }
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 890 "java_scanner.l"
{ RETURNTOK(FOR); }
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 891 "java_scanner.l"
{ RETURNTOK(TRY); }
	YY_BREAK
case 43:
YY_RULE_SETUP
#line 892 "java_scanner.l"
{ RETURNTOK(CATCH); }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 893 "java_scanner.l"
{ RETURNTOK(THROW); }
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 894 "java_scanner.l"
{ RETURNTOK(FINALLY); }
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 895 "java_scanner.l"
{ RETURNTOK(SWITCH); }
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 896 "java_scanner.l"
{ RETURNTOK(CASE); }
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 897 "java_scanner.l"
{ RETURNTOK(DEFAULT); }
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 899 "java_scanner.l"
{ RETURNTOK(BREAK); }
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 900 "java_scanner.l"
{ RETURNTOK(CONTINUE); }
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 901 "java_scanner.l"
{ RETURNTOK(RETURN); }
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 902 "java_scanner.l"
{ RETURNTOK(GOTO); }
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 904 "java_scanner.l"
{ RETURNTOK(BYTE); }
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 905 "java_scanner.l"
{ RETURNTOK(BOOLEAN); }
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 906 "java_scanner.l"
{ RETURNTOK(CLASS); }
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 907 "java_scanner.l"
{ RETURNTOK(DOUBLE); }
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 908 "java_scanner.l"
{ RETURNTOK(INT); }
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 909 "java_scanner.l"
{ RETURNTOK(SHORT); }
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 910 "java_scanner.l"
{ RETURNTOK(VOID); }
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 911 "java_scanner.l"
{ RETURNTOK(CHAR); }
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 912 "java_scanner.l"
{ RETURNTOK(LONG); }
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 913 "java_scanner.l"
{ RETURNTOK(FLOAT); }
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 915 "java_scanner.l"
{ RETURNTOK(IMPORT); }
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 916 "java_scanner.l"
{ RETURNTOK(INSTANCEOF); }
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 917 "java_scanner.l"
{ RETURNTOK(STRICTFP); }
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 918 "java_scanner.l"
{ RETURNTOK(VOLATILE); }
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 919 "java_scanner.l"
{ RETURNTOK(NATIVE); }
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 920 "java_scanner.l"
{ RETURNTOK(SUPER); }
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 921 "java_scanner.l"
{ RETURNTOK(CONST); }
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 922 "java_scanner.l"
{ RETURNTOK(NEW); }
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 923 "java_scanner.l"
{ RETURNTOK(PACKAGE_KEY); }
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 924 "java_scanner.l"
{ RETURNTOK(THIS); }
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 926 "java_scanner.l"
{ RETURNTOK(TRUE); }
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 927 "java_scanner.l"
{ RETURNTOK(FALSE); }
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 928 "java_scanner.l"
{ RETURNTOK(NULL_LITERAL); }
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 930 "java_scanner.l"
{
				yylval.name = (ParseIdentifier(java_text)).string;
				RETURNTOK(IDENTIFIER);
		}
	YY_BREAK
case 77:
YY_RULE_SETUP
#line 935 "java_scanner.l"
{ RETURNTOK(ParseFloat(java_text)); }
	YY_BREAK
case 78:
YY_RULE_SETUP
#line 936 "java_scanner.l"
{ RETURNTOK(ParseFloat(java_text)); }
	YY_BREAK
case 79:
YY_RULE_SETUP
#line 937 "java_scanner.l"
{ RETURNTOK(ParseFloat(java_text)); }
	YY_BREAK
case 80:
YY_RULE_SETUP
#line 939 "java_scanner.l"
{ ParseInt(java_text); RETURNTOK(INTEGER_LITERAL); }
	YY_BREAK
case 81:
YY_RULE_SETUP
#line 940 "java_scanner.l"
{ ParseInt(java_text); RETURNTOK(INTEGER_LITERAL); }
	YY_BREAK
case 82:
/* rule 82 can match eol */
YY_RULE_SETUP
#line 942 "java_scanner.l"
{
			yylval.charValue = (ILUInt16)(ParseCharConstant(java_text));
		  	RETURNTOK(CHAR_LITERAL);
		}
	YY_BREAK
case 83:
/* rule 83 can match eol */
YY_RULE_SETUP
#line 947 "java_scanner.l"
{ yylval.string = ParseString(java_text + 1);
							  RETURNTOK(STRING_LITERAL); }
	YY_BREAK
case 84:
YY_RULE_SETUP
#line 949 "java_scanner.l"
;
	YY_BREAK
case 85:
YY_RULE_SETUP
#line 951 "java_scanner.l"
{ BEGIN(COMMENT); }
	YY_BREAK
case 86:
YY_RULE_SETUP
#line 952 "java_scanner.l"
{ BEGIN(INITIAL); }
	YY_BREAK
case 87:
YY_RULE_SETUP
#line 953 "java_scanner.l"
{ } /* comment - discard */ 
	YY_BREAK
case 88:
YY_RULE_SETUP
#line 954 "java_scanner.l"
{ } /* comment - discard */
	YY_BREAK
case 89:
/* rule 89 can match eol */
YY_RULE_SETUP
#line 955 "java_scanner.l"
{ } /* comment - discard */
	YY_BREAK
case 90:
/* rule 90 can match eol */
YY_RULE_SETUP
#line 957 "java_scanner.l"
;
	YY_BREAK
case 91:
YY_RULE_SETUP
#line 959 "java_scanner.l"
{ RETURNTOK(((int)(java_text[0])) & 0xFF); }
	YY_BREAK
case 92:
YY_RULE_SETUP
#line 961 "java_scanner.l"
ECHO;
	YY_BREAK
#line 2265 "java_scanner.c"
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(COMMENT):
	yyterminate();

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed java_in at a new source and called
			 * java_lex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = java_in;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

				if ( java_wrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * java_text, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of java_lex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					java_realloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			java_restart(java_in  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 342 )
				yy_c = yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 342 )
			yy_c = yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 341);

	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			/* This was really a NUL. */
			*(yy_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					java_restart(java_in );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( java_wrap( ) )
						return EOF;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	/* cast for 8-bit char's */
	*(yy_c_buf_p) = '\0';	/* preserve java_text */
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void java_restart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        java_ensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            java__create_buffer(java_in,YY_BUF_SIZE );
	}

	java__init_buffer(YY_CURRENT_BUFFER,input_file );
	java__load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void java__switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		java_pop_buffer_state();
	 *		java_push_buffer_state(new_buffer);
     */
	java_ensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	java__load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (java_wrap()) processing, but the only time this flag
	 * is looked at is after java_wrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void java__load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	java_in = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE java__create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) java_alloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in java__create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) java_alloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in java__create_buffer()" );

	b->yy_is_our_buffer = 1;

	java__init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with java__create_buffer()
 * 
 */
    void java__delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		java_free((void *) b->yy_ch_buf  );

	java_free((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a java_restart() or at EOF.
 */
    static void java__init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	java__flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then java__init_buffer was _probably_
     * called from java_restart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void java__flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		java__load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void java_push_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	java_ensure_buffer_stack();

	/* This block is copied from java__switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from java__switch_to_buffer. */
	java__load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void java_pop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	java__delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		java__load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void java_ensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)java_alloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)java_realloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE java__scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) java_alloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in java__scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	java__switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to java_lex() will
 * scan from a @e copy of @a str.
 * @param str a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       java__scan_bytes() instead.
 */
YY_BUFFER_STATE java__scan_string (yyconst char * yystr )
{
    
	return java__scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to java_lex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE java__scan_bytes  (yyconst char * yybytes, int  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) java_alloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in java__scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = java__scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in java__scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up java_text. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		java_text[java_leng] = (yy_hold_char); \
		(yy_c_buf_p) = java_text + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		java_leng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the input stream.
 * 
 */
FILE *java_get_in  (void)
{
        return java_in;
}

/** Get the output stream.
 * 
 */
FILE *java_get_out  (void)
{
        return java_out;
}

/** Get the length of the current token.
 * 
 */
int java_get_leng  (void)
{
        return java_leng;
}

/** Get the current token.
 * 
 */

char *java_get_text  (void)
{
        return java_text;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see java__switch_to_buffer
 */
void java_set_in (FILE *  in_str )
{
        java_in = in_str ;
}

void java_set_out (FILE *  out_str )
{
        java_out = out_str ;
}

int java_get_debug  (void)
{
        return java__flex_debug;
}

void java_set_debug (int  bdebug )
{
        java__flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from java_lex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    java_in = stdin;
    java_out = stdout;
#else
    java_in = (FILE *) 0;
    java_out = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * java_lex_init()
     */
    return 0;
}

/* java_lex_destroy is for both reentrant and non-reentrant scanners. */
int java_lex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		java__delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		java_pop_buffer_state();
	}

	/* Destroy the stack itself. */
	java_free((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * java_lex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *java_alloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *java_realloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void java_free (void * ptr )
{
	free( (char *) ptr );	/* see java_realloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

#line 961 "java_scanner.l"



