/* -*- buffer-read-only: t -*- vi: set ro:
   THIS FILE IS GENERATED AUTOMATICALLY.  PLEASE DO NOT EDIT.
*/

#line 1 "cmdline.opt"
/* This file is part of GNU Dico. -*- c -*-
   Copyright (C) 1998, 1999, 2000, 2008, 2010 Sergey Poznyakoff

   GNU Dico is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Dico is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Dico.  If not, see <http://www.gnu.org/licenses/>. */

#include <dico-priv.h>
#include <getopt.h>

#line 20 "cmdline.opt"

#line 20
void print_help(void);
#line 20
void print_usage(void);
#line 188 "cmdline.opt"

#line 188
/* Option codes */
#line 188
enum {
#line 188
	_OPTION_INIT=255,
#line 188
	#line 26 "cmdline.opt"

#line 26
	OPTION_HOST,
#line 46 "cmdline.opt"

#line 46
	OPTION_SOURCE,
#line 70 "cmdline.opt"

#line 70
	OPTION_LEVDIST,
#line 72 "cmdline.opt"

#line 72
	OPTION_LEVENSHTEIN_DISTANCE,
#line 125 "cmdline.opt"

#line 125
	OPTION_SASL,
#line 131 "cmdline.opt"

#line 131
	OPTION_NOSASL,
#line 145 "cmdline.opt"

#line 145
	OPTION_PASSWORD,
#line 150 "cmdline.opt"

#line 150
	OPTION_AUTOLOGIN,
#line 175 "cmdline.opt"

#line 175
	OPTION_TIME_STAMP,
#line 182 "cmdline.opt"

#line 182
	OPTION_SOURCE_INFO,
#line 188 "cmdline.opt"

#line 188
	OPTION_USAGE,
#line 188 "cmdline.opt"

#line 188
	OPTION_VERSION,

#line 188 "cmdline.opt"
	MAX_OPTION
#line 188
};
#line 188
static struct option long_options[] = {
#line 188
	#line 26 "cmdline.opt"

#line 26
	{ "host", required_argument, 0, OPTION_HOST },
#line 32 "cmdline.opt"

#line 32
	{ "port", required_argument, 0, 'p' },
#line 40 "cmdline.opt"

#line 40
	{ "database", required_argument, 0, 'd' },
#line 46 "cmdline.opt"

#line 46
	{ "source", required_argument, 0, OPTION_SOURCE },
#line 57 "cmdline.opt"

#line 57
	{ "match", no_argument, 0, 'm' },
#line 63 "cmdline.opt"

#line 63
	{ "strategy", required_argument, 0, 's' },
#line 70 "cmdline.opt"

#line 70
	{ "levdist", required_argument, 0, OPTION_LEVDIST },
#line 72 "cmdline.opt"

#line 72
	{ "levenshtein-distance", required_argument, 0, OPTION_LEVENSHTEIN_DISTANCE },
#line 80 "cmdline.opt"

#line 80
	{ "dbs", no_argument, 0, 'D' },
#line 86 "cmdline.opt"

#line 86
	{ "strategies", no_argument, 0, 'S' },
#line 92 "cmdline.opt"

#line 92
	{ "serverhelp", no_argument, 0, 'H' },
#line 98 "cmdline.opt"

#line 98
	{ "info", required_argument, 0, 'i' },
#line 105 "cmdline.opt"

#line 105
	{ "serverinfo", no_argument, 0, 'I' },
#line 111 "cmdline.opt"

#line 111
	{ "quiet", no_argument, 0, 'q' },
#line 119 "cmdline.opt"

#line 119
	{ "noauth", no_argument, 0, 'a' },
#line 125 "cmdline.opt"

#line 125
	{ "sasl", no_argument, 0, OPTION_SASL },
#line 131 "cmdline.opt"

#line 131
	{ "nosasl", no_argument, 0, OPTION_NOSASL },
#line 137 "cmdline.opt"

#line 137
	{ "user", required_argument, 0, 'u' },
#line 143 "cmdline.opt"

#line 143
	{ "key", required_argument, 0, 'k' },
#line 145 "cmdline.opt"

#line 145
	{ "password", required_argument, 0, OPTION_PASSWORD },
#line 150 "cmdline.opt"

#line 150
	{ "autologin", required_argument, 0, OPTION_AUTOLOGIN },
#line 156 "cmdline.opt"

#line 156
	{ "client", required_argument, 0, 'c' },
#line 163 "cmdline.opt"

#line 163
	{ "transcript", no_argument, 0, 't' },
#line 169 "cmdline.opt"

#line 169
	{ "verbose", no_argument, 0, 'v' },
#line 175 "cmdline.opt"

#line 175
	{ "time-stamp", no_argument, 0, OPTION_TIME_STAMP },
#line 182 "cmdline.opt"

#line 182
	{ "source-info", no_argument, 0, OPTION_SOURCE_INFO },
#line 188 "cmdline.opt"

#line 188
	{ "help", no_argument, 0, 'h' },
#line 188 "cmdline.opt"

#line 188
	{ "usage", no_argument, 0, OPTION_USAGE },
#line 188 "cmdline.opt"

#line 188
	{ "version", no_argument, 0, OPTION_VERSION },

#line 188 "cmdline.opt"
	{0, 0, 0, 0}
#line 188
};
#line 188
static struct opthelp {
#line 188
        const char *opt;
#line 188
        const char *arg;
#line 188
        int is_optional;
#line 188
        const char *descr;
#line 188
} opthelp[] = {
#line 188
	#line 24 "cmdline.opt"

#line 24
	{ NULL, NULL, 0, N_("Server selection") },
#line 28 "cmdline.opt"

#line 28
	{ "--host", N_("SERVER"), 0, N_("Connect to this server.") },
#line 34 "cmdline.opt"

#line 34
	{ "-p, --port", N_("SERVICE"), 0, N_("Specify port to connect to.") },
#line 42 "cmdline.opt"

#line 42
	{ "-d, --database", N_("NAME"), 0, N_("Select a database to search.") },
#line 48 "cmdline.opt"

#line 48
	{ "--source", N_("ADDR"), 0, N_("Set a source address for TCP connections.") },
#line 55 "cmdline.opt"

#line 55
	{ NULL, NULL, 0, N_("Operation modes") },
#line 59 "cmdline.opt"

#line 59
	{ "-m, --match", NULL, 0, N_("Match instead of define.") },
#line 65 "cmdline.opt"

#line 65
	{ "-s, --strategy", N_("NAME"), 0, N_("Select a strategy for matching.  Implies --match.") },
#line 73 "cmdline.opt"

#line 73
	{ "--levdist, --levenshtein-distance", N_("N"), 0, N_("Set maximum Levenshtein distance to N.") },
#line 82 "cmdline.opt"

#line 82
	{ "-D, --dbs", NULL, 0, N_("Show available databases.") },
#line 88 "cmdline.opt"

#line 88
	{ "-S, --strategies", NULL, 0, N_("Show available search strategies.") },
#line 94 "cmdline.opt"

#line 94
	{ "-H, --serverhelp", NULL, 0, N_("show server help.") },
#line 100 "cmdline.opt"

#line 100
	{ "-i, --info", N_("DBNAME"), 0, N_("Show information about database DBNAME.") },
#line 107 "cmdline.opt"

#line 107
	{ "-I, --serverinfo", NULL, 0, N_("Show information about the server.") },
#line 113 "cmdline.opt"

#line 113
	{ "-q, --quiet", NULL, 0, N_("Do not print the normal dico welcome.") },
#line 117 "cmdline.opt"

#line 117
	{ NULL, NULL, 0, N_("Authentication") },
#line 121 "cmdline.opt"

#line 121
	{ "-a, --noauth", NULL, 0, N_("Disable authentication.") },
#line 127 "cmdline.opt"

#line 127
	{ "--sasl", NULL, 0, N_("Enable SASL authentication (default).") },
#line 133 "cmdline.opt"

#line 133
	{ "--nosasl", NULL, 0, N_("Disable SASL authentication.") },
#line 139 "cmdline.opt"

#line 139
	{ "-u, --user", N_("NAME"), 0, N_("Set user name for authentication.") },
#line 146 "cmdline.opt"

#line 146
	{ "-k, --key, --password", N_("STRING"), 0, N_("Set shared secret for authentication.") },
#line 152 "cmdline.opt"

#line 152
	{ "--autologin", N_("NAME"), 0, N_("Set the name of autologin file to use.") },
#line 158 "cmdline.opt"

#line 158
	{ "-c, --client", N_("STRING"), 0, N_("Additional text for client command.") },
#line 162 "cmdline.opt"

#line 162
	{ NULL, NULL, 0, N_("Debugging") },
#line 165 "cmdline.opt"

#line 165
	{ "-t, --transcript", NULL, 0, N_("Enable session transcript.") },
#line 171 "cmdline.opt"

#line 171
	{ "-v, --verbose", NULL, 0, N_("Increase debugging verbosity level.") },
#line 177 "cmdline.opt"

#line 177
	{ "--time-stamp", NULL, 0, N_("Include time stamp in the debugging output.") },
#line 184 "cmdline.opt"

#line 184
	{ "--source-info", NULL, 0, N_("Include source line information in the debugging output.") },
#line 188 "cmdline.opt"

#line 188
	{ NULL, NULL, 0, N_("Other options") },
#line 188 "cmdline.opt"

#line 188
	{ "-h, --help", NULL, 0, N_("Give this help list") },
#line 188 "cmdline.opt"

#line 188
	{ "--usage", NULL, 0, N_("Give a short usage message") },
#line 188 "cmdline.opt"

#line 188
	{ "--version", NULL, 0, N_("Print program version") },

#line 188 "cmdline.opt"
};
#line 20 "cmdline.opt"

#line 20
const char *program_version = "dico" " (" PACKAGE_STRING ")";
#line 20
static char doc[] = N_("A DICT client.");
#line 20
static char args_doc[] = N_("[URL-or-WORD]");
#line 20
const char *program_bug_address = "<" PACKAGE_BUGREPORT ">";
#line 20
		    
#line 20
#define DESCRCOLUMN 30
#line 20
#define RMARGIN 79
#line 20
#define GROUPCOLUMN 2
#line 20
#define USAGECOLUMN 13
#line 20
		    
#line 20
static void
#line 20
indent (size_t start, size_t col)
#line 20
{
#line 20
  for (; start < col; start++)
#line 20
    putchar (' ');
#line 20
}
#line 20
		    
#line 20
static void
#line 20
print_option_descr (const char *descr, size_t lmargin, size_t rmargin)
#line 20
{
#line 20
  while (*descr)
#line 20
    {
#line 20
      size_t s = 0;
#line 20
      size_t i;
#line 20
      size_t width = rmargin - lmargin;
#line 20

#line 20
      for (i = 0; ; i++)
#line 20
	{
#line 20
	  if (descr[i] == 0 || isspace (descr[i]))
#line 20
	    {
#line 20
	      if (i > width)
#line 20
		break;
#line 20
	      s = i;
#line 20
	      if (descr[i] == 0)
#line 20
		break;
#line 20
	    }
#line 20
	}
#line 20
      printf ("%*.*s\n", s, s, descr);
#line 20
      descr += s;
#line 20
      if (*descr)
#line 20
	{
#line 20
	  indent (0, lmargin);
#line 20
	  descr++;
#line 20
	}
#line 20
    }
#line 20
}
#line 20

#line 20
void
#line 20
print_help(void)
#line 20
{
#line 20
  unsigned i;
#line 20
  
#line 20
  printf ("%s %s [%s]... %s\n", _("Usage:"), "dico", _("OPTION"),
#line 20
	  gettext (args_doc)); 
#line 20
  if (doc[0])
#line 20
    print_option_descr(gettext (doc), 0, RMARGIN);
#line 20
  putchar ('\n');
#line 20

#line 20
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 20
    {
#line 20
      unsigned n;
#line 20
      if (opthelp[i].opt)
#line 20
	{
#line 20
	  n = printf ("  %s", opthelp[i].opt);
#line 20
	  if (opthelp[i].arg)
#line 20
	    {
#line 20
	      char *cb, *ce;
#line 20
	      if (strlen (opthelp[i].opt) == 2)
#line 20
		{
#line 20
		  if (!opthelp[i].is_optional)
#line 20
		    {
#line 20
		      putchar (' ');
#line 20
		      n++;
#line 20
		    }
#line 20
		}
#line 20
	      else
#line 20
		{
#line 20
		  putchar ('=');
#line 20
		  n++;
#line 20
		}
#line 20
	      if (opthelp[i].is_optional)
#line 20
		{
#line 20
		  cb = "[";
#line 20
		  ce = "]";
#line 20
		}
#line 20
	      else
#line 20
		cb = ce = "";
#line 20
	      n += printf ("%s%s%s", cb, gettext (opthelp[i].arg), ce);
#line 20
	    }
#line 20
	  if (n >= DESCRCOLUMN)
#line 20
	    {
#line 20
	      putchar ('\n');
#line 20
	      n = 0;
#line 20
	    }
#line 20
	  indent (n, DESCRCOLUMN);
#line 20
	  print_option_descr (gettext (opthelp[i].descr), DESCRCOLUMN, RMARGIN);
#line 20
	}
#line 20
      else
#line 20
	{
#line 20
	  if (i)
#line 20
	    putchar ('\n');
#line 20
	  indent (0, GROUPCOLUMN);
#line 20
	  print_option_descr (gettext (opthelp[i].descr),
#line 20
			      GROUPCOLUMN, RMARGIN);
#line 20
	  putchar ('\n');
#line 20
	}
#line 20
    }
#line 20
  
#line 20
  putchar ('\n');
#line 20
  print_option_descr (_("Mandatory or optional arguments to long options are also mandatory or optional for any corresponding short options."), 0, RMARGIN);
#line 20
  putchar ('\n');
#line 20
  printf (_("Report bugs to %s.\n"), program_bug_address);
#line 20
}
#line 20

#line 20
void
#line 20
print_usage(void)
#line 20
{
#line 20
  unsigned i;
#line 20
  int f = 0;
#line 20
  unsigned n;
#line 20
  char buf[RMARGIN+1];
#line 20

#line 20
#define FLUSH                        do                                   {                              	  buf[n] = 0;              	  printf ("%s\n", buf);    	  n = USAGECOLUMN;         	  memset (buf, ' ', n);        }                                while (0)
#line 20
#define ADDC(c)   do { if (n == RMARGIN) FLUSH; buf[n++] = c; } while (0)
#line 20

#line 20
  n = snprintf (buf, sizeof buf, "%s %s ", _("Usage:"), "dico");
#line 20

#line 20
  /* Print a list of short options without arguments. */
#line 20
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 20
    {
#line 20
      if (opthelp[i].opt && opthelp[i].descr && opthelp[i].opt[1] != '-'
#line 20
	  && opthelp[i].arg == NULL)
#line 20
	{
#line 20
	  if (f == 0)
#line 20
	    {
#line 20
	      ADDC('[');
#line 20
	      ADDC('-');
#line 20
	      f = 1;
#line 20
	    }
#line 20
	  ADDC(opthelp[i].opt[1]);
#line 20
	}
#line 20
    }
#line 20
  if (f)
#line 20
    ADDC(']');
#line 20

#line 20
  /* Print a list of short options with arguments. */
#line 20
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 20
    {
#line 20
      if (opthelp[i].opt && opthelp[i].descr && opthelp[i].opt[1] != '-'
#line 20
	  && opthelp[i].arg)
#line 20
	{
#line 20
	  size_t len = 5 
#line 20
	                + strlen (opthelp[i].arg)
#line 20
			   + (opthelp[i].is_optional ? 2 : 1);
#line 20
	  if (n + len > RMARGIN) FLUSH;
#line 20
	  buf[n++] = ' '; 
#line 20
	  buf[n++] = '['; 
#line 20
	  buf[n++] = '-';
#line 20
	  buf[n++] = opthelp[i].opt[1];
#line 20
	  if (opthelp[i].is_optional)
#line 20
	    {
#line 20
	      buf[n++] = '[';
#line 20
	      strcpy (&buf[n], opthelp[i].arg);
#line 20
	      n += strlen (opthelp[i].arg);
#line 20
	      buf[n++] = ']';
#line 20
	    }
#line 20
	  else
#line 20
	    {
#line 20
	      buf[n++] = ' ';
#line 20
	      strcpy (&buf[n], opthelp[i].arg);
#line 20
	      n += strlen (opthelp[i].arg);
#line 20
	    }
#line 20
	  buf[n++] = ']';
#line 20
	}
#line 20
    }
#line 20

#line 20
  /* Print a list of long options */
#line 20
  for (i = 0; i < sizeof (opthelp) / sizeof (opthelp[0]); i++)
#line 20
    {
#line 20
      if (opthelp[i].opt && opthelp[i].descr)
#line 20
	{
#line 20
	  size_t len;
#line 20
	  const char *longopt;
#line 20

#line 20
	  if (opthelp[i].opt[1] == '-')
#line 20
	    longopt = opthelp[i].opt;
#line 20
	  else if (opthelp[i].opt[2] == ',')
#line 20
	    longopt = opthelp[i].opt + 4;
#line 20
	  else
#line 20
	    continue;
#line 20

#line 20
	  len = 3 + strlen (longopt)
#line 20
	          + (opthelp[i].arg ? 1 + strlen (opthelp[i].arg)
#line 20
		      + (opthelp[i].is_optional ? 2 : 0) : 0);
#line 20
	  if (n + len > RMARGIN) FLUSH;
#line 20
	  buf[n++] = ' '; 
#line 20
	  buf[n++] = '['; 
#line 20
	  strcpy (&buf[n], longopt);
#line 20
	  n += strlen (longopt);
#line 20
	  if (opthelp[i].arg)
#line 20
	    {
#line 20
	      buf[n++] = '=';
#line 20
	      if (opthelp[i].is_optional)
#line 20
		{
#line 20
		  buf[n++] = '[';
#line 20
		  strcpy (&buf[n], opthelp[i].arg);
#line 20
		  n += strlen (opthelp[i].arg);
#line 20
		  buf[n++] = ']';
#line 20
		}
#line 20
	      else
#line 20
		{
#line 20
		  strcpy (&buf[n], opthelp[i].arg);
#line 20
		  n += strlen (opthelp[i].arg);
#line 20
		}
#line 20
	    }
#line 20
	  buf[n++] = ']';
#line 20
	}
#line 20
    }
#line 20
  FLUSH;
#line 20
  
#line 20
}
#line 20

#line 20
const char version_etc_copyright[] =
#line 20
  /* Do *not* mark this string for translation.  %s is a copyright
     symbol suitable for this locale, and %d is the copyright
     year.  */
#line 20
  "Copyright %s 2005, 2006, 2007, 2008 Sergey Poznyakoff";
#line 20

#line 20
void
#line 20
print_version_only(const char *program_version, FILE *stream)
#line 20
{
#line 20
	fprintf (stream, "%s\n", program_version);
#line 20
	/* TRANSLATORS: Translate "(C)" to the copyright symbol
	   (C-in-a-circle), if this symbol is available in the user's
	   locale.  Otherwise, do not translate "(C)"; leave it as-is.  */
#line 20
	fprintf (stream, version_etc_copyright, _("(C)"));
#line 20
	fputc ('\n', stream);
#line 20
}
#line 20

#line 20
void
#line 20
print_version(const char *program_version, FILE *stream)
#line 20
{
#line 20
	print_version_only(program_version, stream);
#line 20
	
#line 20
	fputs (_("License GPLv3+: GNU GPL version 3 or later <http://gnu.org/licenses/gpl.html>\nThis is free software: you are free to change and redistribute it.\nThere is NO WARRANTY, to the extent permitted by law.\n\n"),
#line 20
	       stream);
#line 20
	
#line 20
}
#line 20

#line 188 "cmdline.opt"

#line 188


void
get_options (int argc, char *argv[], int *index)
{
    
#line 193
 {
#line 193
  int c;
#line 193

#line 193
  while ((c = getopt_long(argc, argv, "p:d:ms:DSHi:Iqau:k:c:tvh",
#line 193
                          long_options, NULL)) != EOF)
#line 193
    {
#line 193
      switch (c)
#line 193
        {
#line 193
        default:
#line 193
	   	   exit(1);
#line 193
	#line 28 "cmdline.opt"
	 case OPTION_HOST:
#line 28
          {
#line 28

  xdico_assign_string(&dico_url.host, optarg);

#line 30
             break;
#line 30
          }
#line 34 "cmdline.opt"
	 case 'p':
#line 34
          {
#line 34

  dico_url.port = str2port(optarg);
  if (dico_url.port == -1)
      dico_die(1, L_ERR, 0, _("Invalid port"));  

#line 38
             break;
#line 38
          }
#line 42 "cmdline.opt"
	 case 'd':
#line 42
          {
#line 42

  xdico_assign_string(&dico_url.req.database, optarg);  

#line 44
             break;
#line 44
          }
#line 48 "cmdline.opt"
	 case OPTION_SOURCE:
#line 48
          {
#line 48

  source_addr = get_ipaddr(optarg);
  if (source_addr == 0)
    dico_die(1, 0, L_ERR, _("%s: Invalid IP or unknown host name"),
             optarg);

#line 53
             break;
#line 53
          }
#line 59 "cmdline.opt"
	 case 'm':
#line 59
          {
#line 59

  mode = mode_match;   

#line 61
             break;
#line 61
          }
#line 65 "cmdline.opt"
	 case 's':
#line 65
          {
#line 65

  xdico_assign_string(&dico_url.req.strategy, optarg);
  mode = mode_match;

#line 68
             break;
#line 68
          }
#line 73 "cmdline.opt"
	 case OPTION_LEVDIST: case OPTION_LEVENSHTEIN_DISTANCE:
#line 73
          {
#line 73

  char *p;
  levenshtein_threshold = strtoul(optarg, &p, 10);
  if (*p)
      dico_die(1, L_ERR, 0, _("%s: invalid number"), optarg);

#line 78
             break;
#line 78
          }
#line 82 "cmdline.opt"
	 case 'D':
#line 82
          {
#line 82

  mode = mode_dbs;  

#line 84
             break;
#line 84
          }
#line 88 "cmdline.opt"
	 case 'S':
#line 88
          {
#line 88

  mode = mode_strats;

#line 90
             break;
#line 90
          }
#line 94 "cmdline.opt"
	 case 'H':
#line 94
          {
#line 94

  mode = mode_help;

#line 96
             break;
#line 96
          }
#line 100 "cmdline.opt"
	 case 'i':
#line 100
          {
#line 100

  mode = mode_info;
  dico_url.req.database = optarg;

#line 103
             break;
#line 103
          }
#line 107 "cmdline.opt"
	 case 'I':
#line 107
          {
#line 107

  mode = mode_server;

#line 109
             break;
#line 109
          }
#line 113 "cmdline.opt"
	 case 'q':
#line 113
          {
#line 113

  quiet_option = 1;

#line 115
             break;
#line 115
          }
#line 121 "cmdline.opt"
	 case 'a':
#line 121
          {
#line 121

  noauth_option = 1;

#line 123
             break;
#line 123
          }
#line 127 "cmdline.opt"
	 case OPTION_SASL:
#line 127
          {
#line 127

  sasl_enable(1);

#line 129
             break;
#line 129
          }
#line 133 "cmdline.opt"
	 case OPTION_NOSASL:
#line 133
          {
#line 133

  sasl_enable(0);

#line 135
             break;
#line 135
          }
#line 139 "cmdline.opt"
	 case 'u':
#line 139
          {
#line 139

  default_cred.user = optarg;

#line 141
             break;
#line 141
          }
#line 146 "cmdline.opt"
	 case 'k': case OPTION_PASSWORD:
#line 146
          {
#line 146

  default_cred.pass = optarg;

#line 148
             break;
#line 148
          }
#line 152 "cmdline.opt"
	 case OPTION_AUTOLOGIN:
#line 152
          {
#line 152

  autologin_file = optarg;

#line 154
             break;
#line 154
          }
#line 158 "cmdline.opt"
	 case 'c':
#line 158
          {
#line 158

  client = optarg;

#line 160
             break;
#line 160
          }
#line 165 "cmdline.opt"
	 case 't':
#line 165
          {
#line 165

  transcript = 1;

#line 167
             break;
#line 167
          }
#line 171 "cmdline.opt"
	 case 'v':
#line 171
          {
#line 171

  debug_level++;

#line 173
             break;
#line 173
          }
#line 177 "cmdline.opt"
	 case OPTION_TIME_STAMP:
#line 177
          {
#line 177

  int n = 1;
  dico_stream_ioctl(debug_stream, DICO_DBG_CTL_SET_TS, &n);

#line 180
             break;
#line 180
          }
#line 184 "cmdline.opt"
	 case OPTION_SOURCE_INFO:
#line 184
          {
#line 184

  debug_source_info = 1;

#line 186
             break;
#line 186
          }
#line 188 "cmdline.opt"
	 case 'h':
#line 188
          {
#line 188

#line 188
		print_help ();
#line 188
                exit (0);
#line 188
	 
#line 188
             break;
#line 188
          }
#line 188 "cmdline.opt"
	 case OPTION_USAGE:
#line 188
          {
#line 188

#line 188
		print_usage ();
#line 188
		exit (0);
#line 188
	 
#line 188
             break;
#line 188
          }
#line 188 "cmdline.opt"
	 case OPTION_VERSION:
#line 188
          {
#line 188

#line 188
		/* Give version */
#line 188
		print_version(program_version, stdout);
#line 188
		exit (0);
#line 188
         
#line 188
             break;
#line 188
          }

#line 193 "cmdline.opt"
        }
#line 193
    }
#line 193
  *index = optind;
#line 193
 }   
#line 193

}

