;;; -*- Mode: LISP; Syntax: Common-Lisp; Package: USER; Base: 10 -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;         The Garnet User Interface Development Environment.      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This code was written as part of the Garnet project at          ;;;
;;; Carnegie Mellon University, and has been placed in the public   ;;;
;;; domain.  If you are using this code or any part of Garnet,      ;;;
;;; please contact garnet@cs.cmu.edu to be put on the mailing list. ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;

#|
==================================================================
Change log:

   02/20/92 Andrew Mickish - Moved make-package call into Garnet-Loader
   02/18/92 Brad Myers - add gilt-gadget-utils
   03/11/91 Osamu Hashimoto - load only motif's stuff
   12/05/90 Brad Myers - created
==================================================================
|#

(in-package "USER" :use '("LISP"))

(format t "Loading Gilt...~%")

;; check first to see if place is set
(unless (boundp 'Garnet-Gilt-PathName)
  (error "Load 'Garnet-Loader' first to set Garnet-Gilt-PathName before loading this file."))

(dolist (gadget '(
		  "error-gadget-loader"
		  "motif-prop-sheet-win-loader"
		  "multi-selection-loader"
		  "motif-text-buttons-loader"
		  "motif-check-buttons-loader"
		  "motif-radio-buttons-loader"
		  "motif-v-scroll-loader"
		  "motif-h-scroll-loader"
		  "motif-slider-loader"
		  "motif-menu-loader"
		  "motif-gauge-loader"
		  "motif-scrolling-labeled-box-loader"
		  ))
  (load (merge-pathnames gadget
			 #+cmu "gadgets:"
			 #+(not cmu) user::Garnet-Gadgets-PathName)))

#+allegroV3.1
(gc t)

(defvar gilt-files '("gilt-string-edit"
		     "gilt-functions-loader" ; only load if not already loaded
		     "gilt-gadget-utils"
		     "motif-gilt-gadgets"
		     "gilt"
		     "line-imp"  "motif-line-props"
		     "fill-imp"  "motif-fill-props"
		     "align-imp"  "motif-align-props" 
		     "motif-gilt-save" 

		     "motif-gilt-read"
		     "gilt-font-imp"  "motif-gilt-font-props"
		     "color-imp"  "motif-color-props"
		     ))

(dolist (file gilt-files)
  (load (merge-pathnames file
			 #+cmu "gilt:"
			 #+(not cmu) user::Garnet-Gilt-PathName)
	:verbose T))


(format T "Type (gilt:do-go) to start~%")


