/* m88k-opcode.h -- Instruction information for the Motorola 88000
   Contributed by Devon Bowen of Buffalo University
   and Torbjorn Granlund of the Swedish Institute of Computer Science.
   Copyright (C) 1989, 1990, 1991 Free Software Foundation, Inc.

This file is part of GAS, the GNU Assembler.

GAS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GAS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GAS; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#if !defined(__STDC__) && !defined(const)
#define const
#endif

/*
  Character codes for op_spec field below.
  Reserved for self-matching: [ ] ,

  d = GRF Destination register (21:5)
  x = XRF register prefix.  Makes next d, 1, or 2, match an extended register.
  1 = Source register 1 (16:5)
  2 = Source register 2 (0:5)
  3 = Both source registers (same value) (0:5 and 16:5)
  I = IMM16 (0:16)
  b = bit field spec. (0:10)
  p = 16 bit pc displ. (0:16)
  P = 26 bit pc displ. (0:26)
  B = bb0/bb1 condition (21:5)
  M = bcnd condition (21:5)
  f = fcr (5:6)
  c = cr (5:6)
  V = VEC9 (0:9)
  o = O6 field of "prot" insn (10:7)
  ? = Give warning for this insn/operand combination
 */

/* instruction descriptor structure */

struct m88k_opcode
{
  unsigned int opcode;
  char *name;
  char *op_spec;
};

/* and introducing... the Motorola 88100 and 88110 instruction sets...  */

/* By default, include the 88110 instructions.  */
#define MC88110

#if defined (MC88110)
#define _MC88100(OPCODE,MNEM,OP_SPEC)
#define _MC88110(OPCODE,MNEM,OP_SPEC) {OPCODE,MNEM,OP_SPEC},
#else
#define _MC88100(OPCODE,MNEM,OP_SPEC) {OPCODE,MNEM,OP_SPEC},
#define _MC88110(OPCODE,MNEM,OP_SPEC)
#endif

#define _MC88xxx(OPCODE,MNEM,OP_SPEC) {OPCODE,MNEM,OP_SPEC},

/* Equal mnemonics must be adjacent.
   More specific operand specification must go before more general.
   For example, "d,1,2" must go before "d,1,I" as a register for s2
   would otherwise be considered a variable name.  */

static struct m88k_opcode m88k_opcodes[] =
{
  /*	   Opcode	Mnemonic	Opspec */

  _MC88xxx (0xf4007000, "add",		"d,1,2")
  _MC88xxx (0x70000000, "add",		"d,1,I")
  _MC88xxx (0xf4007200, "add.ci",	"d,1,2")
  _MC88xxx (0xf4007300, "add.cio",	"d,1,2")
  _MC88xxx (0xf4007100, "add.co",	"d,1,2")
  _MC88xxx (0xf4006000, "addu",		"d,1,2")
  _MC88xxx (0x60000000, "addu",		"d,1,I")
  _MC88xxx (0xf4006200, "addu.ci",	"d,1,2")
  _MC88xxx (0xf4006300, "addu.cio",	"d,1,2")
  _MC88xxx (0xf4006100, "addu.co",	"d,1,2")
  _MC88xxx (0xf4004000, "and",		"d,1,2")
  _MC88xxx (0x40000000, "and",		"d,1,I")
  _MC88xxx (0xf4004400, "and.c",	"d,1,2")
  _MC88xxx (0x44000000, "and.u",	"d,1,I")
  _MC88xxx (0xd0000000, "bb0",		"B,1,p")
  _MC88xxx (0xd4000000, "bb0.n",	"B,1,p")
  _MC88xxx (0xd8000000, "bb1",		"B,1,p")
  _MC88xxx (0xdc000000, "bb1.n",	"B,1,p")
  _MC88xxx (0xe8000000, "bcnd",		"M,1,p")
  _MC88xxx (0xec000000, "bcnd.n",	"M,1,p")
  _MC88xxx (0xc0000000, "br",		"P")
  _MC88xxx (0xc4000000, "br.n",		"P")
  _MC88xxx (0xc8000000, "bsr",		"P")
  _MC88xxx (0xcc000000, "bsr.n",	"P")
  _MC88xxx (0xf4008000, "clr",		"d,1,2")
  _MC88xxx (0xf0008000, "clr",		"d,1,b")
  _MC88xxx (0xf4007c00, "cmp",		"d,1,2")
  _MC88xxx (0x7c000000, "cmp",		"d,1,I")
  _MC88xxx (0xf4007800, "div",		"d,1,2")
  _MC88xxx (0x78000000, "div",		"d,1,I")
  _MC88xxx (0xf4007800, "divs",		"d,1,2")
  _MC88xxx (0x78000000, "divs",		"d,1,I")
  _MC88110 (0xf4006900, "divu.d",	"d,1,2")
  _MC88xxx (0xf4006800, "divu",		"d,1,2")
  _MC88xxx (0x68000000, "divu",		"d,1,I")
  _MC88xxx (0xf4009000, "ext",		"d,1,2")
  _MC88xxx (0xf0009000, "ext",		"d,1,b")
  _MC88xxx (0xf4009800, "extu",		"d,1,2")
  _MC88xxx (0xf0009800, "extu",		"d,1,b")
  _MC88xxx (0x84002800, "fadd.sss",	"d,1,2")
  _MC88110 (0x8400a800, "fadd.sss",	"xd,x1,x2")
  _MC88xxx (0x84002880, "fadd.ssd",	"d,1,2")
  _MC88110 (0x8400a820, "fadd.ssd",	"xd,x1,x2")
  _MC88110 (0x8400a840, "fadd.ssx",	"xd,x1,x2")
  _MC88xxx (0x84002a00, "fadd.sds",	"d,1,2")
  _MC88110 (0x8400a880, "fadd.sds",	"xd,x1,x2")
  _MC88xxx (0x84002a80, "fadd.sdd",	"d,1,2")
  _MC88110 (0x8400a8a0, "fadd.sdd",	"xd,x1,x2")
  _MC88110 (0x8400a8c0, "fadd.sdx",	"xd,x1,x2")
  _MC88110 (0x8400a900, "fadd.sxs",	"xd,x1,x2")
  _MC88110 (0x8400a920, "fadd.sxd",	"xd,x1,x2")
  _MC88110 (0x8400a940, "fadd.sxx",	"xd,x1,x2")
  _MC88xxx (0x84002820, "fadd.dss",	"d,1,2")
  _MC88110 (0x8400aa00, "fadd.dss",	"xd,x1,x2")
  _MC88xxx (0x840028a0, "fadd.dsd",	"d,1,2")
  _MC88110 (0x8400aa20, "fadd.dsd",	"xd,x1,x2")
  _MC88110 (0x8400aa40, "fadd.dsx",	"xd,x1,x2")
  _MC88xxx (0x84002a20, "fadd.dds",	"d,1,2")
  _MC88110 (0x8400aa80, "fadd.dds",	"xd,x1,x2")
  _MC88xxx (0x84002aa0, "fadd.ddd",	"d,1,2")
  _MC88110 (0x8400aaa0, "fadd.ddd",	"xd,x1,x2")
  _MC88110 (0x8400aac0, "fadd.ddx",	"xd,x1,x2")
  _MC88110 (0x8400ab00, "fadd.dxs",	"xd,x1,x2")
  _MC88110 (0x8400ab20, "fadd.dxd",	"xd,x1,x2")
  _MC88110 (0x8400ab40, "fadd.dxx",	"xd,x1,x2")
  _MC88110 (0x8400ac00, "fadd.xss",	"xd,x1,x2")
  _MC88110 (0x8400ac20, "fadd.xsd",	"xd,x1,x2")
  _MC88110 (0x8400ac40, "fadd.xsx",	"xd,x1,x2")
  _MC88110 (0x8400ac80, "fadd.xds",	"xd,x1,x2")
  _MC88110 (0x8400aca0, "fadd.xdd",	"xd,x1,x2")
  _MC88110 (0x8400acc0, "fadd.xdx",	"xd,x1,x2")
  _MC88110 (0x8400ad00, "fadd.xxs",	"xd,x1,x2")
  _MC88110 (0x8400ad20, "fadd.xxd",	"xd,x1,x2")
  _MC88110 (0x8400ad40, "fadd.xxx",	"xd,x1,x2")
  _MC88xxx (0x84003a80, "fcmp.sdd",	"d,1,2")
  _MC88110 (0x8400ba80, "fcmp.sdd",	"d,x1,x2")
  _MC88xxx (0x84003a00, "fcmp.sds",	"d,1,2")
  _MC88110 (0x8400ba00, "fcmp.sds",	"d,x1,x2")
  _MC88110 (0x8400bb00, "fcmp.sdx",	"d,x1,x2")
  _MC88xxx (0x84003880, "fcmp.ssd",	"d,1,2")
  _MC88110 (0x8400b880, "fcmp.ssd",	"d,x1,x2")
  _MC88xxx (0x84003800, "fcmp.sss",	"d,1,2")
  _MC88110 (0x8400b800, "fcmp.sss",	"d,x1,x2")
  _MC88110 (0x8400b900, "fcmp.ssx",	"d,x1,x2")
  _MC88110 (0x8400bc80, "fcmp.sxd",	"d,x1,x2")
  _MC88110 (0x8400bc00, "fcmp.sxs",	"d,x1,x2")
  _MC88110 (0x8400bd00, "fcmp.sxx",	"d,x1,x2")
  _MC88110 (0x84003aa0, "fcmpu.sdd",	"d,1,2")
  _MC88110 (0x8400baa0, "fcmpu.sdd",	"d,x1,x2")
  _MC88110 (0x84003a20, "fcmpu.sds",	"d,1,2")
  _MC88110 (0x8400ba20, "fcmpu.sds",	"d,x1,x2")
  _MC88110 (0x8400bb20, "fcmpu.sdx",	"d,x1,x2")
  _MC88110 (0x840038a0, "fcmpu.ssd",	"d,1,2")
  _MC88110 (0x8400b8a0, "fcmpu.ssd",	"d,x1,x2")
  _MC88110 (0x84003820, "fcmpu.sss",	"d,1,2")
  _MC88110 (0x8400b820, "fcmpu.sss",	"d,x1,x2")
  _MC88110 (0x8400b920, "fcmpu.ssx",	"d,x1,x2")
  _MC88110 (0x8400bca0, "fcmpu.sxd",	"d,x1,x2")
  _MC88110 (0x8400bc20, "fcmpu.sxs",	"d,x1,x2")
  _MC88110 (0x8400bd20, "fcmpu.sxx",	"d,x1,x2")
  _MC88110 (0x84000880, "fcvt.ds",	"d,2")
  _MC88110 (0x84008880, "fcvt.ds",	"xd,x2")
  _MC88110 (0x840088c0, "fcvt.dx",	"xd,x2")
  _MC88110 (0x84000820, "fcvt.sd",	"d,2")
  _MC88110 (0x84008820, "fcvt.sd",	"xd,x2")
  _MC88110 (0x84008840, "fcvt.sx",	"xd,x2")
  _MC88110 (0x84008920, "fcvt.xd",	"xd,x2")
  _MC88110 (0x84008900, "fcvt.xs",	"xd,x2")
  _MC88xxx (0x84007000, "fdiv.sss",	"d,1,2")
  _MC88110 (0x8400f000, "fdiv.sss",	"xd,x1,x2")
  _MC88xxx (0x84007080, "fdiv.ssd",	"d,1,2")
  _MC88110 (0x8400f020, "fdiv.ssd",	"xd,x1,x2")
  _MC88110 (0x8400f040, "fdiv.ssx",	"xd,x1,x2")
  _MC88xxx (0x84007200, "fdiv.sds",	"d,1,2")
  _MC88110 (0x8400f080, "fdiv.sds",	"xd,x1,x2")
  _MC88xxx (0x84007280, "fdiv.sdd",	"d,1,2")
  _MC88110 (0x8400f0a0, "fdiv.sdd",	"xd,x1,x2")
  _MC88110 (0x8400f0c0, "fdiv.sdx",	"xd,x1,x2")
  _MC88110 (0x8400f100, "fdiv.sxs",	"xd,x1,x2")
  _MC88110 (0x8400f120, "fdiv.sxd",	"xd,x1,x2")
  _MC88110 (0x8400f140, "fdiv.sxx",	"xd,x1,x2")
  _MC88xxx (0x84007020, "fdiv.dss",	"d,1,2")
  _MC88110 (0x8400f200, "fdiv.dss",	"xd,x1,x2")
  _MC88xxx (0x840070a0, "fdiv.dsd",	"d,1,2")
  _MC88110 (0x8400f220, "fdiv.dsd",	"xd,x1,x2")
  _MC88110 (0x8400f240, "fdiv.dsx",	"xd,x1,x2")
  _MC88xxx (0x84007220, "fdiv.dds",	"d,1,2")
  _MC88110 (0x8400f280, "fdiv.dds",	"xd,x1,x2")
  _MC88xxx (0x840072a0, "fdiv.ddd",	"d,1,2")
  _MC88110 (0x8400f2a0, "fdiv.ddd",	"xd,x1,x2")
  _MC88110 (0x8400f2c0, "fdiv.ddx",	"xd,x1,x2")
  _MC88110 (0x8400f300, "fdiv.dxs",	"xd,x1,x2")
  _MC88110 (0x8400f320, "fdiv.dxd",	"xd,x1,x2")
  _MC88110 (0x8400f340, "fdiv.dxx",	"xd,x1,x2")
  _MC88110 (0x8400f400, "fdiv.xss",	"xd,x1,x2")
  _MC88110 (0x8400f420, "fdiv.xsd",	"xd,x1,x2")
  _MC88110 (0x8400f440, "fdiv.xsx",	"xd,x1,x2")
  _MC88110 (0x8400f480, "fdiv.xds",	"xd,x1,x2")
  _MC88110 (0x8400f4a0, "fdiv.xdd",	"xd,x1,x2")
  _MC88110 (0x8400f4c0, "fdiv.xdx",	"xd,x1,x2")
  _MC88110 (0x8400f500, "fdiv.xxs",	"xd,x1,x2")
  _MC88110 (0x8400f520, "fdiv.xxd",	"xd,x1,x2")
  _MC88110 (0x8400f540, "fdiv.xxx",	"xd,x1,x2")
  _MC88xxx (0xf400ec00, "ff0",		"d,2")
  _MC88xxx (0xf400e800, "ff1",		"d,2")
  _MC88xxx (0x80004800, "fldcr",	"d,f")
  _MC88xxx (0x84002020, "flt.ds",	"d,2")
  _MC88110 (0x84002220, "flt.ds",	"xd,2")
  _MC88xxx (0x84002000, "flt.ss",	"d,2")
  _MC88110 (0x84002200, "flt.ss",	"xd,2")
  _MC88110 (0x84002240, "flt.xs",	"xd,2")
  _MC88xxx (0x84000000, "fmul.sss",	"d,1,2")
  _MC88110 (0x84008000, "fmul.sss",	"xd,x1,x2")
  _MC88xxx (0x84000080, "fmul.ssd",	"d,1,2")
  _MC88110 (0x84008020, "fmul.ssd",	"xd,x1,x2")
  _MC88110 (0x84008040, "fmul.ssx",	"xd,x1,x2")
  _MC88xxx (0x84000200, "fmul.sds",	"d,1,2")
  _MC88110 (0x84008080, "fmul.sds",	"xd,x1,x2")
  _MC88xxx (0x84000280, "fmul.sdd",	"d,1,2")
  _MC88110 (0x840080a0, "fmul.sdd",	"xd,x1,x2")
  _MC88110 (0x840080c0, "fmul.sdx",	"xd,x1,x2")
  _MC88110 (0x84008100, "fmul.sxs",	"xd,x1,x2")
  _MC88110 (0x84008120, "fmul.sxd",	"xd,x1,x2")
  _MC88110 (0x84008140, "fmul.sxx",	"xd,x1,x2")
  _MC88xxx (0x84000020, "fmul.dss",	"d,1,2")
  _MC88110 (0x84008200, "fmul.dss",	"xd,x1,x2")
  _MC88xxx (0x840000a0, "fmul.dsd",	"d,1,2")
  _MC88110 (0x84008220, "fmul.dsd",	"xd,x1,x2")
  _MC88110 (0x84008240, "fmul.dsx",	"xd,x1,x2")
  _MC88xxx (0x84000220, "fmul.dds",	"d,1,2")
  _MC88110 (0x84008280, "fmul.dds",	"xd,x1,x2")
  _MC88xxx (0x840002a0, "fmul.ddd",	"d,1,2")
  _MC88110 (0x840082a0, "fmul.ddd",	"xd,x1,x2")
  _MC88110 (0x840082c0, "fmul.ddx",	"xd,x1,x2")
  _MC88110 (0x84008300, "fmul.dxs",	"xd,x1,x2")
  _MC88110 (0x84008320, "fmul.dxd",	"xd,x1,x2")
  _MC88110 (0x84008340, "fmul.dxx",	"xd,x1,x2")
  _MC88110 (0x84008400, "fmul.xss",	"xd,x1,x2")
  _MC88110 (0x84008420, "fmul.xsd",	"xd,x1,x2")
  _MC88110 (0x84008440, "fmul.xsx",	"xd,x1,x2")
  _MC88110 (0x84008480, "fmul.xds",	"xd,x1,x2")
  _MC88110 (0x840084a0, "fmul.xdd",	"xd,x1,x2")
  _MC88110 (0x840084c0, "fmul.xdx",	"xd,x1,x2")
  _MC88110 (0x84008500, "fmul.xxs",	"xd,x1,x2")
  _MC88110 (0x84008520, "fmul.xxd",	"xd,x1,x2")
  _MC88110 (0x84008540, "fmul.xxx",	"xd,x1,x2")
  _MC88110 (0x840078a0, "fsqrt.dd",	"d,2")
  _MC88110 (0x8400f8a0, "fsqrt.dd",	"xd,x2")
  _MC88110 (0x84007880, "fsqrt.ds",	"d,2")
  _MC88110 (0x8400f880, "fsqrt.ds",	"xd,x2")
  _MC88110 (0x8400f8c0, "fsqrt.dx",	"xd,x2")
  _MC88110 (0x84007820, "fsqrt.sd",	"d,2")
  _MC88110 (0x8400f820, "fsqrt.sd",	"xd,x2")
  _MC88110 (0x84007800, "fsqrt.ss",	"d,2")
  _MC88110 (0x8400f800, "fsqrt.ss",	"xd,x2")
  _MC88110 (0x8400f840, "fsqrt.sx",	"xd,x2")
  _MC88110 (0x8400f920, "fsqrt.xd",	"xd,x2")
  _MC88110 (0x8400f900, "fsqrt.xs",	"xd,x2")
  _MC88110 (0x8400f940, "fsqrt.xx",	"xd,x2")
  _MC88xxx (0x80008800, "fstcr",	"3,f")
  _MC88xxx (0x84003000, "fsub.sss",	"d,1,2")
  _MC88110 (0x8400b000, "fsub.sss",	"xd,x1,x2")
  _MC88xxx (0x84003080, "fsub.ssd",	"d,1,2")
  _MC88110 (0x8400b020, "fsub.ssd",	"xd,x1,x2")
  _MC88110 (0x8400b040, "fsub.ssx",	"xd,x1,x2")
  _MC88xxx (0x84003200, "fsub.sds",	"d,1,2")
  _MC88110 (0x8400b080, "fsub.sds",	"xd,x1,x2")
  _MC88xxx (0x84003280, "fsub.sdd",	"d,1,2")
  _MC88110 (0x8400b0a0, "fsub.sdd",	"xd,x1,x2")
  _MC88110 (0x8400b0c0, "fsub.sdx",	"xd,x1,x2")
  _MC88110 (0x8400b100, "fsub.sxs",	"xd,x1,x2")
  _MC88110 (0x8400b120, "fsub.sxd",	"xd,x1,x2")
  _MC88110 (0x8400b140, "fsub.sxx",	"xd,x1,x2")
  _MC88xxx (0x84003020, "fsub.dss",	"d,1,2")
  _MC88110 (0x8400b200, "fsub.dss",	"xd,x1,x2")
  _MC88xxx (0x840030a0, "fsub.dsd",	"d,1,2")
  _MC88110 (0x8400b220, "fsub.dsd",	"xd,x1,x2")
  _MC88110 (0x8400b240, "fsub.dsx",	"xd,x1,x2")
  _MC88xxx (0x84003220, "fsub.dds",	"d,1,2")
  _MC88110 (0x8400b280, "fsub.dds",	"xd,x1,x2")
  _MC88xxx (0x840032a0, "fsub.ddd",	"d,1,2")
  _MC88110 (0x8400b2a0, "fsub.ddd",	"xd,x1,x2")
  _MC88110 (0x8400b2c0, "fsub.ddx",	"xd,x1,x2")
  _MC88110 (0x8400b300, "fsub.dxs",	"xd,x1,x2")
  _MC88110 (0x8400b320, "fsub.dxd",	"xd,x1,x2")
  _MC88110 (0x8400b340, "fsub.dxx",	"xd,x1,x2")
  _MC88110 (0x8400b400, "fsub.xss",	"xd,x1,x2")
  _MC88110 (0x8400b420, "fsub.xsd",	"xd,x1,x2")
  _MC88110 (0x8400b440, "fsub.xsx",	"xd,x1,x2")
  _MC88110 (0x8400b480, "fsub.xds",	"xd,x1,x2")
  _MC88110 (0x8400b4a0, "fsub.xdd",	"xd,x1,x2")
  _MC88110 (0x8400b4c0, "fsub.xdx",	"xd,x1,x2")
  _MC88110 (0x8400b500, "fsub.xxs",	"xd,x1,x2")
  _MC88110 (0x8400b520, "fsub.xxd",	"xd,x1,x2")
  _MC88110 (0x8400b540, "fsub.xxx",	"xd,x1,x2")
  _MC88xxx (0x8000c800, "fxcr",		"d,3,f")
  _MC88xxx (0x8400fc01, "illop1",	"")
  _MC88xxx (0x8400fc02, "illop2",	"")
  _MC88xxx (0x8400fc03, "illop3",	"")
  _MC88xxx (0x84004880, "int.sd",	"d,2")
  _MC88110 (0x8400c880, "int.sd",	"d,x2")
  _MC88xxx (0x84004800, "int.ss",	"d,2")
  _MC88110 (0x8400c800, "int.ss",	"d,x2")
  _MC88110 (0x8400c900, "int.sx",	"d,x2")
  _MC88xxx (0xf400c000, "jmp",		"2")
  _MC88xxx (0xf400c400, "jmp.n",	"2")
  _MC88xxx (0xf400c800, "jsr",		"2")
  _MC88xxx (0xf400cc00, "jsr.n",	"2")
  _MC88xxx (0xf4001400, "ld",		"d,1,2")
  _MC88xxx (0xf4001600, "ld",		"d,1[2]")
  _MC88xxx (0x14000000, "ld",		"d,1,I")
  _MC88110 (0xf0001600, "ld",		"xd,1[2]")
  _MC88110 (0xf0001400, "ld",		"xd,1,2")
  _MC88110 (0x04000000, "ld",		"xd,1,I")
  _MC88xxx (0xf4001e00, "ld.b",		"d,1[2]")
  _MC88xxx (0xf4001c00, "ld.b",		"d,1,2")
  _MC88xxx (0x1c000000, "ld.b",		"d,1,I")
  _MC88xxx (0xf4001d00, "ld.b.usr",	"d,1,2")
  _MC88xxx (0xf4001f00, "ld.b.usr",	"d,1[2]")
  _MC88xxx (0xf4000e00, "ld.bu",	"d,1[2]")
  _MC88xxx (0xf4000c00, "ld.bu",	"d,1,2")
  _MC88xxx (0x0c000000, "ld.bu",	"d,1,I")
  _MC88xxx (0xf4000d00, "ld.bu.usr",	"d,1,2")
  _MC88xxx (0xf4000f00, "ld.bu.usr",	"d,1[2]")
  _MC88xxx (0xf4001200, "ld.d",		"d,1[2]")
  _MC88xxx (0xf4001000, "ld.d",		"d,1,2")
  _MC88xxx (0x10000000, "ld.d",		"d,1,I")
  _MC88110 (0xf0001200, "ld.d",		"xd,1[2]")
  _MC88110 (0xf0001000, "ld.d",		"xd,1,2")
  _MC88110 (0x00000000, "ld.d",		"xd,1,I")
  _MC88xxx (0xf4001100, "ld.d.usr",	"d,1,2")
  _MC88xxx (0xf4001300, "ld.d.usr",	"d,1[2]")
  _MC88110 (0xf0001100, "ld.d.usr",	"xd,1,2")
  _MC88110 (0xf0001300, "ld.d.usr",	"xd,1[2]")
  _MC88xxx (0xf4001a00, "ld.h",		"d,1[2]")
  _MC88xxx (0xf4001800, "ld.h",		"d,1,2")
  _MC88xxx (0x18000000, "ld.h",		"d,1,I")
  _MC88xxx (0xf4001900, "ld.h.usr",	"d,1,2")
  _MC88xxx (0xf4001b00, "ld.h.usr",	"d,1[2]")
  _MC88xxx (0xf4000a00, "ld.hu",	"d,1[2]")
  _MC88xxx (0xf4000800, "ld.hu",	"d,1,2")
  _MC88xxx (0x08000000, "ld.hu",	"d,1,I")
  _MC88xxx (0xf4000900, "ld.hu.usr",	"d,1,2")
  _MC88xxx (0xf4000b00, "ld.hu.usr",	"d,1[2]")
  _MC88xxx (0xf4001500, "ld.usr",	"d,1,2")
  _MC88xxx (0xf4001700, "ld.usr",	"d,1[2]")
  _MC88110 (0xf0001500, "ld.usr",	"xd,1,2")
  _MC88110 (0xf0001700, "ld.usr",	"xd,1[2]")
  _MC88110 (0xf0001a00, "ld.x",		"xd,1[2]")
  _MC88110 (0xf0001800, "ld.x",		"xd,1,2")
  _MC88110 (0x3c000000, "ld.x",		"xd,1,I")
  _MC88110 (0xf0001900, "ld.x.usr",	"xd,1,2")
  _MC88110 (0xf0001b00, "ld.x.usr",	"xd,1[2]")
  _MC88xxx (0xf4003600, "lda",		"d,1[2]")
  _MC88xxx (0xf4006000, "lda",		"?d,1,2")	/* Output addu */
  _MC88xxx (0x60000000, "lda",		"?d,1,I")	/* Output addu */
  _MC88xxx (0xf4006000, "lda.b",	"?d,1[2]")	/* Output addu */
  _MC88xxx (0xf4006000, "lda.b",	"?d,1,2")	/* Output addu */
  _MC88xxx (0x60000000, "lda.b",	"?d,1,I")	/* Output addu */
  _MC88xxx (0xf4003200, "lda.d",	"d,1[2]")
  _MC88xxx (0xf4006000, "lda.d",	"?d,1,2")	/* Output addu */
  _MC88xxx (0x60000000, "lda.d",	"?d,1,I")	/* Output addu */
  _MC88110 (0xf4003e00, "lda.x",	"d,1[2]")
  _MC88xxx (0xf4003a00, "lda.h",	"d,1[2]")
  _MC88xxx (0xf4006000, "lda.h",	"?d,1,2")	/* Output addu */
  _MC88xxx (0x60000000, "lda.h",	"?d,1,I")	/* Output addu */
  _MC88xxx (0x80004000, "ldcr",		"d,c")
  _MC88xxx (0xf400a000, "mak",		"d,1,2")
  _MC88xxx (0xf000a000, "mak",		"d,1,b")
  _MC88xxx (0x48000000, "mask",		"d,1,I")
  _MC88xxx (0x4c000000, "mask.u",	"d,1,I")
  _MC88110 (0x8400c000, "mov.s",	"d,x2")
  _MC88110 (0x84004200, "mov.s",	"xd,2")
  _MC88110 (0x8400c080, "mov.d",	"d,x2")
  _MC88110 (0x84004280, "mov.d",	"xd,2")
  _MC88110 (0x8400c300, "mov",		"xd,x2")
  _MC88xxx (0xf4006c00, "mul",		"d,1,2")
  _MC88xxx (0x6c000000, "mul",		"d,1,I")
  _MC88xxx (0xf4006e00, "muls",		"d,1,2")
  _MC88xxx (0x6c000000, "muls",		"d,1,I")
  _MC88xxx (0xf4006c00, "mulu",		"d,1,2")	/* synonym for mul */
  _MC88xxx (0x6c000000, "mulu",		"d,1,I")	/* synonym for mul */
  _MC88110 (0xf4006d00, "mulu.d",	"d,1,2")
  _MC88xxx (0x84005080, "nint.sd",	"d,2")
  _MC88110 (0x8400d080, "nint.sd",	"d,x2")
  _MC88xxx (0x84005000, "nint.ss",	"d,2")
  _MC88110 (0x8400d000, "nint.ss",	"d,x2")
  _MC88110 (0x8400d100, "nint.sx",	"d,x2")
  _MC88xxx (0xf4005800, "or",		"d,1,2")
  _MC88xxx (0x58000000, "or",		"d,1,I")
  _MC88xxx (0xf4005c00, "or.c",		"d,1,2")
  _MC88xxx (0x5c000000, "or.u",		"d,1,I")
  _MC88110 (0x88002020, "padd.b",	"d,1,2")
  _MC88110 (0x88002040, "padd.h",	"d,1,2")
  _MC88110 (0x88002060, "padd",		"d,1,2")
  _MC88110 (0x880020a0, "padds.u.b",	"d,1,2")
  _MC88110 (0x880020c0, "padds.u.h",	"d,1,2")
  _MC88110 (0x880020e0, "padds.u",	"d,1,2")
  _MC88110 (0x88002120, "padds.us.b",	"d,1,2")
  _MC88110 (0x88002140, "padds.us.h",	"d,1,2")
  _MC88110 (0x88002160, "padds.us",	"d,1,2")
  _MC88110 (0x880021a0, "padds.s.b",	"d,1,2")
  _MC88110 (0x880021c0, "padds.s.h",	"d,1,2")
  _MC88110 (0x880021e0, "padds.s",	"d,1,2")
  _MC88110 (0x88003860, "pcmp",		"d,1,2")
  _MC88110 (0x88000000, "pmul",		"d,1,2")
  _MC88110 (0x88006420, "ppack.32.b",	"d,1,2")
  _MC88110 (0x88006240, "ppack.16.h",	"d,1,2")
  _MC88110 (0x88006440, "ppack.32.h",	"d,1,2")
  _MC88110 (0x88006160, "ppack.8",	"d,1,2")
  _MC88110 (0x88006260, "ppack.16",	"d,1,2")
  _MC88110 (0x88006460, "ppack.32",	"d,1,2")
  _MC88110 (0x88007800, "prot",		"d,1,2")
  _MC88110 (0x88007000, "prot",		"d,1,o")
  _MC88110 (0x88003020, "psub.b",	"d,1,2")
  _MC88110 (0x88003040, "psub.h",	"d,1,2")
  _MC88110 (0x88003060, "psub",		"d,1,2")
  _MC88110 (0x880030a0, "psubs.u.b",	"d,1,2")
  _MC88110 (0x880030c0, "psubs.u.h",	"d,1,2")
  _MC88110 (0x880030e0, "psubs.u",	"d,1,2")
  _MC88110 (0x88003120, "psubs.us.b",	"d,1,2")
  _MC88110 (0x88003140, "psubs.us.h",	"d,1,2")
  _MC88110 (0x88003160, "psubs.us",	"d,1,2")
  _MC88110 (0x880031a0, "psubs.s.b",	"d,1,2")
  _MC88110 (0x880031c0, "psubs.s.h",	"d,1,2")
  _MC88110 (0x880031e0, "psubs.s",	"d,1,2")
  _MC88110 (0x88006800, "punpk.n",	"d,1")
  _MC88110 (0x88006820, "punpk.b",	"d,1")
  _MC88110 (0x88006840, "punpk.h",	"d,1")
  _MC88xxx (0xf400a800, "rot",		"d,1,2")
  _MC88xxx (0xf000a800, "rot",		"d,1,b")
  _MC88xxx (0xf400fc00, "rte",		"")
  _MC88xxx (0xf4008800, "set",		"d,1,2")
  _MC88xxx (0xf0008800, "set",		"d,1,b")
  _MC88xxx (0xf4002600, "st",		"d,1[2]")
  _MC88xxx (0xf4002400, "st",		"d,1,2")
  _MC88xxx (0x24000000, "st",		"d,1,I")
  _MC88110 (0xf0002600, "st",		"xd,1[2]")
  _MC88110 (0xf0002400, "st",		"xd,1,2")
  _MC88110 (0x34000000, "st",		"xd,1,I")
  _MC88xxx (0xf4002e00, "st.b",		"d,1[2]")
  _MC88xxx (0xf4002c00, "st.b",		"d,1,2")
  _MC88xxx (0x2c000000, "st.b",		"d,1,I")
  _MC88xxx (0xf4002d00, "st.b.usr",	"d,1,2")
  _MC88xxx (0xf4002f00, "st.b.usr",	"d,1[2]")
  _MC88110 (0xf4002d80, "st.b.usr.wt",	"d,1,2")
  _MC88110 (0xf4002f80, "st.b.usr.wt",	"d,1[2]")
  _MC88110 (0xf4002c80, "st.b.wt",	"d,1,2")
  _MC88110 (0xf4002e80, "st.b.wt",	"d,1[2]")
  _MC88xxx (0xf4002200, "st.d",		"d,1[2]")
  _MC88xxx (0xf4002000, "st.d",		"d,1,2")
  _MC88xxx (0x20000000, "st.d",		"d,1,I")
  _MC88110 (0xf0002200, "st.d",		"xd,1[2]")
  _MC88110 (0xf0002000, "st.d",		"xd,1,2")
  _MC88110 (0x30000000, "st.d",		"xd,1,I")
  _MC88xxx (0xf4002100, "st.d.usr",	"d,1,2")
  _MC88xxx (0xf4002300, "st.d.usr",	"d,1[2]")
  _MC88110 (0xf0002100, "st.d.usr",	"xd,1,2")
  _MC88110 (0xf0002300, "st.d.usr",	"xd,1[2]")
  _MC88110 (0xf4002180, "st.d.usr.wt",	"d,1,2")
  _MC88110 (0xf4002380, "st.d.usr.wt",	"d,1[2]")
  _MC88110 (0xf0002180, "st.d.usr.wt",	"xd,1,2")
  _MC88110 (0xf0002380, "st.d.usr.wt",	"xd,1[2]")
  _MC88110 (0xf4002080, "st.d.wt",	"d,1,2")
  _MC88110 (0xf4002280, "st.d.wt",	"d,1[2]")
  _MC88110 (0xf0002080, "st.d.wt",	"xd,1,2")
  _MC88110 (0xf0002280, "st.d.wt",	"xd,1[2]")
  _MC88xxx (0xf4002a00, "st.h",		"d,1[2]")
  _MC88xxx (0xf4002800, "st.h",		"d,1,2")
  _MC88xxx (0x28000000, "st.h",		"d,1,I")
  _MC88xxx (0xf4002900, "st.h.usr",	"d,1,2")
  _MC88xxx (0xf4002b00, "st.h.usr",	"d,1[2]")
  _MC88110 (0xf4002980, "st.h.usr.wt",	"d,1,2")
  _MC88110 (0xf4002b80, "st.h.usr.wt",	"d,1[2]")
  _MC88110 (0xf4002880, "st.h.wt",	"d,1,2")
  _MC88110 (0xf4002a80, "st.h.wt",	"d,1[2]")
  _MC88xxx (0xf4002500, "st.usr",	"d,1,2")
  _MC88xxx (0xf4002700, "st.usr",	"d,1[2]")
  _MC88110 (0xf0002500, "st.usr",	"xd,1,2")
  _MC88110 (0xf0002700, "st.usr",	"xd,1[2]")
  _MC88110 (0xf4002580, "st.usr.wt",	"d,1,2")
  _MC88110 (0xf4002780, "st.usr.wt",	"d,1[2]")
  _MC88110 (0xf0002580, "st.usr.wt",	"xd,1,2")
  _MC88110 (0xf0002780, "st.usr.wt",	"xd,1[2]")
  _MC88110 (0xf4002480, "st.wt",	"d,1,2")
  _MC88110 (0xf4002680, "st.wt",	"d,1[2]")
  _MC88110 (0xf0002480, "st.wt",	"xd,1,2")
  _MC88110 (0xf0002680, "st.wt",	"xd,1[2]")
  _MC88110 (0xf0002a00, "st.x",		"xd,1[2]")
  _MC88110 (0xf0002800, "st.x",		"xd,1,2")
  _MC88110 (0x38000000, "st.x",		"xd,1,I")
  _MC88110 (0xf0002900, "st.x.usr",	"xd,1,2")
  _MC88110 (0xf0002b00, "st.x.usr",	"xd,1[2]")
  _MC88110 (0xf0002980, "st.x.usr.wt",	"xd,1,2")
  _MC88110 (0xf0002b80, "st.x.usr.wt",	"xd,1[2]")
  _MC88110 (0xf0002880, "st.x.wt",	"xd,1,2")
  _MC88110 (0xf0002a80, "st.x.wt",	"xd,1[2]")
  _MC88xxx (0x80008000, "stcr",		"3,c")
  _MC88xxx (0xf4007400, "sub",		"d,1,2")
  _MC88xxx (0x74000000, "sub",		"d,1,I")
  _MC88xxx (0xf4007600, "sub.ci",	"d,1,2")
  _MC88xxx (0xf4007700, "sub.cio",	"d,1,2")
  _MC88xxx (0xf4007500, "sub.co",	"d,1,2")
  _MC88xxx (0xf4006400, "subu",		"d,1,2")
  _MC88xxx (0x64000000, "subu",		"d,1,I")
  _MC88xxx (0xf4006600, "subu.ci",	"d,1,2")
  _MC88xxx (0xf4006700, "subu.cio",	"d,1,2")
  _MC88xxx (0xf4006500, "subu.co",	"d,1,2")
  _MC88xxx (0xf000d000, "tb0",		"B,1,V")
  _MC88xxx (0xf000d800, "tb1",		"B,1,V")
  _MC88xxx (0xf400f800, "tbnd",		"1,2")
  _MC88xxx (0xf8000000, "tbnd",		"1,I")
  _MC88xxx (0xf000e800, "tcnd",		"M,1,V")
  _MC88xxx (0x84005880, "trnc.sd",	"d,2")
  _MC88110 (0x8400d880, "trnc.sd",	"d,x2")
  _MC88xxx (0x84005800, "trnc.ss",	"d,2")
  _MC88110 (0x8400d800, "trnc.ss",	"d,x2")
  _MC88110 (0x8400d900, "trnc.sx",	"d,x2")
  _MC88xxx (0x8000c000, "xcr",		"d,3,c")
  _MC88xxx (0xf4000600, "xmem",		"d,1[2]")
  _MC88xxx (0xf4000400, "xmem",		"d,1,2")
  _MC88100 (0x04000000, "xmem",		"?d,1,I")
  _MC88xxx (0xf4000200, "xmem.bu",	"d,1[2]")
  _MC88xxx (0xf4000000, "xmem.bu",	"d,1,2")
  _MC88100 (0x00000000, "xmem.bu",	"?d,1,I")
  _MC88xxx (0xf4000300, "xmem.bu.usr",	"d,1[2]")
  _MC88xxx (0xf4000100, "xmem.bu.usr",	"d,1,2")
  _MC88100 (0x00000100, "xmem.bu.usr",	"?d,1,I")
  _MC88xxx (0xf4000700, "xmem.usr",	"d,1[2]")
  _MC88xxx (0xf4000500, "xmem.usr",	"d,1,2")
  _MC88100 (0x04000100, "xmem.usr",	"?d,1,I")
  _MC88xxx (0xf4005000, "xor",		"d,1,2")
  _MC88xxx (0x50000000, "xor",		"d,1,I")
  _MC88xxx (0xf4005400, "xor.c",	"d,1,2")
  _MC88xxx (0x54000000, "xor.u",	"d,1,I")
  _MC88xxx (0x00000000, "",		0)
};

#define NUMOPCODES ((sizeof m88k_opcodes)/(sizeof m88k_opcodes[0]))
