dnl Copyright (C) 1999-2001 Open Source Telecom Corporation.
dnl  
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2 of the License, or
dnl (at your option) any later version.
dnl 
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl 
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software 
dnl Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
dnl 
dnl As a special exception to the GNU General Public License, if you 
dnl distribute this file as part of a program that contains a configuration 
dnl script generated by Autoconf, you may include it under the same 
dnl distribution terms that you use for the rest of that program.

AC_DEFUN(OST_NOSTREAMS,[
	STREAM_LIBS=
	STREAM_FLAGS=
	ost_cv_unix_streams=false
	AC_SUBST(STREAM_LIBS)
	AC_SUBST(STREAM_FLAGS)
])

AC_DEFUN(OST_STREAMS,[
	STREAM_LIBS=
	STREAM_FLAGS=
	ost_cv_unix_streams=false
	AC_CHECK_HEADERS(stropts.h,[
		ost_cv_unix_streams=true,
		AC_DEFINE(HAVE_STROPTS_H)])
	if test -z "$LIS_HOME" ; then
		LiSdir=/usr/src/LiS
	else
		LiSdir="$LIS_HOME"
	fi
	if test -d $prefix/$target ; then
		LiSdir=$prefix/$target/src/LiS
	elif test -f $prefix/src/LiS ; then
		LiSdir=$prefix/src/LiS
	fi
	STREAM_PREFIX=""
	AC_MSG_CHECKING([for LiS streams ($LiSdir)])
	if test -d $LiSdir ; then
		STREAM_PREFIX=$LiSdir
		AC_MSG_RESULT(found)
		ost_cv_unix_streams=true
		AC_DEFINE(HAVE_SYS_STROPTS_H)
		STREAM_FLAGS="-I$LiSdir/include $CXXFLAGS"
		if test -f $LiSdir/libc/libLiSuser.* ; then
			STREAM_LIBS="-L$LiSdir/libc -lLiSuser"
		else
			STREAM_LIBS="-L$LiSdir/libc -lLiS"
		fi
	
		AC_ARG_WITH(streamlink,  [--without-streamlink    Disable stream linking],
        		STREAM_LIBS="")
	else
		AC_MSG_RESULT(missing)
	fi
	AC_SUBST(STREAM_PREFIX)
	AC_SUBST(STREAM_LIBS)
	AC_SUBST(STREAM_FLAGS)
])

dnl ACCONFIG TEMPLATE
dnl #undef HAVE_STROPTS_H
dnl #undef HAVE_SYS_STROPTS_H
dnl END ACCONFIG

dnl ACCONFIG BOTTOM
dnl #ifdef HAVE_SYS_STROPTS_H
dnl #include <sys/stropts.h>
dnl #else
dnl #ifdef HAVE_STROPTS_H
dnl #include <stropts.h>
dnl #endif
dnl #endif
dnl END ACCONFIG

