
/*
 *  $Id: defReduce.c,v 1.13 2002/01/24 05:06:41 bkorb Exp $
 *  Parse Reduction processing routines
 */

/*
 *  AutoGen copyright 1992-2002 Bruce Korb
 *
 *  AutoGen is free software.
 *  You may redistribute it and/or modify it under the terms of the
 *  GNU General Public License, as published by the Free Software
 *  Foundation; either version 2, or (at your option) any later version.
 *
 *  AutoGen is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with AutoGen.  See the file "COPYING".  If not,
 *  write to:  The Free Software Foundation, Inc.,
 *             59 Temple Place - Suite 330,
 *             Boston,  MA  02111-1307, USA.
 */

typedef struct {
    int     entryCt;
    int     allocCt;
    char*   entries[1];
} tList;

#include "autogen.h"

STATIC tDefEntry* pFreeEntryList = NULL;
STATIC void*      pAllocList     = NULL;

#define ENTRY_ALLOC_CT     (4092 / sizeof(tDefEntry))
#define ENTRY_ALLOC_SIZE   ((ENTRY_ALLOC_CT * sizeof( tDefEntry )) + 4)

STATIC tDefEntry* getEntry( void );


#ifdef MEMDEBUG
    void
unloadDefs( void )
{
    /*
     *  Free up the definitions data
     */
    for (;;) {
        tScanCtx* p = pDoneCtx->pCtx;
        AGFREE( (void*)pDoneCtx );
        pDoneCtx = p;
        if (p == NULL)
            break;
    }

    for (;;) {
        void* p = *(void**)pAllocList;
        AGFREE( pAllocList );
        if (p == NULL)
            break;
        pAllocList = p;
    }
}
#endif

STATIC tDefEntry*
getEntry( void )
{
    tDefEntry*  pRes = pFreeEntryList;

    if (pRes != NULL) {
        pFreeEntryList = pRes->pNext;

    } else {
        int   ct = ENTRY_ALLOC_CT-1;
        void* p  = AGALOC( ENTRY_ALLOC_SIZE, "definition headers" );

        *((void**)p) = pAllocList;
        pAllocList   = p;
        pRes = pFreeEntryList = (tDefEntry*)((void**)p + 1);

        /*
         *  This is a post-loop test loop.  It will cycle one fewer times
         *  than there are 'tDefEntry' structs in the memory we just alloced.
         */
        do  {
            tDefEntry* pNxt = pRes+1;
            pRes->pNext = pNxt;

            /*
             *  When the loop ends, "pRes" will point to the last allocated
             *  structure instance.  That is the one we will return.
             */
            pRes = pNxt;
        } while (--ct > 0);

        /*
         *  Unlink the last entry from the chain.  The next time this
         *  routine is called, the *FIRST* structure in this list will
         *  be returned.
         */
        pRes[-1].pNext = NULL;
    }

    memset( (void*)pRes, 0, sizeof( *pRes ));
    return pRes;
}


/*
 *  Parsing happens in reverse order.  Therefore, when a new sibling
 *  happens along, it is always an elder (earlier-occurring) sibling.
 *  Now that we allow lists, this new sibling may already have a twin list.
 */
EXPORT YYSTYPE
addSibMacro(
        YYSTYPE  def,
        YYSTYPE  list )
{
    tDefEntry*  pDef  = (tDefEntry*)def;
    tDefEntry*  pScn  = (tDefEntry*)list;
    tDefEntry** ppT   = (tDefEntry**)&list;

    for (;;) {
        if (strcmp( pDef->pzDefName, pScn->pzDefName ) == 0) {
            /*
             *  Make sure that two entries with the same name
             *  are of the same type.
             */
            if (pDef->valType != pScn->valType) {
                char* pz = asprintf( "macro named ``%s'' has two types",
                                     pDef->pzDefName );
                AG_ABEND( pz );
            }

            /*
             *  Link in the new head of the twin chain to the sibling list.
             *  If the twin list is the first sibling, then ppT points
             *  to the "list" variable.  It will now be changed to return
             *  the value we need to return (the new head).
             */
            pDef->pNext = pScn->pNext;
            pScn->pNext = NULL;
            *ppT = pDef;

            /*
             *  Find the end of the twin list for the new eldest twin.
             *  Do this by setting a pointer to the place where we have
             *  to stash the pointer to the list.  (We are not saving it.)
             */
            for (ppT  = &(pDef->pTwin);
                 *ppT != NULL;
                 ppT  = &((*ppT)->pTwin) )
                ;

            *ppT = pScn;
            break;
        }

        /*
         *  IF we are at the end of the list,
         *  THEN put the new entry at the start of the list
         */
        if (pScn->pNext == NULL) {

            pDef->pNext = (tDefEntry*)list;
            list = def;
            break;
        }

        /*
         *  Check the next sibling for a twin value.
         *  If it is a twin, we will have to remember where
         *  we got the pointer so we can set a new value.
         */
        ppT  = &(pScn->pNext);
        pScn = pScn->pNext;
    }

    return list;
}


/*
 *  This function is called in two situations:
 *  1.  When we are doing the final reduction of all the definitions
 *  2.  When we are reducing a definition without a value (empty string)
 */
EXPORT YYSTYPE
makeMacro(
        YYSTYPE    place,
        YYSTYPE    val,
        teValType  type )
{
    ((tDefEntry*)place)->pzValue = (char*)val;
    ((tDefEntry*)place)->valType = type;
    return place;
}


/*
 *  This routine produces one or more definitions for a particular
 *  value name.  The first entry is actually the last value of the
 *  list, so we have to pass them to "addSibMacro" in reverse order.
 */
EXPORT YYSTYPE
makeMacroList(
        YYSTYPE    place,
        YYSTYPE    list,
        teValType  type )
{
    tDefEntry* pListDE  = (tDefEntry*)place;
    tDefEntry* pNewDE   = pListDE;
    YYSTYPE    twinName = (YYSTYPE)pListDE->pzDefName;
    tList*     pL  = (tList*)list;
    int        ct  = pL->entryCt;

    /*
     *  Put the first listed value (found last in the list)
     *  into the definition entry's value pointer.
     */
    pListDE->pzValue = pL->entries[ --ct ];
    pListDE->valType = type;

    /*
     *  There are several entries in the list.  Convert the list to
     *  a sibling list in the same order.
     */
    while (ct-- > 0) {
        pNewDE->pTwin =
            (tDefEntry*)findPlace( twinName, NULL );
        pNewDE = pNewDE->pTwin;
        pNewDE->pzValue = pL->entries[ ct ];
        pNewDE->valType = type;
    }

    AGFREE( (void*)pL );
    return (YYSTYPE)pListDE;
}


/*
 *  This routine produces the first entry in a value list.
 */
EXPORT YYSTYPE
startList( YYSTYPE entry )
{
    tList* pList = (tList*)AGALOC( sizeof( tList ), "value list" );
    pList->entryCt = pList->allocCt = 1;
    pList->entries[0] = (char*)entry;
    return (YYSTYPE)pList;
}


EXPORT YYSTYPE
appendList(
        YYSTYPE entry,
        YYSTYPE list )
{
    tList*  pList = (tList*)list;
    if (pList->entryCt++ >= pList->allocCt) {
        size_t sz;
        pList->allocCt += 12;
        sz = sizeof( tList ) + (sizeof( char* ) * pList->allocCt);
        pList = (tList*)AGREALOC( (void*)pList, sz, "token list" );
    }

    pList->entries[ pList->entryCt-1 ] = (char*)entry;
    return (YYSTYPE)pList;
}


EXPORT YYSTYPE
findPlace(
        YYSTYPE name,
        YYSTYPE index )
{
    tDefEntry*  pE = getEntry();
    const char* pz = (char*)index;

    pE->pzDefName  = (char*)name;

    if (pz == NULL)
        pE->index = NO_INDEX;

    else if (isdigit( *pz ) || (*pz == '-'))
        pE->index = strtol( pz, NULL, 0 );

    else {
        pz = getDefine( (char*)pz );
        if (pz != NULL)
             pE->index = strtol( pz, NULL, 0 );
        else pE->index = NO_INDEX;
    }
    strtransform( pE->pzDefName, pE->pzDefName );
    pE->valType = VALTYP_UNKNOWN;

    return (YYSTYPE)pE;
}


EXPORT YYSTYPE
identify( YYSTYPE template )
{
    /*
     *  Allow this routine to be called multiple times.
     *  This may happen if we #include another definition file.
     */
    if (pzTemplFileName == NULL) {

        if (HAVE_OPT(OVERRIDE_TPL))
             pzTemplFileName = OPT_ARG(OVERRIDE_TPL);
        else pzTemplFileName = (char*)template;
    }

    return (YYSTYPE)0;
}
/*
 * Local Variables:
 * c-file-style: "stroustrup"
 * indent-tabs-mode: nil
 * End:
 * end of defReduce.c */
