;;; babel.el --- AUCTeX style for `babel.sty'

;; Copyright (C) 2005 Free Software Foundation, Inc.

;; Author: Ralf Angeli <angeli@iwi.uni-sb.de>
;; Maintainer: auctex-devel@gnu.org
;; Created: 2005-05-29
;; Keywords: tex

;; This file is part of AUCTeX.

;; AUCTeX is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; AUCTeX is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with AUCTeX; see the file COPYING.  If not, write to the Free
;; Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
;; 02111-1307, USA.

;;; Commentary:

;; This file adds support for `babel.sty'.

;;; Code:

(defvar LaTeX-babel-language-list
  '("acadian" "afrikaans" "american" "austrian""bahasa" "basque" "brazil"
    "brazilian" "breton" "british" "bulgarian" "canadian" "canadien"
    "catalan" "croatian" "czech" "danish" "dutch" "english" "esperanto"
    "estonian" "finnish" "francais" "frenchb" "french" "galician"
    "german" "germanb" "greek" "polutonikogreek" "hebrew" "hungarian"
    "icelandic" "irish" "italian" "latin" "lowersorbian" "magyar"
    "naustrian" "ngerman" "norsk" "samin" "nynorsk" "polish" "portuges"
    "portuguese" "romanian" "russian" "scottish" "serbian" "slovak"
    "slovene" "spanish" "swedish" "turkish" "ukrainian" "uppersorbian"
    "welsh" "UKenglish" "USenglish")
  "List of languages supported by the babel LaTeX package.")

(defun LaTeX-babel-active-languages ()
  "Return a list of languages used in the document."
  (let (active-languages)
    (dolist (elt LaTeX-babel-language-list)
      (when (member elt TeX-active-styles)
	(add-to-list 'active-languages (list elt))))
    active-languages))

(defun TeX-arg-babel-lang (optional &optional prompt)
  "Prompt for a language with completion and insert it as an argument."
  (TeX-argument-insert
   (completing-read "Language: " (LaTeX-babel-active-languages)) nil))

(defun LaTeX-env-babel-lang (env)
  "Prompt for a language and insert it as an argument of ENV."
  (LaTeX-insert-environment
   env (format "{%s}" (completing-read "Language: "
				       (LaTeX-babel-active-languages)))))

(TeX-add-style-hook
 "babel"
 (lambda ()
   ;; New symbols
   (TeX-add-symbols
    '("selectlanguage" TeX-arg-babel-lang)
    '("foreignlanguage" TeX-arg-babel-lang t)
    "languagename"
    '("iflanguage" TeX-arg-babel-lang t nil)
    '("useshorthands" t)
    '("defineshorthand" t nil)
    '("aliasshorthand" t nil)
    '("languageshorthands" TeX-arg-babel-lang)
    '("shorthandon" t)
    '("shorthandoff" t)
    '("languageattribute" TeX-arg-babel-lang t))
   ;; New environments
   (LaTeX-add-environments
    '("otherlanguage" LaTeX-env-babel-lang)
    '("otherlanguage*" LaTeX-env-babel-lang)
    '("hyphenrules" LaTeX-env-babel-lang))
   ;; Fontification
   (when (and (featurep 'font-latex)
	      (eq TeX-install-font-lock 'font-latex-setup))
     (mapcar (lambda (keyword)
	       (add-to-list 'font-latex-match-function-keywords-local keyword))
	     '("selectlanguage"
	       ;; "foreignlanguage" ; Enable once we support proper
	       ;; "iflanguage"      ; highlighting of multiple arguments.
	       "languagename"
	       "useshorthands"
	       "languageshorthands"
	       "shorthandon"
	       "shorthandoff"))
     (font-latex-match-function-make)
     (add-to-list 'font-latex-match-variable-keywords-local "defineshorthand")
     (add-to-list 'font-latex-match-variable-keywords-local "aliasshorthand")
     (add-to-list 'font-latex-match-variable-keywords-local "languageattribute")
     (font-latex-match-variable-make)
     ;; Tell font-lock about the update.
     (setq font-lock-set-defaults nil)
     (font-lock-set-defaults))))

;;; babel.el ends here
