/* drift.h -- This file is part of Archimedes release 0.0.2.
   Archimedes is a simulator for Submicron 2D Silicon/GaAs
   Devices. It implements the Monte Carlo method
   for the simulation of the semiclassical Boltzmann equation for both
   electrons and holes. It also includes the quantum effects by means 
   of effective potential method.

   Copyright (C) 2004, 2005, 2006, 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
   USA.  */


// ######################################################
// Created on 06 sep.2004, Siracusa, J.M.Sellier
// Last modif. : 13 Jan.2005, Siracusa, J.M.Sellier
// ######################################################

// calculation of drift process

void
drift(real tau)
{
 int i,j;
 real dkx,dky,hmt,ksquared,gk,thesquareroot;

 if(IV==9) return;

 i=(int)(X/dx)+1;
 j=(int)(Y/dy)+1;
 if(i>=nx) i=nx;
 if(j>=ny) j=ny;

// Valid for every material
 dkx=-QH*E[i][j][0]*tau;
 dky=-QH*E[i][j][1]*tau;

 if(Material==SILICON){
// Electron drift process
   hmt=HM[0]*tau;
   ksquared=KX*KX+KY*KY+KZ*KZ;
   gk=HHM[0]*ksquared;
   thesquareroot=sqrt(1.+4.*alphaSILICON*gk);
// Second order Runge-Kutta method
   X+=hmt*(KX+0.5*dkx)/thesquareroot;
   Y+=hmt*(KY+0.5*dky)/thesquareroot;
   KX+=dkx;
   KY+=dky;
 }
 if(Material==GAAS){
// Electron drift process
   hmt=HM[IV]*tau;
   ksquared=KX*KX+KY*KY+KZ*KZ;
   gk=HHM[IV]*ksquared;
   thesquareroot=sqrt(1.+4.*AF[IV]*gk);
// Second order Runge-Kutta method
   X+=hmt*(KX+0.5*dkx)/thesquareroot;
   Y+=hmt*(KY+0.5*dky)/thesquareroot;
   KX+=dkx;
   KY+=dky;
 }
// check if some particles are out of the device
 i=(int)(X/dx)+1;
 j=(int)(Y/dy)+1;
 if(i>=nx) i=nx;
 if(j>=ny) j=ny;

// Generic boundary conditions for the super-particles
// ===================================================

// left edge
// =========
// ---Insulator---
 if(X<=0. && EDGE[3][j][0]==0){
  X=-X;
  KX=-KX;
  return;
 }
// ---Schottky or ohmic contact---
 else if(X<=0. && (EDGE[3][j][0]==1 || EDGE[3][j][0]==2)){
   IV=9;
   return;
 }
// right edge
// ==========
// ---Insulator---
 if(X>=LX && EDGE[1][j][0]==0){
  X=LX-(X-LX);
  KX=-KX;
  return;
 }
// ---Schottky or ohmic contact---
 else if(X>=LX && (EDGE[1][j][0]==1 || EDGE[1][j][0]==2)){
   IV=9;
   return;
 }
// bottom edge
// ===========
// ---Insulator---
 if(Y<=0. && EDGE[0][i][0]==0){
  Y=-Y;
  KY=-KY;
  return;
 }
// ---Schottky or ohmic contact---
 else if(Y<=0. && (EDGE[0][i][0]==1 || EDGE[0][i][0]==2)){
   IV=9;
   return;
 }
// upper edge
// ==========
// ---Insulator---
 if(Y>=LY && EDGE[2][i][0]==0){
  Y=LY-(Y-LY);
  KY=-KY;
  return;
 }
// ---Schottky or ohmic contact---
 else if(Y>=LY && (EDGE[2][i][0]==1 || EDGE[2][i][0]==2)){
   IV=9;
   return;
 }
}

// ============================================================
