/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
                                          <aeneas@southnovel.eu>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 11 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 16 september 2007, Siracusa, Jean Michel Sellier

// save the position of all particles

void save_particles_mesh_format(int num)
{
 int i,n;
 FILE *fp;
 char s[200];

 sprintf(s,"particles/position_mesh_format/particles_pos%d.mesh",num);
 if(num<100) sprintf(s,"particles/position_mesh_format/particles_pos0%d.mesh",num); 
 if(num<10)  sprintf(s,"particles/position_mesh_format/particles_pos00%d.mesh",num);

 printf("Saving the %d particle positions in mesh format... num = %d\n",INUM,num);

 fp=fopen(s,"w"); 
 if(fp==NULL){
    printf("save_particles_mesh_format : impossible to open the output file!\n");
    exit(0);
 }
 fprintf(fp,"MeshVersionFormatted 1\n");
 fprintf(fp,"Dimension\n 3\n");
 fprintf(fp,"Vertices\n");
 fprintf(fp,"%d\n",INUM);

// printf("INUM = %d\n",INUM);
 
 for(n=1;n<=INUM;n++){
//        printf("n = %d\n",n);
   double x,y,z;
   i=(int) P[n][9];
   x=0.25*(P[n][5]*coord[0][noeud_geo[0][i]-1]
          +P[n][6]*coord[0][noeud_geo[1][i]-1]
          +P[n][7]*coord[0][noeud_geo[2][i]-1]
          +P[n][8]*coord[0][noeud_geo[3][i]-1]);
   y=0.25*(P[n][5]*coord[1][noeud_geo[0][i]-1]
          +P[n][6]*coord[1][noeud_geo[1][i]-1]
          +P[n][7]*coord[1][noeud_geo[2][i]-1]
          +P[n][8]*coord[1][noeud_geo[3][i]-1]);
   z=0.25*(P[n][5]*coord[2][noeud_geo[0][i]-1]
          +P[n][6]*coord[2][noeud_geo[1][i]-1]
          +P[n][7]*coord[2][noeud_geo[2][i]-1]
          +P[n][8]*coord[2][noeud_geo[3][i]-1]);
  fprintf(fp,"%f %f %f 1\n",x*1.e6,y*1.e6,z*1.e6); // in micron
/*if(z<-1.0){
  printf("n = %d\n",n);
  printf("%g %g %g %g\n",P[n][5],P[n][6],P[n][7],P[n][8]);
  printf("%f %f %f 1\n",x,y,z);  
}*/
//  if(n==10) printf("* %f %f %f\n",x,y,z);
//  if(n==20) printf("# %f %f %f\n\n",x,y,z);
 }
 fclose(fp);    
}
