/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 13 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 16 september 2007, Siracusa, Jean Michel Sellier

// calculate the electron density by means of a modified
// version of the well-known cloud in cell algorithm.

void electron_density(void)
{
// NOELEC[i] is the number of electrons in the i-th element
 int i;
 int *vertex;
 
 for(i=0;i<Ng;i++) NE[i]=0.; // just in case...

// modified cloud-in-cell method for 3D unstructured meshes

// it is a bit affected by statistical noise, but this is
// definitely normal.
 
 vertex=malloc((Ng+1)*sizeof(int));
 if(vertex==NULL){
   printf("electron_density error : not enough memory for vertex array!\n");
   exit(0);
 }
 for(i=0;i<Ng;i++) vertex[i]=0; // just in case...

   for(i=0;i<Ne;i++){
    if(i_dom[i]!=SIO2){
      NE[noeud_geo[0][i]-1]+=(double)(NOELEC[i])*EPP[i]/VOLUME[i];
      NE[noeud_geo[1][i]-1]+=(double)(NOELEC[i])*EPP[i]/VOLUME[i];
      NE[noeud_geo[2][i]-1]+=(double)(NOELEC[i])*EPP[i]/VOLUME[i];
      NE[noeud_geo[3][i]-1]+=(double)(NOELEC[i])*EPP[i]/VOLUME[i];
      vertex[noeud_geo[0][i]-1]++;
      vertex[noeud_geo[1][i]-1]++;
      vertex[noeud_geo[2][i]-1]++;
      vertex[noeud_geo[3][i]-1]++;
    }
   }
 for(i=0;i<Ng;i++) NE[i]/=(double)vertex[i];

 free(vertex);
}
