/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 14 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 16 august 2007, Siracusa, Jean Michel Sellier

// some calculations to make the code faster

void initial_usefull_calculations(void)
{
 int i;
 double *vertex;
 
 vertex=malloc((Ng+1)*sizeof(double));
 if(vertex==NULL){
  printf("initial_usefull_calculations : not enough memory for vertex!\n");
  system("PAUSE");
  exit(0);
 }
 
 for(i=0;i<Ng;i++) da[i]=0.; // just in case...
 for(i=0;i<Ng;i++) vertex[i]=0.;
// for(i=0;i<Ng;i++) for(j=0;j<Ng;j++) resr[i][j]=0.;

// for(i=0;i<Ne;i++) printf("%g %g %g\n",ND[i],VOLUME[i],ND[i]*VOLUME[i]);

 printf("calculating the acceptor density on vertices.\n");
 for(i=0;i<Ne;i++){
   da[noeud_geo[0][i]-1]+=ND[i]*VOLUME[i];
   da[noeud_geo[1][i]-1]+=ND[i]*VOLUME[i];
   da[noeud_geo[2][i]-1]+=ND[i]*VOLUME[i];
   da[noeud_geo[3][i]-1]+=ND[i]*VOLUME[i];

   vertex[noeud_geo[0][i]-1]+=1.;
   vertex[noeud_geo[1][i]-1]+=1.;
   vertex[noeud_geo[2][i]-1]+=1.;
   vertex[noeud_geo[3][i]-1]+=1.;
 }
 for(i=0;i<Ng;i++){
//   printf("da = %g vertex = %g\n",da[i], vertex[i]);
   da[i]/=vertex[i]; // da[i] = number of acceptors in the i-th vertex
//   printf("da = %g\n",da[i]);
 }

/* printf("calculating the relative dielectric constant on vertices.\n");
 for(i=0;i<Ne;i++){
   if(i_dom[i]!=SIO2){
     k[noeud_geo[0][i]-1]=1./(EPS0*EPSR[i_dom[i]]);
     k[noeud_geo[1][i]-1]=1./(EPS0*EPSR[i_dom[i]]);
     k[noeud_geo[2][i]-1]=1./(EPS0*EPSR[i_dom[i]]);
     k[noeud_geo[3][i]-1]=1./(EPS0*EPSR[i_dom[i]]);
   }
   if(i_dom[i]==SIO2){
     k[noeud_geo[0][i]-1]=1./(EPS0*EPSR_SiO2);
     k[noeud_geo[1][i]-1]=1./(EPS0*EPSR_SiO2);
     k[noeud_geo[2][i]-1]=1./(EPS0*EPSR_SiO2);
     k[noeud_geo[3][i]-1]=1./(EPS0*EPSR_SiO2);
   }

 }*/
// if(RELATIVEDISTANCESFLAG==WRITE){
/*   printf("calculating the relative distance on vertices.\n");
   for(i=0;i<Ng;i++)
     for(j=0;j<Ng;j++){
       resr[i][j]=sqrt(pow(coord[0][i]-coord[0][j],2.)
                      +pow(coord[1][i]-coord[1][j],2.)
                      +pow(coord[2][i]-coord[2][j],2.));
     }*/
//   printf("saving...\n");
//   FILE *fp;
//   fp=fopen("relative_distances.dat","wb"); 
//   for(i=0;i<Ng;i++)
//     for(j=0;j<i;j++) fprintf(fp,"%g ",resr[i][j]);
//   fclose(fp);
// }
// if(RELATIVEDISTANCESFLAG==READ){
//   FILE *fp;
//   double dum;
//   printf("reading the relative distances table...\n");
//   fp=fopen("relative_distances.dat","rb");
//   for(i=0;i<Ng;i++)
//     for(j=0;j<i;j++){
//       fscanf(fp,"%lf ",&dum);
//       resr[i][j]=dum;
//       resr[j][i]=dum;
//       printf("resr[%d][%d] = %g\n",i,j,resr[i][j]);
//     }
//   fclose(fp);
// }
 free(vertex);
}
