/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 08 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 08 june 2007, Siracusa, Jean Michel Sellier

// solves the set of n linear equations A.x = B. Here a[1..n][1..n] is input,
// not as the matrix A but rather as its LU decomposition, determined by the
// routine ludcmp. indx[1..n] is input as the permutation vector returned by
// ludcmp. b[1..n] is input as the right-hand side vector B, and returns with 
// the solution vector X. a, n and indx are not modified by this routine and can
// be left in place for successive calls with different right-hand sides b.
// This routine takes into account the possibility that b will begin with many
// zero elements, so it is efficient for use in matrix inversion.

{
 int i,ii=0,ip,j;
 double sum;
 
 for(i=1;i<=n;i++){
    ip=indx[i];
    sum=b[ip];
    b[ip]=b[i];
    if(ii) for(j=ii;j<=i-1;j++) sum-=a[i][j]*b[j];
    else if(sum) ii=i;
    b[i]=sum;
 }
 for(i=n;i>=1;i--){
    sum=b[i];
    for(j=i+1;j<=n;j++) sum-=a[i][j]*b[j];
    b[i]=sum/a[i][i];
 }
}
