/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/


/*
 ************************************************************************

  Program Name              : AENEAS
  Version                   : 1.0
  File Name                 : finite_element_3D_poisson.c
  Programmer                : Jean Michel Sellier
  Copyright                 : 2005, 2006, 2007, Jean Michel Sellier
  Created on                : 30 may 2005 Siracusa (PETSC_POISSON_3D.c)
  Last modified on          : 07 jun.2007 Siracusa
  Description               : Computes the electrostatic potential on a device
                              described by the simple Poisson equation :
                              -\nabla^2 (\phi) = 0.0
                              The numerical method is the Finite Element Method
                              using the P1 Lagrange finite element.
  Dependencies              : None
  Important bibliography    : Elements finis: theorie, applications, mise en oeuvre ,
                              Alexandre Ern, Jean-Luc Guermond, SMAI, Springer (french book).

  ************************************************************************
*/

// itol is 1,2,3 or 4, specifying which convergence test is applied (see below)
// itmax is the maximum number of allowed iterations
// tol is the desired convergence tollerance
// On output, x[1..n] is reset to the improved solution
// iter is the number of iterations actually taken
// err is the estimated error

void poisson3D(double x[],int itol,double tol,int itmax)
{
 printf("\nSolving the 3D Poisson equation...\n");
  
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  linbcg(Ng,b,x,itol,tol,itmax);
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
// @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

  printf("Poisson equation solved...\n\n");
}
