/*
   This file belongs to Aeneas. Aeneas is a GNU package released under GPL 3 license.
   This code is a simulator for Submicron 3D Semiconductor Devices. 
   It implements the Monte Carlo transport in 3D tetrahedra meshes
   for the simulation of the semiclassical Boltzmann equation for both electrons.
   It also includes all the relevant quantum effects for nanodevices.

   Copyright (C) 2007 Jean Michel Sellier <sellier@dmi.unict.it>
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

// Created on : 07 june 2007, Siracusa, Jean Michel Sellier
// Last modified : 16 august 2007, Siracusa, Jean Michel Sellier

// calculates the electric field components on every node of the mesh

void electric_field(int fl)
{
// if fl == 0 then this is the first time one computes the electric field
// if fl == 1 then this is not the first one computes the electric field
 int i;
 double dum[3];
// int *ivertex;

/* ivertex=malloc((Ng+1)*sizeof(int));
 if(ivertex==NULL){
  printf("electric_field : not enough memory for dynamical allocation!\n");
  system("PAUSE");
  exit(0);
 }*/
 
// for(i=0;i<Ng;i++) ivertex[i]=0;
// for(i=0;i<Ng;i++) Ex[i]=Ey[i]=Ez[i]=0.; // just in case... // <--- this is wrong!!!
 
 for(i=0;i<Ne;i++){
    int l;
    int n=4;
    int indx[5];
    double d;
    double a[5][5];
    double b[5];
    double ac[4],bc[4],cc[4]; //,dc[4];

// definition of the a matrix for the linear system
    {int k;
     for(k=0;k<4;k++){
       a[k+1][1]=coord[0][noeud_geo[k][i]-1]; 
       a[k+1][2]=coord[1][noeud_geo[k][i]-1]; 
       a[k+1][3]=coord[2][noeud_geo[k][i]-1]; 
       a[k+1][4]=1.;
     }}
// LU decomposition of the A matrix
#include "../linear_solver/ludcmp.h"
    for(l=0;l<4;l++){
      if(l==0){b[1]=1.;b[2]=0.;b[3]=0.;b[4]=0.;}
      if(l==1){b[1]=0.;b[2]=1.;b[3]=0.;b[4]=0.;}
      if(l==2){b[1]=0.;b[2]=0.;b[3]=1.;b[4]=0.;}
      if(l==3){b[1]=0.;b[2]=0.;b[3]=0.;b[4]=1.;}
#include "../linear_solver/lubksb.h"
      ac[l]=b[1]; bc[l]=b[2]; cc[l]=b[3];// dc[l]=b[4];
//printf("*** %g %g %g %g\n",b[1],b[2],b[3],b[4]);
/*printf("%g\n",b[1]*coord[0][noeud_geo[0][i]-1]
             +b[2]*coord[1][noeud_geo[0][i]-1]
             +b[3]*coord[2][noeud_geo[0][i]-1]
             +b[4]);
printf("%g\n",b[1]*coord[0][noeud_geo[1][i]-1]
             +b[2]*coord[1][noeud_geo[1][i]-1]
             +b[3]*coord[2][noeud_geo[1][i]-1]
             +b[4]);
printf("%g\n",b[1]*coord[0][noeud_geo[2][i]-1]
             +b[2]*coord[1][noeud_geo[2][i]-1]
             +b[3]*coord[2][noeud_geo[2][i]-1]
             +b[4]);
printf("%g\n\n",b[1]*coord[0][noeud_geo[3][i]-1]
             +b[2]*coord[1][noeud_geo[3][i]-1]
             +b[3]*coord[2][noeud_geo[3][i]-1]
             +b[4]);*/
    }
// calculation of the electric field around the barycenter
// by means of a second order finite difference formula

//     double xm=0.,ym=0.,zm=0.;
//     int k;

// calculation of the center of mass for a homogeneous tetrahedra
/*     for(k=0;k<4;k++){
         xm+=coord[0][noeud_geo[k][i]-1];
         ym+=coord[1][noeud_geo[k][i]-1];
         zm+=coord[2][noeud_geo[k][i]-1];         
     }
     xm*=0.25; ym*=0.25; zm*=0.25;*/
//     printf("xm = %g ym = %g zm = %g\n",xm,ym,zm);

// ALL THE COMPONENTS ARE COMPUTED ANALITYCALLY
// ============================================

// x-component of the electric field
     dum[0]=V[noeud_geo[0][i]-1]*ac[0]+
         V[noeud_geo[1][i]-1]*ac[1]+
         V[noeud_geo[2][i]-1]*ac[2]+
         V[noeud_geo[3][i]-1]*ac[3];// dum*=-1.e-8;

// x-component of the electric field
     dum[1]=V[noeud_geo[0][i]-1]*bc[0]+
         V[noeud_geo[1][i]-1]*bc[1]+
         V[noeud_geo[2][i]-1]*bc[2]+
         V[noeud_geo[3][i]-1]*bc[3];// dum*=-1.e-8;

// z-component of the electric field
     dum[2]=V[noeud_geo[0][i]-1]*cc[0]+
         V[noeud_geo[1][i]-1]*cc[1]+
         V[noeud_geo[2][i]-1]*cc[2]+
         V[noeud_geo[3][i]-1]*cc[3];// dum*=-1.e-8;
     {int h,w;
      for(h=0;h<4;h++){
        w=noeud_geo[h][i]-1;
        Ex[w]=-dum[0];
        Ey[w]=-dum[1];
        Ez[w]=-dum[2];
      }}

// first time one computes the electric field
/*     {int h,w;
      if(fl==0) for(h=0;h<4;h++){
        w=noeud_geo[h][i]-1;
        Ex[w]=-dum[0];
        Ey[w]=-dum[1];
        Ez[w]=-dum[2];
      }
     }
// this is not the first time one computes the electric field
     if(fl==1)
     {int h,w; 
      int flag;
      flag=0;
      for(h=0;h<4;h++) if(i_front[noeud_geo[h][i]-1]==OHMIC ||
                          i_front[noeud_geo[h][i]-1]==SCHOTTKY ||
                          i_front[noeud_geo[h][i]-1]==INSULATOR) flag=1;
      if(flag==0) for(h=0;h<4;h++){
        w=noeud_geo[h][i]-1;
        Ex[w]=-dum[0];
        Ey[w]=-dum[1];
        Ez[w]=-dum[2];
//        ivertex[w]++;
      }
     }
         */
//    printf("Ex = %g\n",Ex[noeud_geo[0][i]-1]);
//    printf("Ey = %g\n",Ey[noeud_geo[0][i]-1]);
//    printf("Ez = %g\n\n",i,Ez[noeud_geo[0][i]-1]);
 } // end of the i-cycle

// we compute the mean average of electric field components on all vertices
// charge neutrality is now maintained!

/* for(i=0;i<Ne;i++){
  {int h,w;
   int flag;
   flag=0;
   for(h=0;h<4;h++) if(i_front[noeud_geo[h][i]-1]==OHMIC ||
                       i_front[noeud_geo[h][i]-1]==SCHOTTKY ||
                       i_front[noeud_geo[h][i]-1]==INSULATOR) flag=1;
   if(flag==0) for(h=0;h<4;h++){
     w=noeud_geo[h][i]-1;
     if(ivertex[w]!=0){
       Ex[w]/=(double)ivertex[w];
       Ey[w]/=(double)ivertex[w];
       Ez[w]/=(double)ivertex[w];
     }
   }
  }
 }*/
// free(ivertex);
}
