/*
//  project  VPL
//  version  V3.31F
//  design   03 mar 1999 (finished)
//  doc      LIBVGAP.DOC
//  history  V1 - QBX/PDS VGAP I/O library; 1995 - 1997.
//           V2 - Borland Pascal VGAP I/O library; 1997- 1998 (never quite
//                completed).
//           V3 - DJGPP VGAP I/O library; As of mar 1999:
//           28 mar 1999 Begin work on newly designed VGAP I/O library
//           04 mar 1999 First beta version for internal use.
//                       (V3.00F1)
//           24 may 1999 Some bugs fixed for none-existing files and ANSI
//                       standards.
//                       (V3.00F2)
//           29 may 1999 slight change in ship and planet I/O - problem with
//                       the way the compiler stores packed structs in
//                       memory. It does seem to work without failure now
//                       One additional bug removed
//                       (V3.00F3)
//           21 nov 1999 earlier problem with ship and planet I/O acting up
//                       again with newer version of compiler. Fix made
//                       compiler-independant (and nicer too)
//                       (V3.00F4)
//           22 nov 1999 Changes made to vent it as freeware.
//                       (V3.00F5)
//           23 nov 1999 Started work on the player-side data I/O
//           30 dec 1999 Started work on <vpl3.h> header and dispatchers.
//           03 jan 2000 Finished work on <vpl3.h> header and dispatchers.
//           08 mar 2000 Debugged shutdown routine - removed a bug in the
//                       map saving.
//                       Added the Gators and Starbase Enhancer support
//                       Rewrote the documentation
//                       (V3.10F)
//           23 mar 2000 Debugged shutdown - removed a bug that could cause
//                       an error number 63 in the host (invalid record
//                       number) when building a new ship (ship ID could be
//                       set to 0 in the database)
//           19 apr 2000 Gators version 3.1.1 employs some changes in
//                       structures - implemented
//           27 apr 2000 bugspray applied - filters.c implemented
//  authors  Dlanor Blytkerchan <dlanor@dds.nl>
//           with data from: Kero van Gelder
//                           Dan & Dave
//                           Tim Wisseman
//  comments This should NOT be used for player-side files!
//           files still unknown:
//             * CLOAKC.HST
//           files not accessed:
//             * TRUEHULL.DAT
//             * TRUEHULL.NEW
//             * FRIDAY.HST
//             * VCR.HST
//             code is available but not implemented in this library (yet).
//  function VGAP 3.x I/O library for host-side data files. Intended for use
//           in host-side add-ons.
*/

#ifndef VPL3
#ifdef VPL3_VPL3_H
#error <vpl3.h> already included!
#endif // VPL3_VPL3_H
#endif // VPL3
#ifndef VPL3_VPL_H  // to prevent doing this twice..
#define VPL3_VPL_H
#ifdef __cplusplus
extern "C" {
#endif
/*****************************************************************Includes*/
#include <stdio.h>
#define LSW1_fileIO
#include <swing.h>
/******************************************************************Defines*/
#define vpl_name       "RLSystems VGAP I/O library"
#define vpl_version    "V3.30F"
#define vpl_hexVersion 0x0300
#define vpl_author     "Dlanor Blytkerchan <dlanor@dds.nl>"

#ifndef word
  #define word unsigned short
#endif // word
#ifndef byte
  #define byte unsigned char
#endif // byte
#ifndef bool
  #define bool byte
#endif // bool
#ifndef false
  #define false 0
#endif // false
#ifndef true
  #define true !false
#endif // true

#define planetFileName      "PDATA.HST"
#define planetXYFileName    "XYPLAN.HST"
#define shipFileName        "SHIP.HST"
#define shipXYFileName      "SHIPXY.HST"
#define baseFileName        "BDATA.HST"
#define hConfigFileName     "HCONFIG.HST"
#define greyFileName        "GREY.HST"
#define genFileName         "GEN.HST"
#define UFOFileName         "UFO.HST"
#define VCRFileName         "VCR.HST"
#define minesFileName       "MINES.HST"
#define beamSpecFileName    "BEAMSPEC.DAT"
#define torpSpecFileName    "TORPSPEC.DAT"
#define engSpecFileName     "ENGSPEC.DAT"
#define hullSpecFileName    "HULLSPEC.DAT"
#define trueHullFileName    "TRUEHULL.DAT"
#define SR_trueHullFileName "TRUEHULL.NEW"
#define SR_racesFileName    "FRIDAY.HST"
#define raceNameFileName    "RACE.NM"
#define planetNameFileName  "PLANET.NM"
#define cloakFileName       "CLOAKC.HST"
#define nextturnFileName    "NEXTTURN.HST"
#define fizzFileName        "FIZZ.BIN"

#define numPlanets         500   // PLANETS has a fixed number of planets
#define numMines           500   // probable maximum number of mine fields
#define planetNameLength   20    // As in file PLANET.NM
#define numRaces           11    // There are 11 races
#define numHulls           105   // Maximum number of hulls that can be read
#define numBeams           10    // Beam specs
#define numTorps           10    // Torp specs
#define numEngines         9     // Engine specs
#define numIonStorms       50    // maximum number of ion disturbances
#define numUFOs            1000  // maximum number of UFOs
#define maxMessageSize     615   // 15 lines of 40 chars + CR

#ifdef __cplusplus
extern "C" {
#endif
/*********************************************Universal structural defines*/
typedef struct { // see comment 1
  short xCoord;
  short yCoord;
  short owner;
} planetXYType;

typedef struct { // see comment 3
  short ID;
  short owner;
  char  fCode[3];
  short speed;
  short xDisplacement, yDisplacement;
  short xCoord, yCoord;
  short engineTech;
  short hullClass;
  short beamTech;
  short nBeamWeapons;
  short nFighterBays;
  short torpTech;
  short nTorps;
  short nTubes;
  short mission;
  short primeEnemy;
  short shipInTow;
  short damage;
  short crew;
  short colonists;
  char  name[20];
  short neutronium;
  short tritanium;
  short duranium;
  short molybdenum;
  short supplies;
  short unloadNeutronium;
  short unloadTritanium;
  short unloadDuranium;
  short unloadMolybdenum;
  short unloadColonists;
  short unloadSupplies;
  short unloadPlanet;
  short transferFuel;
  short transferTritanium;
  short transferDuranium;
  short transferMolybdenum;
  short transferColonists;
  short transferSupplies;
  short transferShip;
  short intercept;
  short megaCredits;
} shipType;
#define sizeofshipType 107 // see comment 4

typedef struct { // see comment 5
  short xCoord;
  short yCoord;
  short owner;
  short mass;
} shipXYType;
#define sizeofshipXYType 8

typedef struct { // see comment 6
  char  name[30];
  short picture;
  short pad;
  short tritanium;
  short duranium;
  short molybdenum;
  short fueltankSize;
  short crewSize;
  short engines;
  short mass;
  short techLevel;
  short cargoBaySize;
  short nFighterBays;
  short nTubes;
  short nBeams;
  short hullcost;
} hullSpecType;

typedef struct {
  char  name[20];
  short cost;
  short tritanium;
  short duranium;
  short molybdenum;
  short mass;
  short techlevel;
  short killPower;
  short explosivePower;
} beamSpecType;

typedef struct {
  char  name[20];
  short torpCost;
  short tubeCost;
  short tritanium;
  short duranium;
  short molybdenum;
  short mass;
  short techLevel;
  short killPower;
  short explosivePower;
} torpSpecType;

typedef struct {
  char  name[20];
  short cost;
  short tritanium;
  short duranium;
  short molybdenum;
  short techLevel;
  long  fuelburned[9];
} engineSpecType;

#define TXT_attitude(x) (((x) < 20) ? ("fighting") : (((x) < 40) ? ("rioting") : (((x) < 50) ? ("very angry") : (((x) < 70) ? ("unhappy") : (((x) < 90) ? ("calm") : ("happy"))))))
#define TXT_nativeGovernment(x) (((x) == 1) ? ("Anarchy") : (((x) == 2) ? ("Pre-Tribal") : (((x) == 3) ? ("Early Tribal") : (((x) == 4) ? ("Tribal") : (((x) == 5) ? ("Feudal") : (((x) == 6) ? ("Monarchy") : (((x) == 7) ? ("Representative") : (((x) == 8) ? ("Participatory") : ("Unity")))))))))
#define TXT_nativeRace(x) (((x) == 1) ? ("Humanoid") : (((x) == 2) ? ("Bovinoid") : (((x) == 3) ? ("Reptilian") : (((x) == 4) ? ("Avian") : (((x) == 5) ? ("Amorphous") : (((x) == 6) ? ("Insectoid") : (((x) == 7) ? ("Amphibian") : (((x) == 8) ? ("Ghipsodal") : ("Siliconoid")))))))))
#define TXT_climate(x) (((x) < 15) ? ("Arctic") :                          \
                       (((x) < 40) ? ("Cool") :                            \
                       (((x) < 65) ? ("Warm") :                            \
                       (((x) < 85) ? ("Tropic") : ("Desert")))))
#define TXT_happiness(happiness, type) ((type == 0) ?                                                   \
                                       ((happiness >=  450) ? ("love you") :                            \
                                       ((happiness >=   50) ? ("like your leadership") :                \
                                       ((happiness >= -100) ? ("are undecided about you") :             \
                                       ((happiness >= -550) ? ("are angry at you") : ("hate you"))))) : \
                                       ((happiness >=  450) ? ("love") :                                \
                                       ((happiness >=   50) ? ("like") :                                \
                                       ((happiness >= -100) ? ("undecided") :                           \
                                       ((happiness >= -550) ? ("angry") : ("hate"))))))

typedef struct { // see comment 7
  short owner;
  short ID;
  char  fCode[3];
  short mines;
  short factories;
  short defense;
  long  minedNeutronium;
  long  minedTritanium;
  long  minedDuranium;
  long  minedMolybdenum;
  long  colonists;
  long  supplies;
  long  megaCredits;
  long  inGroundNeutronium;
  long  inGroundTritanium;
  long  inGroundDuranium;
  long  inGroundMolybdenum;
  short neutroniumDensity;
  short tritaniumDensity;
  short duraniumDensity;
  short molybdenumDensity;
  short colonistTaxRate;
  short nativeTaxRate;
  short colonistAttitude;
  short nativeAttitude;
  short nativeGovernment;
  long  natives;
  short nativeRace;
  short temperature;
  short buildStarbase;
} planetType;

typedef struct { // See comment 8
  long randomSeed;
  short climate;
  short isPlanet;
  short mass1;
  short mass2;
  char  name1[20];
  short damage1;
  short crew1;
  short ID1;
  short owner1;
  short picture1;
  short beamTech1;
  short nBeams1;
  short nBays1;
  short torpTech1;
  short nTorps1;
  short nTubes1;
  char  name2[20];
  short damage2;
  short crew2;
  short ID2;
  short race2;
  short picture2;
  short beamTech2;
  short nBeams2;
  short nBays2;
  short nTorpTech2;
  short nTorps2;
  short nTubes2;
  short shield1;
  short shield2;
} VCRType;

typedef struct { // see comment 9
  short ID;
  short owner;
  short defense;
  short damage;
  short engineTech;
  short hullTech;
  short beamTech;
  short torpTech;
  short nEngines[9];
  short nHulls[20];
  short nBeams[10];
  short nTubes[10];
  short nTorps[10];
  short nFighters;
  short fixID;
  short fixType;
  short mission;
  short buildHull;
  short buildEngineTech;
  short buildBeamTech;
  short buildBeamCount;
  short buildTorpTech;
  short buildTubeCount;
  short buildFighterCount;
} baseType;

typedef struct {
  char longName[11][30];
  char pluralName[11][20];
  char adjectiveName[11][12];
} raceNameType;
/*********************************************Host-side structural defines*/
typedef struct { // see comment 10
  short xCoord;
  short yCoord;
  short owner;
  long  numberOfMines;
  short webType;
} mineType;

typedef struct { // see comment 11
  short marker;
  char  name[20];
  char  info1[20];
  char  info2[20];
  short xCoord;
  short yCoord;
  short speed;
  short heading;
  short rangeP;
  short rangeS;
  short edge;
  short parent;
} UFOType;

typedef struct { // see comment 12
  short xCoord;
  short yCoord;
  short radius;
  short voltage;
  short heading;
  short xDisplacement;
  short yDisplacement;
  short reserved;
} ionType;

// race n is allied with race x in allianceType A
#define isAllied(n,x,A) (((n) == 1) ? ((A).race1 & (1 << ((x) - 1))) : (((n) == 2) ? ((A).race2 & (1 << ((x) - 1))) : (((n) == 3) ? ((A).race3 & (1 << ((x) - 1))) : (((n) == 4) ? ((A).race4 & (1 << ((x) - 1))) : (((n) == 5) ? ((A).race5 & (1 << ((x) - 1))) : (((n) == 6) ? ((A).race6 & (1 << ((x) - 1))) : (((n) == 7) ? ((A).race7 & (1 << ((x) - 1))) : (((n) == 8) ? ((A).race8 & (1 << ((x) - 1))) : (((n) == 9) ? ((A).race9 & (1 << ((x) - 1))) : (((n) == 10) ? ((A).race10 & (1 << ((x) - 1))) : ((A).race11 & (1 << ((x) - 1)))))))))))))
#define setAlliance(n,x,A) switch (n) {                                                     \
                             case 1 : (A).race1 = ((A).race1 | (1 << ((x) - 1))); break;    \
                             case 2 : (A).race2 = ((A).race2 | (1 << ((x) - 1))); break;    \
                             case 3 : (A).race3 = ((A).race3 | (1 << ((x) - 1))); break;    \
                             case 4 : (A).race4 = ((A).race4 | (1 << ((x) - 1))); break;    \
                             case 5 : (A).race5 = ((A).race5 | (1 << ((x) - 1))); break;    \
                             case 6 : (A).race6 = ((A).race6 | (1 << ((x) - 1))); break;    \
                             case 7 : (A).race7 = ((A).race7 | (1 << ((x) - 1))); break;    \
                             case 8 : (A).race8 = ((A).race8 | (1 << ((x) - 1))); break;    \
                             case 9 : (A).race9 = ((A).race9 | (1 << ((x) - 1))); break;    \
                             case 10 : (A).race10 = ((A).race10 | (1 << ((x) - 1))); break; \
                             case 11 : (A).race11 = ((A).race11 | (1 << ((x) - 1))); break; \
                           }
#define clearAlliance(n,x,A) switch (n) {                                                         \
                               case 1 : (A).race1 = ((A).race1 & (~(1 << ((x) - 1)))); break;     \
                               case 2 : (A).race2 = ((A).race2 & (~(1 << ((x) - 2)))); break;     \
                               case 3 : (A).race3 = ((A).race3 & (~(1 << ((x) - 3)))); break;     \
                               case 4 : (A).race4 = ((A).race4 & (~(1 << ((x) - 4)))); break;     \
                               case 5 : (A).race5 = ((A).race5 & (~(1 << ((x) - 5)))); break;     \
                               case 6 : (A).race6 = ((A).race6 & (~(1 << ((x) - 6)))); break;     \
                               case 7 : (A).race7 = ((A).race7 & (~(1 << ((x) - 7)))); break;     \
                               case 8 : (A).race8 = ((A).race8 & (~(1 << ((x) - 8)))); break;     \
                               case 9 : (A).race9 = ((A).race9 & (~(1 << ((x) - 9)))); break;     \
                               case 10 : (A).race10 = ((A).race10 & (~(1 << ((x) - 10)))); break; \
                               case 11 : (A).race11 = ((A).race11 & (~(1 << ((x) - 11)))); break; \
                             }
typedef struct { // see comment 13
  short race1;
  short race2;
  short race3;
  short race4;
  short race5;
  short race6;
  short race7;
  short race8;
  short race9;
  short race10;
  short race11;
} allianceType;

typedef struct {
  short recycle;                 // % of ore recovered from colonizing ships
  short meteor;                  // % odds of one large meteor impact
  short mineFields;              // flag mine fields yes (1) or no (0)
  short alchemy;                 // flag alchemy yes (1) or no (0)
  short deleteOldMessages;       // flag delete old messages yes (1)
  short noPassword;              // flag disable passwords yes (1)
  short groundKillRatio[11];     // ground combat kill ratios
  short defenseKillRatio[11];    // ground combat defense factor
  short freeFighters[11];        // number of free fighters
  short mineRates[11];           // mineral mining rates
  short taxRate[11];             // tax 50% to 500%
  short rebelBuildFighters;      // build fighters in space
  short coloniesBuildFighters;   // build fighters in space
  short robotBuildFighters;      // build fighters in space
  short oddsCloakFail;           // 0% - 50% cloak ship failure
  short robCloakedShips;         // rob cloaked ships (yes/no)
  short shipScanRange;           // ship scan range limit
  short darkSenseRange;          // range of dark sense
  short hissMission;             // hiss mission on and off
  short groundAttack;            // rebel ground attack on and off
  short superRefit;              // super refit on and off
  short webMines;                // web mines on and off
  short cloakBurn;               // cloaked ship fuel burn 1 to 50 kt
  short sensorRange;             // range of the sensor mission
  short newNativesAppear;        // add new natives
  short planetCanAttack;         // planets attack ships (yes/no)
  short cyborgAssimilation;      // cyborg assimulation rate (1-100)
  short webDecayRate;            // web mine decay rate
  short mineDecayRate;           // mine field decay rate
  short maxMinefieldRadius;      // max mine field radius in lightyears
  short isotopeTransmutation;    // new mineral form rate
  short structuralDecay;         // decay of structures on underpop planet
  short overpopEatSupplies;      // eat supplies? (yes/no)
  short moveWithoutFuel;         // ships without fuel can move (yes/no)
  short oddsMineHit;             // odds of hitting a mine
  short oddsWebMineHit;          // odds of hitting a web mine
  short mineVisibleRange;        // range that you can see mines
  short minesKillMines;          // mines destroy enemy mines
  short engineShieldBonus;       // engine shield bonus shield
  short engineShieldBonusRate;   // engine shield bonus % rate
  short colFighterSweep;         // colonies fighter sweep rate
  short colFighterWebSweep;      // colonies fighter sweep web mines (yes/no)
  short mineSweepRate;           // rate that weapons sweep mines
  short webSweepRate;            // rate that weapons sweep web mines
  short lizardMaxHiss;           // the max that a hiss mission can effect planet
  short robFailRate;             // the odds that the rob mission will fail
  short rebelNoATTNUK;           // planets can attack rebels (yes/no)
  short fascistNoATTNUK;         // planets can attack fascists (yes/no)
  short mineSweepRange;          // the range that a mine field can be sweeped
  short webSweepRange;           // the range that a web field can be sweeped
  short scienceMissions;         // ship science missions
  short cloakedMineHitOdds;      // the odds that a cloaked ship will hit a mine
  short maxDamageCloak;          // the amount of damage that prevents cloaking
  short fedCrewBonus;            // fed ships get a combat bonus (yes/no)
  short oddsSallMeteorImpact;    // odds of small meteor impacts
  long  smallMeteorMinimumNeu;   // minimum minerals in meteor
  long  smallMeteorMinimumDur;   //
  long  smallMeteorMinimumTri;   //
  long  smallMeteorMinimumMol;   //
  long  smallMeteorMaximumNeu;   // maximum minerals in meteor
  long  smallMeteorMaximumDur;   //
  long  smallMeteorMaximumTri;   //
  long  smallMeteorMaximumMol;   //
  short numberOfLargeMeteors;    // number of large meteors to impact
  long  largeMeteorMinimumNeu;   // minimum minerals in meteor
  long  largeMeteorMinimumDur;   //
  long  largeMeteorMinimumTri;   //
  long  largeMeteorMinimumMol;   //
  long  largeMeteorMaximumNeu;   // maximum minerals in meteor
  long  largeMeteorMaximumDur;   //
  long  largeMeteorMaximumTri;   //
  long  largeMeteorMaximumMol;   //
  short sendMeteorMessages;      // send meteor messages?
  short singleEngineTow;         // a ship with one engine can tow another
  short hyperSpaceJumps;         // hyper space jumps
  short colonistDeathRate;       // colonist death rate
  short gravityWells;            // gravity wells
  short crystalsLikeHot;         // crystals immune to bad climates
  short minesDestroyWebs;        // normal mines destroy web mines
  short climateLimitsPop;        // climate limits population
  long  maxPlanetaryIncome;      // max income that the planet can make per turn
  short ionStormActivity;        // 0%-100% The activity rating of Ion storms
  short chunneling;              // warp chunnel
  short spyBoost;                // super spy bonus
  short ionsHideMines;           // ion storms hide mines
  short gloryDevice;             // klingon glory device (D19, Saber)
  short lokiDevice;              // loki anti-cloaking
  short gambling;                // lady royal gambing
  short cloakAttack;             // cloaked ships can attack
  short cloning;                 // ships can be cloned
  short boardingParties;         // crystals and privateers can capture with tow
  short imperialAssault;         // super star destroyer can take planets with 10 clans
  short cobolFreeFuel;           // amount of free fuel per LY
  short ariesRefinery;           // aries can convert minerals to fuel?
  short bioScanners;             // do they exist?
  short hullTechMineResist;      // hull tech not slowed by mine hits
  short birdDecloak;             // Are Birds decloacked by lokis?
} hConfigType;

typedef struct _shipShieldStatusType {
  bool isCloaked;
  short shieldPower;
} shipShieldStatusType;
/****************************************************Host data I/O methods*/
// openers
bool openGen(char *genPath);
bool openHConfig(char *hConfigPath);
bool openPlanetXYDB(char *planetXYPath);
bool openPlanetNameDB(char *planetNMPath);
bool openRaceNameDB(char *raceNamePath);
bool openGreyDB(char *greyPath);
bool openTorpDB(char *torpPath);
bool openBeamDB(char *beamPath);
bool openEngineDB(char *enginePath);
bool openBaseDB(char *basePath);
bool openHullDB(char *hullPath);
bool openMineDB(char *minePath);
bool openPlanetDB(char *planetPath);
bool openShipDB(char *shipPath);
bool openShipXYDB(char *shipXYPath);
bool openUFODB(char *UFOPath);
bool openCloakDB(char *cloakPath);
// closers
bool closeGen(void);
bool closeHConfig(void);
bool closePlanetXYDB(void);
bool closePlanetNameDB(void);
bool closeRaceNameDB(void);
bool closeGreyDB(void);
bool closeTorpDB(void);
bool closeBeamDB(void);
bool closeEngineDB(void);
bool closeBaseDB(void);
bool closeHullDB(void);
bool closeMineDB(void);
bool closePlanetDB(void);
bool closeShipDB(void);
bool closeShipXYDB(void);
bool closeUFODB(void);
bool closeCloakDB(void);
// readers..
bool readActive(bool *isActive, short record);
bool readAllianceStatus(allianceType *alliances);
bool readKillPoints(short *PBP, short record);
bool readCrewExperience(short *experience, short record);
bool readIonStorm(ionType *ionRec, short record);
bool readTorpRecord(torpSpecType *torpRec, short record);
bool readBeamRecord(beamSpecType *beamRec, short record);
bool readEngineRecord(engineSpecType *engineRec, short record);
bool readBaseRecord(baseType *baseRec, short record);
bool readHullRecord(hullSpecType *hullRec, short record);
bool readMineRecord(mineType *mineRec, short record);
bool readPlanetRecord(planetType *planetRec, short record);
bool readShipRecord(shipType *shipRec, short record);
bool readShipXYRecord(shipXYType *shipXYRec, short record);
bool readUFORecord(UFOType *UFORec, short record);
bool readHConfig(hConfigType *hConfigRec);
bool readPlanetXYRecord(planetXYType *planetXYRec, short record);
bool readPlanetNameRecord(char *planetNMRec, short record);
bool readRaceNames(raceNameType *raceNames);
bool readShipShieldStatus(shipShieldStatusType *S, short record);
// writers..
bool writeActive(bool *isActive, short record);
bool writeAllianceStatus(allianceType *alliances);
bool writeKillPoints(short *PBP, short record);
bool writeCrewExperience(short *experience, short record);
bool writeIonStorm(ionType *ionRec, short record);
bool writeTorpRecord(torpSpecType *torpRec, short record);
bool writeBeamRecord(beamSpecType *beamRec, short record);
bool writeEngineRecord(engineSpecType *engineRec, short record);
bool writeBaseRecord(baseType *baseRec, short record);
bool writeHullRecord(hullSpecType *hullRec, short record);
bool writeMineRecord(mineType *mineRec, short record);
bool writePlanetRecord(planetType *planetRec, short record);
bool writeShipRecord(shipType *shipRec, short record);
bool writeShipXYRecord(shipXYType *shipXYRec, short record);
bool writeUFORecord(UFOType *UFORec, short record);
bool writeHConfig(hConfigType *hConfigRec);
bool writePlanetXYRecord(planetXYType *planetXYRec, short record);
bool writePlanetNameRecord(char *planetNMRec, short record);
bool writeRaceNames(raceNameType *raceNames);
bool writeShipShieldStatus(shipShieldStatusType *S, short record);

#ifdef __cplusplus
}
#endif
/******************************************************************Globals*/
extern short numShips;
/*****************************************************************Comments**
// 1.  The file XYPLAN.HST contains 500 records of planet coordinats and
//     some redundant info (the owner of the planet is actually stored in
//     PDATA.HST. The record here is for use by the master and some config
//     programs only, and not reliable).
//     There is a checksum over the X coordinats: the sum of all X
//     coordinats must be 998681. If it is not, some player-side programs
//     will not work. Newer programs have no problems with this.
// 2.  The file PLANET.NM contains 500 BASIC-type strings (not NULL
//     terminated and filled up with spaces) of 20 characters. If you want
//     to use planet names, you can read them as char[20] and put them in a
//     char[21] to NULL-terminate them. Some planet names actually have 20
//     chars, so this is the only way to safely use them..
// 3.  The SHIP.HST file contains a redundant short at the start of the
//     file. This short is used in the player-side SHIP??.DAT file to
//     determine the amount of planets in the file, but is always 0x0000 in
//     the host-side file.
// 4.  The size of the ship record in the SHIP.HST file is 107 bytes. In
//     memory, the record is larger (usually 108 bytes, but that may vary
//     with each compiler version). This 107 bytes can be used to determine
//     how many ship slots are in the game - 500 or 999 - by determining the
//     size of the SHIP.HST file, substracting 2 (for the redundant short at
//     front) and dividing by sizeofshipType. You should get either 500 or
//     999. Otherwise, the database is either corrupted or you're using an
//     odd host.
// 5.  The data in the SHIPXY.HST file is a digest of the data in the
//     SHIP.HST file. The coordinats in the SHIPXY.HST file are not always
//     correct, as the mass may not always be correct and the owner may not
//     always be correct. In short, you should either validate the data, or
//     use the data from SHIP.HST.
//     The host program itself keep good track of the data in the SHIPXY.HST
//     file - some add-ons do not.
// 6.  There is a single checksum over the spec files, which is the sum of
//     all bytes in the four spec files (HULLSPEC.DAT, ENGSPEC.DAT,
//     BEAMSPEC.DAT and TORPSPEC.DAT). This is calculated in a 32-bit
//     integer and used only by player-side programs by Tim. The newer
//     player-side programs don't care about this and some add-ons change
//     the info.. TORPSPEC.DAT has some trailing garbage at the end, to fix
//     this checksum..
// 7.  Like SHIP.HST, PDATA.HST contains a single short to determine the
//     number of planets in the database on the player side (PDATA??.HST).
//     This short is always 0x0000 on the host side.
// 8.  A file normally not accessed by add-ons is VCR.HST. The first short
//     in the file determines the number of battles done by the host. Next
//     are the records of the data with which the host started. The host
//     does not use the RNG of the compiler, but has an array of "random"
//     numbers. The entire source code for VCR is on file, but not for
//     public knowledge.
//     This library does not grant access to the VCR.HST file.
//     This structure is only here for reference.
// 9.  Like SHIP.HST and PDATA.HST, BDATA.HST also contains a short at the
//     start of the file, always set to 0x0000. On the player's side, it's
//     used to determine the amount of starbases in BDATA??.DAT.
// 10. The mine field data file always contains 500 records - one for each
//     mine field. The WinPlan VGAP clients can use this data, while the
//     DosPlan clients can not. This data file was not designed to be sent
//     to the players, but is transmitted in the RST file. Hence, it does
//     not contain a short to determine the amount of fields as the
//     databases sent to the players do.
// 11. The UFO.HST file contains 100 records, which are only sent to WinPlan
//     users. DosPlan users do not see UFOs unless UFO4DOS or UFO4VPA is
//     used - or something similar..
// 12. The GREY.HST file contains the information about ion disturbances.
//     There are up to 50 of them. The "reserved" field could well be an
//     indication whether the disturbance is growing or weakening.. It could
//     also be a pointer to the name. I'm looking into this now..
// 13. The GREY.HST also contain the alliances between the races, set with
//     the ffN friendly codes. These are not always stored - when no
//     alliances have been set, they are not stored. This is probably
//     because alliances are fairly new in the game - at least, host-side
//     support for alliances are.
//     Alliances are stored as 16-bit integers, of which 5 bits are paddding
//     and not interesting. The rest is interesting: bites 0 thru 10
//     correspond with races 1 thru 11. Race N has an alliance with race X
//     when (raceN & (1 << (X - 1)) != 0. Thus, race N can't attack race X.
//     The macros isAllied() returns true of race n is allied to race x. A
//     is a parameter of allianceType.
// 14. The passwords in GEN.HST cannot be read (yet).
***************************************************************************/
#ifdef __cplusplus
}
#endif
#endif // VPL_H
