################################################################################
#
# GNU MAKE (3.79.1) Makefile for PDCurses library - DOS DJGPP V2.0+
#
# Usage: make -f [path\]gccdos.mak [-DDEBUG] [target]
#
# where target can be any of:
# [all|libs|demos|dist|install|pdcurses.a|panel.a|testcurs.exe...]
#
################################################################################
#
# First, set the environment variable PDCURSES_SRCDIR, or edit the line 
# below; for example, "set PDCURSES_SRCDIR=c:\pdcurses".
#
################################################################################
PDCURSES_HOME	= $(PDCURSES_SRCDIR)
################################################################################
# Nothing below here should require changing.
################################################################################
# This reproduces the standard installation directory tree of a
# stock DJGPP distribution.
#
# It will install the products in the standard places for a stock
# DJGPP installation given by the value of the environment variable
# DJDIR.
# If the user prefers to install in some other directory, he must
# supply a new value for the variable prefix at the command line
# like this:
#   make -f [path\]gccdos.mak install prefix=/some/other/dir
################################################################################
prefix		= /dev/env/DJDIR
includedir	= $(prefix)/include
libdir		= $(prefix)/lib
docdir		= $(prefix)/contrib/pdcurses.$(VER)
mandir		= $(prefix)/contrib/pdcurses.$(VER)/man


RM		= /dev/env/DJDIR/bin/rm
INSTALL		= /dev/env/DJDIR/bin/ginstall

O = o

include $(PDCURSES_HOME)/version.mif
include $(PDCURSES_HOME)/libobjs.mif

osdir		= $(PDCURSES_HOME)/dos

PDCURSES_DOS_H	= $(osdir)/pdcdos.h

CC		= gcc

ifeq ($(DEBUG),Y)
	CFLAGS  = -g -Wall -DPDCDEBUG
	LDFLAGS = -g
else
	CFLAGS  = -O2 -Wall
	LDFLAGS =
endif

CPPFLAGS	= -I$(PDCURSES_HOME) -funsigned-char

CCFLAGS		= $(CFLAGS) $(CPPFLAGS)

LINK		= gcc

LIBEXE		= ar
LIBFLAGS	= rcv

LIBCURSES	= libpdcurses.a
LIBPANEL	= libpanel.a

PDCLIBS		= $(LIBCURSES) $(LIBPANEL)

################################################################################
.PHONY: all libs clean demos dist install

all:	libs demos

libs:	$(PDCLIBS)

clean:
	-del *.o
	-del $(LIBCURSES)
	-del $(LIBPANEL)
	-del *.exe

demos:	$(DEMOS)
	strip *.exe

#------------------------------------------------------------------------

$(LIBCURSES) : $(LIBOBJS) $(PDCOBJS)
	$(LIBEXE) $(LIBFLAGS) $@ $(LIBOBJS) $(PDCOBJS)

$(LIBPANEL) : $(PANOBJS)
	$(LIBEXE) $(LIBFLAGS) $@ $(PANOBJS)

$(LIBOBJS) $(PDCOBJS) $(PANOBJS) : $(PDCURSES_HEADERS)
$(PDCOBJS) : $(PDCURSES_DOS_H)
$(PANOBJS) : $(PANEL_HEADER)
$(DEMOS) : $(PDCURSES_CURSES_H) $(LIBCURSES)
terminfo.o: $(TERM_HEADER)

$(LIBOBJS) : %.o: $(srcdir)/%.c
	$(CC) -c $(CCFLAGS) $<

$(PDCOBJS) : %.o: $(osdir)/%.c
	$(CC) -c $(CCFLAGS) $<

$(PANOBJS) : %.o: $(pandir)/%.c
	$(CC) -c $(CCFLAGS) $<

#------------------------------------------------------------------------

firework.exe newdemo.exe rain.exe testcurs.exe worm.exe xmas.exe: \
%.exe: $(demodir)/%.c
	$(CC) $(CCFLAGS) -o$@ $< $(LIBCURSES)

ptest.exe: $(demodir)/ptest.c $(PANEL_HEADER) $(LIBPANEL)
	$(CC) $(CCFLAGS) -o$@ $< $(LIBCURSES) $(LIBPANEL)

tuidemo.exe: tuidemo.o tui.o
	$(LINK) $(LDFLAGS) -o$@ tuidemo.o tui.o $(LIBCURSES)

tui.o: $(demodir)/tui.c $(demodir)/tui.h $(PDCURSES_CURSES_H)
	$(CC) -c $(CCFLAGS) -I$(demodir) -o$@ $<

tuidemo.o: $(demodir)/tuidemo.c $(PDCURSES_CURSES_H)
	$(CC) -c $(CCFLAGS) -I$(demodir) -o$@ $<

#------------------------------------------------------------------------

install: $(PDCLIBS)
	$(INSTALL) -d $(includedir)
	$(INSTALL) -d $(libdir)
	$(INSTALL) -d $(docdir)
	$(INSTALL) -d $(mandir)
	$(INSTALL) $(PDCURSES_HOME)\curses.h $(includedir)
	$(INSTALL) $(PDCURSES_HOME)\curspriv.h $(includedir)
	$(INSTALL) $(PDCURSES_HOME)\panel.h $(includedir)
	$(INSTALL) $(PDCURSES_HOME)\term.h $(includedir)
	$(INSTALL) $(LIBCURSES) $(libdir)
	$(INSTALL) $(LIBPANEL) $(libdir)
	$(INSTALL) $(PDCURSES_HOME)\README $(docdir)
	$(INSTALL) $(PDCURSES_HOME)\HISTORY $(docdir)
	$(INSTALL) $(PDCURSES_HOME)\maintain.er $(docdir)
	$(INSTALL) $(PDCURSES_HOME)\doc\intro.man $(mandir)
	$(INSTALL) $(PDCURSES_HOME)\doc\latin-1.man $(mandir)
	$(INSTALL) $(PDCURSES_HOME)\doc\overview.man $(mandir)
	$(INSTALL) $(PDCURSES_HOME)\doc\x11.man $(mandir)

#------------------------------------------------------------------------

PLATFORM1 = DJGPP 2.03
PLATFORM2 = DJGPP 2.03 for DOS
ARCNAME = pdc$(VER)djg

include $(PDCURSES_HOME)/makedist.mif
