@echo off
echo Configuring PCRE 8.33 for DJGPP v2.x...

Rem WARNING WARNING WARNING: This file needs to have DOS CRLF end-of-line
Rem format, or else stock DOS/Windows shells will refuse to run it.

Rem The SmallEnv tests protect against fixed and too small size
Rem of the environment in stock DOS shell.

Rem Find out if NLS is wanted or not,
Rem if dependency-tracking is wanted or not,
Rem if caching is wanted or not
Rem and where the sources are.
Rem We always default to NLS support,
Rem no dependency tracking
Rem and to in place configuration.
set ARGS=
set NLS=enabled
if not "%NLS%" == "enabled" goto SmallEnv
set CACHING=enabled
if not "%CACHING%" == "enabled" goto SmallEnv
set DEPENDENCY_TRACKING=disabled
if not "%DEPENDENCY_TRACKING%" == "disabled" goto SmallEnv
set LIBICONV_PREFIX=disabled
if not "%LIBICONV_PREFIX%" == "disabled" goto SmallEnv
set LIBINTL_PREFIX=disabled
if not "%LIBINTL_PREFIX%" == "disabled" goto SmallEnv
set LIBBZ2=enabled
if not "%LIBBZ2%" == "enabled" goto SmallEnv
set LIBZ=enabled
if not "%LIBZ%" == "enabled" goto SmallEnv
set LIBR=enabled
if not "%LIBR%" == "enabled" goto SmallEnv
set CR=disabled
if not "%CR%" == "disabled" goto SmallEnv
set LF=disabled
if not "%LF%" == "disabled" goto SmallEnv
set CRLF=disabled
if not "%CRLF%" == "disabled" goto SmallEnv
set ANY_CRLF=enabled
if not "%ANY_CRLF%" == "enabled" goto SmallEnv
set CPP=enabled
if not "%CPP%" == "enabled" goto SmallEnv
set PCRE8=enabled
if not "%PCRE8%" == "enabled" goto SmallEnv
set PCRE16=disabled
if not "%PCRE16%" == "disabled" goto SmallEnv
set JIT=disabled
if not "%JIT%" == "disabled" goto SmallEnv
set GREPJIT=disabled
if not "%GREPJIT%" == "disabled" goto SmallEnv
set RECSTACK=disabled
if not "%RECSTACK%" == "disabled" goto SmallEnv
set SILENT=enabled
if not "%SILENT%" == "enabled" goto SmallEnv
set CHARTABLES=enabled
if not "%CHARTABLES%" == "enabled" goto SmallEnv
set XSRC=.
if not "%XSRC%" == "." goto SmallEnv

Rem Loop over all arguments.
Rem Special arguments are: NLS, XSRC, CACHE, STATIC_LIBS, LIBICONV_PREFIX, LIBINTL_PREFIX, LIBBZ2, LIBZ, LIBR, CR, LF, CRLF, ANY_CRLF, CPP and DEPS.
Rem All other arguments are stored into ARGS.
:ArgLoop
if "%1" == "nls" goto NextArgument
if "%1" == "NLS" goto NextArgument
if "%1" == "no-nls" goto NoNLS
if "%1" == "no-NLS" goto NoNLS
if "%1" == "NO-NLS" goto NoNLS
goto CachingOption
:NoNLS
if "%1" == "no-nls" set NLS=disabled
if "%1" == "no-NLS" set NLS=disabled
if "%1" == "NO-NLS" set NLS=disabled
if not "%NLS%" == "disabled" goto SmallEnv
goto NextArgument
:CachingOption
if "%1" == "cache" goto NextArgument
if "%1" == "CACHE" goto NextArgument
if "%1" == "no-cache" goto NoCaching
if "%1" == "no-CACHE" goto NoCaching
if "%1" == "NO-CACHE" goto NoCaching
goto DependencyOption
:NoCaching
if "%1" == "no-cache" set CACHING=disabled
if "%1" == "no-CACHE" set CACHING=disabled
if "%1" == "NO-CACHE" set CACHING=disabled
if not "%CACHING%" == "disabled" goto SmallEnv
goto NextArgument
:DependencyOption
if "%1" == "no-dep" goto NextArgument
if "%1" == "no-DEP" goto NextArgument
if "%1" == "NO-DEP" goto NextArgument
if "%1" == "dep" goto _DependencyTraking
if "%1" == "DEP" goto _DependencyTraking
goto LibiconvPrefixOption
:_DependencyTraking
if "%1" == "dep" set DEPENDENCY_TRACKING=enabled
if "%1" == "DEP" set DEPENDENCY_TRACKING=enabled
if not "%DEPENDENCY_TRACKING%" == "enabled" goto SmallEnv
goto NextArgument
:LibiconvPrefixOption
if "%1" == "no-libiconvprefix" goto NextArgument
if "%1" == "no-LIBICONVPREFIX" goto NextArgument
if "%1" == "NO-LIBICONVPREFIX" goto NextArgument
if "%1" == "libiconvprefix" goto WithLibiconvPrefix
if "%1" == "LIBICONVPREFIX" goto WithLibiconvPrefix
goto LibintlPrefixOption
:WithLibiconvPrefix
if "%1" == "libiconvprefix" set LIBICONV_PREFIX=enabled
if "%1" == "LIBICONVPREFIX" set LIBICONV_PREFIX=enabled
if not "%LIBICONV_PREFIX%" == "enabled" goto SmallEnv
goto NextArgument
:LibintlPrefixOption
if "%1" == "no-libintlprefix" goto NextArgument
if "%1" == "no-LIBINTLPREFIX" goto NextArgument
if "%1" == "NO-LIBINTLPREFIX" goto NextArgument
if "%1" == "libintlprefix" goto _WithLibintlPrefix
if "%1" == "LIBINTLPREFIX" goto _WithLibintlPrefix
goto LIBBZ2Option
:_WithLibintlPrefix
if "%1" == "libintlprefix" set LIBINTL_PREFIX=enabled
if "%1" == "LIBINTLPREFIX" set LIBINTL_PREFIX=enabled
if not "%LIBINTL_PREFIX%" == "enabled" goto SmallEnv
goto NextArgument
:LIBBZ2Option
if "%1" == "lbz2" goto NextArgument
if "%1" == "LBZ2" goto NextArgument
if "%1" == "no-lbz2" goto 1WithoutLIBBZ2
if "%1" == "no-LBZ2" goto 1WithoutLIBBZ2
if "%1" == "NO-LBZ2" goto 1WithoutLIBBZ2
goto LIBZOption
:1WithoutLIBBZ2
if "%1" == "no-lbz2" set LIBBZ2=disabled
if "%1" == "no-LBZ2" set LIBBZ2=disabled
if "%1" == "NO-LBZ2" set LIBBZ2=disabled
if not "%LIBBZ2%" == "disabled" goto SmallEnv
goto NextArgument
:LIBZOption
if "%1" == "lz" goto NextArgument
if "%1" == "LZ" goto NextArgument
if "%1" == "no-lz" goto 2WithoutLIBZ
if "%1" == "no-LZ" goto 2WithoutLIBZ
if "%1" == "NO-LZ" goto 2WithoutLIBZ
goto LIBROption
:2WithoutLIBZ
if "%1" == "no-lz" set LIBZ=disabled
if "%1" == "no-LZ" set LIBZ=disabled
if "%1" == "NO-LZ" set LIBZ=disabled
if not "%LIBZ%" == "disabled" goto SmallEnv
goto NextArgument
:LIBROption
if "%1" == "rl" goto NextArgument
if "%1" == "RL" goto NextArgument
if "%1" == "no-rl" goto 3WithoutLIBR
if "%1" == "no-RL" goto 3WithoutLIBR
if "%1" == "NO-RL" goto 3WithoutLIBR
goto CROption
:3WithoutLIBR
if "%1" == "no-rl" set LIBZ=disabled
if "%1" == "no-RL" set LIBZ=disabled
if "%1" == "NO-RL" set LIBZ=disabled
if not "%LIBZ%" == "disabled" goto SmallEnv
goto NextArgument
:CROption
if "%1" == "no-cr" goto NextArgument
if "%1" == "no-CR" goto NextArgument
if "%1" == "NO-CR" goto NextArgument
if "%1" == "cr" goto WithCR
if "%1" == "CR" goto WithCR
goto LFOption
:WithCR
if "%1" == "cr" set CR=enabled
if "%1" == "CR" set CR=enabled
if not "%CR%" == "enabled" goto SmallEnv
goto NextArgument
:LFOption
if "%1" == "no-lf" goto NextArgument
if "%1" == "no-LF" goto NextArgument
if "%1" == "NO-LF" goto NextArgument
if "%1" == "lf" goto WithLF
if "%1" == "LF" goto WithLF
goto CRLFOption
:WithLF
if "%1" == "lf" set LF=enabled
if "%1" == "LF" set LF=enabled
if not "%LF%" == "enabled" goto SmallEnv
goto NextArgument
:CRLFOption
if "%1" == "no-crlf" goto NextArgument
if "%1" == "no-CRLF" goto NextArgument
if "%1" == "NO-CRLF" goto NextArgument
if "%1" == "crlf" goto WithCRLF
if "%1" == "CRLF" goto WithCRLF
goto ANY_CRLFOption
:WithCRLF
if "%1" == "crlf" set CRLF=enabled
if "%1" == "CRLF" set CRLF=enabled
if not "%CRLF%" == "enabled" goto SmallEnv
goto NextArgument
:ANY_CRLFOption
if "%1" == "any-crlf" goto NextArgument
if "%1" == "any-CRLF" goto NextArgument
if "%1" == "ANY-CRLF" goto NextArgument
if "%1" == "no-any-crlf" goto 4WithoutANY_CRLF
if "%1" == "no-any-CRLF" goto 4WithoutANY_CRLF
if "%1" == "no-ANY-CRLF" goto 4WithoutANY_CRLF
if "%1" == "NO-ANY-CRLF" goto 4WithoutANY_CRLF
goto CPPOption
:4WithoutANY_CRLF
if "%1" == "no-any-crlf" set ANY_CRLF=disabled
if "%1" == "no-any-CRLF" set ANY_CRLF=disabled
if "%1" == "no-ANY-CRLF" set ANY_CRLF=disabled
if "%1" == "NO-ANY-CRLF" set ANY_CRLF=disabled
if not "%ANY_CRLF%" == "disabled" goto SmallEnv
goto NextArgument
:CPPOption
if "%1" == "cpp" goto NextArgument
if "%1" == "CPP" goto NextArgument
if "%1" == "no-cpp" goto NoCPPSupport
if "%1" == "no-CPP" goto NoCPPSupport
if "%1" == "NO-CPP" goto NoCPPSupport
goto Pcre8Option
:NoCPPSupport
if "%1" == "no-cpp" set CPP=disabled
if "%1" == "no-CPP" set CPP=disabled
if "%1" == "NO-CPP" set CPP=disabled
if not "%CPP%" == "disabled" goto SmallEnv
goto NextArgument
:Pcre8Option
if "%1" == "pcre8" goto NextArgument
if "%1" == "PCRE8" goto NextArgument
if "%1" == "no-pcre8" goto NoPCRE8
if "%1" == "no-PCRE8" goto NoPCRE8
if "%1" == "NO-PCRE8" goto NoPCRE8
goto Pcre16Option
:NoPCRE8
if "%1" == "no-pcre8" set PCRE8=disabled
if "%1" == "no-PCRE8" set PCRE8=disabled
if "%1" == "NO-PCRE8" set PCRE8=disabled
if not "%PCRE8%" == "disabled" goto SmallEnv
goto NextArgument
:Pcre16Option
if "%1" == "no-pcre16" goto NextArgument
if "%1" == "no-PCRE16" goto NextArgument
if "%1" == "NO-PCRE16" goto NextArgument
if "%1" == "pcre16" goto _PCRE16
if "%1" == "Pcre16" goto _PCRE16
if "%1" == "PCRE16" goto _PCRE16
goto JitOption
:_PCRE16
if "%1" == "pcre16" set PCRE16=enabled
if "%1" == "Pcre16" set PCRE16=enabled
if "%1" == "PCRE16" set PCRE16=enabled
if not "%PCRE16%" == "enabled" goto SmallEnv
goto NextArgument
:JitOption
if "%1" == "no-jit" goto NextArgument
if "%1" == "no-JIT" goto NextArgument
if "%1" == "NO-JIT" goto NextArgument
if "%1" == "jit" goto _JIT
if "%1" == "Jit" goto _JIT
if "%1" == "JIT" goto _JIT
goto GrepJitOption
:_JIT
if "%1" == "jit" set JIT=enabled
if "%1" == "Jit" set JIT=enabled
if "%1" == "JIT" set JIT=enabled
if not "%JIT%" == "enabled" goto SmallEnv
goto NextArgument
:GrepJitOption
if "%1" == "no-grepjit" goto NextArgument
if "%1" == "no-GREPJIT" goto NextArgument
if "%1" == "NO-GREPJIT" goto NextArgument
if "%1" == "grepjit" goto _GREPJIT
if "%1" == "GrepJit" goto _GREPJIT
if "%1" == "GREPJIT" goto _GREPJIT
goto RecStackOption
:_GREPJIT
if "%1" == "grepjit" set GREPJIT=enabled
if "%1" == "GrepJit" set GREPJIT=enabled
if "%1" == "GREPJIT" set GREPJIT=enabled
if not "%GREPJIT%" == "enabled" goto SmallEnv
goto NextArgument
:RecStackOption
if "%1" == "no-recstack" goto NextArgument
if "%1" == "no-RECSTACK" goto NextArgument
if "%1" == "NO-RECSTACK" goto NextArgument
if "%1" == "recstack" goto _RECSTACK
if "%1" == "RecStack" goto _RECSTACK
if "%1" == "RECSTACK" goto _RECSTACK
goto SilentOption
:_RECSTACK
if "%1" == "recstack" set RECSTACK=enabled
if "%1" == "RecStack" set RECSTACK=enabled
if "%1" == "RECSTACK" set RECSTACK=enabled
if not "%RECSTACK%" == "enabled" goto SmallEnv
goto NextArgument
:SilentOption
if "%1" == "silent" goto NextArgument
if "%1" == "SILENT" goto NextArgument
if "%1" == "no-silent" goto NoSILENT
if "%1" == "no-SILENT" goto NoSILENT
if "%1" == "NO-SILENT" goto NoSILENT
goto ChartablesOption
:NoSILENT
if "%1" == "no-silent" set SILENT=disabled
if "%1" == "no-SILENT" set SILENT=disabled
if "%1" == "NO-SILENT" set SILENT=disabled
if not "%SILENT%" == "disabled" goto SmallEnv
goto NextArgument
:ChartablesOption
if "%1" == "chartables" goto NextArgument
if "%1" == "CHARTABLES" goto NextArgument
if "%1" == "no-chartables" goto NoCHARTABLES
if "%1" == "no-CHARTABLES" goto NoCHARTABLES
if "%1" == "NO-CHARTABLES" goto NoCHARTABLES
goto SrcDirOption
:NoCHARTABLES
if "%1" == "no-chartables" set CHARTABLES=disabled
if "%1" == "no-CHARTABLES" set CHARTABLES=disabled
if "%1" == "NO-CHARTABLES" set CHARTABLES=disabled
if not "%CHARTABLES%" == "disabled" goto SmallEnv
goto NextArgument
:SrcDirOption
echo %1 | grep -q "/"
if errorlevel 1 goto CollectArgument
set XSRC=%1
if not "%XSRC%" == "%1" goto SmallEnv
goto NextArgument
:CollectArgument
if "%ARGS%" == "" goto AddFirstArgToList
set _ARGS=%ARGS% %1
goto AddArgToList
:AddFirstArgToList
set _ARGS=%1
:AddArgToList
if not "%_ARGS%" == "%ARGS% %1" if not "%_ARGS%" == "%ARGS%%1" goto SmallEnv
echo %_ARGS% | grep -q "[^ ]"
if not errorlevel 0 set ARGS=%_ARGS%
set _ARGS=
:NextArgument
shift
if not "%1" == "" goto ArgLoop

Rem Make sure no contradicting options are given.
if "%CR%" == "disabled" goto CheckLF
set LF=disabled
set CRLF=disabled
set ANY_CRLF=disabled
goto CreateArgs
:CheckLF
if "%LF%" == "disabled" goto CheckCRLF
set CR=disabled
set CRLF=disabled
set ANY_CRLF=disabled
goto CreateArgs
:CheckCRLF
if "%CRLF%" == "disabled" goto CheckAnyCRLF
set CR=disabled
set LF=disabled
set ANY_CRLF=disabled
goto CreateArgs
:CheckAnyCRLF
if "%ANY_CRLF%" == "disabled" goto
set CR=disabled
set LF=disabled
set CRLF=disabled

:CreateArgs
Rem Create an arguments file for the configure script.
echo --srcdir=%XSRC% > args
:if "%CACHING%" == "enabled"              echo --cache-file=%XSRC%/djgpp/config.cache >> args
if "%CACHING%" == "enabled"              echo --cache-file=./config.cache >> args
if "%DEPENDENCY_TRACKING%" == "enabled"  echo --enable-dependency-tracking >> args
if "%DEPENDENCY_TRACKING%" == "disabled" echo --disable-dependency-tracking >> args
if "%LIBICONV_PREFIX%" == "enabled"      echo --with-libiconv-prefix >> args
if "%LIBICONV_PREFIX%" == "disabled"     echo --without-libiconv-prefix >> args
if "%LIBINTL_PREFIX%" == "enabled"       echo --with-libintl-prefix >> args
if "%LIBINTL_PREFIX%" == "disabled"      echo --without-libintl-prefix >> args
if "%LIBBZ2%" == "enabled"               echo --enable-pcregrep-libbz2 >> args
if "%LIBBZ2%" == "disabled"              echo --disable-pcregrep-libbz2 >> args
if "%LIBZ%" == "enabled"                 echo --enable-pcregrep-libz >> args
if "%LIBZ%" == "disabled"                echo --disable-pcregrep-libz >> args
if "%LIBR%" == "enabled"                 echo --enable-pcretest-libreadline >> args
if "%LIBR%" == "disabled"                echo --disable-pcretest-libreadline >> args
if "%CR%" == "enabled"                   echo --enable-newline-is-cr >> args
if "%CR%" == "disabled"                  echo --disable-newline-is-cr >> args
if "%LF%" == "enabled"                   echo --enable-newline-is-lf >> args
if "%LF%" == "disabled"                  echo --disable-newline-is-lf >> args
if "%CRLF%" == "enabled"                 echo --enable-newline-is-crlf >> args
if "%CRLF%" == "disabled"                echo --disable-newline-is-crlf >> args
if "%ANY_CRLF%" == "enabled"             echo --enable-newline-is-anycrlf >> args
if "%ANY_CRLF%" == "disabled"            echo --disable-newline-is-anycrlf >> args
if "%CPP%" == "enabled"                  echo --enable-cpp >> args
if "%CPP%" == "disabled"                 echo --disable-cpp >> args
if "%PCRE8%" == "enabled"                echo --enable-pcre8 >> args
if "%PCRE8%" == "disabled"               echo --disable-pcre8 >> args
if "%PCRE16%" == "enabled"               echo --enable-pcre16 >> args
if "%PCRE16%" == "disabled"              echo --disable-pcre16 >> args
if "%JIT%" == "enabled"                  echo --enable-jit >> args
if "%JIT%" == "disabled"                 echo --disable-jit >> args
if "%GREPJIT%" == "enabled"              echo --enable-pcregrep-jit >> args
if "%GREPJIT%" == "disabled"             echo --disable-pcregrep-jit >> args
if "%RECSTACK%" == "enabled"             echo --enable-stack-for-recursion >> args
if "%RECSTACK%" == "disabled"            echo --disable-stack-for-recursion >> args
if "%SILENT%" == "enabled"               echo --enable-silent-rules >> args
if "%SILENT%" == "disabled"              echo --disable-silent-rules >> args
if "%CHARTABLES%" == "enabled"           echo --enable-rebuild-chartables >> args
if "%CHARTABLES%" == "disabled"          echo --disable-rebuild-chartables >> args
if not "%ARGS%" == ""                    echo %ARGS% >> args
echo --prefix=/dev/env/DJDIR >> args

set ARGS=
set CACHING=
set DEPENDENCY_TRACKING=
set LIBICONV_PREFIX=
set LIBINTL_PREFIX=
set LIBBZ2=
set LIBZ=
set LIBR=
set CR=
set LF=
set CRLF=
set ANY_CRLF=
set CPP=
set PCRE8=
set PCRE16=
set JIT=
set GREPJIT=
set RECSTACK=
set SILENT=
set CHARTABLES=

if "%XSRC%" == "." goto InPlace

:NotInPlace
redir -e /dev/null update %XSRC%/configure.org ./configure
test -f ./configure
if errorlevel 1 update %XSRC%/configure ./configure

:InPlace
Rem Update configuration files
echo Updating configuration scripts...
test -f ./configure.org
if errorlevel 1 update configure configure.org
sed -f %XSRC%/djgpp/config.sed configure.org > filename.ext
if errorlevel 1 goto SedError
sed "/symlink /s/`//g" ./filename.ext > ./configure
rm -f ./filename.ext

Rem Make sure they have a config.site file
set CONFIG_SITE=%XSRC%/djgpp/config.site
if not "%CONFIG_SITE%" == "%XSRC%/djgpp/config.site" goto SmallEnv

Rem Make sure crucial file names are not munged by unpacking
test -f %XSRC%/config.h.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/config.h.in %XSRC%/config.h-in
test -f %XSRC%/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/config.h %XSRC%/config.h-in
test -f %XSRC%/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/configh.in %XSRC%/config.h-in
test -f %XSRC%/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/config_h.in %XSRC%/config.h-in
test -f %XSRC%/config.h.generic
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/config.h.generic %XSRC%/config.h-generic
test -f %XSRC%/config.h-generic
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/config.h %XSRC%/config.h-generic
test -f %XSRC%/config.h-generic
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/configh.generic %XSRC%/config.h-generic
test -f %XSRC%/config.h-generic
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/config_h.generic %XSRC%/config.h-generic
test -f %XSRC%/po/Makefile.am.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.am.in %XSRC%/po/Makefile.am-in
test -f %XSRC%/po/Makefile.am-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.am %XSRC%/po/Makefile.am-in
test -f %XSRC%/po/Makefile.in.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.in.in %XSRC%/po/Makefile.in-in
test -f %XSRC%/po/Makefile.in-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.in %XSRC%/po/Makefile.in-in
test -f %XSRC%/libpcre.pc.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/libpcre.pc.in %XSRC%/libpcre.pc-in
test -f %XSRC%/libpcre.pc-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/libpcre.pc %XSRC%/libpcre.pc-in
test -f %XSRC%/libpcre.pc-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/libpcrepc.in %XSRC%/libpcre.pc-in
test -f %XSRC%/libpcre.pc-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/libpcre_pc.in %XSRC%/libpcre.pc-in
test -f %XSRC%/libpcre16.pc.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/libpcre16.pc.in %XSRC%/libpcre16.pc-in
test -f %XSRC%/libpcre16.pc-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/libpcre16.pc %XSRC%/libpcre16.pc-in
test -f %XSRC%/libpcre16.pc-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/libpcre16pc.in %XSRC%/libpcre16.pc-in
test -f %XSRC%/libpcre16.pc-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/libpcre16_pc.in %XSRC%/libpcre16.pc-in
test -f %XSRC%/libpcreposix.pc.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/libpcreposix.pc.in %XSRC%/libpcreposix.pc-in
test -f %XSRC%/libpcreposix.pc-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/libpcreposix.pc %XSRC%/libpcreposix.pc-in
test -f %XSRC%/libpcreposix.pc-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/libpcreposixpc.in %XSRC%/libpcreposix.pc-in
test -f %XSRC%/libpcreposix.pc-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/libpcreposix_pc.in %XSRC%/libpcreposix.pc-in
test -f %XSRC%/libpcrecpp.pc.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/libpcrecpp.pc.in %XSRC%/libpcrecpp.pc-in
test -f %XSRC%/libpcrecpp.pc-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/libpcrecpp.pc %XSRC%/libpcrecpp.pc-in
test -f %XSRC%/libpcrecpp.pc-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/libpcrecpppc.in %XSRC%/libpcrecpp.pc-in
test -f %XSRC%/libpcrecpp.pc-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/libpcrecpp_pc.in %XSRC%/libpcrecpp.pc-in
test -f %XSRC%/pcrecpparg.h.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcrecpparg.h.in %XSRC%/pcrecpparg.h-in
test -f %XSRC%/pcrecpparg.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcrecpparg.h %XSRC%/pcrecpparg.h-in
test -f %XSRC%/pcrecpparg.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcrecppargh.in %XSRC%/pcrecpparg.h-in
test -f %XSRC%/pcrecpparg.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcrecpparg_h.in %XSRC%/pcrecpparg.h-in
test -f %XSRC%/pcre.h.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcre.h.in %XSRC%/pcre.h-in
test -f %XSRC%/pcre.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcre.h %XSRC%/pcre.h-in
test -f %XSRC%/pcre.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcreh.in %XSRC%/pcre.h-in
test -f %XSRC%/pcre.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcre_h.in %XSRC%/pcre.h-in
test -f %XSRC%/pcre.h.generic
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcre.h.generic %XSRC%/pcre.h-generic
test -f %XSRC%/pcre.h-generic
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcre.h %XSRC%/pcre.h-generic
test -f %XSRC%/pcre.h-generic
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcreh.generic %XSRC%/pcre.h-generic
test -f %XSRC%/pcre.h-generic
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcre_h.generic %XSRC%/pcre.h-generic
test -f %XSRC%/pcre_chartables.c.dist
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcre_chartables.c.dist %XSRC%/pcre_chartables.c-dist
test -f %XSRC%/pcre_chartables.c-dist
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcre_chartables.c %XSRC%/pcre_chartables.c-dist
test -f %XSRC%/pcre_chartables.c-dist
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcre_chartablesc.dist %XSRC%/pcre_chartables.c-dist
test -f %XSRC%/pcre_chartables.c-dist
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcre_chartables_c.dist %XSRC%/pcre_chartables.c-dist
test -f %XSRC%/pcre_stringpiece.h.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcre_stringpiece.h.in %XSRC%/pcre_stringpiece.h-in
test -f %XSRC%/pcre_stringpiece.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcre_stringpiece.h %XSRC%/pcre_stringpiece.h-in
test -f %XSRC%/pcre_stringpiece.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcre_stringpieceh.in %XSRC%/pcre_stringpiece.h-in
test -f %XSRC%/pcre_stringpiece.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/pcre_stringpiece_h.in %XSRC%/pcre_stringpiece.h-in
:# Beginn  Zusaetzliche zu veraendernde Dateinamen.
:test -f %XSRC%/man/libpcre.in
:if not errorlevel redir -e /dev/null 1 mv -f %XSRC%/man/libpcre..in %XSRC%/man/libpcre.-in
:test -f %XSRC%/man/libpcre.-in
:if errorlevel 1 redir -e /dev/null mv -f %XSRC%/man/libpcre. %XSRC%/man/libpcre.-in
:# Ende  Zusaetzliche zu veraendernde Dateinamen.

Rem Update libtool files
echo Updating libtool scripts...
test -f %XSRC%/ltmain.org
if errorlevel 1 update %XSRC%/ltmain.sh %XSRC%/ltmain.org
sed -f %XSRC%/djgpp/ltmain.sed %XSRC%/ltmain.org > ltmain.tmp
if errorlevel 1 goto SedError6
mv -f ltmain.tmp %XSRC%/ltmain.sh

Rem This is required because DOS/Windows are case-insensitive
Rem to file names, and "make install" will do nothing if Make
Rem finds a file called `install'.
if exist INSTALL ren INSTALL INSTALL.txt

Rem Set SHELL to a sane default or some configure tests stop working
Rem if the package is configured across partitions.
if not "%SHELL%" == "" goto HomeName
set SHELL=/bin/sh
if not "%SHELL%" == "/bin/sh" goto SmallEnv
echo No SHELL found in the environment, using default value

:HomeName
Rem Set HOME to a sane default so configure stops complaining.
if not "%HOME%" == "" goto HostName
set HOME=%XSRC%/djgpp
if not "%HOME%" == "%XSRC%/djgpp" goto SmallEnv
echo No HOME found in the environment, using default value

:HostName
Rem Set HOSTNAME so it shows in config.status
if not "%HOSTNAME%" == "" goto hostdone
if "%windir%" == "" goto msdos
set OS=MS-Windows
if not "%OS%" == "MS-Windows" goto SmallEnv
goto haveos
:msdos
set OS=MS-DOS
if not "%OS%" == "MS-DOS" goto SmallEnv
:haveos
if not "%USERNAME%" == "" goto haveuname
if not "%USER%" == "" goto haveuser
echo No USERNAME and no USER found in the environment, using default values
set HOSTNAME=Unknown PC
if not "%HOSTNAME%" == "Unknown PC" goto SmallEnv
goto userdone
:haveuser
set HOSTNAME=%USER%'s PC
if not "%HOSTNAME%" == "%USER%'s PC" goto SmallEnv
goto userdone
:haveuname
set HOSTNAME=%USERNAME%'s PC
if not "%HOSTNAME%" == "%USERNAME%'s PC" goto SmallEnv
:userdone
set _HOSTNAME=%HOSTNAME%, %OS%
if not "%_HOSTNAME%" == "%HOSTNAME%, %OS%" goto SmallEnv
set HOSTNAME=%_HOSTNAME%
:hostdone
set _HOSTNAME=
set OS=

Rem install-sh is required by the configure script but clashes with the
Rem various Makefile install-foo targets, so we MUST have it before the
Rem script runs and rename it afterwards
test -f %XSRC%/install-sh
if not errorlevel 1 goto NoRen0
test -f %XSRC%/install-sh.sh
if not errorlevel 1 mv -f %XSRC%/install-sh.sh %XSRC%/install-sh
:NoRen0

if "%NLS%" == "disabled" goto WithoutNLS

:WithNLS
test -d %XSRC%/po
if errorlevel 1 goto WithoutNLS

Rem Check for the needed libraries and binaries.
test -x /dev/env/DJDIR/bin/msgfmt.exe
if errorlevel 1 goto MissingNLSTools
test -x /dev/env/DJDIR/bin/xgettext.exe
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/libcharset.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libcharset.a
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/iconv.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libiconv.a
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/libintl.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libintl.a
if errorlevel 1 goto MissingNLSTools

Rem Recreate the files in the %XSRC%/po subdir with our ported tools.
redir -e /dev/null rm %XSRC%/po/*.gmo
redir -e /dev/null rm %XSRC%/po/libpcre.pot
redir -e /dev/null rm %XSRC%/po/cat-id-tbl.c
redir -e /dev/null rm %XSRC%/po/stamp-cat-id

Rem Update the arguments file for the configure script.
Rem We prefer without-included-gettext because libintl.a from gettext package
Rem is the only one that is garanteed to have been ported to DJGPP.
echo --enable-nls --without-included-gettext >> args
goto ConfigurePackage

:MissingNLSTools
echo Needed DJGPP ports of the required libs/tools for NLS support not found.
echo Configuring without NLS.
:WithoutNLS
Rem Update the arguments file for the configure script.
echo --disable-nls >> args

:ConfigurePackage
echo Running the ./configure script...
sh ./configure @args
if errorlevel 1 goto RunConfigStatus
rm args
echo Done.
goto EditFiles
:RunConfigStatus
test -f ./config.status
if errorlevel 1 goto CfgError
echo Running the ./config.status script (manually)...
redir -e /dev/null sh ./config.status
if errorlevel 1 goto CfgError
rm args
echo Done.

:EditFiles
dtou %XSRC%/testdata/grepoutput
goto End


:SedError
echo ./configure script editing failed!
goto End

:SedError6
echo ./ltmain.sh editing failed!
goto End

:CfgError
echo ./configure script exited abnormally!
goto End

:SmallEnv
echo Your environment size is too small.  Enlarge it and run me again.
echo Configuration NOT done!

:End
test -f %XSRC%/install-sh.sh
if not errorlevel 1 goto NoRen1
test -f %XSRC%/install-sh
if not errorlevel 1 mv -f %XSRC%/install-sh %XSRC%/install-sh.sh
:NoRen1
if "%SHELL%" == "/bin/sh" set SHELL=
if "%HOME%" == "%XSRC%/djgpp" set HOME=
set ARGS=
set CONFIG_SITE=
set HOSTNAME=
set NLS=
set CACHING=
set DEPENDENCY_TRACKING=
set PCRE8=
set PCRE16=
set JIT=
set GREPJIT=
set RECSTACK=
set SILENT=
set CHARTABLES=
set XSRC=
