/*
 * Copyright (c) 2000 Todd C. Miller <Todd.Miller@courtesan.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include "config.h"

#ifndef HAVE_STRERROR

#include <stdio.h>
#include <errno.h>

#include <extern.h>

#ifndef lint
static const char rcsid[] = "$Id: strerror.c,v 1.2 2004/04/26 18:31:35 millert Exp $";
#endif /* lint */

/*
 * Map errno -> error string.
 */
char *
strerror(n)
	int n;
{
	extern int sys_nerr;
	extern char *sys_errlist[];

	if (n > 0 && n < sys_nerr)
		return(sys_errlist[n]);
	else
		return("Unknown error");
}

#endif /* HAVE_STRERROR */
