/****************************************************************************/
/* TTAB                                                                     */
/*--------------------------------------------------------------------------*/
/* Objet TTab (onglet)                                                      */
/*--------------------------------------------------------------------------*/
/* Auteur     : DELPRAT Jean-Pierre                                         */
/* Cr le    : 30/05/95                                                    */
/****************************************************************************/

#include <stdlib.h>

#include "Const.h"
#include "JPDebug.h"

#include "Callback.h"

#include "TTabGrp.h"

#include "TTab.h"


/*ͻ*/
/*                           METHODES PUBLIQUES                           */
/*ͼ*/

/****************************************************************************/
/* Constructeur                                                             */
/*--------------------------------------------------------------------------*/
/* tab_group        : Groupe d'onglets auquel appartient l'onglet           */
/* caption          : Lgende du groupe (hot-key prcd de ~)              */
/* enabled          : ENABLED si le groupe est activable (DISABLED sinon)   */
/****************************************************************************/

TTab::TTab(PTabGroup tab_group,
	   const char *caption)

     :TGroup(tab_group,
	     OBJ_TAB,
	     0,1,
             tab_group->m_get_width(),
             tab_group->m_get_height()-1,
	     tab_group->m_get_background(),
             caption,
             ENABLED,
	     TRUE,  // FOCUS_DEPENDING_ASPECT,
	     TRUE,  // CAN_BE_ENABLED
	     FALSE) // NEED_NOT_FOCUSED_ELEMENT

{
  // Callbacks

  InitCallback(f_visible_action,f_visible_argument);
}

/****************************************************************************/
/* Destructeur                                                              */
/*--------------------------------------------------------------------------*/
/****************************************************************************/

TTab::~TTab()
{
  // Destruction des variables dynamiques

  DestroyCallback(f_visible_action,f_visible_argument);

}

/****************************************************************************/
/* m_set_visible                                                            */
/*--------------------------------------------------------------------------*/
/* Si possible, rend l'onglet visible                                       */
/****************************************************************************/

void TTab::m_set_visible()
{
  ((PTabGroup)f_parent)->m_set_visible_tab(f_number);
}

/****************************************************************************/
/* m_set_visible_callback                                                   */
/*--------------------------------------------------------------------------*/
/* Dfinition du callback appel quand l'onglet devient visible             */
/****************************************************************************/

void TTab::m_set_visible_callback(void (*visible_action)(TObject *, const char *),
				  const char *visible_argument)
{
  SetCallback(f_visible_action,f_visible_argument,
	      visible_action,visible_argument);
}

/*ͻ*/
/*                          METHODES PROTEGEES                            */
/*ͼ*/

/**************************/
/* m_display : Affichage  */
/* ---------   de l'objet */
/**************************/

void TTab::m_display()
{
  // On appelle cette fonction
  // car elle n'est pas appele par
  // la mthode de TObject si cet onglet est ferm

  m_display_caption();

  // Affichage du reste du groupe

  TGroup::m_display();
}


/**********************************************************************/
/* m_display_focus_depending_part : Affichage de la partie de l'objet */
/* ------------------------------   dont l'aspect dpend du focus     */
/**********************************************************************/

void TTab::m_display_focus_depending_part()
{
  m_display_caption();
}

/****************************************************************************/
/* m_display_caption                                                        */
/*--------------------------------------------------------------------------*/
/* Affichage de la lgende de l'objet                                       */
/****************************************************************************/

void TTab::m_display_caption()
{
  if (f_open)
    ((PTabGroup)f_parent)->m_display_tab_caption(f_number);
}

/****************************************/
/* m_take_focus : Appele quand l'objet */
/* ------------   prend le focus        */
/****************************************/

void TTab::m_take_focus()
{
  if (f_focused)
    return;
  TGroup::m_take_focus();
  if (!f_focused)
    return;

  m_set_visible();

  JPDEBUG_TEST(DEBUG_ERROR_16,f_number==(((PTabGroup)f_parent)->f_visible_tab->object->m_get_number()));
}

/*ͻ*/
/*                            METHODES PRIVEES                            */
/*ͼ*/

