/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Fri Jan 27 20:18:49 EST 2006 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2hc -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -n 3 -dit -name hf_3 -include hf.h */

/*
 * This function contains 16 FP additions, 14 FP multiplications,
 * (or, 6 additions, 4 multiplications, 10 fused multiply/add),
 * 21 stack variables, and 12 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.8 2006-01-05 03:04:27 stevenj Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.15 2006-01-05 03:04:27 stevenj Exp $
 */

#include "hf.h"

static const R *hf_3(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 4, MAKE_VOLATILE_STRIDE(ios)) {
	  E T1, Tm, T3, T6, Tj, Td, T5, Tg, T4, Th, T7;
	  {
	       E T9, Tc, T8, Tb, T2, Ti, Ta;
	       T1 = rio[0];
	       T9 = rio[WS(ios, 2)];
	       Tc = iio[0];
	       T8 = W[2];
	       Tb = W[3];
	       Tm = iio[-WS(ios, 2)];
	       T3 = rio[WS(ios, 1)];
	       Ti = T8 * Tc;
	       Ta = T8 * T9;
	       T6 = iio[-WS(ios, 1)];
	       T2 = W[0];
	       Tj = FNMS(Tb, T9, Ti);
	       Td = FMA(Tb, Tc, Ta);
	       T5 = W[1];
	       Tg = T2 * T6;
	       T4 = T2 * T3;
	  }
	  Th = FNMS(T5, T3, Tg);
	  T7 = FMA(T5, T6, T4);
	  {
	       E Tk, Te, To, Tn, Tl, Tf;
	       Tk = Th - Tj;
	       Tl = Th + Tj;
	       Te = T7 + Td;
	       To = Td - T7;
	       iio[0] = Tl + Tm;
	       Tn = FNMS(KP500000000, Tl, Tm);
	       rio[0] = T1 + Te;
	       Tf = FNMS(KP500000000, Te, T1);
	       rio[WS(ios, 2)] = FMS(KP866025403, To, Tn);
	       iio[-WS(ios, 1)] = FMA(KP866025403, To, Tn);
	       iio[-WS(ios, 2)] = FNMS(KP866025403, Tk, Tf);
	       rio[WS(ios, 1)] = FMA(KP866025403, Tk, Tf);
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 3},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 3, "hf_3", twinstr, &GENUS, {6, 4, 10, 0}, 0, 0, 0 };

void X(codelet_hf_3) (planner *p) {
     X(khc2hc_register) (p, hf_3, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2hc -compact -variables 4 -pipeline-latency 4 -n 3 -dit -name hf_3 -include hf.h */

/*
 * This function contains 16 FP additions, 12 FP multiplications,
 * (or, 10 additions, 6 multiplications, 6 fused multiply/add),
 * 15 stack variables, and 12 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.8 2006-01-05 03:04:27 stevenj Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.15 2006-01-05 03:04:27 stevenj Exp $
 */

#include "hf.h"

static const R *hf_3(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 4, MAKE_VOLATILE_STRIDE(ios)) {
	  E T1, Ti, T6, Te, Tb, Tf, Tc, Th;
	  T1 = rio[0];
	  Ti = iio[-WS(ios, 2)];
	  {
	       E T3, T5, T2, T4;
	       T3 = rio[WS(ios, 1)];
	       T5 = iio[-WS(ios, 1)];
	       T2 = W[0];
	       T4 = W[1];
	       T6 = FMA(T2, T3, T4 * T5);
	       Te = FNMS(T4, T3, T2 * T5);
	  }
	  {
	       E T8, Ta, T7, T9;
	       T8 = rio[WS(ios, 2)];
	       Ta = iio[0];
	       T7 = W[2];
	       T9 = W[3];
	       Tb = FMA(T7, T8, T9 * Ta);
	       Tf = FNMS(T9, T8, T7 * Ta);
	  }
	  Tc = T6 + Tb;
	  Th = Te + Tf;
	  rio[0] = T1 + Tc;
	  iio[0] = Th + Ti;
	  {
	       E Td, Tg, Tj, Tk;
	       Td = FNMS(KP500000000, Tc, T1);
	       Tg = KP866025403 * (Te - Tf);
	       iio[-WS(ios, 2)] = Td - Tg;
	       rio[WS(ios, 1)] = Td + Tg;
	       Tj = KP866025403 * (Tb - T6);
	       Tk = FNMS(KP500000000, Th, Ti);
	       rio[WS(ios, 2)] = Tj - Tk;
	       iio[-WS(ios, 1)] = Tj + Tk;
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 3},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 3, "hf_3", twinstr, &GENUS, {10, 6, 6, 0}, 0, 0, 0 };

void X(codelet_hf_3) (planner *p) {
     X(khc2hc_register) (p, hf_3, &desc);
}
#endif				/* HAVE_FMA */
