/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Fri Jan 27 20:42:24 EST 2006 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2hc -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -sign 1 -n 9 -dif -name hb_9 -include hb.h */

/*
 * This function contains 96 FP additions, 88 FP multiplications,
 * (or, 24 additions, 16 multiplications, 72 fused multiply/add),
 * 74 stack variables, and 36 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.8 2006-01-05 03:04:27 stevenj Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.15 2006-01-05 03:04:27 stevenj Exp $
 */

#include "hb.h"

static const R *hb_9(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP777861913, +0.777861913430206160028177977318626690410586096);
     DK(KP852868531, +0.852868531952443209628250963940074071936020296);
     DK(KP492403876, +0.492403876506104029683371512294761506835321626);
     DK(KP984807753, +0.984807753012208059366743024589523013670643252);
     DK(KP954188894, +0.954188894138671133499268364187245676532219158);
     DK(KP363970234, +0.363970234266202361351047882776834043890471784);
     DK(KP176326980, +0.176326980708464973471090386868618986121633062);
     DK(KP839099631, +0.839099631177280011763127298123181364687434283);
     DK(KP866025403, +0.866025403784438646763723170752936183471402627);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 16, MAKE_VOLATILE_STRIDE(ios)) {
	  E T20, T1X, T23, T1S, T1T, T1Y, T1U, T1Z, T22, T24, T21;
	  {
	       E T5, Tl, T1f, T1y, TQ, T1J, Tg, Tz, TT, TW, T13, TE, Tw, T10, T1E;
	       E T1L, T1K, T1B;
	       {
		    E T1, Th, T2, T3, Ti, Tj;
		    T1 = rio[0];
		    Th = iio[0];
		    T2 = rio[WS(ios, 3)];
		    T3 = iio[-WS(ios, 6)];
		    Ti = iio[-WS(ios, 3)];
		    Tj = rio[WS(ios, 6)];
		    {
			 E TV, Tb, TS, TR, Ta, Tq, TU, Tr, Ts, TZ, Te, Tt;
			 {
			      E T6, Tm, Tn, To, T9, Tc, Td, Tp;
			      {
				   E T7, T8, TP, T4;
				   T6 = rio[WS(ios, 1)];
				   TP = T2 - T3;
				   T4 = T2 + T3;
				   {
					E T1e, Tk, T1d, TO;
					T1e = Tj + Ti;
					Tk = Ti - Tj;
					T7 = rio[WS(ios, 4)];
					T5 = T1 + T4;
					T1d = FNMS(KP500000000, T4, T1);
					Tl = Th + Tk;
					TO = FNMS(KP500000000, Tk, Th);
					T1f = FMA(KP866025403, T1e, T1d);
					T1y = FNMS(KP866025403, T1e, T1d);
					TQ = FNMS(KP866025403, TP, TO);
					T1J = FMA(KP866025403, TP, TO);
					T8 = iio[-WS(ios, 7)];
				   }
				   Tm = iio[-WS(ios, 1)];
				   Tn = iio[-WS(ios, 4)];
				   To = rio[WS(ios, 7)];
				   T9 = T7 + T8;
				   TV = T7 - T8;
			      }
			      Tb = rio[WS(ios, 2)];
			      TS = To + Tn;
			      Tp = Tn - To;
			      TR = FNMS(KP500000000, T9, T6);
			      Ta = T6 + T9;
			      Tc = iio[-WS(ios, 5)];
			      Td = iio[-WS(ios, 8)];
			      Tq = Tm + Tp;
			      TU = FMS(KP500000000, Tp, Tm);
			      Tr = iio[-WS(ios, 2)];
			      Ts = rio[WS(ios, 5)];
			      TZ = Td - Tc;
			      Te = Tc + Td;
			      Tt = rio[WS(ios, 8)];
			 }
			 {
			      E T11, T12, T1C, Tv, TY, T1D, Tu, Tf, T1A, T1z;
			      T11 = FNMS(KP500000000, Te, Tb);
			      Tf = Tb + Te;
			      Tu = Ts + Tt;
			      T12 = Ts - Tt;
			      Tg = Ta + Tf;
			      Tz = Ta - Tf;
			      TT = FMA(KP866025403, TS, TR);
			      T1C = FNMS(KP866025403, TS, TR);
			      Tv = Tr - Tu;
			      TY = FMA(KP500000000, Tu, Tr);
			      T1D = FNMS(KP866025403, TV, TU);
			      TW = FMA(KP866025403, TV, TU);
			      T13 = FNMS(KP866025403, T12, T11);
			      T1A = FMA(KP866025403, T12, T11);
			      TE = Tv - Tq;
			      Tw = Tq + Tv;
			      T1z = FNMS(KP866025403, TZ, TY);
			      T10 = FMA(KP866025403, TZ, TY);
			      T1E = FMA(KP839099631, T1D, T1C);
			      T1L = FNMS(KP839099631, T1C, T1D);
			      T1K = FMA(KP176326980, T1z, T1A);
			      T1B = FNMS(KP176326980, T1A, T1z);
			 }
		    }
	       }
	       {
		    E T18, T14, T17, TX;
		    rio[0] = T5 + Tg;
		    T18 = FMA(KP363970234, T10, T13);
		    T14 = FNMS(KP363970234, T13, T10);
		    T17 = FMA(KP176326980, TT, TW);
		    TX = FNMS(KP176326980, TW, TT);
		    iio[-WS(ios, 8)] = Tl + Tw;
		    {
			 E TL, TK, TJ, Ty, TD;
			 Ty = FNMS(KP500000000, Tw, Tl);
			 TD = FNMS(KP500000000, Tg, T5);
			 {
			      E Tx, TC, TA, TF, TI;
			      Tx = W[10];
			      TC = W[11];
			      TA = FNMS(KP866025403, Tz, Ty);
			      TL = FMA(KP866025403, Tz, Ty);
			      TF = FNMS(KP866025403, TE, TD);
			      TI = FMA(KP866025403, TE, TD);
			      {
				   E TH, TB, TG, TM;
				   TH = W[4];
				   TB = Tx * TA;
				   TK = W[5];
				   TG = Tx * TF;
				   TM = TH * TL;
				   TJ = TH * TI;
				   iio[-WS(ios, 2)] = FMA(TC, TF, TB);
				   rio[WS(ios, 6)] = FNMS(TC, TA, TG);
				   iio[-WS(ios, 5)] = FMA(TK, TI, TM);
			      }
			 }
			 rio[WS(ios, 3)] = FNMS(TK, TL, TJ);
			 {
			      E T1m, T1p, T1l, T1o, T1M, T1R, T1G;
			      {
				   E T1g, T19, T15, T1i;
				   T1g = FNMS(KP954188894, T18, T17);
				   T19 = FMA(KP954188894, T18, T17);
				   T15 = FNMS(KP954188894, T14, TX);
				   T1i = FMA(KP954188894, T14, TX);
				   {
					E TN, T1v, T1s, T1c, T1a, T1j, T16, T1h, T1u, T1t;
					TN = W[14];
					T1v = FMA(KP984807753, T15, TQ);
					T16 = FNMS(KP492403876, T15, TQ);
					T1s = FMA(KP984807753, T1g, T1f);
					T1h = FNMS(KP492403876, T1g, T1f);
					T1c = W[15];
					T1a = FNMS(KP852868531, T19, T16);
					T1m = FMA(KP852868531, T19, T16);
					T1j = FMA(KP852868531, T1i, T1h);
					T1p = FNMS(KP852868531, T1i, T1h);
					{
					     E T1r, T1b, T1k, T1w;
					     T1r = W[2];
					     T1b = TN * T1a;
					     T1u = W[3];
					     T1k = TN * T1j;
					     T1w = T1r * T1v;
					     T1t = T1r * T1s;
					     iio[0] = FMA(T1c, T1j, T1b);
					     rio[WS(ios, 8)] = FNMS(T1c, T1a, T1k);
					     iio[-WS(ios, 6)] = FMA(T1u, T1s, T1w);
					}
					rio[WS(ios, 2)] = FNMS(T1u, T1v, T1t);
					T1l = W[8];
					T1o = W[9];
				   }
			      }
			      {
				   E T1W, T1F, T1q, T1n, T1V;
				   T1M = FNMS(KP777861913, T1L, T1K);
				   T1W = FMA(KP777861913, T1L, T1K);
				   T1F = FNMS(KP777861913, T1E, T1B);
				   T1R = FMA(KP777861913, T1E, T1B);
				   T1q = T1l * T1p;
				   T1n = T1l * T1m;
				   T1G = FNMS(KP984807753, T1F, T1y);
				   T1V = FMA(KP492403876, T1F, T1y);
				   rio[WS(ios, 5)] = FNMS(T1o, T1m, T1q);
				   iio[-WS(ios, 3)] = FMA(T1o, T1p, T1n);
				   T20 = FMA(KP852868531, T1W, T1V);
				   T1X = FNMS(KP852868531, T1W, T1V);
			      }
			      {
				   E T1x, T1N, T1Q, T1I, T1H, T1O, T1P;
				   T1x = W[0];
				   T1N = FMA(KP984807753, T1M, T1J);
				   T1Q = FNMS(KP492403876, T1M, T1J);
				   T1I = W[1];
				   T1H = T1x * T1G;
				   T1P = W[12];
				   T23 = FMA(KP852868531, T1R, T1Q);
				   T1S = FNMS(KP852868531, T1R, T1Q);
				   T1O = T1I * T1G;
				   rio[WS(ios, 1)] = FNMS(T1I, T1N, T1H);
				   T1T = T1P * T1S;
				   T1Y = T1P * T1X;
				   iio[-WS(ios, 7)] = FMA(T1x, T1N, T1O);
				   T1U = W[13];
				   T1Z = W[6];
				   T22 = W[7];
			      }
			 }
		    }
	       }
	  }
	  rio[WS(ios, 7)] = FNMS(T1U, T1S, T1Y);
	  iio[-WS(ios, 1)] = FMA(T1U, T1X, T1T);
	  T24 = T1Z * T23;
	  T21 = T1Z * T20;
	  iio[-WS(ios, 4)] = FMA(T22, T20, T24);
	  rio[WS(ios, 4)] = FNMS(T22, T23, T21);
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 9},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 9, "hb_9", twinstr, &GENUS, {24, 16, 72, 0}, 0, 0, 0 };

void X(codelet_hb_9) (planner *p) {
     X(khc2hc_register) (p, hb_9, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2hc -compact -variables 4 -pipeline-latency 4 -sign 1 -n 9 -dif -name hb_9 -include hb.h */

/*
 * This function contains 96 FP additions, 72 FP multiplications,
 * (or, 60 additions, 36 multiplications, 36 fused multiply/add),
 * 53 stack variables, and 36 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.8 2006-01-05 03:04:27 stevenj Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.15 2006-01-05 03:04:27 stevenj Exp $
 */

#include "hb.h"

static const R *hb_9(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP642787609, +0.642787609686539326322643409907263432907559884);
     DK(KP766044443, +0.766044443118978035202392650555416673935832457);
     DK(KP984807753, +0.984807753012208059366743024589523013670643252);
     DK(KP173648177, +0.173648177666930348851716626769314796000375677);
     DK(KP342020143, +0.342020143325668733044099614682259580763083368);
     DK(KP939692620, +0.939692620785908384054109277324731469936208134);
     DK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DK(KP866025403, +0.866025403784438646763723170752936183471402627);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 16, MAKE_VOLATILE_STRIDE(ios)) {
	  E T5, T1z, Tm, T18, TQ, T1i, Ta, Tf, Tg, T1A, T1B, T1C, Tx, TS, T1e;
	  E T1k, T1b, T1j, TI, TR;
	  {
	       E T1, TM, T4, TP, Tl, TN, Ti, TO;
	       T1 = rio[0];
	       TM = iio[0];
	       {
		    E T2, T3, Tj, Tk;
		    T2 = rio[WS(ios, 3)];
		    T3 = iio[-WS(ios, 6)];
		    T4 = T2 + T3;
		    TP = KP866025403 * (T2 - T3);
		    Tj = rio[WS(ios, 6)];
		    Tk = iio[-WS(ios, 3)];
		    Tl = KP866025403 * (Tj + Tk);
		    TN = Tj - Tk;
	       }
	       T5 = T1 + T4;
	       T1z = TM - TN;
	       Ti = FNMS(KP500000000, T4, T1);
	       Tm = Ti + Tl;
	       T18 = Ti - Tl;
	       TO = FMA(KP500000000, TN, TM);
	       TQ = TO - TP;
	       T1i = TP + TO;
	  }
	  {
	       E T6, T9, Ty, TG, TD, TE, TB, TF, Tb, Te, Tn, Tv, Tt, Ts, Tq;
	       E Tu;
	       {
		    E T7, T8, Tz, TA;
		    T6 = rio[WS(ios, 1)];
		    T7 = rio[WS(ios, 4)];
		    T8 = iio[-WS(ios, 7)];
		    T9 = T7 + T8;
		    Ty = FNMS(KP500000000, T9, T6);
		    TG = KP866025403 * (T7 - T8);
		    TD = iio[-WS(ios, 1)];
		    Tz = rio[WS(ios, 7)];
		    TA = iio[-WS(ios, 4)];
		    TE = Tz - TA;
		    TB = KP866025403 * (Tz + TA);
		    TF = FMA(KP500000000, TE, TD);
	       }
	       {
		    E Tc, Td, To, Tp;
		    Tb = rio[WS(ios, 2)];
		    Tc = iio[-WS(ios, 5)];
		    Td = iio[-WS(ios, 8)];
		    Te = Tc + Td;
		    Tn = FNMS(KP500000000, Te, Tb);
		    Tv = KP866025403 * (Tc - Td);
		    Tt = iio[-WS(ios, 2)];
		    To = rio[WS(ios, 5)];
		    Tp = rio[WS(ios, 8)];
		    Ts = To + Tp;
		    Tq = KP866025403 * (To - Tp);
		    Tu = FMA(KP500000000, Ts, Tt);
	       }
	       {
		    E Tr, Tw, T1c, T1d;
		    Ta = T6 + T9;
		    Tf = Tb + Te;
		    Tg = Ta + Tf;
		    T1A = TD - TE;
		    T1B = Tt - Ts;
		    T1C = T1A + T1B;
		    Tr = Tn - Tq;
		    Tw = Tu - Tv;
		    Tx = FMA(KP939692620, Tr, KP342020143 * Tw);
		    TS = FNMS(KP939692620, Tw, KP342020143 * Tr);
		    T1c = Tn + Tq;
		    T1d = Tv + Tu;
		    T1e = FNMS(KP984807753, T1d, KP173648177 * T1c);
		    T1k = FMA(KP984807753, T1c, KP173648177 * T1d);
		    {
			 E T19, T1a, TC, TH;
			 T19 = Ty - TB;
			 T1a = TG + TF;
			 T1b = FNMS(KP642787609, T1a, KP766044443 * T19);
			 T1j = FMA(KP766044443, T1a, KP642787609 * T19);
			 TC = Ty + TB;
			 TH = TF - TG;
			 TI = FNMS(KP984807753, TH, KP173648177 * TC);
			 TR = FMA(KP173648177, TH, KP984807753 * TC);
		    }
	       }
	  }
	  rio[0] = T5 + Tg;
	  {
	       E TX, T11, TK, T10, TU, TW, TJ, TT, Th, TL;
	       TX = KP866025403 * (TI + Tx);
	       T11 = KP866025403 * (TS - TR);
	       TJ = Tx - TI;
	       TK = Tm - TJ;
	       T10 = FMA(KP500000000, TJ, Tm);
	       TT = TR + TS;
	       TU = TQ + TT;
	       TW = FNMS(KP500000000, TT, TQ);
	       Th = W[2];
	       TL = W[3];
	       rio[WS(ios, 2)] = FNMS(TL, TU, Th * TK);
	       iio[-WS(ios, 6)] = FMA(Th, TU, TL * TK);
	       {
		    E T14, T16, T13, T15;
		    T14 = TW + TX;
		    T16 = T11 + T10;
		    T13 = W[8];
		    T15 = W[9];
		    iio[-WS(ios, 3)] = FMA(T13, T14, T15 * T16);
		    rio[WS(ios, 5)] = FNMS(T15, T14, T13 * T16);
	       }
	       {
		    E TY, T12, TV, TZ;
		    TY = TW - TX;
		    T12 = T10 - T11;
		    TV = W[14];
		    TZ = W[15];
		    iio[0] = FMA(TV, TY, TZ * T12);
		    rio[WS(ios, 8)] = FNMS(TZ, TY, TV * T12);
	       }
	  }
	  iio[-WS(ios, 8)] = T1z + T1C;
	  {
	       E T1G, T1O, T1K, T1M;
	       {
		    E T1E, T1F, T1I, T1J;
		    T1E = FNMS(KP500000000, T1C, T1z);
		    T1F = KP866025403 * (Ta - Tf);
		    T1G = T1E - T1F;
		    T1O = T1F + T1E;
		    T1I = FNMS(KP500000000, Tg, T5);
		    T1J = KP866025403 * (T1B - T1A);
		    T1K = T1I - T1J;
		    T1M = T1I + T1J;
	       }
	       {
		    E T1D, T1H, T1L, T1N;
		    T1D = W[10];
		    T1H = W[11];
		    iio[-WS(ios, 2)] = FMA(T1D, T1G, T1H * T1K);
		    rio[WS(ios, 6)] = FNMS(T1H, T1G, T1D * T1K);
		    T1L = W[4];
		    T1N = W[5];
		    rio[WS(ios, 3)] = FNMS(T1N, T1O, T1L * T1M);
		    iio[-WS(ios, 5)] = FMA(T1L, T1O, T1N * T1M);
	       }
	  }
	  {
	       E T1p, T1t, T1g, T1s, T1m, T1o, T1f, T1l, T17, T1h;
	       T1p = KP866025403 * (T1b - T1e);
	       T1t = KP866025403 * (T1k - T1j);
	       T1f = T1b + T1e;
	       T1g = T18 + T1f;
	       T1s = FNMS(KP500000000, T1f, T18);
	       T1l = T1j + T1k;
	       T1m = T1i + T1l;
	       T1o = FNMS(KP500000000, T1l, T1i);
	       T17 = W[0];
	       T1h = W[1];
	       rio[WS(ios, 1)] = FNMS(T1h, T1m, T17 * T1g);
	       iio[-WS(ios, 7)] = FMA(T1h, T1g, T17 * T1m);
	       {
		    E T1q, T1u, T1n, T1r;
		    T1q = T1o - T1p;
		    T1u = T1s - T1t;
		    T1n = W[12];
		    T1r = W[13];
		    iio[-WS(ios, 1)] = FMA(T1n, T1q, T1r * T1u);
		    rio[WS(ios, 7)] = FNMS(T1r, T1q, T1n * T1u);
	       }
	       {
		    E T1w, T1y, T1v, T1x;
		    T1w = T1s + T1t;
		    T1y = T1p + T1o;
		    T1v = W[6];
		    T1x = W[7];
		    rio[WS(ios, 4)] = FNMS(T1x, T1y, T1v * T1w);
		    iio[-WS(ios, 4)] = FMA(T1v, T1y, T1x * T1w);
	       }
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 9},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 9, "hb_9", twinstr, &GENUS, {60, 36, 36, 0}, 0, 0, 0 };

void X(codelet_hb_9) (planner *p) {
     X(khc2hc_register) (p, hb_9, &desc);
}
#endif				/* HAVE_FMA */
