/*
 * Copyright (c) 2003 Matteo Frigo
 * Copyright (c) 2003 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Sat Jul  5 21:57:11 EDT 2003 */

#include "codelet-rdft.h"

/* Generated by: /homee/stevenj/cvs/fftw3.0.1/genfft/gen_hc2hc -compact -variables 4 -n 64 -dit -name hf_64 -include hf.h */

/*
 * This function contains 1038 FP additions, 500 FP multiplications,
 * (or, 808 additions, 270 multiplications, 230 fused multiply/add),
 * 176 stack variables, and 256 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.7 2003/03/15 20:29:42 stevenj Exp $
 * $Id: fft.ml,v 1.2 2003/03/15 20:29:42 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.9 2003/04/17 19:25:50 athena Exp $
 */

#include "hf.h"

static const R *hf_64(R *rio, R *iio, const R *W, stride ios, int m, int dist)
{
     DK(KP471396736, +0.471396736825997648556387625905254377657460319);
     DK(KP881921264, +0.881921264348355029712756863660388349508442621);
     DK(KP290284677, +0.290284677254462367636192375817395274691476278);
     DK(KP956940335, +0.956940335732208864935797886980269969482849206);
     DK(KP634393284, +0.634393284163645498215171613225493370675687095);
     DK(KP773010453, +0.773010453362736960810906609758469800971041293);
     DK(KP098017140, +0.098017140329560601994195563888641845861136673);
     DK(KP995184726, +0.995184726672196886244836953109479921575474869);
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     int i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 126) {
	  E Tj, TcL, ThT, Tin, T6b, Taz, TgT, Thn, TG, Thm, TcO, TgO, T6m, ThQ, TaC;
	  E Tim, T14, Tfq, T6y, T9O, TaG, Tc0, TcU, TeE, T1r, Tfr, T6J, T9P, TaJ, Tc1;
	  E TcZ, TeF, T1Q, T2d, Tfx, Tfu, Tfv, Tfw, T6Q, TaM, Tdb, TeJ, T71, TaQ, T7a;
	  E TaN, Td6, TeI, T77, TaP, T2B, T2Y, Tfz, TfA, TfB, TfC, T7h, TaW, Tdm, TeM;
	  E T7s, TaU, T7B, TaX, Tdh, TeL, T7y, TaT, T3M, TfL, TdL, TeQ, TfI, Tgt, T7K;
	  E Tb2, T7V, Tbe, T8s, Tb3, Tdu, TeT, T8p, Tbd, T5j, TfR, Tec, Tf0, TfY, Tgy;
	  E T8D, Tbl, T8O, Tbx, T9l, Tbm, TdV, TeX, T9i, Tbw, T64, TfZ, Te5, Ted, TfU;
	  E Tgz, T90, T9o, T9b, T9n, Tbt, Tbz, Te0, Tee, Tbq, TbA, T4x, TfJ, TdE, TdM;
	  E TfO, Tgu, T87, T8v, T8i, T8u, Tba, Tbg, Tdz, TdN, Tb7, Tbh;
	  {
	       E T1, TgR, T6, TgQ, Tc, T68, Th, T69;
	       T1 = rio[0];
	       TgR = iio[-WS(ios, 63)];
	       {
		    E T3, T5, T2, T4;
		    T3 = rio[WS(ios, 32)];
		    T5 = iio[-WS(ios, 31)];
		    T2 = W[62];
		    T4 = W[63];
		    T6 = FMA(T2, T3, T4 * T5);
		    TgQ = FNMS(T4, T3, T2 * T5);
	       }
	       {
		    E T9, Tb, T8, Ta;
		    T9 = rio[WS(ios, 16)];
		    Tb = iio[-WS(ios, 47)];
		    T8 = W[30];
		    Ta = W[31];
		    Tc = FMA(T8, T9, Ta * Tb);
		    T68 = FNMS(Ta, T9, T8 * Tb);
	       }
	       {
		    E Te, Tg, Td, Tf;
		    Te = rio[WS(ios, 48)];
		    Tg = iio[-WS(ios, 15)];
		    Td = W[94];
		    Tf = W[95];
		    Th = FMA(Td, Te, Tf * Tg);
		    T69 = FNMS(Tf, Te, Td * Tg);
	       }
	       {
		    E T7, Ti, ThR, ThS;
		    T7 = T1 + T6;
		    Ti = Tc + Th;
		    Tj = T7 + Ti;
		    TcL = T7 - Ti;
		    ThR = TgR - TgQ;
		    ThS = Tc - Th;
		    ThT = ThR - ThS;
		    Tin = ThS + ThR;
	       }
	       {
		    E T67, T6a, TgP, TgS;
		    T67 = T1 - T6;
		    T6a = T68 - T69;
		    T6b = T67 - T6a;
		    Taz = T67 + T6a;
		    TgP = T68 + T69;
		    TgS = TgQ + TgR;
		    TgT = TgP + TgS;
		    Thn = TgS - TgP;
	       }
	  }
	  {
	       E To, T6c, Tt, T6d, T6e, T6f, Tz, T6i, TE, T6j, T6h, T6k;
	       {
		    E Tl, Tn, Tk, Tm;
		    Tl = rio[WS(ios, 8)];
		    Tn = iio[-WS(ios, 55)];
		    Tk = W[14];
		    Tm = W[15];
		    To = FMA(Tk, Tl, Tm * Tn);
		    T6c = FNMS(Tm, Tl, Tk * Tn);
	       }
	       {
		    E Tq, Ts, Tp, Tr;
		    Tq = rio[WS(ios, 40)];
		    Ts = iio[-WS(ios, 23)];
		    Tp = W[78];
		    Tr = W[79];
		    Tt = FMA(Tp, Tq, Tr * Ts);
		    T6d = FNMS(Tr, Tq, Tp * Ts);
	       }
	       T6e = T6c - T6d;
	       T6f = To - Tt;
	       {
		    E Tw, Ty, Tv, Tx;
		    Tw = rio[WS(ios, 56)];
		    Ty = iio[-WS(ios, 7)];
		    Tv = W[110];
		    Tx = W[111];
		    Tz = FMA(Tv, Tw, Tx * Ty);
		    T6i = FNMS(Tx, Tw, Tv * Ty);
	       }
	       {
		    E TB, TD, TA, TC;
		    TB = rio[WS(ios, 24)];
		    TD = iio[-WS(ios, 39)];
		    TA = W[46];
		    TC = W[47];
		    TE = FMA(TA, TB, TC * TD);
		    T6j = FNMS(TC, TB, TA * TD);
	       }
	       T6h = Tz - TE;
	       T6k = T6i - T6j;
	       {
		    E Tu, TF, TcM, TcN;
		    Tu = To + Tt;
		    TF = Tz + TE;
		    TG = Tu + TF;
		    Thm = TF - Tu;
		    TcM = T6c + T6d;
		    TcN = T6i + T6j;
		    TcO = TcM - TcN;
		    TgO = TcM + TcN;
	       }
	       {
		    E T6g, T6l, TaA, TaB;
		    T6g = T6e - T6f;
		    T6l = T6h + T6k;
		    T6m = KP707106781 * (T6g - T6l);
		    ThQ = KP707106781 * (T6g + T6l);
		    TaA = T6f + T6e;
		    TaB = T6h - T6k;
		    TaC = KP707106781 * (TaA + TaB);
		    Tim = KP707106781 * (TaB - TaA);
	       }
	  }
	  {
	       E TS, TcQ, T6q, T6t, T13, TcR, T6r, T6w, T6s, T6x;
	       {
		    E TM, T6o, TR, T6p;
		    {
			 E TJ, TL, TI, TK;
			 TJ = rio[WS(ios, 4)];
			 TL = iio[-WS(ios, 59)];
			 TI = W[6];
			 TK = W[7];
			 TM = FMA(TI, TJ, TK * TL);
			 T6o = FNMS(TK, TJ, TI * TL);
		    }
		    {
			 E TO, TQ, TN, TP;
			 TO = rio[WS(ios, 36)];
			 TQ = iio[-WS(ios, 27)];
			 TN = W[70];
			 TP = W[71];
			 TR = FMA(TN, TO, TP * TQ);
			 T6p = FNMS(TP, TO, TN * TQ);
		    }
		    TS = TM + TR;
		    TcQ = T6o + T6p;
		    T6q = T6o - T6p;
		    T6t = TM - TR;
	       }
	       {
		    E TX, T6u, T12, T6v;
		    {
			 E TU, TW, TT, TV;
			 TU = rio[WS(ios, 20)];
			 TW = iio[-WS(ios, 43)];
			 TT = W[38];
			 TV = W[39];
			 TX = FMA(TT, TU, TV * TW);
			 T6u = FNMS(TV, TU, TT * TW);
		    }
		    {
			 E TZ, T11, TY, T10;
			 TZ = rio[WS(ios, 52)];
			 T11 = iio[-WS(ios, 11)];
			 TY = W[102];
			 T10 = W[103];
			 T12 = FMA(TY, TZ, T10 * T11);
			 T6v = FNMS(T10, TZ, TY * T11);
		    }
		    T13 = TX + T12;
		    TcR = T6u + T6v;
		    T6r = TX - T12;
		    T6w = T6u - T6v;
	       }
	       T14 = TS + T13;
	       Tfq = TcQ + TcR;
	       T6s = T6q + T6r;
	       T6x = T6t - T6w;
	       T6y = FNMS(KP923879532, T6x, KP382683432 * T6s);
	       T9O = FMA(KP923879532, T6s, KP382683432 * T6x);
	       {
		    E TaE, TaF, TcS, TcT;
		    TaE = T6q - T6r;
		    TaF = T6t + T6w;
		    TaG = FNMS(KP382683432, TaF, KP923879532 * TaE);
		    Tc0 = FMA(KP382683432, TaE, KP923879532 * TaF);
		    TcS = TcQ - TcR;
		    TcT = TS - T13;
		    TcU = TcS - TcT;
		    TeE = TcT + TcS;
	       }
	  }
	  {
	       E T1f, TcW, T6B, T6E, T1q, TcX, T6C, T6H, T6D, T6I;
	       {
		    E T19, T6z, T1e, T6A;
		    {
			 E T16, T18, T15, T17;
			 T16 = rio[WS(ios, 60)];
			 T18 = iio[-WS(ios, 3)];
			 T15 = W[118];
			 T17 = W[119];
			 T19 = FMA(T15, T16, T17 * T18);
			 T6z = FNMS(T17, T16, T15 * T18);
		    }
		    {
			 E T1b, T1d, T1a, T1c;
			 T1b = rio[WS(ios, 28)];
			 T1d = iio[-WS(ios, 35)];
			 T1a = W[54];
			 T1c = W[55];
			 T1e = FMA(T1a, T1b, T1c * T1d);
			 T6A = FNMS(T1c, T1b, T1a * T1d);
		    }
		    T1f = T19 + T1e;
		    TcW = T6z + T6A;
		    T6B = T6z - T6A;
		    T6E = T19 - T1e;
	       }
	       {
		    E T1k, T6F, T1p, T6G;
		    {
			 E T1h, T1j, T1g, T1i;
			 T1h = rio[WS(ios, 12)];
			 T1j = iio[-WS(ios, 51)];
			 T1g = W[22];
			 T1i = W[23];
			 T1k = FMA(T1g, T1h, T1i * T1j);
			 T6F = FNMS(T1i, T1h, T1g * T1j);
		    }
		    {
			 E T1m, T1o, T1l, T1n;
			 T1m = rio[WS(ios, 44)];
			 T1o = iio[-WS(ios, 19)];
			 T1l = W[86];
			 T1n = W[87];
			 T1p = FMA(T1l, T1m, T1n * T1o);
			 T6G = FNMS(T1n, T1m, T1l * T1o);
		    }
		    T1q = T1k + T1p;
		    TcX = T6F + T6G;
		    T6C = T1k - T1p;
		    T6H = T6F - T6G;
	       }
	       T1r = T1f + T1q;
	       Tfr = TcW + TcX;
	       T6D = T6B + T6C;
	       T6I = T6E - T6H;
	       T6J = FMA(KP382683432, T6D, KP923879532 * T6I);
	       T9P = FNMS(KP923879532, T6D, KP382683432 * T6I);
	       {
		    E TaH, TaI, TcV, TcY;
		    TaH = T6B - T6C;
		    TaI = T6E + T6H;
		    TaJ = FMA(KP923879532, TaH, KP382683432 * TaI);
		    Tc1 = FNMS(KP382683432, TaH, KP923879532 * TaI);
		    TcV = T1f - T1q;
		    TcY = TcW - TcX;
		    TcZ = TcV + TcY;
		    TeF = TcV - TcY;
	       }
	  }
	  {
	       E T1y, T6M, T1D, T6N, T1E, Td2, T1J, T74, T1O, T75, T1P, Td3, T21, Td8, T6W;
	       E T6Z, T2c, Td9, T6R, T6U;
	       {
		    E T1v, T1x, T1u, T1w;
		    T1v = rio[WS(ios, 2)];
		    T1x = iio[-WS(ios, 61)];
		    T1u = W[2];
		    T1w = W[3];
		    T1y = FMA(T1u, T1v, T1w * T1x);
		    T6M = FNMS(T1w, T1v, T1u * T1x);
	       }
	       {
		    E T1A, T1C, T1z, T1B;
		    T1A = rio[WS(ios, 34)];
		    T1C = iio[-WS(ios, 29)];
		    T1z = W[66];
		    T1B = W[67];
		    T1D = FMA(T1z, T1A, T1B * T1C);
		    T6N = FNMS(T1B, T1A, T1z * T1C);
	       }
	       T1E = T1y + T1D;
	       Td2 = T6M + T6N;
	       {
		    E T1G, T1I, T1F, T1H;
		    T1G = rio[WS(ios, 18)];
		    T1I = iio[-WS(ios, 45)];
		    T1F = W[34];
		    T1H = W[35];
		    T1J = FMA(T1F, T1G, T1H * T1I);
		    T74 = FNMS(T1H, T1G, T1F * T1I);
	       }
	       {
		    E T1L, T1N, T1K, T1M;
		    T1L = rio[WS(ios, 50)];
		    T1N = iio[-WS(ios, 13)];
		    T1K = W[98];
		    T1M = W[99];
		    T1O = FMA(T1K, T1L, T1M * T1N);
		    T75 = FNMS(T1M, T1L, T1K * T1N);
	       }
	       T1P = T1J + T1O;
	       Td3 = T74 + T75;
	       {
		    E T1V, T6X, T20, T6Y;
		    {
			 E T1S, T1U, T1R, T1T;
			 T1S = rio[WS(ios, 10)];
			 T1U = iio[-WS(ios, 53)];
			 T1R = W[18];
			 T1T = W[19];
			 T1V = FMA(T1R, T1S, T1T * T1U);
			 T6X = FNMS(T1T, T1S, T1R * T1U);
		    }
		    {
			 E T1X, T1Z, T1W, T1Y;
			 T1X = rio[WS(ios, 42)];
			 T1Z = iio[-WS(ios, 21)];
			 T1W = W[82];
			 T1Y = W[83];
			 T20 = FMA(T1W, T1X, T1Y * T1Z);
			 T6Y = FNMS(T1Y, T1X, T1W * T1Z);
		    }
		    T21 = T1V + T20;
		    Td8 = T6X + T6Y;
		    T6W = T1V - T20;
		    T6Z = T6X - T6Y;
	       }
	       {
		    E T26, T6S, T2b, T6T;
		    {
			 E T23, T25, T22, T24;
			 T23 = rio[WS(ios, 58)];
			 T25 = iio[-WS(ios, 5)];
			 T22 = W[114];
			 T24 = W[115];
			 T26 = FMA(T22, T23, T24 * T25);
			 T6S = FNMS(T24, T23, T22 * T25);
		    }
		    {
			 E T28, T2a, T27, T29;
			 T28 = rio[WS(ios, 26)];
			 T2a = iio[-WS(ios, 37)];
			 T27 = W[50];
			 T29 = W[51];
			 T2b = FMA(T27, T28, T29 * T2a);
			 T6T = FNMS(T29, T28, T27 * T2a);
		    }
		    T2c = T26 + T2b;
		    Td9 = T6S + T6T;
		    T6R = T26 - T2b;
		    T6U = T6S - T6T;
	       }
	       T1Q = T1E + T1P;
	       T2d = T21 + T2c;
	       Tfx = T1Q - T2d;
	       Tfu = Td2 + Td3;
	       Tfv = Td8 + Td9;
	       Tfw = Tfu - Tfv;
	       {
		    E T6O, T6P, Td7, Tda;
		    T6O = T6M - T6N;
		    T6P = T1J - T1O;
		    T6Q = T6O + T6P;
		    TaM = T6O - T6P;
		    Td7 = T1E - T1P;
		    Tda = Td8 - Td9;
		    Tdb = Td7 - Tda;
		    TeJ = Td7 + Tda;
	       }
	       {
		    E T6V, T70, T78, T79;
		    T6V = T6R - T6U;
		    T70 = T6W + T6Z;
		    T71 = KP707106781 * (T6V - T70);
		    TaQ = KP707106781 * (T70 + T6V);
		    T78 = T6Z - T6W;
		    T79 = T6R + T6U;
		    T7a = KP707106781 * (T78 - T79);
		    TaN = KP707106781 * (T78 + T79);
	       }
	       {
		    E Td4, Td5, T73, T76;
		    Td4 = Td2 - Td3;
		    Td5 = T2c - T21;
		    Td6 = Td4 - Td5;
		    TeI = Td4 + Td5;
		    T73 = T1y - T1D;
		    T76 = T74 - T75;
		    T77 = T73 - T76;
		    TaP = T73 + T76;
	       }
	  }
	  {
	       E T2j, T7d, T2o, T7e, T2p, Tdd, T2u, T7v, T2z, T7w, T2A, Tde, T2M, Tdj, T7n;
	       E T7q, T2X, Tdk, T7i, T7l;
	       {
		    E T2g, T2i, T2f, T2h;
		    T2g = rio[WS(ios, 62)];
		    T2i = iio[-WS(ios, 1)];
		    T2f = W[122];
		    T2h = W[123];
		    T2j = FMA(T2f, T2g, T2h * T2i);
		    T7d = FNMS(T2h, T2g, T2f * T2i);
	       }
	       {
		    E T2l, T2n, T2k, T2m;
		    T2l = rio[WS(ios, 30)];
		    T2n = iio[-WS(ios, 33)];
		    T2k = W[58];
		    T2m = W[59];
		    T2o = FMA(T2k, T2l, T2m * T2n);
		    T7e = FNMS(T2m, T2l, T2k * T2n);
	       }
	       T2p = T2j + T2o;
	       Tdd = T7d + T7e;
	       {
		    E T2r, T2t, T2q, T2s;
		    T2r = rio[WS(ios, 14)];
		    T2t = iio[-WS(ios, 49)];
		    T2q = W[26];
		    T2s = W[27];
		    T2u = FMA(T2q, T2r, T2s * T2t);
		    T7v = FNMS(T2s, T2r, T2q * T2t);
	       }
	       {
		    E T2w, T2y, T2v, T2x;
		    T2w = rio[WS(ios, 46)];
		    T2y = iio[-WS(ios, 17)];
		    T2v = W[90];
		    T2x = W[91];
		    T2z = FMA(T2v, T2w, T2x * T2y);
		    T7w = FNMS(T2x, T2w, T2v * T2y);
	       }
	       T2A = T2u + T2z;
	       Tde = T7v + T7w;
	       {
		    E T2G, T7o, T2L, T7p;
		    {
			 E T2D, T2F, T2C, T2E;
			 T2D = rio[WS(ios, 6)];
			 T2F = iio[-WS(ios, 57)];
			 T2C = W[10];
			 T2E = W[11];
			 T2G = FMA(T2C, T2D, T2E * T2F);
			 T7o = FNMS(T2E, T2D, T2C * T2F);
		    }
		    {
			 E T2I, T2K, T2H, T2J;
			 T2I = rio[WS(ios, 38)];
			 T2K = iio[-WS(ios, 25)];
			 T2H = W[74];
			 T2J = W[75];
			 T2L = FMA(T2H, T2I, T2J * T2K);
			 T7p = FNMS(T2J, T2I, T2H * T2K);
		    }
		    T2M = T2G + T2L;
		    Tdj = T7o + T7p;
		    T7n = T2G - T2L;
		    T7q = T7o - T7p;
	       }
	       {
		    E T2R, T7j, T2W, T7k;
		    {
			 E T2O, T2Q, T2N, T2P;
			 T2O = rio[WS(ios, 54)];
			 T2Q = iio[-WS(ios, 9)];
			 T2N = W[106];
			 T2P = W[107];
			 T2R = FMA(T2N, T2O, T2P * T2Q);
			 T7j = FNMS(T2P, T2O, T2N * T2Q);
		    }
		    {
			 E T2T, T2V, T2S, T2U;
			 T2T = rio[WS(ios, 22)];
			 T2V = iio[-WS(ios, 41)];
			 T2S = W[42];
			 T2U = W[43];
			 T2W = FMA(T2S, T2T, T2U * T2V);
			 T7k = FNMS(T2U, T2T, T2S * T2V);
		    }
		    T2X = T2R + T2W;
		    Tdk = T7j + T7k;
		    T7i = T2R - T2W;
		    T7l = T7j - T7k;
	       }
	       T2B = T2p + T2A;
	       T2Y = T2M + T2X;
	       Tfz = T2B - T2Y;
	       TfA = Tdd + Tde;
	       TfB = Tdj + Tdk;
	       TfC = TfA - TfB;
	       {
		    E T7f, T7g, Tdi, Tdl;
		    T7f = T7d - T7e;
		    T7g = T2u - T2z;
		    T7h = T7f + T7g;
		    TaW = T7f - T7g;
		    Tdi = T2p - T2A;
		    Tdl = Tdj - Tdk;
		    Tdm = Tdi - Tdl;
		    TeM = Tdi + Tdl;
	       }
	       {
		    E T7m, T7r, T7z, T7A;
		    T7m = T7i - T7l;
		    T7r = T7n + T7q;
		    T7s = KP707106781 * (T7m - T7r);
		    TaU = KP707106781 * (T7r + T7m);
		    T7z = T7q - T7n;
		    T7A = T7i + T7l;
		    T7B = KP707106781 * (T7z - T7A);
		    TaX = KP707106781 * (T7z + T7A);
	       }
	       {
		    E Tdf, Tdg, T7u, T7x;
		    Tdf = Tdd - Tde;
		    Tdg = T2X - T2M;
		    Tdh = Tdf - Tdg;
		    TeL = Tdf + Tdg;
		    T7u = T2j - T2o;
		    T7x = T7v - T7w;
		    T7y = T7u - T7x;
		    TaT = T7u + T7x;
	       }
	  }
	  {
	       E T36, T7G, T3b, T7H, T3c, Tdq, T3h, T8m, T3m, T8n, T3n, Tdr, T3z, TdI, T7Q;
	       E T7T, T3K, TdJ, T7L, T7O;
	       {
		    E T33, T35, T32, T34;
		    T33 = rio[WS(ios, 1)];
		    T35 = iio[-WS(ios, 62)];
		    T32 = W[0];
		    T34 = W[1];
		    T36 = FMA(T32, T33, T34 * T35);
		    T7G = FNMS(T34, T33, T32 * T35);
	       }
	       {
		    E T38, T3a, T37, T39;
		    T38 = rio[WS(ios, 33)];
		    T3a = iio[-WS(ios, 30)];
		    T37 = W[64];
		    T39 = W[65];
		    T3b = FMA(T37, T38, T39 * T3a);
		    T7H = FNMS(T39, T38, T37 * T3a);
	       }
	       T3c = T36 + T3b;
	       Tdq = T7G + T7H;
	       {
		    E T3e, T3g, T3d, T3f;
		    T3e = rio[WS(ios, 17)];
		    T3g = iio[-WS(ios, 46)];
		    T3d = W[32];
		    T3f = W[33];
		    T3h = FMA(T3d, T3e, T3f * T3g);
		    T8m = FNMS(T3f, T3e, T3d * T3g);
	       }
	       {
		    E T3j, T3l, T3i, T3k;
		    T3j = rio[WS(ios, 49)];
		    T3l = iio[-WS(ios, 14)];
		    T3i = W[96];
		    T3k = W[97];
		    T3m = FMA(T3i, T3j, T3k * T3l);
		    T8n = FNMS(T3k, T3j, T3i * T3l);
	       }
	       T3n = T3h + T3m;
	       Tdr = T8m + T8n;
	       {
		    E T3t, T7R, T3y, T7S;
		    {
			 E T3q, T3s, T3p, T3r;
			 T3q = rio[WS(ios, 9)];
			 T3s = iio[-WS(ios, 54)];
			 T3p = W[16];
			 T3r = W[17];
			 T3t = FMA(T3p, T3q, T3r * T3s);
			 T7R = FNMS(T3r, T3q, T3p * T3s);
		    }
		    {
			 E T3v, T3x, T3u, T3w;
			 T3v = rio[WS(ios, 41)];
			 T3x = iio[-WS(ios, 22)];
			 T3u = W[80];
			 T3w = W[81];
			 T3y = FMA(T3u, T3v, T3w * T3x);
			 T7S = FNMS(T3w, T3v, T3u * T3x);
		    }
		    T3z = T3t + T3y;
		    TdI = T7R + T7S;
		    T7Q = T3t - T3y;
		    T7T = T7R - T7S;
	       }
	       {
		    E T3E, T7M, T3J, T7N;
		    {
			 E T3B, T3D, T3A, T3C;
			 T3B = rio[WS(ios, 57)];
			 T3D = iio[-WS(ios, 6)];
			 T3A = W[112];
			 T3C = W[113];
			 T3E = FMA(T3A, T3B, T3C * T3D);
			 T7M = FNMS(T3C, T3B, T3A * T3D);
		    }
		    {
			 E T3G, T3I, T3F, T3H;
			 T3G = rio[WS(ios, 25)];
			 T3I = iio[-WS(ios, 38)];
			 T3F = W[48];
			 T3H = W[49];
			 T3J = FMA(T3F, T3G, T3H * T3I);
			 T7N = FNMS(T3H, T3G, T3F * T3I);
		    }
		    T3K = T3E + T3J;
		    TdJ = T7M + T7N;
		    T7L = T3E - T3J;
		    T7O = T7M - T7N;
	       }
	       {
		    E T3o, T3L, TdH, TdK;
		    T3o = T3c + T3n;
		    T3L = T3z + T3K;
		    T3M = T3o + T3L;
		    TfL = T3o - T3L;
		    TdH = T3c - T3n;
		    TdK = TdI - TdJ;
		    TdL = TdH - TdK;
		    TeQ = TdH + TdK;
	       }
	       {
		    E TfG, TfH, T7I, T7J;
		    TfG = Tdq + Tdr;
		    TfH = TdI + TdJ;
		    TfI = TfG - TfH;
		    Tgt = TfG + TfH;
		    T7I = T7G - T7H;
		    T7J = T3h - T3m;
		    T7K = T7I + T7J;
		    Tb2 = T7I - T7J;
	       }
	       {
		    E T7P, T7U, T8q, T8r;
		    T7P = T7L - T7O;
		    T7U = T7Q + T7T;
		    T7V = KP707106781 * (T7P - T7U);
		    Tbe = KP707106781 * (T7U + T7P);
		    T8q = T7T - T7Q;
		    T8r = T7L + T7O;
		    T8s = KP707106781 * (T8q - T8r);
		    Tb3 = KP707106781 * (T8q + T8r);
	       }
	       {
		    E Tds, Tdt, T8l, T8o;
		    Tds = Tdq - Tdr;
		    Tdt = T3K - T3z;
		    Tdu = Tds - Tdt;
		    TeT = Tds + Tdt;
		    T8l = T36 - T3b;
		    T8o = T8m - T8n;
		    T8p = T8l - T8o;
		    Tbd = T8l + T8o;
	       }
	  }
	  {
	       E T4D, T9e, T4I, T9f, T4J, Te8, T4O, T8A, T4T, T8B, T4U, Te9, T56, TdS, T8G;
	       E T8H, T5h, TdT, T8J, T8M;
	       {
		    E T4A, T4C, T4z, T4B;
		    T4A = rio[WS(ios, 63)];
		    T4C = iio[0];
		    T4z = W[124];
		    T4B = W[125];
		    T4D = FMA(T4z, T4A, T4B * T4C);
		    T9e = FNMS(T4B, T4A, T4z * T4C);
	       }
	       {
		    E T4F, T4H, T4E, T4G;
		    T4F = rio[WS(ios, 31)];
		    T4H = iio[-WS(ios, 32)];
		    T4E = W[60];
		    T4G = W[61];
		    T4I = FMA(T4E, T4F, T4G * T4H);
		    T9f = FNMS(T4G, T4F, T4E * T4H);
	       }
	       T4J = T4D + T4I;
	       Te8 = T9e + T9f;
	       {
		    E T4L, T4N, T4K, T4M;
		    T4L = rio[WS(ios, 15)];
		    T4N = iio[-WS(ios, 48)];
		    T4K = W[28];
		    T4M = W[29];
		    T4O = FMA(T4K, T4L, T4M * T4N);
		    T8A = FNMS(T4M, T4L, T4K * T4N);
	       }
	       {
		    E T4Q, T4S, T4P, T4R;
		    T4Q = rio[WS(ios, 47)];
		    T4S = iio[-WS(ios, 16)];
		    T4P = W[92];
		    T4R = W[93];
		    T4T = FMA(T4P, T4Q, T4R * T4S);
		    T8B = FNMS(T4R, T4Q, T4P * T4S);
	       }
	       T4U = T4O + T4T;
	       Te9 = T8A + T8B;
	       {
		    E T50, T8E, T55, T8F;
		    {
			 E T4X, T4Z, T4W, T4Y;
			 T4X = rio[WS(ios, 7)];
			 T4Z = iio[-WS(ios, 56)];
			 T4W = W[12];
			 T4Y = W[13];
			 T50 = FMA(T4W, T4X, T4Y * T4Z);
			 T8E = FNMS(T4Y, T4X, T4W * T4Z);
		    }
		    {
			 E T52, T54, T51, T53;
			 T52 = rio[WS(ios, 39)];
			 T54 = iio[-WS(ios, 24)];
			 T51 = W[76];
			 T53 = W[77];
			 T55 = FMA(T51, T52, T53 * T54);
			 T8F = FNMS(T53, T52, T51 * T54);
		    }
		    T56 = T50 + T55;
		    TdS = T8E + T8F;
		    T8G = T8E - T8F;
		    T8H = T50 - T55;
	       }
	       {
		    E T5b, T8K, T5g, T8L;
		    {
			 E T58, T5a, T57, T59;
			 T58 = rio[WS(ios, 55)];
			 T5a = iio[-WS(ios, 8)];
			 T57 = W[108];
			 T59 = W[109];
			 T5b = FMA(T57, T58, T59 * T5a);
			 T8K = FNMS(T59, T58, T57 * T5a);
		    }
		    {
			 E T5d, T5f, T5c, T5e;
			 T5d = rio[WS(ios, 23)];
			 T5f = iio[-WS(ios, 40)];
			 T5c = W[44];
			 T5e = W[45];
			 T5g = FMA(T5c, T5d, T5e * T5f);
			 T8L = FNMS(T5e, T5d, T5c * T5f);
		    }
		    T5h = T5b + T5g;
		    TdT = T8K + T8L;
		    T8J = T5b - T5g;
		    T8M = T8K - T8L;
	       }
	       {
		    E T4V, T5i, Tea, Teb;
		    T4V = T4J + T4U;
		    T5i = T56 + T5h;
		    T5j = T4V + T5i;
		    TfR = T4V - T5i;
		    Tea = Te8 - Te9;
		    Teb = T5h - T56;
		    Tec = Tea - Teb;
		    Tf0 = Tea + Teb;
	       }
	       {
		    E TfW, TfX, T8z, T8C;
		    TfW = Te8 + Te9;
		    TfX = TdS + TdT;
		    TfY = TfW - TfX;
		    Tgy = TfW + TfX;
		    T8z = T4D - T4I;
		    T8C = T8A - T8B;
		    T8D = T8z - T8C;
		    Tbl = T8z + T8C;
	       }
	       {
		    E T8I, T8N, T9j, T9k;
		    T8I = T8G - T8H;
		    T8N = T8J + T8M;
		    T8O = KP707106781 * (T8I - T8N);
		    Tbx = KP707106781 * (T8I + T8N);
		    T9j = T8J - T8M;
		    T9k = T8H + T8G;
		    T9l = KP707106781 * (T9j - T9k);
		    Tbm = KP707106781 * (T9k + T9j);
	       }
	       {
		    E TdR, TdU, T9g, T9h;
		    TdR = T4J - T4U;
		    TdU = TdS - TdT;
		    TdV = TdR - TdU;
		    TeX = TdR + TdU;
		    T9g = T9e - T9f;
		    T9h = T4O - T4T;
		    T9i = T9g + T9h;
		    Tbw = T9g - T9h;
	       }
	  }
	  {
	       E T5u, TdW, T8S, T8V, T62, Te3, T94, T99, T5F, TdX, T8T, T8Y, T5R, Te2, T93;
	       E T96;
	       {
		    E T5o, T8Q, T5t, T8R;
		    {
			 E T5l, T5n, T5k, T5m;
			 T5l = rio[WS(ios, 3)];
			 T5n = iio[-WS(ios, 60)];
			 T5k = W[4];
			 T5m = W[5];
			 T5o = FMA(T5k, T5l, T5m * T5n);
			 T8Q = FNMS(T5m, T5l, T5k * T5n);
		    }
		    {
			 E T5q, T5s, T5p, T5r;
			 T5q = rio[WS(ios, 35)];
			 T5s = iio[-WS(ios, 28)];
			 T5p = W[68];
			 T5r = W[69];
			 T5t = FMA(T5p, T5q, T5r * T5s);
			 T8R = FNMS(T5r, T5q, T5p * T5s);
		    }
		    T5u = T5o + T5t;
		    TdW = T8Q + T8R;
		    T8S = T8Q - T8R;
		    T8V = T5o - T5t;
	       }
	       {
		    E T5W, T97, T61, T98;
		    {
			 E T5T, T5V, T5S, T5U;
			 T5T = rio[WS(ios, 11)];
			 T5V = iio[-WS(ios, 52)];
			 T5S = W[20];
			 T5U = W[21];
			 T5W = FMA(T5S, T5T, T5U * T5V);
			 T97 = FNMS(T5U, T5T, T5S * T5V);
		    }
		    {
			 E T5Y, T60, T5X, T5Z;
			 T5Y = rio[WS(ios, 43)];
			 T60 = iio[-WS(ios, 20)];
			 T5X = W[84];
			 T5Z = W[85];
			 T61 = FMA(T5X, T5Y, T5Z * T60);
			 T98 = FNMS(T5Z, T5Y, T5X * T60);
		    }
		    T62 = T5W + T61;
		    Te3 = T97 + T98;
		    T94 = T5W - T61;
		    T99 = T97 - T98;
	       }
	       {
		    E T5z, T8W, T5E, T8X;
		    {
			 E T5w, T5y, T5v, T5x;
			 T5w = rio[WS(ios, 19)];
			 T5y = iio[-WS(ios, 44)];
			 T5v = W[36];
			 T5x = W[37];
			 T5z = FMA(T5v, T5w, T5x * T5y);
			 T8W = FNMS(T5x, T5w, T5v * T5y);
		    }
		    {
			 E T5B, T5D, T5A, T5C;
			 T5B = rio[WS(ios, 51)];
			 T5D = iio[-WS(ios, 12)];
			 T5A = W[100];
			 T5C = W[101];
			 T5E = FMA(T5A, T5B, T5C * T5D);
			 T8X = FNMS(T5C, T5B, T5A * T5D);
		    }
		    T5F = T5z + T5E;
		    TdX = T8W + T8X;
		    T8T = T5z - T5E;
		    T8Y = T8W - T8X;
	       }
	       {
		    E T5L, T91, T5Q, T92;
		    {
			 E T5I, T5K, T5H, T5J;
			 T5I = rio[WS(ios, 59)];
			 T5K = iio[-WS(ios, 4)];
			 T5H = W[116];
			 T5J = W[117];
			 T5L = FMA(T5H, T5I, T5J * T5K);
			 T91 = FNMS(T5J, T5I, T5H * T5K);
		    }
		    {
			 E T5N, T5P, T5M, T5O;
			 T5N = rio[WS(ios, 27)];
			 T5P = iio[-WS(ios, 36)];
			 T5M = W[52];
			 T5O = W[53];
			 T5Q = FMA(T5M, T5N, T5O * T5P);
			 T92 = FNMS(T5O, T5N, T5M * T5P);
		    }
		    T5R = T5L + T5Q;
		    Te2 = T91 + T92;
		    T93 = T91 - T92;
		    T96 = T5L - T5Q;
	       }
	       {
		    E T5G, T63, Te1, Te4;
		    T5G = T5u + T5F;
		    T63 = T5R + T62;
		    T64 = T5G + T63;
		    TfZ = T63 - T5G;
		    Te1 = T5R - T62;
		    Te4 = Te2 - Te3;
		    Te5 = Te1 + Te4;
		    Ted = Te1 - Te4;
	       }
	       {
		    E TfS, TfT, T8U, T8Z;
		    TfS = TdW + TdX;
		    TfT = Te2 + Te3;
		    TfU = TfS - TfT;
		    Tgz = TfS + TfT;
		    T8U = T8S + T8T;
		    T8Z = T8V - T8Y;
		    T90 = FNMS(KP923879532, T8Z, KP382683432 * T8U);
		    T9o = FMA(KP923879532, T8U, KP382683432 * T8Z);
	       }
	       {
		    E T95, T9a, Tbr, Tbs;
		    T95 = T93 + T94;
		    T9a = T96 - T99;
		    T9b = FMA(KP382683432, T95, KP923879532 * T9a);
		    T9n = FNMS(KP923879532, T95, KP382683432 * T9a);
		    Tbr = T93 - T94;
		    Tbs = T96 + T99;
		    Tbt = FMA(KP923879532, Tbr, KP382683432 * Tbs);
		    Tbz = FNMS(KP382683432, Tbr, KP923879532 * Tbs);
	       }
	       {
		    E TdY, TdZ, Tbo, Tbp;
		    TdY = TdW - TdX;
		    TdZ = T5u - T5F;
		    Te0 = TdY - TdZ;
		    Tee = TdZ + TdY;
		    Tbo = T8S - T8T;
		    Tbp = T8V + T8Y;
		    Tbq = FNMS(KP382683432, Tbp, KP923879532 * Tbo);
		    TbA = FMA(KP382683432, Tbo, KP923879532 * Tbp);
	       }
	  }
	  {
	       E T3X, TdB, T8a, T8d, T4v, Tdx, T80, T85, T48, TdC, T8b, T8g, T4k, Tdw, T7X;
	       E T84;
	       {
		    E T3R, T88, T3W, T89;
		    {
			 E T3O, T3Q, T3N, T3P;
			 T3O = rio[WS(ios, 5)];
			 T3Q = iio[-WS(ios, 58)];
			 T3N = W[8];
			 T3P = W[9];
			 T3R = FMA(T3N, T3O, T3P * T3Q);
			 T88 = FNMS(T3P, T3O, T3N * T3Q);
		    }
		    {
			 E T3T, T3V, T3S, T3U;
			 T3T = rio[WS(ios, 37)];
			 T3V = iio[-WS(ios, 26)];
			 T3S = W[72];
			 T3U = W[73];
			 T3W = FMA(T3S, T3T, T3U * T3V);
			 T89 = FNMS(T3U, T3T, T3S * T3V);
		    }
		    T3X = T3R + T3W;
		    TdB = T88 + T89;
		    T8a = T88 - T89;
		    T8d = T3R - T3W;
	       }
	       {
		    E T4p, T7Y, T4u, T7Z;
		    {
			 E T4m, T4o, T4l, T4n;
			 T4m = rio[WS(ios, 13)];
			 T4o = iio[-WS(ios, 50)];
			 T4l = W[24];
			 T4n = W[25];
			 T4p = FMA(T4l, T4m, T4n * T4o);
			 T7Y = FNMS(T4n, T4m, T4l * T4o);
		    }
		    {
			 E T4r, T4t, T4q, T4s;
			 T4r = rio[WS(ios, 45)];
			 T4t = iio[-WS(ios, 18)];
			 T4q = W[88];
			 T4s = W[89];
			 T4u = FMA(T4q, T4r, T4s * T4t);
			 T7Z = FNMS(T4s, T4r, T4q * T4t);
		    }
		    T4v = T4p + T4u;
		    Tdx = T7Y + T7Z;
		    T80 = T7Y - T7Z;
		    T85 = T4p - T4u;
	       }
	       {
		    E T42, T8e, T47, T8f;
		    {
			 E T3Z, T41, T3Y, T40;
			 T3Z = rio[WS(ios, 21)];
			 T41 = iio[-WS(ios, 42)];
			 T3Y = W[40];
			 T40 = W[41];
			 T42 = FMA(T3Y, T3Z, T40 * T41);
			 T8e = FNMS(T40, T3Z, T3Y * T41);
		    }
		    {
			 E T44, T46, T43, T45;
			 T44 = rio[WS(ios, 53)];
			 T46 = iio[-WS(ios, 10)];
			 T43 = W[104];
			 T45 = W[105];
			 T47 = FMA(T43, T44, T45 * T46);
			 T8f = FNMS(T45, T44, T43 * T46);
		    }
		    T48 = T42 + T47;
		    TdC = T8e + T8f;
		    T8b = T42 - T47;
		    T8g = T8e - T8f;
	       }
	       {
		    E T4e, T82, T4j, T83;
		    {
			 E T4b, T4d, T4a, T4c;
			 T4b = rio[WS(ios, 61)];
			 T4d = iio[-WS(ios, 2)];
			 T4a = W[120];
			 T4c = W[121];
			 T4e = FMA(T4a, T4b, T4c * T4d);
			 T82 = FNMS(T4c, T4b, T4a * T4d);
		    }
		    {
			 E T4g, T4i, T4f, T4h;
			 T4g = rio[WS(ios, 29)];
			 T4i = iio[-WS(ios, 34)];
			 T4f = W[56];
			 T4h = W[57];
			 T4j = FMA(T4f, T4g, T4h * T4i);
			 T83 = FNMS(T4h, T4g, T4f * T4i);
		    }
		    T4k = T4e + T4j;
		    Tdw = T82 + T83;
		    T7X = T4e - T4j;
		    T84 = T82 - T83;
	       }
	       {
		    E T49, T4w, TdA, TdD;
		    T49 = T3X + T48;
		    T4w = T4k + T4v;
		    T4x = T49 + T4w;
		    TfJ = T4w - T49;
		    TdA = T3X - T48;
		    TdD = TdB - TdC;
		    TdE = TdA + TdD;
		    TdM = TdD - TdA;
	       }
	       {
		    E TfM, TfN, T81, T86;
		    TfM = TdB + TdC;
		    TfN = Tdw + Tdx;
		    TfO = TfM - TfN;
		    Tgu = TfM + TfN;
		    T81 = T7X - T80;
		    T86 = T84 + T85;
		    T87 = FNMS(KP923879532, T86, KP382683432 * T81);
		    T8v = FMA(KP382683432, T86, KP923879532 * T81);
	       }
	       {
		    E T8c, T8h, Tb8, Tb9;
		    T8c = T8a + T8b;
		    T8h = T8d - T8g;
		    T8i = FMA(KP923879532, T8c, KP382683432 * T8h);
		    T8u = FNMS(KP923879532, T8h, KP382683432 * T8c);
		    Tb8 = T8a - T8b;
		    Tb9 = T8d + T8g;
		    Tba = FMA(KP382683432, Tb8, KP923879532 * Tb9);
		    Tbg = FNMS(KP382683432, Tb9, KP923879532 * Tb8);
	       }
	       {
		    E Tdv, Tdy, Tb5, Tb6;
		    Tdv = T4k - T4v;
		    Tdy = Tdw - Tdx;
		    Tdz = Tdv - Tdy;
		    TdN = Tdv + Tdy;
		    Tb5 = T7X + T80;
		    Tb6 = T84 - T85;
		    Tb7 = FNMS(KP382683432, Tb6, KP923879532 * Tb5);
		    Tbh = FMA(KP923879532, Tb6, KP382683432 * Tb5);
	       }
	  }
	  {
	       E T1t, Tgn, TgK, TgL, TgV, Th1, T30, Th0, T66, TgX, Tgw, TgE, TgB, TgF, Tgq;
	       E TgM;
	       {
		    E TH, T1s, TgI, TgJ;
		    TH = Tj + TG;
		    T1s = T14 + T1r;
		    T1t = TH + T1s;
		    Tgn = TH - T1s;
		    TgI = Tgt + Tgu;
		    TgJ = Tgy + Tgz;
		    TgK = TgI - TgJ;
		    TgL = TgI + TgJ;
	       }
	       {
		    E TgN, TgU, T2e, T2Z;
		    TgN = Tfq + Tfr;
		    TgU = TgO + TgT;
		    TgV = TgN + TgU;
		    Th1 = TgU - TgN;
		    T2e = T1Q + T2d;
		    T2Z = T2B + T2Y;
		    T30 = T2e + T2Z;
		    Th0 = T2Z - T2e;
	       }
	       {
		    E T4y, T65, Tgs, Tgv;
		    T4y = T3M + T4x;
		    T65 = T5j + T64;
		    T66 = T4y + T65;
		    TgX = T65 - T4y;
		    Tgs = T3M - T4x;
		    Tgv = Tgt - Tgu;
		    Tgw = Tgs + Tgv;
		    TgE = Tgv - Tgs;
	       }
	       {
		    E Tgx, TgA, Tgo, Tgp;
		    Tgx = T5j - T64;
		    TgA = Tgy - Tgz;
		    TgB = Tgx - TgA;
		    TgF = Tgx + TgA;
		    Tgo = Tfu + Tfv;
		    Tgp = TfA + TfB;
		    Tgq = Tgo - Tgp;
		    TgM = Tgo + Tgp;
	       }
	       {
		    E T31, TgW, TgH, TgY;
		    T31 = T1t + T30;
		    iio[-WS(ios, 32)] = T31 - T66;
		    rio[0] = T31 + T66;
		    TgW = TgM + TgV;
		    rio[WS(ios, 32)] = TgL - TgW;
		    iio[0] = TgL + TgW;
		    TgH = T1t - T30;
		    iio[-WS(ios, 48)] = TgH - TgK;
		    rio[WS(ios, 16)] = TgH + TgK;
		    TgY = TgV - TgM;
		    rio[WS(ios, 48)] = TgX - TgY;
		    iio[-WS(ios, 16)] = TgX + TgY;
	       }
	       {
		    E Tgr, TgC, TgZ, Th2;
		    Tgr = Tgn + Tgq;
		    TgC = KP707106781 * (Tgw + TgB);
		    iio[-WS(ios, 40)] = Tgr - TgC;
		    rio[WS(ios, 8)] = Tgr + TgC;
		    TgZ = KP707106781 * (TgE + TgF);
		    Th2 = Th0 + Th1;
		    rio[WS(ios, 40)] = TgZ - Th2;
		    iio[-WS(ios, 8)] = TgZ + Th2;
	       }
	       {
		    E TgD, TgG, Th3, Th4;
		    TgD = Tgn - Tgq;
		    TgG = KP707106781 * (TgE - TgF);
		    iio[-WS(ios, 56)] = TgD - TgG;
		    rio[WS(ios, 24)] = TgD + TgG;
		    Th3 = KP707106781 * (TgB - Tgw);
		    Th4 = Th1 - Th0;
		    rio[WS(ios, 56)] = Th3 - Th4;
		    iio[-WS(ios, 24)] = Th3 + Th4;
	       }
	  }
	  {
	       E Tft, Tg7, Tgh, Tgl, Th9, Thf, TfE, Th6, TfQ, Tg4, Tga, The, Tge, Tgk, Tg1;
	       E Tg5;
	       {
		    E Tfp, Tfs, Tgf, Tgg;
		    Tfp = Tj - TG;
		    Tfs = Tfq - Tfr;
		    Tft = Tfp - Tfs;
		    Tg7 = Tfp + Tfs;
		    Tgf = TfR + TfU;
		    Tgg = TfY + TfZ;
		    Tgh = FNMS(KP382683432, Tgg, KP923879532 * Tgf);
		    Tgl = FMA(KP923879532, Tgg, KP382683432 * Tgf);
	       }
	       {
		    E Th7, Th8, Tfy, TfD;
		    Th7 = T1r - T14;
		    Th8 = TgT - TgO;
		    Th9 = Th7 + Th8;
		    Thf = Th8 - Th7;
		    Tfy = Tfw - Tfx;
		    TfD = Tfz + TfC;
		    TfE = KP707106781 * (Tfy - TfD);
		    Th6 = KP707106781 * (Tfy + TfD);
	       }
	       {
		    E TfK, TfP, Tg8, Tg9;
		    TfK = TfI - TfJ;
		    TfP = TfL - TfO;
		    TfQ = FMA(KP923879532, TfK, KP382683432 * TfP);
		    Tg4 = FNMS(KP923879532, TfP, KP382683432 * TfK);
		    Tg8 = Tfx + Tfw;
		    Tg9 = Tfz - TfC;
		    Tga = KP707106781 * (Tg8 + Tg9);
		    The = KP707106781 * (Tg9 - Tg8);
	       }
	       {
		    E Tgc, Tgd, TfV, Tg0;
		    Tgc = TfI + TfJ;
		    Tgd = TfL + TfO;
		    Tge = FMA(KP382683432, Tgc, KP923879532 * Tgd);
		    Tgk = FNMS(KP382683432, Tgd, KP923879532 * Tgc);
		    TfV = TfR - TfU;
		    Tg0 = TfY - TfZ;
		    Tg1 = FNMS(KP923879532, Tg0, KP382683432 * TfV);
		    Tg5 = FMA(KP382683432, Tg0, KP923879532 * TfV);
	       }
	       {
		    E TfF, Tg2, Thd, Thg;
		    TfF = Tft + TfE;
		    Tg2 = TfQ + Tg1;
		    iio[-WS(ios, 44)] = TfF - Tg2;
		    rio[WS(ios, 12)] = TfF + Tg2;
		    Thd = Tg4 + Tg5;
		    Thg = The + Thf;
		    rio[WS(ios, 44)] = Thd - Thg;
		    iio[-WS(ios, 12)] = Thd + Thg;
	       }
	       {
		    E Tg3, Tg6, Thh, Thi;
		    Tg3 = Tft - TfE;
		    Tg6 = Tg4 - Tg5;
		    iio[-WS(ios, 60)] = Tg3 - Tg6;
		    rio[WS(ios, 28)] = Tg3 + Tg6;
		    Thh = Tg1 - TfQ;
		    Thi = Thf - The;
		    rio[WS(ios, 60)] = Thh - Thi;
		    iio[-WS(ios, 28)] = Thh + Thi;
	       }
	       {
		    E Tgb, Tgi, Th5, Tha;
		    Tgb = Tg7 + Tga;
		    Tgi = Tge + Tgh;
		    iio[-WS(ios, 36)] = Tgb - Tgi;
		    rio[WS(ios, 4)] = Tgb + Tgi;
		    Th5 = Tgk + Tgl;
		    Tha = Th6 + Th9;
		    rio[WS(ios, 36)] = Th5 - Tha;
		    iio[-WS(ios, 4)] = Th5 + Tha;
	       }
	       {
		    E Tgj, Tgm, Thb, Thc;
		    Tgj = Tg7 - Tga;
		    Tgm = Tgk - Tgl;
		    iio[-WS(ios, 52)] = Tgj - Tgm;
		    rio[WS(ios, 20)] = Tgj + Tgm;
		    Thb = Tgh - Tge;
		    Thc = Th9 - Th6;
		    rio[WS(ios, 52)] = Thb - Thc;
		    iio[-WS(ios, 20)] = Thb + Thc;
	       }
	  }
	  {
	       E Td1, Ten, Tdo, ThA, ThD, ThJ, Teq, ThI, Teh, TeB, Tel, Tex, TdQ, TeA, Tek;
	       E Teu;
	       {
		    E TcP, Td0, Teo, Tep;
		    TcP = TcL - TcO;
		    Td0 = KP707106781 * (TcU - TcZ);
		    Td1 = TcP - Td0;
		    Ten = TcP + Td0;
		    {
			 E Tdc, Tdn, ThB, ThC;
			 Tdc = FNMS(KP923879532, Tdb, KP382683432 * Td6);
			 Tdn = FMA(KP382683432, Tdh, KP923879532 * Tdm);
			 Tdo = Tdc - Tdn;
			 ThA = Tdc + Tdn;
			 ThB = KP707106781 * (TeF - TeE);
			 ThC = Thn - Thm;
			 ThD = ThB + ThC;
			 ThJ = ThC - ThB;
		    }
		    Teo = FMA(KP923879532, Td6, KP382683432 * Tdb);
		    Tep = FNMS(KP923879532, Tdh, KP382683432 * Tdm);
		    Teq = Teo + Tep;
		    ThI = Tep - Teo;
		    {
			 E Te7, Tev, Teg, Tew, Te6, Tef;
			 Te6 = KP707106781 * (Te0 - Te5);
			 Te7 = TdV - Te6;
			 Tev = TdV + Te6;
			 Tef = KP707106781 * (Ted - Tee);
			 Teg = Tec - Tef;
			 Tew = Tec + Tef;
			 Teh = FNMS(KP980785280, Teg, KP195090322 * Te7);
			 TeB = FMA(KP831469612, Tew, KP555570233 * Tev);
			 Tel = FMA(KP195090322, Teg, KP980785280 * Te7);
			 Tex = FNMS(KP555570233, Tew, KP831469612 * Tev);
		    }
		    {
			 E TdG, Tes, TdP, Tet, TdF, TdO;
			 TdF = KP707106781 * (Tdz - TdE);
			 TdG = Tdu - TdF;
			 Tes = Tdu + TdF;
			 TdO = KP707106781 * (TdM - TdN);
			 TdP = TdL - TdO;
			 Tet = TdL + TdO;
			 TdQ = FMA(KP980785280, TdG, KP195090322 * TdP);
			 TeA = FNMS(KP555570233, Tet, KP831469612 * Tes);
			 Tek = FNMS(KP980785280, TdP, KP195090322 * TdG);
			 Teu = FMA(KP555570233, Tes, KP831469612 * Tet);
		    }
	       }
	       {
		    E Tdp, Tei, ThH, ThK;
		    Tdp = Td1 + Tdo;
		    Tei = TdQ + Teh;
		    iio[-WS(ios, 46)] = Tdp - Tei;
		    rio[WS(ios, 14)] = Tdp + Tei;
		    ThH = Tek + Tel;
		    ThK = ThI + ThJ;
		    rio[WS(ios, 46)] = ThH - ThK;
		    iio[-WS(ios, 14)] = ThH + ThK;
	       }
	       {
		    E Tej, Tem, ThL, ThM;
		    Tej = Td1 - Tdo;
		    Tem = Tek - Tel;
		    iio[-WS(ios, 62)] = Tej - Tem;
		    rio[WS(ios, 30)] = Tej + Tem;
		    ThL = Teh - TdQ;
		    ThM = ThJ - ThI;
		    rio[WS(ios, 62)] = ThL - ThM;
		    iio[-WS(ios, 30)] = ThL + ThM;
	       }
	       {
		    E Ter, Tey, Thz, ThE;
		    Ter = Ten + Teq;
		    Tey = Teu + Tex;
		    iio[-WS(ios, 38)] = Ter - Tey;
		    rio[WS(ios, 6)] = Ter + Tey;
		    Thz = TeA + TeB;
		    ThE = ThA + ThD;
		    rio[WS(ios, 38)] = Thz - ThE;
		    iio[-WS(ios, 6)] = Thz + ThE;
	       }
	       {
		    E Tez, TeC, ThF, ThG;
		    Tez = Ten - Teq;
		    TeC = TeA - TeB;
		    iio[-WS(ios, 54)] = Tez - TeC;
		    rio[WS(ios, 22)] = Tez + TeC;
		    ThF = Tex - Teu;
		    ThG = ThD - ThA;
		    rio[WS(ios, 54)] = ThF - ThG;
		    iio[-WS(ios, 22)] = ThF + ThG;
	       }
	  }
	  {
	       E TeH, Tf9, TeO, Thk, Thp, Thv, Tfc, Thu, Tf3, Tfn, Tf7, Tfj, TeW, Tfm, Tf6;
	       E Tfg;
	       {
		    E TeD, TeG, Tfa, Tfb;
		    TeD = TcL + TcO;
		    TeG = KP707106781 * (TeE + TeF);
		    TeH = TeD - TeG;
		    Tf9 = TeD + TeG;
		    {
			 E TeK, TeN, Thl, Tho;
			 TeK = FNMS(KP382683432, TeJ, KP923879532 * TeI);
			 TeN = FMA(KP923879532, TeL, KP382683432 * TeM);
			 TeO = TeK - TeN;
			 Thk = TeK + TeN;
			 Thl = KP707106781 * (TcU + TcZ);
			 Tho = Thm + Thn;
			 Thp = Thl + Tho;
			 Thv = Tho - Thl;
		    }
		    Tfa = FMA(KP382683432, TeI, KP923879532 * TeJ);
		    Tfb = FNMS(KP382683432, TeL, KP923879532 * TeM);
		    Tfc = Tfa + Tfb;
		    Thu = Tfb - Tfa;
		    {
			 E TeZ, Tfh, Tf2, Tfi, TeY, Tf1;
			 TeY = KP707106781 * (Tee + Ted);
			 TeZ = TeX - TeY;
			 Tfh = TeX + TeY;
			 Tf1 = KP707106781 * (Te0 + Te5);
			 Tf2 = Tf0 - Tf1;
			 Tfi = Tf0 + Tf1;
			 Tf3 = FNMS(KP831469612, Tf2, KP555570233 * TeZ);
			 Tfn = FMA(KP195090322, Tfh, KP980785280 * Tfi);
			 Tf7 = FMA(KP831469612, TeZ, KP555570233 * Tf2);
			 Tfj = FNMS(KP195090322, Tfi, KP980785280 * Tfh);
		    }
		    {
			 E TeS, Tfe, TeV, Tff, TeR, TeU;
			 TeR = KP707106781 * (TdE + Tdz);
			 TeS = TeQ - TeR;
			 Tfe = TeQ + TeR;
			 TeU = KP707106781 * (TdM + TdN);
			 TeV = TeT - TeU;
			 Tff = TeT + TeU;
			 TeW = FMA(KP555570233, TeS, KP831469612 * TeV);
			 Tfm = FNMS(KP195090322, Tfe, KP980785280 * Tff);
			 Tf6 = FNMS(KP831469612, TeS, KP555570233 * TeV);
			 Tfg = FMA(KP980785280, Tfe, KP195090322 * Tff);
		    }
	       }
	       {
		    E TeP, Tf4, Tht, Thw;
		    TeP = TeH + TeO;
		    Tf4 = TeW + Tf3;
		    iio[-WS(ios, 42)] = TeP - Tf4;
		    rio[WS(ios, 10)] = TeP + Tf4;
		    Tht = Tf6 + Tf7;
		    Thw = Thu + Thv;
		    rio[WS(ios, 42)] = Tht - Thw;
		    iio[-WS(ios, 10)] = Tht + Thw;
	       }
	       {
		    E Tf5, Tf8, Thx, Thy;
		    Tf5 = TeH - TeO;
		    Tf8 = Tf6 - Tf7;
		    iio[-WS(ios, 58)] = Tf5 - Tf8;
		    rio[WS(ios, 26)] = Tf5 + Tf8;
		    Thx = Tf3 - TeW;
		    Thy = Thv - Thu;
		    rio[WS(ios, 58)] = Thx - Thy;
		    iio[-WS(ios, 26)] = Thx + Thy;
	       }
	       {
		    E Tfd, Tfk, Thj, Thq;
		    Tfd = Tf9 + Tfc;
		    Tfk = Tfg + Tfj;
		    iio[-WS(ios, 34)] = Tfd - Tfk;
		    rio[WS(ios, 2)] = Tfd + Tfk;
		    Thj = Tfm + Tfn;
		    Thq = Thk + Thp;
		    rio[WS(ios, 34)] = Thj - Thq;
		    iio[-WS(ios, 2)] = Thj + Thq;
	       }
	       {
		    E Tfl, Tfo, Thr, Ths;
		    Tfl = Tf9 - Tfc;
		    Tfo = Tfm - Tfn;
		    iio[-WS(ios, 50)] = Tfl - Tfo;
		    rio[WS(ios, 18)] = Tfl + Tfo;
		    Thr = Tfj - Tfg;
		    Ths = Thp - Thk;
		    rio[WS(ios, 50)] = Thr - Ths;
		    iio[-WS(ios, 18)] = Thr + Ths;
	       }
	  }
	  {
	       E T6L, T9x, TiD, TiJ, T7E, TiI, T9A, TiA, T8y, T9K, T9u, T9E, T9r, T9L, T9v;
	       E T9H;
	       {
		    E T6n, T6K, TiB, TiC;
		    T6n = T6b - T6m;
		    T6K = T6y - T6J;
		    T6L = T6n - T6K;
		    T9x = T6n + T6K;
		    TiB = T9P - T9O;
		    TiC = Tin - Tim;
		    TiD = TiB + TiC;
		    TiJ = TiC - TiB;
	       }
	       {
		    E T7c, T9y, T7D, T9z;
		    {
			 E T72, T7b, T7t, T7C;
			 T72 = T6Q - T71;
			 T7b = T77 - T7a;
			 T7c = FNMS(KP980785280, T7b, KP195090322 * T72);
			 T9y = FMA(KP980785280, T72, KP195090322 * T7b);
			 T7t = T7h - T7s;
			 T7C = T7y - T7B;
			 T7D = FMA(KP195090322, T7t, KP980785280 * T7C);
			 T9z = FNMS(KP980785280, T7t, KP195090322 * T7C);
		    }
		    T7E = T7c - T7D;
		    TiI = T9z - T9y;
		    T9A = T9y + T9z;
		    TiA = T7c + T7D;
	       }
	       {
		    E T8k, T9C, T8x, T9D;
		    {
			 E T7W, T8j, T8t, T8w;
			 T7W = T7K - T7V;
			 T8j = T87 - T8i;
			 T8k = T7W - T8j;
			 T9C = T7W + T8j;
			 T8t = T8p - T8s;
			 T8w = T8u - T8v;
			 T8x = T8t - T8w;
			 T9D = T8t + T8w;
		    }
		    T8y = FMA(KP995184726, T8k, KP098017140 * T8x);
		    T9K = FNMS(KP634393284, T9D, KP773010453 * T9C);
		    T9u = FNMS(KP995184726, T8x, KP098017140 * T8k);
		    T9E = FMA(KP634393284, T9C, KP773010453 * T9D);
	       }
	       {
		    E T9d, T9F, T9q, T9G;
		    {
			 E T8P, T9c, T9m, T9p;
			 T8P = T8D - T8O;
			 T9c = T90 - T9b;
			 T9d = T8P - T9c;
			 T9F = T8P + T9c;
			 T9m = T9i - T9l;
			 T9p = T9n - T9o;
			 T9q = T9m - T9p;
			 T9G = T9m + T9p;
		    }
		    T9r = FNMS(KP995184726, T9q, KP098017140 * T9d);
		    T9L = FMA(KP773010453, T9G, KP634393284 * T9F);
		    T9v = FMA(KP098017140, T9q, KP995184726 * T9d);
		    T9H = FNMS(KP634393284, T9G, KP773010453 * T9F);
	       }
	       {
		    E T7F, T9s, TiH, TiK;
		    T7F = T6L + T7E;
		    T9s = T8y + T9r;
		    iio[-WS(ios, 47)] = T7F - T9s;
		    rio[WS(ios, 15)] = T7F + T9s;
		    TiH = T9u + T9v;
		    TiK = TiI + TiJ;
		    rio[WS(ios, 47)] = TiH - TiK;
		    iio[-WS(ios, 15)] = TiH + TiK;
	       }
	       {
		    E T9t, T9w, TiL, TiM;
		    T9t = T6L - T7E;
		    T9w = T9u - T9v;
		    iio[-WS(ios, 63)] = T9t - T9w;
		    rio[WS(ios, 31)] = T9t + T9w;
		    TiL = T9r - T8y;
		    TiM = TiJ - TiI;
		    rio[WS(ios, 63)] = TiL - TiM;
		    iio[-WS(ios, 31)] = TiL + TiM;
	       }
	       {
		    E T9B, T9I, Tiz, TiE;
		    T9B = T9x + T9A;
		    T9I = T9E + T9H;
		    iio[-WS(ios, 39)] = T9B - T9I;
		    rio[WS(ios, 7)] = T9B + T9I;
		    Tiz = T9K + T9L;
		    TiE = TiA + TiD;
		    rio[WS(ios, 39)] = Tiz - TiE;
		    iio[-WS(ios, 7)] = Tiz + TiE;
	       }
	       {
		    E T9J, T9M, TiF, TiG;
		    T9J = T9x - T9A;
		    T9M = T9K - T9L;
		    iio[-WS(ios, 55)] = T9J - T9M;
		    rio[WS(ios, 23)] = T9J + T9M;
		    TiF = T9H - T9E;
		    TiG = TiD - TiA;
		    rio[WS(ios, 55)] = TiF - TiG;
		    iio[-WS(ios, 23)] = TiF + TiG;
	       }
	  }
	  {
	       E TaL, TbJ, Ti9, Tif, Tb0, Tie, TbM, Ti6, Tbk, TbW, TbG, TbQ, TbD, TbX, TbH;
	       E TbT;
	       {
		    E TaD, TaK, Ti7, Ti8;
		    TaD = Taz - TaC;
		    TaK = TaG - TaJ;
		    TaL = TaD - TaK;
		    TbJ = TaD + TaK;
		    Ti7 = Tc1 - Tc0;
		    Ti8 = ThT - ThQ;
		    Ti9 = Ti7 + Ti8;
		    Tif = Ti8 - Ti7;
	       }
	       {
		    E TaS, TbK, TaZ, TbL;
		    {
			 E TaO, TaR, TaV, TaY;
			 TaO = TaM - TaN;
			 TaR = TaP - TaQ;
			 TaS = FNMS(KP831469612, TaR, KP555570233 * TaO);
			 TbK = FMA(KP555570233, TaR, KP831469612 * TaO);
			 TaV = TaT - TaU;
			 TaY = TaW - TaX;
			 TaZ = FMA(KP831469612, TaV, KP555570233 * TaY);
			 TbL = FNMS(KP831469612, TaY, KP555570233 * TaV);
		    }
		    Tb0 = TaS - TaZ;
		    Tie = TbL - TbK;
		    TbM = TbK + TbL;
		    Ti6 = TaS + TaZ;
	       }
	       {
		    E Tbc, TbO, Tbj, TbP;
		    {
			 E Tb4, Tbb, Tbf, Tbi;
			 Tb4 = Tb2 - Tb3;
			 Tbb = Tb7 - Tba;
			 Tbc = Tb4 - Tbb;
			 TbO = Tb4 + Tbb;
			 Tbf = Tbd - Tbe;
			 Tbi = Tbg - Tbh;
			 Tbj = Tbf - Tbi;
			 TbP = Tbf + Tbi;
		    }
		    Tbk = FMA(KP956940335, Tbc, KP290284677 * Tbj);
		    TbW = FNMS(KP471396736, TbP, KP881921264 * TbO);
		    TbG = FNMS(KP956940335, Tbj, KP290284677 * Tbc);
		    TbQ = FMA(KP471396736, TbO, KP881921264 * TbP);
	       }
	       {
		    E Tbv, TbR, TbC, TbS;
		    {
			 E Tbn, Tbu, Tby, TbB;
			 Tbn = Tbl - Tbm;
			 Tbu = Tbq - Tbt;
			 Tbv = Tbn - Tbu;
			 TbR = Tbn + Tbu;
			 Tby = Tbw - Tbx;
			 TbB = Tbz - TbA;
			 TbC = Tby - TbB;
			 TbS = Tby + TbB;
		    }
		    TbD = FNMS(KP956940335, TbC, KP290284677 * Tbv);
		    TbX = FMA(KP881921264, TbS, KP471396736 * TbR);
		    TbH = FMA(KP290284677, TbC, KP956940335 * Tbv);
		    TbT = FNMS(KP471396736, TbS, KP881921264 * TbR);
	       }
	       {
		    E Tb1, TbE, Tid, Tig;
		    Tb1 = TaL + Tb0;
		    TbE = Tbk + TbD;
		    iio[-WS(ios, 45)] = Tb1 - TbE;
		    rio[WS(ios, 13)] = Tb1 + TbE;
		    Tid = TbG + TbH;
		    Tig = Tie + Tif;
		    rio[WS(ios, 45)] = Tid - Tig;
		    iio[-WS(ios, 13)] = Tid + Tig;
	       }
	       {
		    E TbF, TbI, Tih, Tii;
		    TbF = TaL - Tb0;
		    TbI = TbG - TbH;
		    iio[-WS(ios, 61)] = TbF - TbI;
		    rio[WS(ios, 29)] = TbF + TbI;
		    Tih = TbD - Tbk;
		    Tii = Tif - Tie;
		    rio[WS(ios, 61)] = Tih - Tii;
		    iio[-WS(ios, 29)] = Tih + Tii;
	       }
	       {
		    E TbN, TbU, Ti5, Tia;
		    TbN = TbJ + TbM;
		    TbU = TbQ + TbT;
		    iio[-WS(ios, 37)] = TbN - TbU;
		    rio[WS(ios, 5)] = TbN + TbU;
		    Ti5 = TbW + TbX;
		    Tia = Ti6 + Ti9;
		    rio[WS(ios, 37)] = Ti5 - Tia;
		    iio[-WS(ios, 5)] = Ti5 + Tia;
	       }
	       {
		    E TbV, TbY, Tib, Tic;
		    TbV = TbJ - TbM;
		    TbY = TbW - TbX;
		    iio[-WS(ios, 53)] = TbV - TbY;
		    rio[WS(ios, 21)] = TbV + TbY;
		    Tib = TbT - TbQ;
		    Tic = Ti9 - Ti6;
		    rio[WS(ios, 53)] = Tib - Tic;
		    iio[-WS(ios, 21)] = Tib + Tic;
	       }
	  }
	  {
	       E Tc3, Tcv, ThV, Ti1, Tca, Ti0, Tcy, ThO, Tci, TcI, Tcs, TcC, Tcp, TcJ, Tct;
	       E TcF;
	       {
		    E TbZ, Tc2, ThP, ThU;
		    TbZ = Taz + TaC;
		    Tc2 = Tc0 + Tc1;
		    Tc3 = TbZ - Tc2;
		    Tcv = TbZ + Tc2;
		    ThP = TaG + TaJ;
		    ThU = ThQ + ThT;
		    ThV = ThP + ThU;
		    Ti1 = ThU - ThP;
	       }
	       {
		    E Tc6, Tcw, Tc9, Tcx;
		    {
			 E Tc4, Tc5, Tc7, Tc8;
			 Tc4 = TaM + TaN;
			 Tc5 = TaP + TaQ;
			 Tc6 = FNMS(KP195090322, Tc5, KP980785280 * Tc4);
			 Tcw = FMA(KP980785280, Tc5, KP195090322 * Tc4);
			 Tc7 = TaT + TaU;
			 Tc8 = TaW + TaX;
			 Tc9 = FMA(KP195090322, Tc7, KP980785280 * Tc8);
			 Tcx = FNMS(KP195090322, Tc8, KP980785280 * Tc7);
		    }
		    Tca = Tc6 - Tc9;
		    Ti0 = Tcx - Tcw;
		    Tcy = Tcw + Tcx;
		    ThO = Tc6 + Tc9;
	       }
	       {
		    E Tce, TcA, Tch, TcB;
		    {
			 E Tcc, Tcd, Tcf, Tcg;
			 Tcc = Tbd + Tbe;
			 Tcd = Tba + Tb7;
			 Tce = Tcc - Tcd;
			 TcA = Tcc + Tcd;
			 Tcf = Tb2 + Tb3;
			 Tcg = Tbg + Tbh;
			 Tch = Tcf - Tcg;
			 TcB = Tcf + Tcg;
		    }
		    Tci = FMA(KP634393284, Tce, KP773010453 * Tch);
		    TcI = FNMS(KP098017140, TcA, KP995184726 * TcB);
		    Tcs = FNMS(KP773010453, Tce, KP634393284 * Tch);
		    TcC = FMA(KP995184726, TcA, KP098017140 * TcB);
	       }
	       {
		    E Tcl, TcD, Tco, TcE;
		    {
			 E Tcj, Tck, Tcm, Tcn;
			 Tcj = Tbl + Tbm;
			 Tck = TbA + Tbz;
			 Tcl = Tcj - Tck;
			 TcD = Tcj + Tck;
			 Tcm = Tbw + Tbx;
			 Tcn = Tbq + Tbt;
			 Tco = Tcm - Tcn;
			 TcE = Tcm + Tcn;
		    }
		    Tcp = FNMS(KP773010453, Tco, KP634393284 * Tcl);
		    TcJ = FMA(KP098017140, TcD, KP995184726 * TcE);
		    Tct = FMA(KP773010453, Tcl, KP634393284 * Tco);
		    TcF = FNMS(KP098017140, TcE, KP995184726 * TcD);
	       }
	       {
		    E Tcb, Tcq, ThZ, Ti2;
		    Tcb = Tc3 + Tca;
		    Tcq = Tci + Tcp;
		    iio[-WS(ios, 41)] = Tcb - Tcq;
		    rio[WS(ios, 9)] = Tcb + Tcq;
		    ThZ = Tcs + Tct;
		    Ti2 = Ti0 + Ti1;
		    rio[WS(ios, 41)] = ThZ - Ti2;
		    iio[-WS(ios, 9)] = ThZ + Ti2;
	       }
	       {
		    E Tcr, Tcu, Ti3, Ti4;
		    Tcr = Tc3 - Tca;
		    Tcu = Tcs - Tct;
		    iio[-WS(ios, 57)] = Tcr - Tcu;
		    rio[WS(ios, 25)] = Tcr + Tcu;
		    Ti3 = Tcp - Tci;
		    Ti4 = Ti1 - Ti0;
		    rio[WS(ios, 57)] = Ti3 - Ti4;
		    iio[-WS(ios, 25)] = Ti3 + Ti4;
	       }
	       {
		    E Tcz, TcG, ThN, ThW;
		    Tcz = Tcv + Tcy;
		    TcG = TcC + TcF;
		    iio[-WS(ios, 33)] = Tcz - TcG;
		    rio[WS(ios, 1)] = Tcz + TcG;
		    ThN = TcI + TcJ;
		    ThW = ThO + ThV;
		    rio[WS(ios, 33)] = ThN - ThW;
		    iio[-WS(ios, 1)] = ThN + ThW;
	       }
	       {
		    E TcH, TcK, ThX, ThY;
		    TcH = Tcv - Tcy;
		    TcK = TcI - TcJ;
		    iio[-WS(ios, 49)] = TcH - TcK;
		    rio[WS(ios, 17)] = TcH + TcK;
		    ThX = TcF - TcC;
		    ThY = ThV - ThO;
		    rio[WS(ios, 49)] = ThX - ThY;
		    iio[-WS(ios, 17)] = ThX + ThY;
	       }
	  }
	  {
	       E T9R, Taj, Tip, Tiv, T9Y, Tiu, Tam, Tik, Ta6, Taw, Tag, Taq, Tad, Tax, Tah;
	       E Tat;
	       {
		    E T9N, T9Q, Til, Tio;
		    T9N = T6b + T6m;
		    T9Q = T9O + T9P;
		    T9R = T9N - T9Q;
		    Taj = T9N + T9Q;
		    Til = T6y + T6J;
		    Tio = Tim + Tin;
		    Tip = Til + Tio;
		    Tiv = Tio - Til;
	       }
	       {
		    E T9U, Tak, T9X, Tal;
		    {
			 E T9S, T9T, T9V, T9W;
			 T9S = T6Q + T71;
			 T9T = T77 + T7a;
			 T9U = FNMS(KP555570233, T9T, KP831469612 * T9S);
			 Tak = FMA(KP555570233, T9S, KP831469612 * T9T);
			 T9V = T7h + T7s;
			 T9W = T7y + T7B;
			 T9X = FMA(KP831469612, T9V, KP555570233 * T9W);
			 Tal = FNMS(KP555570233, T9V, KP831469612 * T9W);
		    }
		    T9Y = T9U - T9X;
		    Tiu = Tal - Tak;
		    Tam = Tak + Tal;
		    Tik = T9U + T9X;
	       }
	       {
		    E Ta2, Tao, Ta5, Tap;
		    {
			 E Ta0, Ta1, Ta3, Ta4;
			 Ta0 = T8p + T8s;
			 Ta1 = T8i + T87;
			 Ta2 = Ta0 - Ta1;
			 Tao = Ta0 + Ta1;
			 Ta3 = T7K + T7V;
			 Ta4 = T8u + T8v;
			 Ta5 = Ta3 - Ta4;
			 Tap = Ta3 + Ta4;
		    }
		    Ta6 = FMA(KP471396736, Ta2, KP881921264 * Ta5);
		    Taw = FNMS(KP290284677, Tao, KP956940335 * Tap);
		    Tag = FNMS(KP881921264, Ta2, KP471396736 * Ta5);
		    Taq = FMA(KP956940335, Tao, KP290284677 * Tap);
	       }
	       {
		    E Ta9, Tar, Tac, Tas;
		    {
			 E Ta7, Ta8, Taa, Tab;
			 Ta7 = T8D + T8O;
			 Ta8 = T9o + T9n;
			 Ta9 = Ta7 - Ta8;
			 Tar = Ta7 + Ta8;
			 Taa = T9i + T9l;
			 Tab = T90 + T9b;
			 Tac = Taa - Tab;
			 Tas = Taa + Tab;
		    }
		    Tad = FNMS(KP881921264, Tac, KP471396736 * Ta9);
		    Tax = FMA(KP290284677, Tar, KP956940335 * Tas);
		    Tah = FMA(KP881921264, Ta9, KP471396736 * Tac);
		    Tat = FNMS(KP290284677, Tas, KP956940335 * Tar);
	       }
	       {
		    E T9Z, Tae, Tit, Tiw;
		    T9Z = T9R + T9Y;
		    Tae = Ta6 + Tad;
		    iio[-WS(ios, 43)] = T9Z - Tae;
		    rio[WS(ios, 11)] = T9Z + Tae;
		    Tit = Tag + Tah;
		    Tiw = Tiu + Tiv;
		    rio[WS(ios, 43)] = Tit - Tiw;
		    iio[-WS(ios, 11)] = Tit + Tiw;
	       }
	       {
		    E Taf, Tai, Tix, Tiy;
		    Taf = T9R - T9Y;
		    Tai = Tag - Tah;
		    iio[-WS(ios, 59)] = Taf - Tai;
		    rio[WS(ios, 27)] = Taf + Tai;
		    Tix = Tad - Ta6;
		    Tiy = Tiv - Tiu;
		    rio[WS(ios, 59)] = Tix - Tiy;
		    iio[-WS(ios, 27)] = Tix + Tiy;
	       }
	       {
		    E Tan, Tau, Tij, Tiq;
		    Tan = Taj + Tam;
		    Tau = Taq + Tat;
		    iio[-WS(ios, 35)] = Tan - Tau;
		    rio[WS(ios, 3)] = Tan + Tau;
		    Tij = Taw + Tax;
		    Tiq = Tik + Tip;
		    rio[WS(ios, 35)] = Tij - Tiq;
		    iio[-WS(ios, 3)] = Tij + Tiq;
	       }
	       {
		    E Tav, Tay, Tir, Tis;
		    Tav = Taj - Tam;
		    Tay = Taw - Tax;
		    iio[-WS(ios, 51)] = Tav - Tay;
		    rio[WS(ios, 19)] = Tav + Tay;
		    Tir = Tat - Taq;
		    Tis = Tip - Tik;
		    rio[WS(ios, 51)] = Tir - Tis;
		    iio[-WS(ios, 19)] = Tir + Tis;
	       }
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 64},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 64, "hf_64", twinstr, {808, 270, 230, 0}, &GENUS, 0, 0, 0 };

void X(codelet_hf_64) (planner *p) {
     X(khc2hc_dit_register) (p, hf_64, &desc);
}
