/*
 * This file is part of Palantir.
 * Version : 0.4.1
 * Copyright (c) 1997 Dim Zegebart, Moscow Russia.
 * zager@post.comstar.ru
 * http://www.geocities.com/siliconvalley/pines/7817
 * file : dzapp.c
 *
 */

#include <string.h>
#include <stdio.h>
#include <io.h>
#include "palantir.h"

odlist *palantir_app_list;
dz_app *system_app;
char *wd;

//#include "d:/djgpp/work/xfault/xfault.h"
//---------------------- APP WRAPPER ------------------
// This wrapper spawned for each new app. It 'listening' app's msg queue
// and calls handler, provided by you, for each msg in queue. Then start, it
// posts msg APP_START to the queue, so you may process it at handler to
// do some startup settings. Then whole system shutdowns, kernel sends
// msg APP_STOP to each app, so you may process it to do some task specific
// deinitiliasation. By defaul, app_wrapper do return() on APP_STOP.
// It couses killing process to be performed by kernel (see PDMLWP docs for
// more details on lwp process.) If you need to exit app before APP_STOP,
// just return 0 from handler.
// See also : dz_app_kill(),dz_app_new()
// Example : you should never call this function directly. It always called
// by a kernel.
void app_wrapper(void *args)
{ dz_app *app;
  fifo_queue *q;
  dz_msg msg;
  int n;
  app=(dz_app*)lwp_getusrptr();
  q=app->msg_queue;

  #ifdef __DZ_DEBUG__
  { int tmp;
  lwp_disable;
  #ifdef __GRX_MODE__
  { char s[125];
    sprintf(s,"APP PID : %i , NAME : %s\n",lwp_getpid(),app->szName);
    textout(screen, font,s,1,cur_y,255);
    cur_y+=20;
  }
  #else
  printf("APP : %i,%s\n",lwp_getpid(),app->szName);
//  printf("%s,%d\n",app->szName,q->size);
  #endif
  lwp_enable;
  }
  #endif

  app_msg_put(app,APP_START,(int)app,(int)args);
  while (1)
   { lwp_wait_true((int*)&(q->empt));
     app_msg_get(app,&msg);
     n=app->msg_handler(msg.code,msg.p1,msg.p2);
     if (!n||msg.code==APP_STOP)
       { odlist_remove(palantir_app_list,(dz_app*)lwp_getusrptr());
         return; //this couse the selfkilling;
       }
     lwp_yield();
   }
  return;
}

//-------------------------- DZ APP KILL ---------------------------
// Post msg APP_STOP to the msg queue of a given app.
// See also : app_wrapper()
// Example :
// { dz_app *my_app;
//   my_app=dz_app_new(...);
//   ...
//   dz_app_kill(my_app);
// }
void dz_app_kill(dz_app* app)
{
  app_msg_put(app,APP_STOP,0,0);
  return;
}

//---------------------------- DZ APP NEW ---------------------------
// This is, probably, the most important function in Palantir, so don't
// skip it's description before you go further.
// First of all lets look closer at app data structure. It's taken from
// palantir.h:
// typedef struct
// { lwp *lwp_thread;
//   char szName[64];
//   int (*msg_handler)(a_message code,int p1,int p2);
//   void *app_usrdata;
//   fifo_queue *msg_queue;
// } dz_app;
//
// *lwp_thread - pointer to lwp data structure. After successful spawning
// of an app it points to the underlieing lwp thread. Since each app based
// on app_wrapper() (See app_wrapper() description for more details)
// lwp_thread points to the copy of app_wrapper.
//
// szName[64] - name of application. You provide this name. Currently not
// used by any function, but future release may work with it. For example :
// my_app=get_app_by_name(app_name)
//
// int (*msg_handler)(a_message code,int p1,int p2) - function performs
// actual msg handling. Should usualy return 1, if you want self terminate
// app just return 0 (See app_wrapper() description for more details)
// code - msg code, p1,p2 - msg parameters. Each msg type has it's own
// parameters, so you should refer to msg section below in this text.
// The minimal recomended msg_handler is :
// int my_hnd(a_message code,int p1,int p2)
// { int tmp; //variable used by lwp_enable(disable) macros
//   dz_app *app;
//
//   switch(code)
//    { case APP_START:
//       app=app_(p1); //it's optional
//       break;
//      case APP_STOP:
//       return(0); // do nothing just terminate app.
//       break;
//      default:
//       break;
//    }
//
//  return(1); //always return 1 under normal conditions.
//             //Returning 0 will couse app to be terminated by system
//             //without posting APP_STOP
// }
// Note : primarly handler goal is to process one msg per call.
// You may also handle msg queue by yourself :
// int my_hnd(...)
// { dz_app *my_app;
//   fifo_queue *msg_q;
//   dz_msg msg;
//
//   switch(code)
//    { case APP_STAR:
//       my_app=app_(p1);
//       msg_q=my_app->msg_queue;
//      deafault:
//      break;
//    }
//   // now setup your own msg loop
//   while(1)
//    { lwp_wait_true((int*)&(msg_q->empt)); //sleep until a new msg in queue
//      //alternate way is 'if (msg_q->empt) ...' don't sleep until a new msg
//      app_msg_get(my_app,&msg);
//      switch(msg.code)
//       { ... //do whatever stuff you want
//         case APP_STOP:
//         return(0);
//         deafault:
//         break;
//       }
//    }
//   return(1);
// }
//
// void *app_usrdata - pointer to some app data area. Each app may hold it's
// own set of data. For example : you have a set of cubes to be rotated by
// a thread per cube, so
// for (i=0;i<NUM_CUBES;i++)
//  { my_app=dz_app_new(...);
//    my_app->app_usrdata=cubes[i];
//  }
// ...
// int cube_app(...)
//  { static cube *my_cube;
//    dz_app *my_app;
//    ...
//    case APP_START:
//      my_app=app_(p1);
//      my_cube=my_app->app_usrdata;
//    ...
//  }
//
// fifo_queue *app_msg_queue - queue where msgs will be posts. Default size
// is 12K (4096 msgs in queue)
//
// Parametrs of dz_app_new :
// char *szName - pointer to the app's name (64 bytes maximum). If name len
// greater then 64 symbols all trailing chars will be truncated.
//
// int stack - stack size allocated to app (lwp_thread). The most
// problematic parametr. If app requeries stack larger then allocated,
// the most probably result is awful system crash :( As PDMLWP docs says
// recomended minimal size is 4096 (4K)
//
// priority - the same as in PDMLWP, thread with priority 1 get one timer
// slice, with 2 - two timer slices (twise more then 1), etc.
//
// int (*app_hnd)(a_message code,int p1,int p2) - msg handler.
//
// Return value : pointer to the newly started app (dz_app*), NULL if failed.
//
// Example :
// int my_handler(a_message code,int p1,int p2)
// { ...
// }
//
// { dz_app *my_app;
//   my_app=dz_app_new("My first app",4096,1,my_handler);
// }
dz_app* dz_app_new(char *szName,int stack,int priority,int (*app_hnd)(a_message code,int p1,int p2))
{ dz_app *app;
  fifo_queue *q;
  lwp *lwp_thread;
  int tmp;

  lwp_disable;
  app=(dz_app*)malloc(sizeof(dz_app));
  lwp_enable;
  if (app==NULL) return(NULL);
  if (!odlist_insert(palantir_app_list,app))
   { lwp_disable;
     free(app);
     lwp_enable;
     return(NULL);
   }

  q=queue_new_(4096,4);
  if (q==NULL)
   { lwp_disable;
     free(app);
     lwp_enable;
     return(NULL);
   }

  lwp_disable;
  lwp_lock(&app->status);
  app->msg_handler=app_hnd;
  app->msg_queue=q;
  app->szName[0]=0;
  if (szName!=NULL)
   { strncpy(app->szName,szName,64);
     app->szName[63]=0;
   }
  _go32_dpmi_lock_data(app,sizeof(dz_app));
  lwp_thread=lwp_spawn(app_wrapper,stack,priority,NULL,(int*)app);
  lwp_thread->lwp_threadtype=LWP_APP;
  app->lwp_thread=lwp_thread;

  lwp_enable;
  lwp_unlock(&app->status);
  return(app);
}



