/* Various Thresholds of MPFR, not exported.

Copyright 2005, 2006, 2007, 2008 Free Software Foundation, Inc.

This file is part of the MPFR Library.

The MPFR Library is free software; you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at your
option) any later version.

The MPFR Library is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with the MPFR Library; see the file COPYING.LIB.  If not, write to
the Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
MA 02110-1301, USA. */

#ifndef __MPFR_IMPL_H__
# error "MPFR Internal not included"
#endif

/*****************************
 * Threshold for Pentium 4   *
 *****************************/
#if defined (__pentium4)

#define MPFR_MULHIGH_TAB  \
 -1,0,-1,0,-1,0,0,-1,0,-1,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 40,0,0,48,0,0,0,0,0,0,0,0,0,0,48,44, \
 56,0,56,0,46,0,0,56,56,68,52,54,56,56,54,60, \
 56,56,72,60,64,60,80,71,60,88,79,62,60,64,80,72, \
 95,60,78,80,80,65,80,64,96,80,96,80,66,88,96,66, \
 68,68,96,88,95,95,96,94,94,86,96,94,96,95,96,95, \
 96,96,95,96,95,92,96,92,96,112,111,112,111,112,112,111, \
 108,111,128,112,110,112,112,104,112,112,111,112,111,143,126,112, \
 128,112,128,144,127,127,128,112,128,128,120,124,126,120,110,128, \
 120,128,143,126,128,128,126,128,135,128,128,128,111,112,134,127, \
 134,127,128,111,112,125,126,167,134,185,125,126,127,165,125,128, \
 128,125,144,127,166,129,130,168,144,167,168,126,127,128,129,167, \
 168,167,168,143,166,165,164,167,166,167,168,163,191,184,166,167, \
 168,165,166,166,167,168,166,166,167,168,166,167,168,189,188,189, \
 190,164,192,203,167,168,190,175,192,188,190,187,188,192,167,191, \
 188,189,190,191,239,192,168,186,187,188,189,190,191,192,168,165, \
 233,189,166,239,192,167,191,191,190,191,191,189,186,191,188,166, \
 282,191,192,167,190,191,188,191,190,189,192,191,192,188,189,188, \
 240,190,191,192,185,189,189,186,235,192,188,238,191,191,240,232, \
 189,187,191,189,287,287,189,191,191,281,284,192,283,283,190,285, \
 286,287,288,288,284,285,287,282,285,284,201,239,283,281,282,192, \
 284,285,286,287,288,288,240,282,239,284,285,286,287,288,288,284, \
 334,286,335,284,284,334,287,284,285,283,288,281,325,287,280,335, \
 334,335,336,285,286,288,335,331,331,333,334,335,335,336,334,379, \
 335,336,334,287,336,280,329,283,282,334,286,334,335,335,336,281, \
 285,286,334,286,286,334,334,287,334,335,336,336,330,335,332,329, \
 334,287,334,334,332,335,332,331,334,332,332,335,336,332,334,334, \
 334,336,336,336,331,328,330,334,333,334,334,334,334,335,336,336, \
 333,334,329,334,334,332,331,335,333,333,335,336,336,329,332,333, \
 334,335,336,335,334,332,376,334,335,336,380,335,333,334,379,331, \
 335,332,383,376,336,336,379,334,383,335,336,384,376,376,379,378, \
 334,335,378,378,334,380,384,331,376,376,376,377,380,377,381,377, \
 376,376,380,336,379,380,384,379,377,384,377,378,376,376,381,378, \
 377,384,379,378,384,334,379,384,381,378,381,377,378,379,380,381, \
 378,383,380,381,376,383,384,372,376,377,378,379,377,381,379,378, \
 381,378,383,384,378,376,377,381,376,383,383,379,380,381,382,376, \
 384,376,376,336,381,503,380,376,376,377,378,377,380,376,377,379, \
 384,376,378,500,380,384,383,502,380,381,382,379,502,496,496,381, \
 382,499,497,500,501,496,382,498,498,496,381,496,499,497,379,500, \
 497,498,498,500,498,502,496,495,502,496,497,498,499,500,498,502, \
 503,496,493,498,495,496,496,499,497,504,488,496,498,503,498,496, \
 502,495,496,496,501,496,496,497,498,503,500,501,497,497,498,499, \
 496,497,502,499,500,494,497,503,501,502,496,497,498,499,568,496, \
 496,496,496,576,498,499,502,496,502,570,496,497,504,499,568,502, \
 496,497,570,500,500,575,504,500,576,570,569,502,573,568,569,502, \
 572,568,569,570,504,576,575,503,502,503,568,569,568,501,570,573, \
 502,570,576,573,568,575,576,500,568,502,570,575,569,569,569,568, \
 572,570,568,572,568,504,569,573,571,570,568,572,572,573,570,568, \
 568,568,568,563,570,571,568,563,568,569,568,570,568,569,568,575, \
 576,569,568,568,570,570,570,571,568,569,562,575,570,571,569,569, \
 568,569,570,569,570,573,568,564,571,568,568,568,569,570,572,572, \
 568,574,575,576,567,569,569,570,570,572,573,570,575,576,570,568, \
 568,573,568,573,576,575,568,568,569,568,572,569,568,568,568,569, \
 564,569,576,567,568,562,568,571,572,570,576,568,569,570,568,572, \
 563,574,568,570,568,568,570,570,571,569,568,569,570,570,572,563, \
 842,570,568,572,569,574,569,575,576,501,568,503,568,568,568,819, \
 568,568,574,563,568,563,562,564,564,569,574,568,568,568,570,572, \
 569,568,568,575,576,894,568,839,525,576,568,568,569,573,568,568, \
 560,791,793,719,945,563,564,719,562,568,568,570,570,562,568,569, \
 720,564,573,561,560,575,568,563,568,565,568,568,856,570,570,719, \
 816,573,566,575,568,569,568,855,572,573,568,860,857,568,856,867 \
  
#define MPFR_MUL_THRESHOLD 17
#define MPFR_EXP_2_THRESHOLD 691
#define MPFR_EXP_THRESHOLD 23744

/****************************
 * Threshold for Core 2     *
 ****************************/
#elif defined (__core2)

#define MPFR_MULHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,76, \
 80,80,84,84,76,76,80,80,84,84,76,76,80,80,81,81, \
 88,88,80,80,84,96,88,88,92,89,96,84,88,88,92,92, \
 96,96,88,100,92,92,96,96,97,97,92,104,96,96,97,97, \
 101,101,96,96,100,100,104,104,99,99,100,100,104,104,123,117, \
 117,117,122,122,123,119,120,120,117,117,122,122,123,123,128,120, \
 129,129,122,122,123,123,128,128,129,129,146,146,135,147,128,128, \
 129,153,134,134,135,135,140,140,141,141,146,146,147,147,140,140, \
 141,141,146,150,147,147,152,152,153,153,146,146,147,147,152,152, \
 154,159,150,165,156,156,162,162,158,153,164,159,165,165,171,171, \
 177,167,168,168,164,164,170,175,171,171,172,172,173,173,169,169, \
 170,165,171,176,177,177,158,158,159,169,165,165,166,166,167,167, \
 168,168,169,174,200,225,176,201,177,212,213,213,224,189,215,210, \
 191,203,192,174,175,211,212,200,177,225,196,196,221,239,240,234, \
 235,235,236,212,213,225,208,208,209,209,210,216,235,235,236,236, \
 249,225,220,244,215,227,228,246,223,223,224,224,225,249,244,256, \
 251,227,252,222,235,223,224,248,249,225,268,268,251,239,240,252, \
 249,249,236,250,237,237,259,259,225,260,261,261,283,234,235,249, \
 264,271,272,237,273,273,246,246,261,261,262,248,249,284,264,271, \
 272,251,273,252,260,260,261,268,269,262,270,270,257,271,272,272, \
 273,266,267,274,296,296,297,276,277,270,271,278,300,300,273,308, \
 297,297,282,282,291,283,284,284,285,285,294,278,287,295,272,296, \
 297,297,298,298,299,307,308,300,309,309,278,286,295,295,288,288, \
 297,273,306,306,307,307,308,308,309,309,294,302,303,287,288,288, \
 297,297,290,290,307,307,308,308,309,309,286,286,287,295,296,296, \
 347,347,294,294,358,304,305,359,360,306,307,298,299,308,309,309, \
 346,364,365,365,366,366,304,304,359,377,378,378,379,370,371,380, \
 381,381,364,382,383,383,384,384,376,358,395,377,396,369,379,370, \
 362,398,363,363,364,400,401,365,366,402,403,403,404,404,405,414, \
 409,419,420,410,381,391,382,402,413,383,384,384,395,435,386,366, \
 387,387,398,398,409,389,400,400,401,401,402,402,383,413,414,414, \
 425,435,456,456,387,417,438,438,419,419,420,400,401,391,472,402, \
 453,453,474,384,445,395,396,396,397,397,398,418,419,419,420,420, \
 398,398,399,432,433,411,412,412,413,413,414,414,437,437,438,438, \
 450,428,440,473,474,419,420,464,465,465,477,510,423,467,468,468, \
 425,414,492,470,471,471,472,450,418,473,474,441,453,431,432,432, \
 433,455,456,434,435,446,447,458,437,470,427,460,461,461,462,462, \
 449,437,438,438,451,463,464,440,453,441,442,466,467,527,492,492, \
 505,469,470,506,507,507,472,472,473,485,486,474,451,487,488,488, \
 489,501,490,490,491,467,504,504,481,481,470,470,471,471,472,472, \
 473,473,474,510,523,523,524,524,525,477,490,490,491,527,528,492, \
 528,528,477,503,491,504,505,492,493,506,507,507,495,495,496,509, \
 510,510,524,524,499,525,474,513,501,514,528,515,516,490,517,517, \
 518,492,519,519,520,520,521,508,509,483,523,497,498,524,473,486, \
 500,526,527,527,528,528,490,490,517,491,596,479,519,636,494,520, \
 599,501,600,600,489,503,504,602,603,505,492,632,633,493,494,592, \
 607,523,524,510,525,525,526,526,527,639,528,500,501,599,600,572, \
 517,489,630,630,631,603,604,632,591,633,522,522,635,635,636,608, \
 595,595,638,526,527,625,598,528,599,599,600,600,601,601,602,602, \
 599,629,600,600,616,526,617,632,633,633,634,634,635,620,621,621, \
 637,667,638,668,669,624,625,640,671,641,672,672,643,643,644,644, \
 645,645,661,661,662,707,663,633,664,664,665,665,666,666,667,667, \
 668,668,669,669,670,670,671,671,672,672,673,703,704,704,705,705, \
 705,673,674,706,707,691,708,676,677,677,678,662,663,711,696,696, \
 665,697,698,666,667,715,716,636,669,669,638,702,703,639,704,672, \
 705,705,706,738,643,707,708,708,741,693,710,694,679,679,744,744, \
 777,633,634,682,779,699,700,700,701,669,670,782,751,751,736,704 \
  
#define MPFR_SQRHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,0,6,6,7,8,8,8, \
 0,9,10,10,11,11,13,12,13,13,14,14,15,15,16,16, \
 17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24, \
 25,25,26,26,27,27,28,28,29,29,30,30,31,31,32,32, \
 33,33,34,34,35,35,36,36,37,37,38,38,39,39,40,40, \
 41,41,42,42,43,43,44,44,45,45,46,46,47,47,48,48, \
 49,49,50,50,51,51,52,52,53,53,54,54,55,55,56,56, \
 57,57,58,58,59,59,60,60,61,61,62,62,63,63,64,64, \
 65,65,66,66,67,67,68,68,69,72,70,70,71,71,72,72, \
 73,73,74,74,75,75,76,76,83,86,78,78,79,79,80,80, \
 81,81,82,82,83,83,84,84,85,85,86,86,87,87,88,88, \
 89,89,90,90,91,91,92,92,93,93,94,94,95,95,96,96, \
 97,97,98,98,99,99,100,100,101,101,102,102,103,103,104,104, \
 105,105,106,106,107,107,108,108,109,109,110,110,111,111,112,112, \
 113,113,114,114,115,115,116,116,117,117,118,118,119,119,120,120, \
 121,121,122,154,123,151,152,156,149,149,150,146,147,143,144,128, \
 129,129,130,130,131,131,132,132,133,133,134,134,135,135,136,136, \
 137,137,138,138,139,139,140,140,141,141,142,142,143,143,144,144, \
 145,145,146,146,147,147,148,148,149,149,150,150,151,151,152,152, \
 153,153,154,154,155,155,156,156,157,157,158,158,159,159,160,160, \
 161,161,162,162,163,163,164,164,165,165,166,166,167,167,168,168, \
 169,169,170,170,171,171,172,172,173,173,186,186,187,175,176,188, \
 189,189,178,184,185,191,192,192,181,181,182,182,183,183,184,184, \
 185,185,186,186,187,187,188,188,189,189,190,190,191,191,192,192, \
 193,193,194,194,195,195,196,224,225,197,233,212,199,234,235,228, \
 229,243,230,223,231,238,204,246,247,205,206,248,249,242,243,229, \
 251,209,210,210,260,260,261,212,255,213,249,249,243,264,265,265, \
 266,266,267,218,219,219,220,220,221,221,222,222,223,223,224,224, \
 225,225,226,226,227,227,228,228,229,229,230,230,231,231,232,232, \
 233,233,234,234,235,235,236,236,237,237,238,238,239,239,240,240, \
 241,241,242,242,243,243,244,244,245,245,246,246,247,247,248,248, \
 249,249,250,250,251,267,252,284,261,269,254,254,255,255,256,256, \
 257,257,258,258,259,259,260,260,261,261,262,262,263,263,264,264, \
 265,265,266,266,267,267,268,268,269,269,270,270,271,271,272,272, \
 273,273,274,274,275,275,276,276,277,277,278,278,279,279,280,280, \
 281,281,282,282,283,283,284,284,285,285,286,286,287,314,315,288, \
 289,289,290,290,291,291,292,292,293,293,294,294,295,345,326,326, \
 327,327,318,328,319,319,320,320,321,311,312,312,313,313,314,334, \
 345,325,326,326,327,327,338,338,339,339,340,340,341,341,342,312, \
 313,313,314,314,315,315,316,316,317,317,318,318,319,319,320,320, \
 321,321,333,322,323,323,324,324,325,325,326,326,327,327,328,328, \
 329,329,330,330,331,331,332,332,333,333,334,334,335,335,336,336, \
 337,337,338,338,339,339,340,340,341,341,342,342,343,343,344,344, \
 345,345,346,346,347,347,348,348,349,349,350,350,351,351,352,352, \
 353,353,354,354,355,355,356,356,357,429,442,358,359,359,360,360, \
 361,433,434,398,411,411,436,436,437,437,366,366,367,463,368,368, \
 369,369,370,454,455,371,372,456,373,373,374,374,375,375,376,376, \
 377,377,378,378,379,379,380,380,381,381,382,382,383,383,384,384, \
 385,385,386,386,387,387,388,388,389,389,390,390,391,391,392,392, \
 393,432,407,472,395,395,396,396,397,397,398,463,438,438,465,400, \
 401,401,402,402,403,403,404,456,457,405,406,406,407,446,408,408, \
 409,409,410,410,411,411,412,412,413,413,414,414,415,415,416,416, \
 417,417,418,460,461,419,420,420,463,421,422,422,423,423,424,424, \
 425,425,426,426,427,427,428,428,429,429,430,430,431,431,432,432, \
 433,433,434,434,435,435,436,436,437,437,438,438,439,439,440,440, \
 441,441,442,442,443,443,444,444,445,445,446,446,447,447,448,448, \
 449,449,450,450,451,526,527,527,528,453,454,454,455,455,456,456, \
 457,457,458,458,459,549,460,520,491,536,522,462,463,493,479,464, \
 465,465,466,466,467,557,558,468,469,469,470,470,471,471,472,472, \
 473,473,474,474,475,505,506,506,507,477,553,553,554,509,510,510, \
 513,481,546,514,515,483,548,484,485,485,486,486,487,535,488,488, \
 489,489,490,490,491,491,492,492,573,541,542,526,527,559,544,528, \
 529,545,546,546,547,563,548,548,549,565,566,566,567,567,568,552, \
 537,537,506,506,507,555,556,572,573,573,542,558,543,511,512,560 \
  
#define MPFR_MUL_THRESHOLD 5 /* limbs */
#define MPFR_EXP_2_THRESHOLD 718 /* bits */
#define MPFR_EXP_THRESHOLD 6816 /* bits */

/****************************
 * Threshold for AMD 64     *
 ****************************/
#elif defined (__amd64)

#define MPFR_MULHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 14,13,0,10,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,32,0,0,32,0, \
 0,0,36,0,0,36,0,0,37,0,0,38,0,39,40,0, \
 41,42,0,42,44,43,44,46,45,46,52,64,48,64,64,52, \
 63,64,63,64,64,63,64,64,63,64,63,64,64,63,64,63, \
 64,68,64,68,64,68,76,68,72,68,72,68,72,68,72,80, \
 72,70,75,80,76,84,76,80,76,80,76,84,80,84,80,92, \
 84,88,80,88,86,80,84,82,92,84,92,88,96,88,92,90, \
 88,92,93,88,92,127,128,128,128,128,127,127,127,126,127,128, \
 126,127,128,127,128,126,128,126,127,128,127,127,128,127,128,127, \
 126,127,128,128,128,128,127,136,127,128,127,128,135,127,128,135, \
 127,128,135,136,144,135,127,127,135,136,127,128,126,127,128,126, \
 127,128,135,136,128,132,136,128,127,136,140,135,136,134,136,136, \
 135,136,134,135,142,148,143,144,133,152,142,152,144,148,160,142, \
 136,152,150,160,160,148,152,160,159,152,156,159,160,151,160,164, \
 152,158,175,158,158,157,158,160,160,168,160,165,164,167,164,167, \
 160,176,166,176,165,160,167,192,183,184,176,179,176,168,175,176, \
 182,200,175,192,200,183,183,184,192,191,183,184,183,199,200,192, \
 183,180,200,182,189,180,187,200,208,257,191,190,257,200,254,208, \
 255,254,254,255,255,254,255,256,253,252,255,253,255,254,256,258, \
 252,253,254,255,253,254,255,254,263,254,254,255,256,254,254,255, \
 255,254,257,253,253,254,264,254,256,255,256,255,260,254,255,255, \
 253,254,255,256,254,254,263,263,254,254,255,255,255,264,255,256, \
 255,264,255,258,263,264,263,262,262,276,256,263,258,276,275,272, \
 264,259,275,272,259,288,281,255,256,275,287,258,284,262,255,262, \
 254,255,265,288,254,287,299,257,288,255,257,263,254,257,324,267, \
 258,259,264,261,262,256,276,286,262,262,263,274,261,276,276,275, \
 274,275,276,282,384,275,276,276,383,288,380,382,382,379,379,382, \
 383,384,382,380,379,383,379,379,383,380,384,381,381,383,379,379, \
 379,379,383,384,382,383,382,382,381,384,379,383,380,381,383,384, \
 381,382,381,379,383,383,379,379,381,379,382,384,384,380,381,383, \
 379,384,380,384,382,379,382,383,380,381,381,383,382,382,384,379, \
 382,377,382,382,379,379,379,382,380,381,382,380,380,379,380,379, \
 380,383,380,383,382,380,381,379,380,382,379,382,382,383,384,384, \
 382,380,384,382,383,382,379,379,390,407,401,380,381,382,383,384, \
 398,408,383,383,400,384,395,386,381,384,408,407,382,383,384,395, \
 430,406,383,402,384,383,432,404,383,383,383,431,398,408,403,406, \
 394,396,396,389,431,407,431,430,383,384,404,428,400,443,404,403, \
 401,453,430,404,431,431,407,396,426,400,431,429,407,444,432,456, \
 431,408,407,408,427,431,408,403,431,454,428,431,419,456,407,431, \
 456,437,417,428,425,455,453,430,452,454,454,432,430,455,432,430, \
 452,451,430,452,455,430,428,479,430,432,439,448,449,476,456,431, \
 478,431,446,450,449,455,472,478,479,357,382,358,375,360,361,364, \
 369,369,367,365,379,370,369,371,386,368,366,374,378,369,376,375, \
 374,369,379,378,390,380,392,372,381,375,384,396,385,379,376,387, \
 378,391,385,392,393,381,380,380,381,387,382,384,405,385,384,406, \
 402,387,388,386,394,399,401,405,396,407,390,397,396,395,409,409, \
 397,440,396,403,414,411,406,396,411,397,407,405,417,420,416,421, \
 404,403,405,402,415,422,412,428,410,425,413,408,421,417,409,408, \
 414,436,425,415,424,411,415,413,426,413,422,427,415,415,416,451, \
 429,417,423,418,424,429,420,432,421,422,449,422,423,423,433,425, \
 425,425,427,427,443,446,429,449,435,438,434,439,453,442,443,444, \
 455,439,437,435,437,441,447,446,457,444,453,438,452,462,446,445, \
 449,471,446,451,463,451,471,458,464,449,452,453,457,458,473,460, \
 450,464,469,458,465,458,457,458,453,483,456,463,470,517,474,467, \
 458,458,466,540,490,504,477,493,478,524,490,520,463,491,477,509, \
 519,502,490,507,517,521,504,525,527,524,537,536,543,551,565,645, \
 600,564,568,571,682,586,601,573,663,495,708,762,765,767,763,767, \
 757,660,767,775,763,785,759,764,764,757,757,763,778,767,758,763, \
 761,758,767,762,763,764,788,767,757,765,767,758,757,773,760,760, \
 759,761,758,765,758,763,760,763,759,763,761,757,760,766,791,760, \
 763,782,760,761,760,763,764,764,764,766,764,759,757,758,763,763 \
  
#define MPFR_MUL_THRESHOLD 4
#define MPFR_EXP_2_THRESHOLD 524
#define MPFR_EXP_THRESHOLD 22876

/*****************************
 * Threshold for Athlon      *
 *****************************/
#elif defined (__athlon)

#define MPFR_MULHIGH_TAB  \
 -1,0,-1,0,-1,0,-1,-1,0,-1,-1,0,0,0,0,10, \
 0,12,13,14,15,16,0,0,0,0,0,19,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32, \
 30,32,30,34,32,32,36,34,36,36,38,38,42,38,38,42, \
 40,38,42,46,42,42,42,44,44,44,44,44,48,50,46,46, \
 60,50,50,48,50,56,56,56,56,56,56,56,60,60,64,60, \
 64,64,60,60,60,72,64,64,68,72,76,72,76,72,72,76, \
 75,76,76,72,76,72,75,72,72,72,84,76,84,75,72,76, \
 84,80,76,84,84,76,76,76,76,88,84,88,80,84,83,96, \
 84,96,92,84,88,91,92,88,92,90,96,96,92,91,92,96, \
 96,120,95,100,112,120,100,119,112,120,120,112,119,112,119,119, \
 120,118,119,119,119,118,119,120,128,127,120,128,128,120,120,127, \
 120,128,128,128,128,120,128,127,120,128,128,127,128,127,144,136, \
 128,144,152,152,152,136,144,144,144,136,151,152,144,152,128,151, \
 144,152,144,144,151,144,150,150,136,151,152,143,143,143,142,168, \
 144,144,168,151,168,144,152,151,152,152,160,152,151,152,160,151, \
 152,151,152,167,152,152,166,152,167,160,168,204,160,160,168,168, \
 204,176,202,167,168,166,167,168,204,184,202,204,204,204,204,192, \
 184,192,204,202,202,216,204,227,202,204,216,203,203,204,203,227, \
 202,204,202,202,202,203,202,215,204,202,203,202,202,215,228,214, \
 226,214,228,214,228,215,228,216,226,214,228,225,226,228,226,226, \
 226,215,216,216,226,225,226,227,216,227,240,216,252,252,226,227, \
 228,239,227,250,227,226,227,227,252,238,228,239,252,227,228,228, \
 252,226,246,228,227,227,252,247,250,263,262,250,252,250,250,252, \
 250,288,288,250,250,250,251,264,264,271,287,276,250,288,252,286, \
 251,287,288,251,276,274,288,262,263,263,282,252,288,252,276,284, \
 287,274,264,274,288,275,275,274,274,288,276,264,273,286,274,276, \
 300,287,288,286,286,276,288,285,275,300,275,273,275,299,300,299, \
 279,336,336,286,287,284,360,359,336,335,288,360,333,359,334,335, \
 335,287,359,335,336,336,359,333,334,359,360,288,360,332,335,336, \
 335,336,336,333,336,335,336,359,334,334,335,360,336,334,356,357, \
 335,336,358,359,359,336,335,336,334,355,384,356,354,384,334,357, \
 336,359,384,359,360,356,384,382,336,383,384,384,354,355,383,384, \
 382,359,384,382,382,383,383,359,381,382,383,356,384,382,381,384, \
 357,384,358,357,358,358,380,383,382,382,383,360,360,381,382,360, \
 377,360,378,360,360,381,382,383,381,380,383,383,360,382,383,380, \
 383,383,384,381,379,360,381,381,382,431,380,380,378,380,384,381, \
 382,382,384,407,384,382,379,384,430,431,383,384,408,384,456,431, \
 431,455,431,428,384,454,455,403,432,383,407,430,430,456,408,427, \
 455,455,456,455,432,431,431,429,455,432,432,424,430,427,427,429, \
 452,454,426,455,456,431,430,454,452,454,431,456,431,428,455,430, \
 454,430,432,455,454,442,443,432,443,431,451,452,456,430,451,456, \
 444,455,449,456,432,454,449,454,502,432,448,504,450,503,503,453, \
 454,502,446,452,453,454,455,499,504,453,456,504,454,453,503,455, \
 456,456,500,478,502,454,456,499,478,454,480,499,501,496,502,455, \
 499,502,503,456,478,500,501,500,479,503,504,451,452,479,454,455, \
 502,503,504,504,454,499,503,501,454,503,456,503,504,501,455,502, \
 503,503,502,504,610,503,504,574,480,551,528,504,609,576,480,503, \
 496,502,503,552,551,552,551,503,504,503,610,608,609,610,611,608, \
 608,551,648,611,612,550,576,572,608,611,610,606,608,611,610,574, \
 575,576,606,607,606,606,608,606,606,575,576,604,604,604,608,609, \
 606,606,606,608,604,604,611,604,604,576,610,606,610,606,604,610, \
 606,612,604,608,610,609,604,608,606,647,612,610,604,606,648,610, \
 610,606,646,608,604,647,606,647,606,609,610,647,648,609,641,611, \
 643,611,643,648,643,640,646,611,644,644,645,611,642,646,611,612, \
 640,647,610,611,610,611,606,647,648,647,648,644,682,642,682,683, \
 610,611,680,678,642,681,682,647,682,612,682,648,611,665,680,683, \
 609,646,666,676,680,646,679,647,646,646,648,679,684,611,612,643, \
 684,645,646,647,683,647,608,645,682,647,682,646,610,648,682,610, \
 684,612,612,683,684,647,647,646,680,646,646,745,648,646,644,647, \
 648,647,678,646,647,683,642,682,682,684,646,645,642,647,646,677, \
 646,647,683,678,680,646,646,643,681,647,683,645,666,755,756,645, \
 643,647,646,647,647,648,674,755,756,674,647,643,680,682,684,680, \
 680,682,682,675,682,677,666,683,680,682,682,684,680,681,674,674 \
  
#define MPFR_MUL_THRESHOLD 19
#define MPFR_EXP_2_THRESHOLD 411
#define MPFR_EXP_THRESHOLD 45200

/*****************************
 * Threshold for PentiumPro  *
 *****************************/
#elif defined (__i386)

#define MPFR_MULHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,64,64,56,64,64, \
 64,64,64,64,64,64,63,63,63,63,63,63,63,64,64,64, \
 64,63,64,64,63,63,63,80,80,72,64,80,72,80,80,79, \
 79,79,79,79,80,80,80,80,96,96,96,95,96,96,94,96, \
 95,95,95,96,95,95,96,96,95,95,95,95,96,96,104,96, \
 96,95,104,103,96,104,96,96,96,128,104,104,128,127,128,128, \
 128,128,128,128,126,128,126,127,127,127,128,127,127,127,127,127, \
 126,126,126,126,126,126,126,126,127,127,128,128,126,127,126,128, \
 128,128,128,128,126,127,126,128,128,125,124,127,126,126,126,126, \
 128,128,128,127,127,128,168,160,166,128,159,159,160,192,192,168, \
 167,167,190,192,190,168,190,191,180,188,167,191,191,190,190,190, \
 190,192,191,192,190,191,190,191,190,192,188,191,192,190,190,192, \
 192,189,190,192,191,192,190,192,191,186,188,189,190,188,191,190, \
 192,192,189,189,191,192,190,189,190,190,187,188,188,190,190,192, \
 190,191,191,191,216,192,216,190,192,191,189,216,190,215,191,190, \
 215,189,190,190,192,216,190,190,192,192,190,239,192,192,228,240, \
 239,237,237,238,228,215,236,237,232,230,237,215,192,236,216,234, \
 237,232,236,239,230,256,245,288,285,240,239,248,214,236,257,256, \
 284,288,287,256,239,262,284,288,341,243,216,285,285,280,287,269, \
 286,285,286,286,286,286,286,284,281,281,284,285,283,284,283,273, \
 286,285,276,283,287,286,287,286,282,286,288,288,287,283,288,281, \
 282,280,286,283,284,280,285,280,288,284,283,283,283,283,287,288, \
 281,286,284,284,286,287,286,288,281,288,286,281,286,287,286,287, \
 312,284,288,286,311,288,285,286,312,280,283,308,284,310,287,285, \
 283,286,311,288,287,288,287,311,286,286,287,384,335,334,383,383, \
 333,380,335,312,382,382,384,383,312,311,381,377,382,384,379,379, \
 380,383,384,384,381,381,383,377,381,384,383,383,383,382,384,335, \
 336,384,377,377,379,384,377,382,379,383,379,378,377,377,376,380, \
 377,382,383,380,379,380,381,384,383,377,375,380,383,381,380,378, \
 379,376,380,378,383,374,376,376,375,384,382,376,384,383,377,377, \
 384,380,384,382,383,382,382,377,379,378,384,379,381,383,384,378, \
 383,377,376,381,383,383,379,379,381,377,381,384,377,380,380,384, \
 383,383,384,383,381,377,374,380,379,381,377,378,374,380,376,377, \
 376,383,383,379,380,383,384,383,430,383,381,382,374,382,379,501, \
 379,383,384,382,503,382,497,379,492,380,501,381,383,382,501,502, \
 495,502,499,380,384,498,381,384,498,384,499,499,502,480,497,495, \
 480,478,498,497,502,496,500,503,479,502,501,503,475,492,498,496, \
 479,504,500,492,498,496,500,500,499,494,494,504,492,494,495,496, \
 497,494,504,503,492,494,500,497,575,502,504,496,497,496,575,572, \
 570,502,503,574,568,568,569,502,571,572,568,504,570,569,573,576, \
 574,570,538,566,538,565,566,572,569,568,572,571,568,571,575,569, \
 564,571,568,575,568,576,561,567,560,576,562,573,568,574,572,575, \
 575,564,568,574,574,575,572,568,568,570,572,574,568,576,575,564, \
 572,573,570,564,574,576,574,574,567,566,570,575,571,576,570,573, \
 573,569,567,568,572,574,566,572,573,574,568,570,570,567,566,561, \
 557,571,564,560,557,562,574,563,576,571,557,569,572,575,571,564, \
 572,558,566,562,559,574,563,574,571,569,572,568,574,570,571,566, \
 571,568,566,566,565,572,570,568,572,572,565,575,569,566,567,575, \
 571,573,573,572,563,569,576,567,568,568,569,566,570,568,573,569, \
 570,573,570,574,574,575,574,568,575,568,564,568,567,571,576,576, \
 568,569,575,569,569,573,574,575,573,574,565,571,567,568,568,575, \
 571,569,573,575,575,570,570,571,565,569,571,571,643,648,571,575, \
 576,570,574,576,574,645,572,642,648,644,646,576,575,648,634,719, \
 573,645,644,643,570,641,638,641,574,644,644,645,644,638,637,574, \
 574,575,576,572,642,719,645,648,713,645,682,709,713,718,720,712, \
 645,718,719,716,644,698,682,678,707,647,681,682,716,684,681,682, \
 683,716,715,719,708,706,719,706,709,708,712,708,709,712,715,712, \
 720,717,717,718,717,704,705,706,707,718,700,710,708,708,713,683, \
 719,717,717,718,719,720,710,709,713,705,711,684,717,718,710,717 \
  
#define MPFR_MUL_THRESHOLD 11
#define MPFR_EXP_2_THRESHOLD 528
#define MPFR_EXP_THRESHOLD 47120

/*****************************
 * Threshold for IA64        *
 *****************************/
#elif defined (__ia64)

#define MPFR_MULHIGH_TAB  \
 -1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, \
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0, \
 128,124,124,124,124,124,120,124,120,124,120,124,120,124,124,124, \
 124,124,124,124,144,124,144,140,140,140,140,136,136,136,136,136, \
 136,136,136,136,136,136,136,136,136,136,136,136,140,139,140,152, \
 152,152,160,156,160,156,160,164,156,156,160,156,144,160,147,160, \
 160,159,160,160,160,168,168,168,160,164,176,168,172,168,156,168, \
 168,164,168,176,172,172,160,175,168,172,176,172,176,175,176,184, \
 176,175,176,180,176,180,184,184,168,180,184,184,184,171,172,207, \
 184,184,184,208,200,207,176,207,200,200,208,206,208,200,208,206, \
 200,200,206,207,206,207,208,207,207,206,208,207,208,208,208,208, \
 208,207,224,207,208,240,215,215,240,215,240,239,216,215,216,240, \
 224,223,224,220,222,220,224,223,224,223,224,231,224,223,232,228, \
 256,255,231,231,256,231,232,232,232,255,256,255,238,264,238,238, \
 256,255,256,248,256,264,240,239,240,240,248,271,248,255,272,248, \
 264,255,256,255,256,252,256,256,272,255,256,255,256,263,264,264, \
 264,263,264,264,263,264,264,271,256,271,271,271,272,272,285,270, \
 285,271,280,271,280,280,280,272,280,287,269,279,284,271,280,271, \
 271,271,285,286,271,272,272,280,272,279,272,278,280,271,286,284, \
 271,280,272,277,284,272,336,281,312,279,280,278,280,280,280,280, \
 284,280,348,280,272,334,272,284,285,287,286,279,336,323,331,334, \
 332,331,332,335,286,346,336,332,334,336,334,336,334,341,358,347, \
 336,336,334,335,334,346,344,347,347,360,371,348,355,382,334,356, \
 336,355,347,384,336,358,358,345,357,347,346,347,348,359,371,359, \
 358,382,346,383,347,357,360,358,357,357,360,370,406,394,382,347, \
 406,347,407,408,407,406,365,419,356,395,356,359,358,406,360,406, \
 359,359,408,419,395,432,360,420,408,425,408,395,430,395,371,432, \
 370,401,432,396,384,419,384,406,359,378,379,378,382,380,392,384, \
 377,384,383,395,407,383,384,455,455,371,371,404,381,405,395,431, \
 432,432,408,400,384,383,383,455,455,377,455,438,432,419,420,444, \
 398,424,392,469,432,427,431,430,404,396,406,384,454,451,464,404, \
 428,432,432,429,405,432,444,407,452,473,430,453,443,452,456,430, \
 454,431,407,430,407,416,455,456,468,456,468,443,431,443,442,460, \
 419,448,467,449,448,478,428,448,479,455,467,431,450,478,431,491, \
 480,442,440,458,478,442,442,432,430,467,467,467,469,467,455,479, \
 453,479,451,478,503,443,454,479,473,476,480,473,477,480,479,489, \
 491,491,491,480,476,454,503,499,500,502,504,460,491,455,466,491, \
 480,477,477,476,473,502,502,504,527,490,467,500,489,502,501,503, \
 515,474,528,480,496,498,492,480,479,504,504,480,492,504,503,522, \
 515,491,503,540,491,499,503,552,492,503,500,504,502,526,551,528, \
 526,514,516,528,528,506,551,503,509,491,496,502,503,514,503,501, \
 548,503,504,552,512,515,516,504,506,509,551,548,502,491,504,552, \
 520,526,528,551,502,521,526,520,514,523,539,549,503,545,528,538, \
 504,533,504,520,511,515,528,504,538,516,514,526,514,528,521,599, \
 551,599,515,520,550,528,526,527,597,548,552,624,535,598,540,528, \
 534,530,596,532,623,539,617,540,542,551,552,550,617,549,600,624, \
 624,550,551,547,596,616,622,551,550,551,552,646,646,648,624,647, \
 622,619,623,622,647,599,600,672,646,647,622,623,624,643,647,647, \
 672,641,622,599,671,617,646,623,622,650,644,647,648,672,647,648, \
 622,641,646,647,648,659,624,644,646,672,647,623,647,648,664,645, \
 644,647,646,622,646,647,668,621,624,647,670,644,626,659,647,624, \
 648,647,647,635,682,695,641,665,646,634,645,646,672,670,646,693, \
 624,694,647,648,624,620,660,648,646,660,688,694,695,667,672,666 \
  
#define MPFR_MUL_THRESHOLD 10
#define MPFR_EXP_2_THRESHOLD 534
#define MPFR_EXP_THRESHOLD 20877

/* __mips64? __mips? */
#endif

/*******************************
 * Default values of Threshold *
 *******************************/
#ifndef MPFR_MULHIGH_TAB
# define MPFR_MULHIGH_TAB -1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0
#endif
#ifndef MPFR_SQRHIGH_TAB
# define MPFR_SQRHIGH_TAB -1,-1,-1,-1,-1,-1,-1,-1,0,0,0,0,0,0,0,0,0
#endif
#ifndef MPFR_MUL_THRESHOLD
# define MPFR_MUL_THRESHOLD 40
#endif
#ifndef MPFR_EXP_2_THRESHOLD
# define MPFR_EXP_2_THRESHOLD 100
#endif
#ifndef MPFR_EXP_THRESHOLD
# define MPFR_EXP_THRESHOLD 25000
#endif
