/* isdir.c -- determine whether a directory exists

   Copyright (C) 1990, 1998, 2006, 2009-2011 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#include <config.h>

#include "isdir.h"

#ifdef __DJGPP__
# include <unistd.h>
#endif
#include <sys/types.h>
#include <sys/stat.h>

/* If PATH is an existing directory or symbolic link to a directory,
   return nonzero, else 0.  */
int
isdir (const char *path)
{
  struct stat stats;

#ifdef __DJGPP__
  /*
   *  Computation of stat is very expensive.
   *  To determinate if PATH is an existing
   *  directory, access on DOS platforms is
   *  mostly a fast system call.
   */
  return (access (path, D_OK) == 0);
#else
  return stat (path, &stats) == 0 && S_ISDIR (stats.st_mode);
#endif
}
