/* Copyright (C) 2016 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 2015 DJ Delorie, see COPYING.DJ for details */
/* Copyright (C) 2014 DJ Delorie, see COPYING.DJ for details */
/*
 * This file will be removed as soon as DJGPP implements multi-byte character support.
 */

#define IS_ALNUM(s)   (s[0] == 'a' && s[1] == 'l' && s[2] == 'n' && s[3] == 'u' && s[4] == 'm' && s[5] == '\0')
#define IS_ALPHA(s)   (s[0] == 'a' && s[1] == 'l' && s[2] == 'p' && s[3] == 'h' && s[4] == 'a' && s[5] == '\0')
#define IS_BLANK(s)   (s[0] == 'b' && s[1] == 'l' && s[2] == 'a' && s[3] == 'n' && s[4] == 'k' && s[5] == '\0')
#define IS_CNTRL(s)   (s[0] == 'c' && s[1] == 'n' && s[2] == 't' && s[3] == 'r' && s[4] == 'l' && s[5] == '\0')
#define IS_DIGIT(s)   (s[0] == 'd' && s[1] == 'i' && s[2] == 'g' && s[3] == 'i' && s[4] == 't' && s[5] == '\0')
#define IS_GRAPH(s)   (s[0] == 'g' && s[1] == 'r' && s[2] == 'a' && s[3] == 'p' && s[4] == 'h' && s[5] == '\0')
#define IS_LOWER(s)   (s[0] == 'l' && s[1] == 'o' && s[2] == 'w' && s[3] == 'e' && s[4] == 'r' && s[5] == '\0')
#define IS_PRINT(s)   (s[0] == 'p' && s[1] == 'r' && s[2] == 'i' && s[3] == 'n' && s[4] == 't' && s[5] == '\0')
#define IS_PUNCT(s)   (s[0] == 'p' && s[1] == 'u' && s[2] == 'n' && s[3] == 'c' && s[4] == 't' && s[5] == '\0')
#define IS_SPACE(s)   (s[0] == 's' && s[1] == 'p' && s[2] == 'a' && s[3] == 'c' && s[4] == 'e' && s[5] == '\0')
#define IS_UPPER(s)   (s[0] == 'u' && s[1] == 'p' && s[2] == 'p' && s[3] == 'e' && s[4] == 'r' && s[5] == '\0')
#define IS_XDIGIT(s)  (s[0] == 'x' && s[1] == 'd' && s[2] == 'i' && s[3] == 'g' && s[4] == 'i' && s[5] == 't' && s[6] == '\0')

#include <errno.h>
#include "dj_wctype.h"


wctype_t
wctype(const char *property)
{
  switch (*property)
  {
  case 'a':
    if (IS_ALNUM(property))
      return WC_ALNUM; 
    else if (IS_ALPHA(property))
      return WC_ALPHA;
    break;
  case 'b':
    if (IS_BLANK(property))
      return WC_BLANK;
    break;
  case 'c':
    if (IS_CNTRL(property))
      return WC_CNTRL;
    break;
  case 'd':
    if (IS_DIGIT(property))
      return WC_DIGIT;
    break;
  case 'g':
    if (IS_GRAPH(property))
      return WC_GRAPH;
    break;
  case 'l':
    if (IS_LOWER(property))
      return WC_LOWER;
    break;
  case 'p':
    if (IS_PRINT(property))
      return WC_PRINT;
    else if (IS_PUNCT(property))
      return WC_PUNCT;
    break;
  case 's':
    if (IS_SPACE(property))
      return WC_SPACE;
    break;
  case 'u':
    if (IS_UPPER(property))
      return WC_UPPER;
    break;
  case 'x':
    if (IS_XDIGIT(property))
      return WC_XDIGIT;
    break;
  }

  /* otherwise invalid */
  errno = EINVAL;

  return 0;
}
