program Foo;

uses System;

type
  RBR = packed record
    R : Real;
    BR : BPReal
  end;

var
  i : Integer;
  x : RBR;
  R2 : Real;
  f : file of RBR;

begin
  Rewrite (f, 'bpreal.dat');
  Randomize;
  for i := 1 to 20000 do
    begin
      x.R := (Random + 1e-6) * Exp (Random (88) - 44);
      if Random (2) = 0 then x.R := - x.R;
      x.BR := RealToBPReal (x.R);
      Write (f, x);
      R2 := BPRealToReal (x.BR);
      if Abs (x.R / R2 - 1) > 1e-6 then
        begin
          Writeln ('failed: ', x.R, ', ', R2);
          Halt (1)
        end
    end;
  Writeln ('OK')
end.
