#ifndef dosutil_h
#define dosutil_h

#include <setjmp.h>
#include <sys/types.h>

#include "config.h"
#include "command.h"
#include "general.h"
#include "hashlib.h"
#include "variables.h"
#include "stdc.h"

typedef struct oldenvbuf
{
  int fds[3];

  jmp_buf top_level;
  jmp_buf subshell_top_level;

  HASH_TABLE *shell_variables;
  HASH_TABLE *shell_functions;

  char **temporary_env;
  char **function_env;
  char **builtin_env;
  char **export_env;
  char **non_unsettable_vars;

  char *dollar_vars[10];
  WORD_LIST *rest_of_args;

  char *pwd;
  char *oldpwd;
  char *curdir;

  int interactive;
  int interactive_shell;
  int login_shell;
  int subshell_environment;
  int subshell_exit_builtin;
  int exit_immediately_on_error;
  int variable_context;
  int dollar_dollar_pid;
  WORD_LIST *subst_assign_varlist;
} OLDENVBUF;

extern int dosutil_path_expand;
extern int dosutil_path_separator;
extern int dosutil_path_slash;
extern char dosutil_sysroot[];
extern int dosutil_sysroot_len;
extern int dosutil_wait_status;
extern pid_t dosutil_current_pid;
extern const int dosutil_encoded_drive_len_diff;
extern char dosutil_tmpdir[];
extern char * dosutil_tmpdir_template;
extern size_t dosutil_tmpdir_len;
#define DOSUTIL_TEST_VAR_NAME "TEST_FINDS_EXE"
extern int dosutil_test_finds_exe;

char *dosutil_make_import_path __P((char *value));
char *dosutil_make_export_path __P((char *value));
void dosutil_import_environment_variables __P((void));
char *dosutil_add_slash __P((char *path));
char *dosutil_delete_slash __P((char *path));
char *dosutil_toslash __P((char *path));
char *dosutil_tobslash __P((char *path));
char *dosutil_tolower __P((char *path));
char *dosutil_toupper __P((char *path));
char *dosutil_decode_drivename __P((char *path));
char *dosutil_encode_drivename __P((char *path));
char *dosutil_maybe_encode_drivename __P((char *path));
int dosutil_is_encoded_drivename __P((const char *path));
int dosutil_is_dev_path __P((const char *path));
int dosutil_is_root_directory_pathname __P((const char *path));
void dosutil_set_tmpdir __P((const char *path));
int dosutil_import_unixy_pathvar __P((char *name, char **val));
char *dosutil_export_unixy_pathvar __P((char *path));
char *dosutil_fix_variable __P((char *path));
char **dosutil_get_import_variables __P((void));
void dosutil_put_export_variables __P((char **vp));
void dosutil_reserve_fds __P((void));
void dosutil_save_cwd __P((void));
void dosutil_save_std_fds __P((int fds[]));
void dosutil_restore_std_fds __P((int fds[]));
int dosutil_save_all_environment __P((OLDENVBUF *envp));
int dosutil_restore_all_environment __P((OLDENVBUF *envp));
void dosutil_expand_argv_words __P((WORD_LIST *list));

pid_t dosutil_make_child_pid __P((void));

/* define in trap.c */
int dosutil_get_signal_modes __P((int sig));
int dosutil_set_signal_modes __P((int sig, int modes));

#include <dpmi.h>
#define DOSUTIL_EXCEPTION_COUNT 18

typedef struct oldexceptbuf
{
  __dpmi_paddr except_original[DOSUTIL_EXCEPTION_COUNT];
  __dpmi_paddr kbd_original;
  __dpmi_paddr npx_original;
  __dpmi_raddr cbrk_original;
} OLDEXCEPTBUF;

char *find_executable_ext __P((const char *name, char *buffer));
char *dosutil_add_executable_suffix __P((char *name));
int dosutil_has_executable_suffix __P((const char *name));
int dosutil_has_script_suffix __P((const char *name));
int dosutil_has_suffix __P((const char *name));
void dosutil_save_exceptions __P((OLDEXCEPTBUF *exceptionp));
void dosutil_restore_exceptions __P((OLDEXCEPTBUF *exceptionp));
int *dosutil_check_dpmi_selectors __P((void));
void dosutil_free_dpmi_selectors __P((int *selectors));
char *dosutil_make_response_file __P((char **argv));
void dosutil_reset_console __P((void));

int _opentmp __P((const char *path, int flags, ...));
int _remove_on_close __P((int fd, const char *path));

int bash_spawnve __P((char *_path, char **argv, char ** _envp));

#endif /* dosutil_h */
