#ifndef dosutil_h
#define dosutil_h

#include <setjmp.h>
#include <sys/types.h>

#include "config.h"
#include "command.h"
#include "general.h"
#include "hashlib.h"
#include "variables.h"

typedef struct oldenvbuf
{
  int fds[3];

  jmp_buf top_level;
  jmp_buf subshell_top_level;

  HASH_TABLE *shell_variables;
  HASH_TABLE *shell_functions;

  char **temporary_env;
  char **function_env;
  char **builtin_env;
  char **export_env;
  char **non_unsettable_vars;

  char *dollar_vars[10];
  WORD_LIST *rest_of_args;

  char *pwd;
  char *oldpwd;
  char *curdir;

  int interactive;
  int interactive_shell;
  int login_shell;
  int subshell_environment;
  int subshell_exit_builtin;
  int exit_immediately_on_error;
  int variable_context;
  int dollar_dollar_pid;
} OLDENVBUF;

extern int dosutil_path_expand;
extern int dosutil_path_separator;
extern int dosutil_path_slash;
extern char dosutil_sysroot[];
extern int dosutil_sysroot_len;
extern int dosutil_wait_status;
extern pid_t dosutil_current_pid;
extern const int dosutil_encoded_drive_len_diff;
extern char dosutil_tmpdir[];
extern size_t dosutil_tmpdir_len;
#define DOSUTIL_TEST_VAR_NAME "TEST_FINDS_EXE"
extern int dosutil_test_finds_exe;

char *dosutil_version_string (void);
char *dosutil_make_import_path (char *value);
char *dosutil_make_export_path (char *value);
void dosutil_import_environment_variables (void);
char *dosutil_add_slash (char *path);
char *dosutil_delete_slash (char *path);
char *dosutil_toslash (char *path);
char *dosutil_tobslash (char *path);
char *dosutil_tolower (char *path);
char *dosutil_toupper (char *path);
char *dosutil_delete_sysroot (char *path);
char *dosutil_add_sysroot (char *path);
char *dosutil_expand_path (char *path);
char *dosutil_decode_drivename (char *path);
char *dosutil_encode_drivename (char *path);
int dosutil_is_encoded_drivename (const char *path);
int dosutil_is_dev_path (const char *path);
int dosutil_is_root_directory_pathname (const char *path);
void dosutil_set_tmpdir(const char *path);
int dosutil_import_unixy_pathvar (char *name, char **val);
#define dosutil_export_unixy_pathvar dosutil_fix_variable
char *dosutil_fix_variable (char *path);
char **dosutil_get_import_variables (void);
void dosutil_put_export_variables (char **vp);
void dosutil_reserve_fds (void);
void dosutil_save_cwd (void);
void dosutil_save_std_fds (int fds[]);
void dosutil_restore_std_fds (int fds[]);
int dosutil_save_all_environment (OLDENVBUF *envp);
int dosutil_restore_all_environment (OLDENVBUF *envp);

void dosutil_pipe_clean (int no);
int dosutil_pipe_no (void);
int dosutil_pipe (int fds[]);
pid_t dosutil_make_child_pid (void);

int dosutil_chdir (char *path);
char *dosutil_getcwd (char *buffer, int length);
char *dosutil_getwd (char *buffer);

/* define in trap.c */
int dosutil_get_signal_modes (int sig);
int dosutil_set_signal_modes (int sig, int modes);

#include <dpmi.h>
#define DOSUTIL_EXCEPTION_COUNT 18

typedef struct oldexceptbuf
{
  __dpmi_paddr except_original[DOSUTIL_EXCEPTION_COUNT];
  __dpmi_paddr kbd_original;
  __dpmi_paddr npx_original;
  __dpmi_raddr cbrk_original;
} OLDEXCEPTBUF;
char *dosutil_add_executable_suffix (char *name);
int dosutil_has_executable_suffix (const char *name);
int dosutil_has_suffix (const char *name);
void dosutil_save_exceptions (OLDEXCEPTBUF *exceptionp);
void dosutil_restore_exceptions (OLDEXCEPTBUF *exceptionp);
int *dosutil_check_dpmi_selectors (void);
void dosutil_free_dpmi_selectors (int *selectors);
int dosutil_dup2_wrapper (int from, int to);
char *dosutil_make_response_file (char **argv);
void dosutil_reset_console (void);

void dosutil_add_delay_remove(const char *filename);
void dosutil_try_delay_remove(void);

#endif /* dosutil_h */
