/* This file is automatically generated by aarch64-gen.  Do not edit!  */
/* Copyright 2012  Free Software Foundation, Inc.
   Contributed by ARM Ltd.

   This file is part of the GNU opcodes library.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING3. If not,
   see <http://www.gnu.org/licenses/>.  */

#include "sysdep.h"
#include "aarch64-asm.h"


const aarch64_opcode *
aarch64_find_real_opcode (const aarch64_opcode *opcode)
{
  /* Use the index as the key to locate the real opcode.  */
  int key = opcode - aarch64_opcode_table;
  int value;
  switch (key)
    {
    case 3:	/* ngc */
      value = 2;	/* --> sbc.  */
      break;
    case 5:	/* ngcs */
      value = 4;	/* --> sbcs.  */
      break;
    case 8:	/* cmn */
      value = 7;	/* --> adds.  */
      break;
    case 11:	/* cmp */
      value = 10;	/* --> subs.  */
      break;
    case 13:	/* mov */
      value = 12;	/* --> add.  */
      break;
    case 15:	/* cmn */
      value = 14;	/* --> adds.  */
      break;
    case 18:	/* cmp */
      value = 17;	/* --> subs.  */
      break;
    case 21:	/* cmn */
      value = 20;	/* --> adds.  */
      break;
    case 23:	/* neg */
      value = 22;	/* --> sub.  */
      break;
    case 26:	/* negs */
    case 25:	/* cmp */
      value = 24;	/* --> subs.  */
      break;
    case 139:	/* mov */
      value = 138;	/* --> umov.  */
      break;
    case 141:	/* mov */
      value = 140;	/* --> ins.  */
      break;
    case 143:	/* mov */
      value = 142;	/* --> ins.  */
      break;
    case 204:	/* mvn */
      value = 203;	/* --> not.  */
      break;
    case 259:	/* mov */
      value = 258;	/* --> orr.  */
      break;
    case 427:	/* mov */
      value = 426;	/* --> dup.  */
      break;
    case 494:	/* sxtw */
    case 493:	/* sxth */
    case 492:	/* sxtb */
    case 495:	/* asr */
    case 491:	/* sbfx */
    case 490:	/* sbfiz */
      value = 489;	/* --> sbfm.  */
      break;
    case 498:	/* bfxil */
    case 497:	/* bfi */
      value = 496;	/* --> bfm.  */
      break;
    case 503:	/* uxth */
    case 502:	/* uxtb */
    case 505:	/* lsr */
    case 504:	/* lsl */
    case 501:	/* ubfx */
    case 500:	/* ubfiz */
      value = 499;	/* --> ubfm.  */
      break;
    case 523:	/* cset */
    case 522:	/* cinc */
      value = 521;	/* --> csinc.  */
      break;
    case 526:	/* csetm */
    case 525:	/* cinv */
      value = 524;	/* --> csinv.  */
      break;
    case 528:	/* cneg */
      value = 527;	/* --> csneg.  */
      break;
    case 553:	/* lsl */
      value = 552;	/* --> lslv.  */
      break;
    case 555:	/* lsr */
      value = 554;	/* --> lsrv.  */
      break;
    case 557:	/* asr */
      value = 556;	/* --> asrv.  */
      break;
    case 559:	/* ror */
      value = 558;	/* --> rorv.  */
      break;
    case 561:	/* mul */
      value = 560;	/* --> madd.  */
      break;
    case 563:	/* mneg */
      value = 562;	/* --> msub.  */
      break;
    case 565:	/* smull */
      value = 564;	/* --> smaddl.  */
      break;
    case 567:	/* smnegl */
      value = 566;	/* --> smsubl.  */
      break;
    case 570:	/* umull */
      value = 569;	/* --> umaddl.  */
      break;
    case 572:	/* umnegl */
      value = 571;	/* --> umsubl.  */
      break;
    case 583:	/* ror */
      value = 582;	/* --> extr.  */
      break;
    case 683:	/* strb */
      value = 681;	/* --> sturb.  */
      break;
    case 684:	/* ldrb */
      value = 682;	/* --> ldurb.  */
      break;
    case 686:	/* ldrsb */
      value = 685;	/* --> ldursb.  */
      break;
    case 689:	/* str */
      value = 687;	/* --> stur.  */
      break;
    case 690:	/* ldr */
      value = 688;	/* --> ldur.  */
      break;
    case 693:	/* strh */
      value = 691;	/* --> sturh.  */
      break;
    case 694:	/* ldrh */
      value = 692;	/* --> ldurh.  */
      break;
    case 696:	/* ldrsh */
      value = 695;	/* --> ldursh.  */
      break;
    case 699:	/* str */
      value = 697;	/* --> stur.  */
      break;
    case 700:	/* ldr */
      value = 698;	/* --> ldur.  */
      break;
    case 702:	/* ldrsw */
      value = 701;	/* --> ldursw.  */
      break;
    case 704:	/* prfm */
      value = 703;	/* --> prfum.  */
      break;
    case 746:	/* bic */
      value = 745;	/* --> and.  */
      break;
    case 748:	/* mov */
      value = 747;	/* --> orr.  */
      break;
    case 751:	/* tst */
      value = 750;	/* --> ands.  */
      break;
    case 756:	/* uxtw */
    case 755:	/* mov */
      value = 754;	/* --> orr.  */
      break;
    case 758:	/* mvn */
      value = 757;	/* --> orn.  */
      break;
    case 762:	/* tst */
      value = 761;	/* --> ands.  */
      break;
    case 765:	/* mov */
      value = 764;	/* --> movn.  */
      break;
    case 767:	/* mov */
      value = 766;	/* --> movz.  */
      break;
    case 778:	/* sevl */
    case 777:	/* sev */
    case 776:	/* wfi */
    case 775:	/* wfe */
    case 774:	/* yield */
    case 773:	/* nop */
      value = 772;	/* --> hint.  */
      break;
    case 787:	/* tlbi */
    case 786:	/* ic */
    case 785:	/* dc */
    case 784:	/* at */
      value = 783;	/* --> sys.  */
      break;
    default: return NULL;
    }

  return aarch64_opcode_table + value;
}

const char*
aarch64_insert_operand (const aarch64_operand *self,
			   const aarch64_opnd_info *info,
			   aarch64_insn *code, const aarch64_inst *inst)
{
  /* Use the index as the key.  */
  int key = self - aarch64_operands;
  switch (key)
    {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 13:
    case 14:
    case 15:
    case 16:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 34:
    case 35:
      return aarch64_ins_regno (self, info, code, inst);
    case 11:
      return aarch64_ins_reg_extended (self, info, code, inst);
    case 12:
      return aarch64_ins_reg_shifted (self, info, code, inst);
    case 17:
      return aarch64_ins_ft (self, info, code, inst);
    case 27:
    case 28:
    case 29:
      return aarch64_ins_reglane (self, info, code, inst);
    case 30:
      return aarch64_ins_reglist (self, info, code, inst);
    case 31:
      return aarch64_ins_ldst_reglist (self, info, code, inst);
    case 32:
      return aarch64_ins_ldst_reglist_r (self, info, code, inst);
    case 33:
      return aarch64_ins_ldst_elemlist (self, info, code, inst);
    case 36:
    case 45:
    case 46:
    case 47:
    case 48:
    case 49:
    case 50:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 65:
    case 66:
    case 67:
    case 68:
      return aarch64_ins_imm (self, info, code, inst);
    case 37:
    case 38:
      return aarch64_ins_advsimd_imm_shift (self, info, code, inst);
    case 39:
    case 40:
    case 41:
      return aarch64_ins_advsimd_imm_modified (self, info, code, inst);
    case 58:
      return aarch64_ins_limm (self, info, code, inst);
    case 59:
      return aarch64_ins_aimm (self, info, code, inst);
    case 60:
      return aarch64_ins_imm_half (self, info, code, inst);
    case 61:
      return aarch64_ins_fbits (self, info, code, inst);
    case 63:
      return aarch64_ins_cond (self, info, code, inst);
    case 69:
    case 75:
      return aarch64_ins_addr_simple (self, info, code, inst);
    case 70:
      return aarch64_ins_addr_regoff (self, info, code, inst);
    case 71:
    case 72:
    case 73:
      return aarch64_ins_addr_simm (self, info, code, inst);
    case 74:
      return aarch64_ins_addr_uimm12 (self, info, code, inst);
    case 76:
      return aarch64_ins_simd_addr_post (self, info, code, inst);
    case 77:
      return aarch64_ins_sysreg (self, info, code, inst);
    case 78:
      return aarch64_ins_pstatefield (self, info, code, inst);
    case 79:
    case 80:
    case 81:
    case 82:
      return aarch64_ins_sysins_op (self, info, code, inst);
    case 83:
    case 84:
      return aarch64_ins_barrier (self, info, code, inst);
    case 85:
      return aarch64_ins_prfop (self, info, code, inst);
    default: assert (0); abort ();
    }
}
